package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.model.scheme.sub.SscSchemeMat;
import com.tydic.dyc.ssc.repository.SscQrySchemePackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

import static jdk.nashorn.internal.runtime.regexp.joni.Config.log;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2023/4/13 15:52
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
@Slf4j
public class SscQrySchemePackExtRepositoryImpl implements SscQrySchemePackExtRepository {
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;

    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    private final String exect_status_0 = "0";
    private final String exect_status_16 = "16";
    private final String exect_status_1 = "1";
    private final String exect_status_2 = "2";
    private final String exect_status_24 = "24";
    private final String exect_status_30 = "30";
    @Autowired
    private SscSchemeChangeDistributionModeLogMapper sscSchemeChangeDistributionModeLogMapper;
    /**
     * 雪花序列
     */
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private SchemeBasisFileBuildFailMapper schemeBasisFileBuildFailMapper;
    @Autowired
    private SchemeBasisFileInitMapper schemeBasisFileInitMapper;
    @Autowired
    private SchemeBasisFileMapper schemeBasisFileMapper;
    @Autowired
    private SscAccessoryExtMapper sscAccessoryExtMapper;
    @Autowired
    private SscJoinSignLogMapper sscJoinSignLogMapper;
    @Autowired
    private ISscCommonModel iSscCommonModel;
    @Autowired
    private CrcAllocationRecordMapper crcAllocationRecordMapper;
    @Override
    public SscQrySchemePackExtRspBO qryPackBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackBySchemeIds(reqBO.getSchemeIds());
            if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                List<SscQrySchemePackExtBO> rows = JSONObject.parseArray(JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
                rspBO.setBos(rows);
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        List<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = new ArrayList<>();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            SscSchemePO searchPO = new SscSchemePO();
            searchPO.setSchemeIdList(reqBO.getSchemeIds());
            List<SscSchemePO> sscSchemePOS = saasSchemePackMapper.getModelBy(searchPO);
            if (CollectionUtils.isEmpty(sscSchemePOS)){
                rspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
                rspBO.setRespDesc("方案查询为空");
            }
            List<SscQryPlanPackBO> sscQryPlanPackBOS = sscPlanPackMapper.selectSchemePackExtInfoBySchemeIds
                    (sscSchemePOS.stream().map(SscSchemePO::getSchemeId).collect(Collectors.toList()),"采购员名称");
            Map<Long, String> collect = sscQryPlanPackBOS.stream().collect(Collectors.toMap(SscQryPlanPackBO::getSchemeId, SscQryPlanPackBO::getPurchaseUserName));
            List<Long> noSimpleSchemeIds = new ArrayList<>();
            List<Long> jcSchemeIds = new ArrayList<>();
            for (SscSchemePO sscSchemePO : sscSchemePOS) {
                if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(String.valueOf(sscSchemePO.getSchemeType()))){
                    //简易采购方案没有包
                    SscQrySchemeExectStatusPackExtBO statusPackExtBO = new SscQrySchemeExectStatusPackExtBO();
                    statusPackExtBO.setSchemeId(sscSchemePO.getSchemeId());
                    List<String> exectStatusList = new ArrayList<>();
                    exectStatusList.add(sscSchemePO.getSchemeExectStatus());
                    statusPackExtBO.setExectStatusList(exectStatusList);
                    if (StringUtils.isEmpty(sscSchemePO.getSchemeExectStatus()) || sscSchemePO.getSchemeExectStatus().equals(exect_status_0)
                            || sscSchemePO.getSchemeExectStatus().equals(exect_status_16)|| sscSchemePO.getSchemeExectStatus().equals(exect_status_24)
                            || sscSchemePO.getSchemeExectStatus().equals(exect_status_30)
                    ){
                        //允许
                        statusPackExtBO.setIsDearoOperation(1);
                    }else {
                        statusPackExtBO.setIsDearoOperation(0);
                    }
                    schemeExectBOs.add(statusPackExtBO);
                }else {
                    if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(String.valueOf(sscSchemePO.getSchemeType()))){
                        jcSchemeIds.add(sscSchemePO.getSchemeId());
                    }
                    noSimpleSchemeIds.add(sscSchemePO.getSchemeId());
                }

            }
            if (!CollectionUtils.isEmpty(noSimpleSchemeIds)){
                List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackBySchemeIds(noSimpleSchemeIds);
                if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                    Map<Long, List<SaasSchemePackPO>> schemeIdMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getSchemeId));
                    for (Long schemeId : schemeIdMap.keySet()) {
                        List<SaasSchemePackPO> packPOS = schemeIdMap.get(schemeId);
                        //拿到所有包的非空执行状态
                        Set<String> packExectStatusSet = packPOS.stream().filter(e -> !StringUtils.isEmpty(e.getPackExectStatus())).map(SaasSchemePackPO::getPackExectStatus).collect(Collectors.toSet());

                        SscQrySchemeExectStatusPackExtBO statusPackExtBO = new SscQrySchemeExectStatusPackExtBO();
                        statusPackExtBO.setSchemeId(schemeId);
                        List<String> exectStatusList = new ArrayList<>();
                        exectStatusList.addAll(packExectStatusSet);
                        //允许
                        statusPackExtBO.setIsDearoOperation(1);
                        for (String packExectStatus : exectStatusList) {
                            if (!exect_status_0.equals(packExectStatus) && !exect_status_16.equals(packExectStatus) && !exect_status_1.equals(packExectStatus) && !exect_status_2.equals(packExectStatus)
                                    && !exect_status_24.equals(packExectStatus) && !exect_status_30.equals(packExectStatus)
                            ){
                                statusPackExtBO.setIsDearoOperation(0);
                                break;
                            }
                        }
                        statusPackExtBO.setExectStatusList(exectStatusList);
                        schemeExectBOs.add(statusPackExtBO);
                    }
                }
            }
            /**
             * 校验寻源
             */
            Map<Long,Integer> checkMap = new HashMap<>();
            if(!CollectionUtils.isEmpty(jcSchemeIds)){
                List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackBySchemeIds(jcSchemeIds);
                if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                    List<Long> packIds = saasSchemePackPOS.stream().map(e -> e.getPackId()).collect(Collectors.toList());
                    List<Long> fdPackIds = saasSchemePackMapper.qryXyCount(packIds);
                    for (SaasSchemePackPO saasSchemePackPO : saasSchemePackPOS) {
                        if(fdPackIds.contains(saasSchemePackPO.getPackId())){
                            checkMap.put(saasSchemePackPO.getSchemeId(),0);
                        }
                    }
                }
                for (SscQrySchemeExectStatusPackExtBO schemeExectBO : schemeExectBOs) {
                    if(checkMap.get(schemeExectBO.getSchemeId()) != null && checkMap.get(schemeExectBO.getSchemeId()) == 0){
                        schemeExectBO.setIsDearoOperation(0);
                    }
                }
            }

            //已分配不展示
            //增加企业核实不限制这个已分配 (因为企业核实现在会有被分配人去企业核实)
            List<Long> checkSchemeIds = new ArrayList<>();
            if (!CollectionUtils.isEmpty(sscSchemePOS)){
                checkSchemeIds = sscSchemePOS.stream().filter(e -> SscCommConstant.SchemeStatus.CHECK.getCode().equals(e.getSchemeStatus())).map(SscSchemePO::getSchemeId).collect(Collectors.toList());
            }
            for (SscQrySchemeExectStatusPackExtBO e : schemeExectBOs) {
                if (!CollectionUtils.isEmpty(collect)) {
                    String isDearoOperationStr = collect.get(e.getSchemeId());
                    if (!StringUtils.isEmpty(isDearoOperationStr)) {
                        if (!checkSchemeIds.contains(e.getSchemeId())){
                            e.setIsDearoOperation(0);
                        }
                    }
                }
            }
            rspBO.setSchemeExectBOs(schemeExectBOs);
        }else {
            rspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
            rspBO.setRespDesc("入参为空");
        }
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getPackIds())){
            List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackByPackIds(reqBO.getPackIds());
            if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                List<SscQrySchemePackExtBO> rows = JSONObject.parseArray(JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
                rspBO.setBos(rows);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getPurchasePackIds())){
            List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackByPurchasePackIds(reqBO.getPurchasePackIds());
            if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                List<SscQrySchemePackExtBO> rows = JSONObject.parseArray(JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
                rspBO.setBos(rows);
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemePackImplCodeExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getPackIds())){
            int count = saasSchemePackMapper.updateSchemePackImplCodeExect(reqBO.getPackIds());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackPackStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds()) && !StringUtils.isEmpty(reqBO.getPackExectStatus())){
            SscSchemePO searchPO = new SscSchemePO();
            searchPO.setSchemeIdList(reqBO.getSchemeIds());
            List<SscSchemePO> schemePOS = saasSchemePackMapper.getModelBy(searchPO);
            //简易方案ids
            List<Long> simpleSchemeIds = new ArrayList<>();
            //采购方案ids
            List<Long> purchaseSchemeIds = new ArrayList<>();
            //集采方案ids
            List<Long> focusSchemeIds = new ArrayList<>();

            if (!CollectionUtils.isEmpty(schemePOS)){
                for (SscSchemePO schemePO : schemePOS) {
                    if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(String.valueOf(schemePO.getSchemeType()))){
                        simpleSchemeIds.add(schemePO.getSchemeId());
                    }else if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(String.valueOf(schemePO.getSchemeType()))){
                        purchaseSchemeIds.add(schemePO.getSchemeId());
                    }else {
                        focusSchemeIds.add(schemePO.getSchemeId());
                    }
                }
            }
            if (SscCommConstant.SchemeExectStatus.JYCGJH.getCode().toString().equals(reqBO.getPackExectStatus())){
                //不同方案对应不同的 0,1,2 实现接口去判断
                if (!CollectionUtils.isEmpty(simpleSchemeIds)){
                    //简易计划，状态是在方案上面
                    saasSchemePackMapper.updateSchemePackStatus(simpleSchemeIds,SscCommConstant.SchemeExectStatus.JYCGJH.getCode().toString());
                }
                if (!CollectionUtils.isEmpty(purchaseSchemeIds)){
                    saasSchemePackMapper.updatePackPackStatus(purchaseSchemeIds,SscCommConstant.SchemeExectStatus.CGFA.getCode().toString());
                }
                if (!CollectionUtils.isEmpty(focusSchemeIds)){
                    saasSchemePackMapper.updatePackPackStatus(focusSchemeIds,SscCommConstant.SchemeExectStatus.JCFA.getCode().toString());
                }
            }else {
                if (!CollectionUtils.isEmpty(simpleSchemeIds)){
                    //简易计划，状态是在方案上面
                    saasSchemePackMapper.updateSchemePackStatus(simpleSchemeIds,reqBO.getPackExectStatus());
                }
                List<Long> schemeIds = new ArrayList<>();
                schemeIds.addAll(purchaseSchemeIds);
                schemeIds.addAll(focusSchemeIds);
                if (!CollectionUtils.isEmpty(schemeIds)){
                    int count = saasSchemePackMapper.updatePackPackStatus(schemeIds,reqBO.getPackExectStatus());
                }
            }


        }

        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeExist(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()==null){
            rspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
            rspBO.setRespDesc("入参方案id不能为空");
            return rspBO;
        }
        SscQrySchemeExectStatusPackExtBO sscQrySchemeExectStatusPackExtBO = saasSchemePackMapper.qrySchemeExist(reqBO.getSchemeId());
        Long id = null;

        if (sscQrySchemeExectStatusPackExtBO!=null){
            id = sscQrySchemeExectStatusPackExtBO.getSchemeId();
        }

        if (id!=null){
            rspBO.setIsSchemeExist(1);
            List<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = new ArrayList<>();
            schemeExectBOs.add(sscQrySchemeExectStatusPackExtBO);
            rspBO.setSchemeExectBOs(schemeExectBOs);
        }else {
            rspBO.setIsSchemeExist(0);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeAuditProclnstld(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = saasSchemePackMapper.qrySchemeAuditProclnstld(reqBO.getSchemeIds());
            rspBO.setSchemeExectBOs(schemeExectBOs);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackStatusBySchemeIdsOrpackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        List<SscQrySchemePackExtBO> bos = new ArrayList<>();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.qrySchemeExectStatusBySchemeIds(reqBO.getSchemeIds());
            if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)){
                bos.addAll(sscQrySchemePackExtBOS);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getPackIds())){
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.qryPackStatusByByPackIds(reqBO.getPackIds());
            if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)){
                bos.addAll(sscQrySchemePackExtBOS);
            }
        }
        rspBO.setBos(bos);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackageAllocation(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if(reqBO == null){
            throw new BaseBusinessException("291001", "入参对象不能为空");
        }
        if(reqBO.getImplId() == null){
            throw new BaseBusinessException("291001", "入参对象属性[implId]不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getImplCode())){
            throw new BaseBusinessException("291001", "入参对象属性[implCode]不能为空");
        }
        if(StringUtils.isEmpty(reqBO.getImplName())){
            throw new BaseBusinessException("291001", "入参对象属性[implName]不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getPackIds())){
            throw new BaseBusinessException("291001", "入参包ids不能为空");
        }
        List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackByPackIds(reqBO.getPackIds());
        if (CollectionUtils.isEmpty(saasSchemePackPOS)){
            throw new ZTBusinessException("查询包信息失败，数据为空");
        }
        List<Long> updatePackStatusIds = new ArrayList<>();
        for (SaasSchemePackPO saasSchemePackPO : saasSchemePackPOS) {
            if (StringUtils.isEmpty(saasSchemePackPO.getPackStatus())  ){
                updatePackStatusIds.add(saasSchemePackPO.getPackId());
            }
        }
        int count = saasSchemePackMapper.updateSchemePackImplCodeByBoExect(reqBO);
        if (count==0){
            throw new ZTBusinessException("修改数据失败");
        }else {
            if (!CollectionUtils.isEmpty(updatePackStatusIds)){
                int num = saasSchemePackMapper.updatePackStatus(updatePackStatusIds, "03");
                if (num==0){
                    throw new ZTBusinessException("修改包状态数据失败");
                }
            }
        }
        //保存分配记录
        saveOperateLog(reqBO,saasSchemePackPOS);
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
    private void saveOperateLog(SscQrySchemePackExtReqBO reqBo,List<SaasSchemePackPO> saasSchemePackPOS){
        try{

            Map<Long, List<SaasSchemePackPO>> packMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getPackId));


            List<CrcAllocationRecordPO> crcAllocationRecordPOS = reqBo.getPackIds().stream()
                    .map(item -> {
                        List<SaasSchemePackPO> schemePackPOS = packMap.get(item);
                        if(!CollectionUtils.isEmpty(schemePackPOS)){
                            SaasSchemePackPO saasSchemePackPO = schemePackPOS.get(0);
                            CrcAllocationRecordPO recordPO = new CrcAllocationRecordPO();
                            recordPO.setId(Sequence.getInstance().nextId());
                            recordPO.setObjId(item);
                            recordPO.setObjType(1);
                            recordPO.setOperatorId(StringUtils.isEmpty(saasSchemePackPO.getImplId())?saasSchemePackPO.getUpdateLoginId():Long.parseLong(saasSchemePackPO.getImplId()));
                            recordPO.setOperatorCode(StringUtils.isEmpty(saasSchemePackPO.getImplCode())?saasSchemePackPO.getUpdateUsername():saasSchemePackPO.getImplCode());
                            recordPO.setOperatorName(StringUtils.isEmpty(saasSchemePackPO.getImplName())?saasSchemePackPO.getUpdateName():saasSchemePackPO.getImplName());
                            recordPO.setOperatorById(reqBo.getImplId());
                            recordPO.setOperatorByName(reqBo.getImplName());
                            recordPO.setOperatorByCode(reqBo.getImplCode());
                            recordPO.setIsDeleted(0);
                            return recordPO;
                        }
                        return null;
                    })
                    .collect(Collectors.toList());
            crcAllocationRecordMapper.batchInsert(crcAllocationRecordPOS);
        }catch (Exception e){
            log.error("updatePackageAllocation saveOperateLog error:{}",e);
        }
    }

    @Override
    public SscQrySchemePackExtRspBO updateClearSchemeSchemeExectStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null){
            int num = saasSchemePackMapper.updateClearSchemeSchemeExectStatus(reqBO.getSchemeId(), reqBO.getSchemeExectStatus());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryNonRecruitmentIdBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscSchemeQryPO> sscSchemeExtList = saasSchemePackMapper.getSscSchemeExtList(reqBO.getSchemeIds());
            Map<Long,SscQrySchemeExectStatusPackExtBO> schemeIdMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(sscSchemeExtList)){
                for (SscSchemeQryPO po : sscSchemeExtList) {
                    if ("nonRecruitmentId".equals(po.getFieldCode())){
                        if (schemeIdMap.keySet().contains(po.getSchemeId())){
                            SscQrySchemeExectStatusPackExtBO bo = schemeIdMap.get(po.getSchemeId());
                            bo.setNonRecruitmentId(po.getFieldValue());
                        }else {
                            SscQrySchemeExectStatusPackExtBO bo = new SscQrySchemeExectStatusPackExtBO();
                            bo.setSchemeId(po.getSchemeId());
                            bo.setNonRecruitmentId(po.getFieldValue());
                            schemeIdMap.put(po.getSchemeId(),bo);
                        }
                    }
                    if ("isCanHangUp".equals(po.getFieldCode())){
                        if (schemeIdMap.keySet().contains(po.getSchemeId())){
                            SscQrySchemeExectStatusPackExtBO bo = schemeIdMap.get(po.getSchemeId());
                            bo.setIsCanHangUp(po.getFieldValue());
                        }else {
                            SscQrySchemeExectStatusPackExtBO bo = new SscQrySchemeExectStatusPackExtBO();
                            bo.setSchemeId(po.getSchemeId());
                            bo.setIsCanHangUp(po.getFieldValue());
                            schemeIdMap.put(po.getSchemeId(),bo);
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(schemeIdMap)){
                List<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = new ArrayList<>();
                for (Long schemeId : schemeIdMap.keySet()) {
                    schemeExectBOs.add(schemeIdMap.get(schemeId));
                }
                rspBO.setSchemeExectBOs(schemeExectBOs);
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getIsQryDatabaseSync()!=null && reqBO.getIsQryDatabaseSync()==0){
            if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
                List<Integer> types = new ArrayList<>();
                if (CollectionUtils.isEmpty(reqBO.getTypes())){
                    //默认只查询同步非招
                    types.add(1);
                    types.add(5);
                    types.add(6);
                }else {
                    types = reqBO.getTypes();
                }
                List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.groupQryPushStatus(reqBO.getSchemeIds(),types);
                if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)){
                    List<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<>();
                    Map<Long, List<SscQrySchemePackExtBO>> schemeIdMap = sscQrySchemePackExtBOS.stream().filter(e -> e.getPushStatus() != null).collect(Collectors.groupingBy(SscQrySchemePackExtBO::getSchemeId));
                    for (Long schemeId : schemeIdMap.keySet()) {
                        SscQrySchemePackExtBO bo = new SscQrySchemePackExtBO();
                        bo.setSchemeId(schemeId);
                        bo.setPushStatus(0);
                        for (SscQrySchemePackExtBO packExtBO : schemeIdMap.get(schemeId)) {
                            if (packExtBO.getPushStatus()==1){
                                //同步失败
                                bo.setPushStatus(1);
                                break;
                            }
                        }
                        for (SscQrySchemePackExtBO packExtBO : schemeIdMap.get(schemeId)) {
                            if (packExtBO.getPushStatus()==2){
                                //同步中
                                bo.setPushStatus(2);
                            }
                        }
                        sscSchemePack.add(bo);
                    }
                    reqBO.setSscSchemePack(sscSchemePack);
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getIsQryDatabaseSync()!=null && reqBO.getIsQryDatabaseSync()==0) {
            if (!CollectionUtils.isEmpty(reqBO.getPackIds())) {
                List<Integer> types = new ArrayList<>();
                if (CollectionUtils.isEmpty(reqBO.getTypes())) {
                    types.add(7);
                } else {
                    types = reqBO.getTypes();
                }
                if (reqBO.getIsQryDatabaseSync() != null && reqBO.getIsQryDatabaseSync() == 0) {
                    List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.groupQryPackPushStatus(reqBO.getPackIds(), types);
                    if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)) {
                        List<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<>();
                        Map<Long, List<SscQrySchemePackExtBO>> packIdMap = sscQrySchemePackExtBOS.stream().filter(e -> e.getPushStatus() != null).collect(Collectors.groupingBy(SscQrySchemePackExtBO::getPackId));
                        for (Long packId : packIdMap.keySet()) {
                            SscQrySchemePackExtBO bo = new SscQrySchemePackExtBO();
                            bo.setPackId(packId);
                            bo.setPushStatus(0);
                            for (SscQrySchemePackExtBO packExtBO : packIdMap.get(packId)) {
                                if (packExtBO.getPushStatus() == 1) {
                                    //同步失败
                                    bo.setPushStatus(1);
                                    break;
                                }
                            }
                            for (SscQrySchemePackExtBO packExtBO : packIdMap.get(packId)) {
                                if (packExtBO.getPushStatus() == 2) {
                                    //同步中
                                    bo.setPushStatus(2);
                                }
                            }
                            sscSchemePack.add(bo);
                        }
                        reqBO.setSscSchemePack(sscSchemePack);
                    }
                }
            }
        }
            rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            return rspBO;
    }
    @Override
    public SscQrySchemePackExtRspBO qryPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        List<Integer> types = new ArrayList<>();
        if (CollectionUtils.isEmpty(reqBO.getTypes())){
            //默认只查询同步非招
            types.add(1);
            types.add(5);
            types.add(6);
        }else {
            types = reqBO.getTypes();
        }
        reqBO.setTypes(types);
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.groupQryPushStatus(reqBO.getSchemeIds(),types);
            if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)){
                rspBO.setBos(sscQrySchemePackExtBOS);
            }
        }
        if (reqBO.getPageNo()!=null && reqBO.getPageSize()!=null && reqBO.getSchemeId()!=null){
            Page<SscQrySchemePackExtBO> pg = new Page<SscQrySchemePackExtBO>(reqBO.getPageNo(), reqBO.getPageSize());
            List<SscQrySchemePackExtBO> bos = saasSchemePackMapper.qryPushStatusListPage(reqBO, pg);
            rspBO.setBos(bos);
            rspBO.setPageNo(pg.getPageNo());
            rspBO.setRecordsTotal(pg.getTotalCount());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        List<Integer> types = new ArrayList<>();
        if (CollectionUtils.isEmpty(reqBO.getTypes())){
            types.add(7);

        }else {
            types = reqBO.getTypes();
        }
        reqBO.setTypes(types);
        if (!CollectionUtils.isEmpty(reqBO.getPackIds())){
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = saasSchemePackMapper.groupQryPackPushStatus(reqBO.getPackIds(),types);
            if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)){
                rspBO.setBos(sscQrySchemePackExtBOS);
            }
        }
        if (reqBO.getPageNo()!=null && reqBO.getPageSize()!=null && reqBO.getPackId()!=null){
            Page<SscQrySchemePackExtBO> pg = new Page<SscQrySchemePackExtBO>(reqBO.getPageNo(), reqBO.getPageSize());
            List<SscQrySchemePackExtBO> bos = saasSchemePackMapper.qryPackPushStatusListPage(reqBO, pg);
            rspBO.setBos(bos);
            rspBO.setPageNo(pg.getPageNo());
            rspBO.setRecordsTotal(pg.getTotalCount());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateCommonItemNo(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getPlanId()!=null){

            List<Long> schemeMatIds = new ArrayList<>();
            int pageNo = 1;
            int pageSize = 1000;
            int curPage = (pageNo - 1) * pageSize;
            do{
                List<Long> commonItemNoSchemeMatIds = saasSchemePackMapper.getCommonItemNoSchemeMatIds(reqBO.getPlanId(), curPage, pageSize);
                if (CollectionUtils.isEmpty(commonItemNoSchemeMatIds)){
                    break;
                }else {
                    schemeMatIds.addAll(commonItemNoSchemeMatIds);
                    //修改主表
                    SchemeMatExtBO schemeMatExtBO = new SchemeMatExtBO();
                    schemeMatExtBO.setPlanId(reqBO.getPlanId());
                    schemeMatExtBO.setMatCode(reqBO.getItemNo());
                    schemeMatExtBO.setMatName(reqBO.getItemName());
                    schemeMatExtBO.setMatSpec(reqBO.getSpec());
                    schemeMatExtBO.setMatModel(reqBO.getModel());
                    schemeMatExtBO.setCatalogCode(reqBO.getCatalogCode());
                    schemeMatExtBO.setCatalogName(reqBO.getCatalogName());
                    schemeMatExtBO.setRemark(reqBO.getItemDesc());
                    //方案这面物料名称都是用的物料描述
                    if (!StringUtils.isEmpty(reqBO.getItemDesc())){
                        schemeMatExtBO.setMatName(reqBO.getItemDesc());
                    }
                    schemeMatExtBO.setMeasureUnitName(reqBO.getMeasureUnitName());
                    schemeMatExtBO.setSchemeMatIds(schemeMatIds);
                    saasSchemePackMapper.updateCommonItemNo(schemeMatExtBO);
                    saasSchemePackMapper.updateCommonItemNoCollecControlExt(schemeMatIds,reqBO.getInControlsCatalog());
                    saasSchemePackMapper.updateCommonItemNocollecImplExt(schemeMatIds,reqBO.getInImplementCatalog());
                }
                pageNo++;
                curPage = (pageNo - 1) * pageSize;
            }while (!CollectionUtils.isEmpty(schemeMatIds));
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO verifySchemeNo(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setIsSchemeExist(0);
        if (!StringUtils.isEmpty(reqBO.getSchemeNo())){
            List<SscQrySchemeExectStatusPackExtBO> bos = saasSchemePackMapper.qrySchemeBySchemeNo(reqBO.getSchemeNo());
            if (!CollectionUtils.isEmpty(bos)){
                List<Long> existSchemeIds = bos.stream().filter(e->e.getSchemeId()!=null && !e.getSchemeId().equals(reqBO.getSchemeId())).map(SscQrySchemeExectStatusPackExtBO::getSchemeId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(existSchemeIds)){
                    rspBO.setIsSchemeExist(1);
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updatePackImplCodeDefault(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null && !StringUtils.isEmpty(reqBO.getCreateName()) && !StringUtils.isEmpty(reqBO.getCreateUsername())){
            List<Long> schemeIds = new ArrayList<>();
            schemeIds.add(reqBO.getSchemeId());
            List<SaasSchemePackPO> saasSchemePackPOS = saasSchemePackMapper.qryPackBySchemeIds(schemeIds);
            if (!CollectionUtils.isEmpty(saasSchemePackPOS)){
                List<Long> packIds = saasSchemePackPOS.stream().filter(e -> StringUtils.isEmpty(e.getImplCode()) || StringUtils.isEmpty(e.getImplName())).map(SaasSchemePackPO::getPackId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(packIds)){
                    saasSchemePackMapper.updatePackImplCodeDefault(packIds,reqBO.getCreateUsername(),reqBO.getCreateName());
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryPlanMatBySchemeId(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()==null){
            rspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
            rspBO.setRespDesc("入参查询方案id不能为空");
            return rspBO;
        }
        if (reqBO.getSchemeType()==null){
            throw new ZTBusinessException("入参查询方案类型不能为空");
        }
        if (reqBO.getQryFlag()==null){
            throw new ZTBusinessException("入参查询类型不能为空");
        }else {
            List<SscQryMatExtBO> sscQryMatExtBOS = new ArrayList<>();
            if (reqBO.getQryFlag()==1){
                //查询哪张物资表，1是 查询草稿表  2 是查询正式表  3 是查询历史表
                if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())){
                    sscQryMatExtBOS = saasSchemePackMapper.qryDraftPlanMatBySchemeId(reqBO.getSchemeId(), null, null);
                }
                if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())){
                    //集采方案只对来自计划分流的包做同步方案量，因为 集采方案 不能修改 被分配过来的包,采购方案包ids (当方案修改时，新添加的分配的采购方案包，因为此时包数据还没有存到数据库)
                    sscQryMatExtBOS = saasSchemePackMapper.qryDraftPlanMatBySchemeId(reqBO.getSchemeId(),1,reqBO.getPurchasePackageIds());
                }
            }else  if (reqBO.getQryFlag()==2){
                //查询哪张物资表，1是 查询草稿表  2 是查询正式表  3 是查询历史表
                if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())){
                    sscQryMatExtBOS = saasSchemePackMapper.qryFormalPlanMatBySchemeId(reqBO.getSchemeId(),null);
                }
                if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())){
                    //集采方案只对来自计划分流的包做同步方案量，因为 集采方案 不能修改 被分配过来的包,采购方案包ids (当方案修改时，新添加的分配的采购方案包，因为此时包数据还没有存到数据库)
                    sscQryMatExtBOS = saasSchemePackMapper.qryFormalPlanMatBySchemeId(reqBO.getSchemeId(),1);
                }

            }else if (reqBO.getQryFlag()==3){
                //查询哪张物资表，1是 查询草稿表  2 是查询正式表  3 是查询历史表
                if (reqBO.getSchemeHisId()==null){
                    throw new ZTBusinessException("入参查询历史id不能为空");
                }
                if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())){
                    sscQryMatExtBOS = saasSchemePackMapper.qryHislPlanMatBySchemeId(reqBO.getSchemeId(),null,reqBO.getSchemeHisId());
                }
                if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())){
                    //集采方案只对来自计划分流的包做同步方案量，因为 集采方案 不能修改 被分配过来的包,采购方案包ids (当方案修改时，新添加的分配的采购方案包，因为此时包数据还没有存到数据库)
                    sscQryMatExtBOS = saasSchemePackMapper.qryHislPlanMatBySchemeId(reqBO.getSchemeId(),1,reqBO.getSchemeHisId());
                }
            }else {
                throw new ZTBusinessException("入参查询类型异常");
            }
            rspBO.setSscQryMatExtBOS(sscQryMatExtBOS);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryTotalExpectMoneySum(SscQrySchemePackExtReqBO reqBO) {
        return null;
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemeMatNullValueBatch(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        //首先这个只能修改草稿表的数据字段

        Integer type = Integer.valueOf(reqBO.getUpdateType());
        List<SscSchemeMatCceExtBO> sscSchemeMat = reqBO.getSscSchemeMat();
        if(sscSchemeMat.size() != 1){
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "sscSchemeMat(方案物料信息)有且只能有一条数据,当前存在"+sscSchemeMat.size());
        }
        List<SscSchemeMatDraftExtPO> itemInfo = new ArrayList<>();
        //应用到全部物料行                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             updateType=1
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_ALL_MAT)) {
            //查询所有数据
            Page<SscSchemeMatDraftExtPO> page = new Page<>();
            page.setPageNo(1);
            page.setPageSize(5000);
            SscSchemeMatDraftExtPO searchPO = new SscSchemeMatDraftExtPO();
            searchPO.setSchemeId(reqBO.getSchemeId());
            searchPO.setPackId(sscSchemeMat.get(0).getPackId());
            searchPO.setOrderBy("scheme_mat_id desc");
            List<SscSchemeMatDraftExtPO> list = sscPlanPackMapper.getListPage(searchPO, page);
            if (!CollectionUtils.isEmpty(list)){
                for (SscSchemeMatDraftExtPO po : list) {
                    SscSchemeMatDraftExtPO updatePO = new SscSchemeMatDraftExtPO();
                    updatePO.setSchemeMatId(po.getSchemeMatId());
                    updatePO.setSchemeId(po.getSchemeId());
                    if (po.getTaxRate()!=null && po.getNoTaxPrice()!=null && po.getPurchaseNum()!=null){
                        updatePO.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                        updatePO.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                        updatePO.setExpectPrice(updatePO.getTaxPrice());
                        updatePO.setExpectMoney(updatePO.getTotalTaxPrice());
                        itemInfo.add(updatePO);
                    }
                }
                int totalPages = page.getTotalPages();
                if (totalPages > 1) {
                    for (int i = 2; i <= totalPages; i++) {
                        Page<SscSchemeMatDraftExtPO> pageParam = new Page<>();
                        pageParam.setPageNo(i);
                        pageParam.setPageSize(5000);
                        List<SscSchemeMatDraftExtPO> listPage = sscPlanPackMapper.getListPage(searchPO, page);
                        for (SscSchemeMatDraftExtPO po : listPage) {
                            SscSchemeMatDraftExtPO updatePO = new SscSchemeMatDraftExtPO();
                            updatePO.setSchemeMatId(po.getSchemeMatId());
                            updatePO.setSchemeId(po.getSchemeId());
                            if (po.getTaxRate()!=null && po.getNoTaxPrice()!=null && po.getPurchaseNum()!=null){
                                updatePO.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                                updatePO.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                                updatePO.setExpectPrice(updatePO.getTaxPrice());
                                updatePO.setExpectMoney(updatePO.getTotalTaxPrice());
                                itemInfo.add(updatePO);
                            }
                        }
                    }
                }
            }
        }
        //应用到选中物料行	updateType=3
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_CHECKED)) {
            if(CollectionUtils.isEmpty(sscSchemeMat.get(0).getSchemeMatIds())){
                throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参schemeMatIds方案物料ID集合为空");
            }
            Page<SscSchemeMatDraftExtPO> page = new Page<>();
            page.setPageNo(1);
            page.setPageSize(1000);
            SscSchemeMatDraftExtPO searchPO = new SscSchemeMatDraftExtPO();
            searchPO.setSchemeId(reqBO.getSchemeId());
            searchPO.setPackId(sscSchemeMat.get(0).getPackId());
            searchPO.setSchemeMatIds(sscSchemeMat.get(0).getSchemeMatIds());
            searchPO.setOrderBy("scheme_mat_id desc");
            List<SscSchemeMatDraftExtPO> list = sscPlanPackMapper.getListPage(searchPO, page);
            if (!CollectionUtils.isEmpty(list)){
                for (SscSchemeMatDraftExtPO po : list) {
                    SscSchemeMatDraftExtPO updatePO = new SscSchemeMatDraftExtPO();
                    updatePO.setSchemeMatId(po.getSchemeMatId());
                    updatePO.setSchemeId(po.getSchemeId());
                    if (po.getTaxRate()!=null && po.getNoTaxPrice()!=null && po.getPurchaseNum()!=null){
                        updatePO.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                        updatePO.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                        updatePO.setExpectPrice(updatePO.getTaxPrice());
                        updatePO.setExpectMoney(updatePO.getTotalTaxPrice());
                        itemInfo.add(updatePO);
                    }
                }
            }
        }
        //应用到未填写物料行  updateType=2
        if(type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_NO_WRITE)) {
           //计划分流都是有税率的所以不用计算
        }
        if (!CollectionUtils.isEmpty(itemInfo)){
            sscPlanPackMapper.updateSchemeMatNullValueBatch(itemInfo);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO deleteAllInviteSupDraft(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null ){
            //首先拿到对应的供应商Ids
            List<Long> schemeInviteSupId = saasSchemePackMapper.qrySchemeInviteDraft(reqBO.getSchemeId(), reqBO.getPackId());
            if (!CollectionUtils.isEmpty(schemeInviteSupId)){
                //开始进行删除
                saasSchemePackMapper.deleteSchemeInviteExtDraftBy(schemeInviteSupId);
                int count = saasSchemePackMapper.deleteSchemeInviteDraftBy(schemeInviteSupId);
                if (count==0){
                    rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                    rspBO.setRespDesc("删除失败，删除成功的条数为0条");
                    return rspBO;
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemePackAssignStatusExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            int count = saasSchemePackMapper.updateSchemePackAssignStatusExect(reqBO.getSchemeIds());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeSubmitType(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscQrySchemePackExtBO> bos = saasSchemePackMapper.qrySchemeSubmitType(reqBO.getSchemeIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getList())){
            Date nowDate = new Date();
            List<SscSchemeChangeDistributionModeLogPO> insertPOS = new ArrayList<>();
            for (SscSchemeChangeDistributionModeLogBO bo : reqBO.getList()) {
                SscSchemeChangeDistributionModeLogPO po = JSONObject.parseObject(JSONObject.toJSONString(bo), SscSchemeChangeDistributionModeLogPO.class);
                po.setLogId(uccBatchSequence.nextId());
                po.setCreateTime(nowDate);
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateName(reqBO.getName());
                po.setCreateUserName(reqBO.getUsername());
                insertPOS.add(po);
            }
            sscSchemeChangeDistributionModeLogMapper.insertBatch(insertPOS);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryChangeDistributionModeLogList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null){
            List<Long> schemeIds = new ArrayList<>();
            schemeIds.add(reqBO.getSchemeId());
            Page<SscSchemeChangeDistributionModeLogPO> pg = new Page<SscSchemeChangeDistributionModeLogPO>(reqBO.getPageNo(), reqBO.getPageSize());
            List<SscSchemeChangeDistributionModeLogPO> pos = sscSchemeChangeDistributionModeLogMapper.qryListBySchemeIdsPage(schemeIds, pg);
            if (!CollectionUtils.isEmpty(pos)){
                List<SscSchemeChangeDistributionModeLogBO> logBOS = JSONObject.parseArray(JSONObject.toJSONString(pos), SscSchemeChangeDistributionModeLogBO.class);
                rspBO.setLogBOS(logBOS);
            }else {
                rspBO.setLogBOS(new ArrayList<>());
            }
            rspBO.setTotal(pg.getTotalPages());
            rspBO.setPageNo(pg.getPageNo());
            rspBO.setRecordsTotal(pg.getTotalCount());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryIsExistChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();

        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<Long> schemeIds = sscSchemeChangeDistributionModeLogMapper.qryIsExistChangeDistributionModeLog(reqBO.getSchemeIds());
            rspBO.setSchemeIds(schemeIds);
        }

        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qrySchemeOrganizationFormByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();

        if (!CollectionUtils.isEmpty(reqBO.getPackIds())){
            List<SscQrySchemePackExtBO> bos = saasSchemePackMapper.qrySchemeOrganizationFormByPackIds(reqBO.getPackIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemeNullField(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null){
            saasSchemePackMapper.updateSchemeNullField(reqBO.getSchemeId());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addBasisFile(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null){
            //先清空再新增
            schemeBasisFileMapper.deleteBySchemeId(reqBO.getSchemeId(),1);
        }
        if (!CollectionUtils.isEmpty(reqBO.getBasisFileBoList())){
            //因为 ssc_scheme_pack 表的 包id是唯一的，所以直接 根据包id去清空
            List<Long> packIds = reqBO.getBasisFileBoList().stream().filter(e -> e.getPackId() != null).map(SchemeBasisFileBO::getPackId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(packIds)){
                schemeBasisFileMapper.deleteByPackIds(packIds,1);
            }

            List<SchemeBasisFilePO> list = new ArrayList<>();
            for (SchemeBasisFileBO fileBO : reqBO.getBasisFileBoList()) {
                SchemeBasisFilePO po = JSONObject.parseObject(JSONObject.toJSONString(fileBO), SchemeBasisFilePO.class);
                po.setFileId(uccBatchSequence.nextId());
                list.add(po);
            }
            schemeBasisFileMapper.insertBatch(list);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {

        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getBasisFailBoList())){
            List<SchemeBasisFileBuildFailPO> list =new ArrayList<>();
            for (SchemeBasisFileBuildFailBO bo : reqBO.getBasisFailBoList()) {
                SchemeBasisFileBuildFailPO po = JSONObject.parseObject(JSONObject.toJSONString(bo), SchemeBasisFileBuildFailPO.class);
                po.setFailId(uccBatchSequence.nextId());
                list.add(po);
            }
            if (!CollectionUtils.isEmpty(list))
            schemeBasisFileBuildFailMapper.insertBatch(list);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeBasisFileBuildFailBO()!=null && reqBO.getSchemeBasisFileBuildFailBO().getFailId()!=null){
            SchemeBasisFileBuildFailPO updatePO = JSONObject.parseObject(JSONObject.toJSONString(reqBO.getSchemeBasisFileBuildFailBO()), SchemeBasisFileBuildFailPO.class);
            schemeBasisFileBuildFailMapper.updateByPrimaryKeySelective(updatePO);
        }

        if (!CollectionUtils.isEmpty(reqBO.getFailIds()) && reqBO.getStatus()!=null){
            schemeBasisFileBuildFailMapper.updateStatusBatch(reqBO.getFailIds(),reqBO.getStatus());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        SchemeBasisFileBuildFailPO searchPO = new SchemeBasisFileBuildFailPO();
        searchPO.setStatus(reqBO.getStatus());
        searchPO.setFileType(reqBO.getFileType());
        Page<SchemeBasisFileBuildFailPO> pg = new Page<SchemeBasisFileBuildFailPO>(reqBO.getPageNo(), reqBO.getPageSize());
        List<SchemeBasisFileBuildFailPO> buildFailPOS = schemeBasisFileBuildFailMapper.selectByPOPage(searchPO, pg);
        if (!CollectionUtils.isEmpty(buildFailPOS)){
            List<SchemeBasisFileBuildFailBO> basisFailBoList = JSONObject.parseArray(JSONObject.toJSONString(buildFailPOS), SchemeBasisFileBuildFailBO.class);
            rspBO.setBasisFailBoList(basisFailBoList);
        }
        rspBO.setPageNo(pg.getPageNo());
        rspBO.setRecordsTotal(pg.getTotalCount());
        rspBO.setTotal(pg.getTotalPages());
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        Page<SchemeBasisFileInitPO> pg = new Page<SchemeBasisFileInitPO>(reqBO.getPageNo(), reqBO.getPageSize());

        SchemeBasisFileInitPO searchPO = new SchemeBasisFileInitPO();
        searchPO.setStatus(reqBO.getStatus());
        List<SchemeBasisFileInitPO> initPOS = schemeBasisFileInitMapper.selectByPOPage(searchPO, pg);

        if (!CollectionUtils.isEmpty(initPOS)){
            List<SchemeBasisFileInitBO> basisFileInitBOS = JSONObject.parseArray(JSONObject.toJSONString(initPOS), SchemeBasisFileInitBO.class);
            rspBO.setBasisFileInitBoList(basisFileInitBOS);
        }
        rspBO.setPageNo(pg.getPageNo());
        rspBO.setRecordsTotal(pg.getTotalCount());
        rspBO.setTotal(pg.getTotalPages());
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getBasisFileInitBoList())){
            List<SchemeBasisFileInitPO> collection = JSONObject.parseArray(JSONObject.toJSONString(reqBO.getBasisFileInitBoList()), SchemeBasisFileInitPO.class);
            schemeBasisFileInitMapper.updateBatch(collection);
        }

        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryBasisFileList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getPackIds()) && reqBO.getFileType()!=null){
            List<SchemeBasisFilePO> pos = schemeBasisFileMapper.selectByPackIds(reqBO.getPackIds(), reqBO.getFileType());
            if (!CollectionUtils.isEmpty(pos)){
                List<SchemeBasisFileBO> basisFileBoList = JSONObject.parseArray(JSONObject.toJSONString(pos), SchemeBasisFileBO.class);
                rspBO.setBasisFileBoList(basisFileBoList);
            }
            //需求变动，现在也查询方案用户上传的附件
            if (reqBO.getFileType()==1){
                List<Long> schemeIds = saasSchemePackMapper.getSchemeIdByPackIds(reqBO.getPackIds());
                if (!CollectionUtils.isEmpty(schemeIds)){
                    SscAccessoryPO qrySscAccessoryPO = new SscAccessoryPO();
                    qrySscAccessoryPO.setObjIds(schemeIds);
                    List<SscAccessoryPO> sscAccessoryPOS = sscAccessoryExtMapper.getList(qrySscAccessoryPO);
                    if (!CollectionUtils.isEmpty(sscAccessoryPOS)){
                        List<SchemeBasisFileBO> basisFileBoList = new ArrayList<>();
                        if (!CollectionUtils.isEmpty(rspBO.getBasisFileBoList())){
                            basisFileBoList = rspBO.getBasisFileBoList();
                        }
                        for (SscAccessoryPO sscAccessoryPO : sscAccessoryPOS) {
                            SchemeBasisFileBO fileBO = new SchemeBasisFileBO();
                            fileBO.setFileName(sscAccessoryPO.getAccessoryName());
                            fileBO.setFileUrl(sscAccessoryPO.getAccessoryUrl());
                            basisFileBoList.add(fileBO);
                        }
                        rspBO.setBasisFileBoList(basisFileBoList);
                    }
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryImplInfoBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            List<SscQrySchemePackExtBO> bos = saasSchemePackMapper.qryImplInfoBySchemeIds(reqBO.getSchemeIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO addJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getJoinSignLogBOS())){
            List<SscJoinSignLogPO> sscJoinSignLogPOS = JSONObject.parseArray(JSONObject.toJSONString(reqBO.getJoinSignLogBOS()), SscJoinSignLogPO.class);
            sscJoinSignLogMapper.insertBatch(sscJoinSignLogPOS);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty(reqBO.getTaskIds())){
            List<SscJoinSignLogPO> sscJoinSignLogPOS = sscJoinSignLogMapper.selectByTaskIds(reqBO.getTaskIds());
            if (!CollectionUtils.isEmpty(sscJoinSignLogPOS)){
                List<String> existTaskIds = sscJoinSignLogPOS.stream().map(SscJoinSignLogPO::getTaskId).collect(Collectors.toList());
                rspBO.setExistTaskIds(existTaskIds);
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateSchemeLastTime(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null && !StringUtils.isEmpty(reqBO.getProcInstId()) && !StringUtils.isEmpty(reqBO.getFormUrl())){
            Date lastFinishTime = saasSchemePackMapper.getLastFinishTime(reqBO.getProcInstId(), reqBO.getFormUrl());
            if (lastFinishTime!=null){

            }else {
                //如果上一步骤没有已审批的人，那就取当前时间
                lastFinishTime = new Date();
            }
            //先删除扩展字段
            SscCommonDo deleteSscCommonDo = new SscCommonDo();

            List<SscExtObjInfo> deleteExtOperObjInfoList = new ArrayList<>();
            SscExtObjInfo deleteSchemeExtInfo = new SscExtObjInfo();
            deleteSchemeExtInfo.setObjType("ssc_scheme_ext");
            deleteSchemeExtInfo.setOrderId(reqBO.getSchemeId());
            deleteSchemeExtInfo.setObjId(reqBO.getSchemeId());
            List<SscExtInfo> deleteSchemeExtInfoList = new ArrayList<>();

            SscExtInfo deleteSchemeExtInfo1 = new SscExtInfo();
            deleteSchemeExtInfo1.setFieldCode("lastFinishTime");
            deleteSchemeExtInfoList.add(deleteSchemeExtInfo1);

            SscExtInfo deleteSchemeExtInfo2 = new SscExtInfo();
            deleteSchemeExtInfo2.setFieldCode("lastFinishTimeLong");
            deleteSchemeExtInfoList.add(deleteSchemeExtInfo2);

            deleteSchemeExtInfo.setExtInfo(deleteSchemeExtInfoList);

            deleteExtOperObjInfoList.add(deleteSchemeExtInfo);
            deleteSscCommonDo.setExtObjInfos(deleteExtOperObjInfoList);
            iSscCommonModel.deleteExtInfo(deleteSscCommonDo);

            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            //再新增
            SscCommonDo sscCommonOperDoadd = new SscCommonDo();
            List<SscExtObjInfo> listOperAdd = new ArrayList<>();
            List<SscExtInfo> listExtInfos = new ArrayList<>();
            SscExtInfo ExtInfo1 = new SscExtInfo();
            ExtInfo1.setFieldCode("lastFinishTime");
            ExtInfo1.setFieldName("方案的审批上一步骤的时间");
            ExtInfo1.setFieldValue(sdf.format(lastFinishTime));
            listExtInfos.add(ExtInfo1);

            SscExtInfo ExtInfo2 = new SscExtInfo();
            ExtInfo2.setFieldCode("lastFinishTimeLong");
            ExtInfo2.setFieldName("方案的审批上一步骤的时间Long型");
            ExtInfo2.setFieldValue(lastFinishTime.getTime()+"");
            listExtInfos.add(ExtInfo2);

            SscExtObjInfo schemeExtInfo2 = new SscExtObjInfo();
            schemeExtInfo2.setObjType("ssc_scheme_ext");
            schemeExtInfo2.setOrderId(reqBO.getSchemeId());
            schemeExtInfo2.setObjId(reqBO.getSchemeId());
            schemeExtInfo2.setExtInfo(listExtInfos);
            listOperAdd.add(schemeExtInfo2);
            sscCommonOperDoadd.setExtObjInfos(listOperAdd);
            iSscCommonModel.addExtInfo(sscCommonOperDoadd);
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO qryRelation(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId()!=null){
            SscQrySchemeRelationExtBO schemeRelation = sscPlanPackMapper.qrySchemeRelation(reqBO.getSchemeId());
            if (schemeRelation!=null && schemeRelation.getSchemeId()!=null){
                rspBO.setSchemeRelationExtBO(schemeRelation);
                //判断是否为简易采购计划
                if(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(schemeRelation.getSchemeType())) {
                    //简易采购计划
                }else {
                    //采购方案或者集采方案
                    List<SscQrySchemePackRelationExtBO> packRelationExtBOS = sscPlanPackMapper.qrySchemePackRelation(reqBO.getSchemeId());
                    rspBO.setPackRelationExtBOS(packRelationExtBOS);
                }
            }
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO updateRelation(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        //修改方案
        if (reqBO.getSchemeRelationExtBO()!=null && reqBO.getSchemeRelationExtBO().getSchemeId()!=null){
            sscPlanPackMapper.updateSchemeRelation(reqBO.getSchemeRelationExtBO());
        }
        //修改方案包
        if (!CollectionUtils.isEmpty(reqBO.getPackRelationExtBOS())){
            for (SscQrySchemePackRelationExtBO pack : reqBO.getPackRelationExtBOS()) {
                if (pack.getPackId()==null){
                    throw new ZTBusinessException("包id不能为空");
                }
            }
            sscPlanPackMapper.updateSchemePackRelation(reqBO.getPackRelationExtBOS());
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
