package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.ssc.bo.SscSchemeRspBO;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMapper;
import com.tydic.dyc.ssc.repository.dao.SscSchemeMatMapper;
import com.tydic.dyc.ssc.repositoryExt.config.SscThreadPoolExecutorUtil;
import com.tydic.dyc.ssc.repositoryExt.po.syncSchemeListPO;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.dyc.ssc.service.scheme.syncSchemeListService;
import lombok.extern.ohaotian.HTServiceAPI;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;

/**
 * 描述:
 *
 * @author WangGang
 * @date 2024/7/17
 */
@Slf4j
@HTServiceImpl
public class syncSchemeListServiceImpl implements syncSchemeListService {

    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Value("${PAGE_SIZE:100}")
    private int PAGE_SIZE;
    @Value("${MaxSize:200}")
    private int MaxSize;

    @HTServiceRef
    private SscQrySchemePackExtServie schemePackExtServie;

    /**
     * 线程池
     */
    private static final ThreadPoolExecutor threadPoolExecutor = SscThreadPoolExecutorUtil.poolExecutor;

    @Override
    public SscQrySchemePackExtRspBO syncSchemeList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO busiRspBO = new SscQrySchemePackExtRspBO();
        log.error("同步方案ES开启=====");

        if (null == reqBO.getIsFullSyncEs()) {
            if (CollectionUtils.isEmpty(reqBO.getSchemeIds()) && null == reqBO.getSchemeId()) {
                busiRspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
                busiRspBO.setRespDesc("入参为空");
                return busiRspBO;
            }
            List<Long> ids = new ArrayList<>();
            if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())) {
                ids.addAll(reqBO.getSchemeIds());
            }
            if (null != reqBO.getSchemeId()) {
                ids.add(reqBO.getSchemeId());
            }
            List<SscQrySchemePackExtBO> syncList = new ArrayList<>();
            for (Long schemeId : ids) {
                SscQrySchemePackExtBO sscQrySchemePackExtBO = new SscQrySchemePackExtBO();
                sscQrySchemePackExtBO.setSchemeId(schemeId);
                syncList.add(sscQrySchemePackExtBO);
            }
            dealData(syncList);
            busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            return busiRspBO;
        }else {
            log.error("全量同步方案ES开启=====");
            //查询需要匹配的数据总量
/*
        int planCount = schemePackMapper.queryCount();
        if (planCount == 0) {
            busiRspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_ERROR);
            return busiRspBO;
        }
        //计算页数
        int pageCount = planCount % PAGE_SIZE == 0 ? planCount / PAGE_SIZE : planCount / PAGE_SIZE + 1;
        //设置最大限制页数
        pageCount = pageCount > MaxSize ? MaxSize : pageCount;
*/


            //开启线程进行匹配
            //    for (int i = 1; i <= pageCount; i++){
            Page<syncSchemeListPO> page = new Page<>();
            page.setPageNo(-1);
            page.setPageSize(PAGE_SIZE);
            List<SscQrySchemePackExtBO> syncList = schemePackMapper.querySchemePage(page);
            dealData(syncList);
            //     }
            busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            return busiRspBO;
        }
    }

    @Override
    public SchemeListRspBO qrySchemeByPlanId(SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if(Objects.isNull(reqBO)){
            throw new ZTBusinessException("入参不能为空");
        }
        if(Objects.isNull(reqBO.getPlanId()) && CollectionUtils.isEmpty(reqBO.getPlanIds())){
            throw new ZTBusinessException("入参不能为空");
        }
        List<SscSchemeBO> sscSchemeBOS = schemePackMapper.qrySchemeByPlan(reqBO);
        if(!CollectionUtils.isEmpty(sscSchemeBOS)){
            rspBO.setSchemeList(JSON.parseArray(JSON.toJSONString(sscSchemeBOS), SscSchemeRspBO.class));
        }
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Override
    public SscQrySchemePackExtRspBO syncSchemeEsList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO busiRspBO = new SscQrySchemePackExtRspBO();
        log.error("同步方案ES开启=====");

        if (null == reqBO.getIsFullSyncEs()) {
            if (CollectionUtils.isEmpty(reqBO.getSchemeIds()) && null == reqBO.getSchemeId()) {
                busiRspBO.setRespCode(RspConstant.REQ_PARAM_NULL_ERROR);
                busiRspBO.setRespDesc("入参为空");
                return busiRspBO;
            }
            List<Long> ids = new ArrayList<>();
            if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())) {
                ids.addAll(reqBO.getSchemeIds());
            }
            if (null != reqBO.getSchemeId()) {
                ids.add(reqBO.getSchemeId());
            }
            List<SscQrySchemePackExtBO> syncList = new ArrayList<>();
            for (Long schemeId : ids) {
                SscQrySchemePackExtBO sscQrySchemePackExtBO = new SscQrySchemePackExtBO();
                sscQrySchemePackExtBO.setSchemeId(schemeId);
                syncList.add(sscQrySchemePackExtBO);
            }
            syncdealData(syncList);
            busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            return busiRspBO;
        }else {
            log.error("全量同步方案ES开启=====");
            //查询需要匹配的数据总量
/*
        int planCount = schemePackMapper.queryCount();
        if (planCount == 0) {
            busiRspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_ERROR);
            return busiRspBO;
        }
        //计算页数
        int pageCount = planCount % PAGE_SIZE == 0 ? planCount / PAGE_SIZE : planCount / PAGE_SIZE + 1;
        //设置最大限制页数
        pageCount = pageCount > MaxSize ? MaxSize : pageCount;
*/


            //开启线程进行匹配
            //    for (int i = 1; i <= pageCount; i++){
            List<SscQrySchemePackExtBO> syncList;
            int pageNo = 1;
            int pageSize = 1000;
            //Page<PlanDiversionInfo> page = new Page<>(pageNo,pageSize);
            int curPage = (pageNo-1)*pageSize;
            do {

                Page<syncSchemeListPO> page = new Page<>();
                page.setPageNo(-1);
                page.setPageSize(PAGE_SIZE);
                syncList = schemePackMapper.selectAllByPage(curPage,pageSize);
                syncdealData(syncList);
                pageNo++;
                curPage = (pageNo-1)*pageSize;
            } while (!CollectionUtils.isEmpty(syncList));
            //     }
            busiRspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            busiRspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            return busiRspBO;
        }
    }

    private void syncdealData( List<SscQrySchemePackExtBO> syncList) {
        CompletableFuture.runAsync(() -> {

            List<Long> schemeIds = syncList.stream().map(SscQrySchemePackExtBO::getSchemeId).collect(Collectors.toList());
            for (Long schemeId : schemeIds) {
                log.error("SchemeId()============" +schemeId);
                    SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
                    sscQrySchemePackExtReqBO.setSchemeId(schemeId);
                    schemePackExtServie.syncSchemeESBySchemeIds(sscQrySchemePackExtReqBO);
            }
        });
    }

    private void dealData( List<SscQrySchemePackExtBO> syncList) {
        CompletableFuture.runAsync(() -> {
            for (SscQrySchemePackExtBO sscQrySchemePackExtBO : syncList) {
                Long objId = schemePackMapper.queryObjId(sscQrySchemePackExtBO.getSchemeId());
                log.error("Objid============" +objId);
                log.error("SchemeId()============" +sscQrySchemePackExtBO.getSchemeId());
                if (null != objId){
                    SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
                    sscQrySchemePackExtReqBO.setOrderId(sscQrySchemePackExtBO.getSchemeId());
                    sscQrySchemePackExtReqBO.setObjId(objId);
                    schemePackExtServie.syncTaskBySchemeId(sscQrySchemePackExtReqBO);
                }
            }
        });
    }
}
