package com.tydic.dyc.ssc.repositoryExt.po;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 描述：通知
 * 
 * @author luoyunhao
 * @date 2023-07-10 16:58
 **/
@Data
public class CrcNoticePO implements Serializable {
	private static final long serialVersionUID =  4348297749596330041L;

	/**
	 * 主键
	 */
	private Long id;
	/**
	 * 来源单号id
	 */
	private List<Long> ids;
	/**
	 * 来源单号id
	 */
	private Long objId;
	/**
	 * 对象类型（1委托通知,2委托公示,3询比通知,4询比公示)
	 */
	private Long objType;
	/**
	 * 对象类型（1委托通知,2委托公示,3询比通知,4询比公示)
	 */
	private List<Long> objTypes;
	/**
	 * 通知书编号
	 */
	private String noticeCode;
	/**
	 * 通知书名称
	 */
	private String noticeName;
	/**
	 * 供应商编码
	 */
	private String supCode;
	/**
	 * 供应商名称
	 */
	private String supName;
	/**
	 * 状态(0-草稿,1-审批中，2-审批通过，3审批驳回 4.审批撤回，5签章中，6签章完成
	 */
	private Integer state;
	/**
	 * 创建时间
	 */
	private Date creatTime;
	private Date creatTimeStart;
	private Date creatTimeEnd;
	/**
	 * 审批时间
	 */
	private Date auditTime;
	private Date auditTimeStart;
	private Date auditTimeEnd;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 创建人id
	 */
	private String createId;
	/**
	 * 创建人编码
	 */
	private String createCode;
	/**
	 * 修改时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/**
	 * 公示公告名称
	 */
	private String noticeTitle;
	private String noticeContent;
	/**
	 * 审批意见
	 */
	private String ext1;
	/**
	 * 提交单位编码
	 */
	private String ext2;
	/**
	 * 提交单位名称
	 */
	private String ext3;
	/**
	 * 提交时间
	 */
	private String ext4;
	/**
	 * 提交人编码
	 */
	private String ext5;
	/**
	 * 提交人名称
	 */
	private String ext6;
	/**
	 * 备注
	 */
	private String ext7;
	/**
	 * 如果通知提交有审批流时，则记录流程Key
	 */
	private String ext8;
	/**
	 * 排序
	 */
	private String orderBy;
	/**
	 * 定标表主键id，非会员表供应商id
	 */
	private Long supTableId;
	/**
	 * 会员表供应商id
	 */
	private String supplierId;
	/**
	 * 电子签章信封id
	 */
	private Long envelopeId;
	/**
	 * 签章定时任务是否正在处理：0否 1是 2已完成
	 */
	private Integer isProcess;
	/**
	 * 发起方统一社会信用代码
	 */
	private String signInitiatorInfoSocCreCode;
	/**
	 * 来源单号id
	 */
	private List<Long> objIds;
	/**
	 * 状态(0-草稿,1-审批中，2-审批通过，3审批驳回 4.审批撤回，5签章中，6签章完成
	 */
	private List<Integer> stateList;
	/**
	 * 通知主键
	 */
	private Long noticeId;
	/**
	 * 询价Id
	 */
	private Long inquiryId;
	/**
	 * 询价编码
	 */
	private String inquiryCode;
	/**
	 * 询价名称
	 */
	private String inquirytName;
	/**
	 * 制单时间从
	 */
	private Date createTimeStart;
	/**
	 * 制单时间到
	 */
	private Date createTimeEnd;
	/**
	 * 定标表主键id，非会员表供应商id
	 */
	private List<Long> supTableIdList;

}
