package com.tydic.dyc.ssc.repositoryExt.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 标题：采购方案询比结果 PO
 * 时间：2023/08/07
 */
@Data
public class SscAwardResultPackExtPO implements Serializable {
    private static final long serialVersionUID = 6682676809916579394L;

    /**
     * 申报单位编码（实际取值申报单位id）
     */
    private String decCompanyCode;
    /**
     * 申报单位编码(实际取值申报单位编码)
     */
    private String decCompanyCodeErp;
    /**
     * 申报单位名称
     */
    private String decCompanyName;

    /**
     * 采购计划编码
     */
    private String planNo;

    /**
     * 物资编码
     */
    private String itemCode;

    /**
     * 物资描述
     */
    private String itemName;

    /**
     * 计量单位
     */
    private String itemUnit;

    /**
     * 询比采购量
     */
    private Double businessNum;

    /**
     * 中标量
     */
    private Double itemNum;

    /**
     * 已订货数量
     */
    private Double orderCount;

    /**
     * 中标未定量
     */
    private Double itemNumNot;

    /**
     * 报价单价
     */
    private Double priceTax;

    /**
     * 报价单价(不含税)
     */
    private Double priceNotax;

    /**
     * 成交单价
     */
    private Double awardPriceTax;

    /**
     * 成交单价(不含税)
     */
    private Double awardPriceNotax;

    /**
     * 报价运杂费
     */
    private Double bidFreight;

    /**
     * 成交运杂费
     */
    private Double awardFreight;

    /**
     * 报价货款(含税)
     */
    private Double amountTax;

    /**
     * 成交货款(含税)
     */
    private Double awardAmountTax;

    /**
     * 项目编码
     */
    private String projectCode;

    /**
     * 项目名称
     */
    private String projectName;

    /**
     * 询比结果编码/询价书编码
     */
    private String businessCode;

    /**
     * 询比结果名称/询价书名称
     */
    private String businessName;

    /**
     * 询价书编号
     */
    private String businessNo;

    /**
     * 询价书主键ID
     */
    private String businessId;

    /**
     * 供应商编码
     */
    private String companyCode;

    /**
     * 供应商名称
     */
    private String companyName;

    /**
     * 采购包编码
     */
    private String packageCode;

    /**
     * 采购包ID
     */
    private String packId;

    /**
     * 报价编码
     */
    private String bidCode;

    /**
     * 采购员编码
     */
    private String buyerId;

    /**
     * 询价制单人编码
     */
    private String createUid;

    /**
     * 结果制单人编码
     */
    private String awardCreateUserCode;

    /**
     * 计划使用单位
     */
    private String userCompanyName;

    /**
     * 方案类型
     */
    private Integer schemeType;

    /**
     * 物资分类字段
     */
    private Integer materialCategory;

    /**
     * 授标结果主键ID
     */
    private String awardId;

    /**
     * 打包人
     */
    private String awardUserName;

    /**
     * 打包人编码
     */
    private String awardEmployeeNumber;

    /**
     * 采购方式
     */
    private Integer dycBuyType;

    /**
     * 计划明细ID
     */
    private String dycPlanItemId;

    /**
     * 供应商主键id
     */
    private String companyId;

    /**
     * 授标明细ID
     */
    private String awardNumId;

    /**
     * 税率
     */
    private String awardItemTax;

    /**
     * 采购包物料ID
     */
    private Long schemaItemId;

    /**
     * 产地品牌
     */
    private String itemBrand;

    /**
     * 可下单数量
     */
    private BigDecimal canOrderNum;

    /**
     * 采购方案ID
     */
    private Long schemeId;

    /**
     * 方案编码
     */
    private String schemeCode;

    /**
     * 方案名称
     */
    private String schemeName;

    /**
     * 合同类型 采购标准合同 采购框架协议（定价） 采购框架协议（寄售）
     */
    private String contractType;

    /**
     * 采购包名称
     */
    private String packName;

    /**
     * 报价方式 1网上报价 2线下报价
     */
    private String quotationType;

    /**
     * 标段编码
     */
    private String bdCode;
    /**
     * 方案物资类别 (0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件)
     */
    private Integer schemeClass;
    /**
     * 合同起草人编码
     */
    private String crcHtQcUserCode;
    /**
     * 采购单位编码
     */
    private String createCompanyCode;

    /**
     * 采购单位名称
     */
    private String createCompanyName;
    /**
     * 成交方式1.总价成交2.单价成交3.费率成交
     */
    private String cjType;
    /**
     * 供应商中标表主键Id
     */
    private Long supTabId;
    /**
     * 审批时间
     */
    private Date auditTime;
    /**
     * 中标时间
     */
    private Date bidTime;
    /**
     * 是否紧急采购 0否1是
     */
    private Integer emergencyFlag;
    /**
     * 使用单位名称
     */
    private String reqUnitName;
    /**
     * 报价类型 10-含税报价，20-不含税报价，30-费率
     */
    private Integer quoteType;
    /**
     * 费率值
     */
    private BigDecimal rate;
    /**
     * 币种
     */
    private String currency;
    private String currencyName;
    /**
     * 询价制单人编码名称
     */
    private String createUidName;
    /**
     * 结果制单人名称
     */
    private String awardCreateUserName;

    /**
     * 产地品牌
     */
    private String produceBrand;
}
