/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtReqBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackExtRspBO;
import com.tydic.dyc.ssc.bo.SscSchemeTrackSyncFzBO;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.repository.SscSchemeTrackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeTrackSyncFzMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SysDicDictionaryMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SScSchemeFindsourcePO;
import com.tydic.dyc.ssc.repositoryExt.po.SaasSchemePackPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscFindsourcePbPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeTrackSyncFzPO;
import com.tydic.dyc.ssc.repositoryExt.po.SysDicDictionaryPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscEntrustResultPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscInquiryItemDbPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscInquiryPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryInquiryInfoExtBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class SscSchemeTrackExtRepositoryImpl
implements SscSchemeTrackExtRepository {
    @Autowired
    private SscSchemeTrackExtMapper sscSchemeTrackExtMapper;
    @Autowired
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Autowired
    private SscSchemeTrackSyncFzMapper sscSchemeTrackSyncFzMapper;
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;

    public int schemeTrackSync(SscSchemeTrackSyncFzBO bo) {
        int rspBO = 8888;
        SscSchemeTrackSyncFzPO po = this.sscSchemeTrackSyncFzMapper.selectByPackId(bo.getPackId());
        if (ObjectUtils.isEmpty((Object)po)) {
            SscSchemeTrackSyncFzPO js = (SscSchemeTrackSyncFzPO)JUtil.js((Object)bo, SscSchemeTrackSyncFzPO.class);
            js.setCreateTime(new Date());
            rspBO = this.sscSchemeTrackSyncFzMapper.insert(js);
        } else {
            SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = (SscSchemeTrackSyncFzPO)JUtil.js((Object)bo, SscSchemeTrackSyncFzPO.class);
            sscSchemeTrackSyncFzPO.setId(po.getId());
            sscSchemeTrackSyncFzPO.setUpdateTime(new Date());
            rspBO = this.sscSchemeTrackSyncFzMapper.updateById(sscSchemeTrackSyncFzPO);
        }
        return rspBO;
    }

    public SscSchemeTrackExtRspBO selectSchemeTrack(SscSchemeTrackExtReqBO reqBO) {
        if (!StringUtils.isEmpty((Object)reqBO.getAuditTimeEnd())) {
            reqBO.setAuditTimeEnd(reqBO.getAuditTimeEnd() + " 23:59:59");
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCreateTimeEnd())) {
            reqBO.setCreateTimeEnd(reqBO.getCreateTimeEnd() + " 23:59:59");
        }
        SscSchemeTrackExtRspBO rspBO = new SscSchemeTrackExtRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        Integer isGroupBuyQryFlag = 0;
        if (!StringUtils.isEmpty((Object)reqBO.getPlanPackCode())) {
            isGroupBuyQryFlag = 1;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPlanPackName())) {
            isGroupBuyQryFlag = 1;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPlanPackNo())) {
            isGroupBuyQryFlag = 1;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPlanPackOrgCode())) {
            isGroupBuyQryFlag = 1;
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPlanPackOrgName())) {
            isGroupBuyQryFlag = 1;
        }
        reqBO.setIsGroupBuyQryFlag(isGroupBuyQryFlag);
        List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS = this.sscSchemeTrackExtMapper.selectSchemeTrack(reqBO, (Page<SscSchemeTrackExtReqBO>)page);
        List<Long> careIds = this.sscSchemeTrackExtMapper.selectCareIdsByUserId(reqBO.getUserId());
        List<String> schemeTypeList = Arrays.asList("2", "3");
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS) && schemeTypeList.contains(reqBO.getSchemeType())) {
            if (CollectionUtils.isEmpty(careIds)) {
                sscSchemeTrackExtBOS.forEach(e -> {
                    e.setCare(Integer.valueOf(0));
                    e.setCareStr("\u672a\u5173\u6ce8");
                });
            } else {
                sscSchemeTrackExtBOS.forEach(e -> {
                    if (careIds.contains(e.getPackId())) {
                        e.setCare(Integer.valueOf(1));
                        e.setCareStr("\u5df2\u5173\u6ce8");
                    } else {
                        e.setCare(Integer.valueOf(0));
                        e.setCareStr("\u672a\u5173\u6ce8");
                    }
                });
            }
        }
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS) && SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(String.valueOf(reqBO.getSchemeType()))) {
            List<SaasSchemePackPO> saasSchemePackPOS;
            ArrayList<Long> packIds = new ArrayList<Long>();
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if (!"\u96c6\u91c7\u5b9e\u65bd-\u81ea\u8425".equals(sscSchemeTrackExtBO.getSchemeSubmitValue())) continue;
                packIds.add(sscSchemeTrackExtBO.getPackId());
            }
            if (!CollectionUtils.isEmpty(packIds) && !CollectionUtils.isEmpty(saasSchemePackPOS = this.saasSchemePackMapper.qryPackByPurchasePackIds(packIds))) {
                Map<String, List<SaasSchemePackPO>> groupBuyPackIdMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getPurchasePackId));
                List<Long> groupBuyPackIds = saasSchemePackPOS.stream().map(SaasSchemePackPO::getPackId).collect(Collectors.toList());
                List<SscSchemeTrackSyncFzPO> sscSchemeTrackSyncFzPOS = this.sscSchemeTrackSyncFzMapper.selectByPackIds(groupBuyPackIds);
                Map<Object, Object> groupBuyPackIdFzMap = new HashMap();
                if (CollectionUtils.isEmpty(sscSchemeTrackSyncFzPOS)) {
                    groupBuyPackIdFzMap = sscSchemeTrackSyncFzPOS.stream().collect(Collectors.groupingBy(SscSchemeTrackSyncFzPO::getPackId));
                }
                for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                    if (!groupBuyPackIdMap.keySet().contains(sscSchemeTrackExtBO.getPackId().toString())) continue;
                    SaasSchemePackPO saasSchemePackPO = groupBuyPackIdMap.get(sscSchemeTrackExtBO.getPackId().toString()).get(0);
                    sscSchemeTrackExtBO.setSchemeExectStatus(saasSchemePackPO.getPackExectStatus());
                    sscSchemeTrackExtBO.setGroupBuyPackCode(saasSchemePackPO.getPackCode());
                    sscSchemeTrackExtBO.setGroupBuyPackId(saasSchemePackPO.getPackId());
                    sscSchemeTrackExtBO.setGroupBuyPackNo(saasSchemePackPO.getPackNo());
                    if (!groupBuyPackIdFzMap.keySet().contains(saasSchemePackPO.getPackId())) continue;
                    SscSchemeTrackSyncFzPO sscSchemeTrackSyncFzPO = (SscSchemeTrackSyncFzPO)((List)groupBuyPackIdFzMap.get(saasSchemePackPO.getPackId())).get(0);
                    sscSchemeTrackExtBO.setEnquiryBook(sscSchemeTrackSyncFzPO.getEnquiryBook());
                    sscSchemeTrackExtBO.setQuoteBook(sscSchemeTrackSyncFzPO.getQuoteBook());
                    sscSchemeTrackExtBO.setEnquiryResult(sscSchemeTrackSyncFzPO.getEnquiryResult());
                    sscSchemeTrackExtBO.setEnquirySupplier(sscSchemeTrackSyncFzPO.getEnquirySupplier());
                    sscSchemeTrackExtBO.setEnquiryMoney(sscSchemeTrackSyncFzPO.getEnquiryMoney());
                    sscSchemeTrackExtBO.setEnquiryMat(sscSchemeTrackSyncFzPO.getEnquiryMat());
                    sscSchemeTrackExtBO.setEntrustBook(sscSchemeTrackSyncFzPO.getEntrustBook());
                    sscSchemeTrackExtBO.setBidReport(sscSchemeTrackSyncFzPO.getBidReport());
                    sscSchemeTrackExtBO.setBidSupplier(sscSchemeTrackSyncFzPO.getBidSupplier());
                    sscSchemeTrackExtBO.setBidMoney(sscSchemeTrackSyncFzPO.getBidMoney());
                    sscSchemeTrackExtBO.setBidMat(sscSchemeTrackSyncFzPO.getBidMat());
                    sscSchemeTrackExtBO.setCalibrationReport(sscSchemeTrackSyncFzPO.getCalibrationReport());
                }
            }
        }
        SysDicDictionaryPO searchPO = new SysDicDictionaryPO();
        searchPO.setPCode("PURCH_WAY");
        List<SysDicDictionaryPO> sysDicDictionaryPOS = this.sysDicDictionaryMapper.selectDictionary(searchPO);
        if (!CollectionUtils.isEmpty(sysDicDictionaryPOS)) {
            Map<String, String> codeMap = sysDicDictionaryPOS.stream().collect(Collectors.toMap(SysDicDictionaryPO::getCode, SysDicDictionaryPO::getDescrip));
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                if (StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getPurchaseType())) continue;
                sscSchemeTrackExtBO.setPurchaseTypeStr(codeMap.get(sscSchemeTrackExtBO.getPurchaseType()));
            }
        }
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)) {
            if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())) {
                this.getCrcFindSource(sscSchemeTrackExtBOS);
            } else {
                this.getInquiryCount(reqBO, sscSchemeTrackExtBOS);
                this.getCrcInquiry(sscSchemeTrackExtBOS);
                this.getCrcEntrust(sscSchemeTrackExtBOS);
            }
        }
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setSchemeTrackList(sscSchemeTrackExtBOS);
        return rspBO;
    }

    private void getInquiryCount(SscSchemeTrackExtReqBO reqBO, List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS) {
        if (CollectionUtils.isEmpty(sscSchemeTrackExtBOS)) {
            return;
        }
        ArrayList<Long> packIds = new ArrayList();
        ArrayList<Long> schemeIds = new ArrayList();
        if (!StringUtils.isEmpty((Object)reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())) {
            schemeIds = sscSchemeTrackExtBOS.stream().map(SscSchemeTrackExtBO::getSchemeId).collect(Collectors.toList());
        } else {
            packIds = sscSchemeTrackExtBOS.stream().map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        Map<Object, Object> inquiryNumMap = new HashMap();
        Map<Object, Object> inquiryQuoteLNumMap = new HashMap();
        if (!CollectionUtils.isEmpty(packIds) || !CollectionUtils.isEmpty(schemeIds)) {
            List<SscQryInquiryInfoExtBo> inquiryQuoteList;
            List<SscQryInquiryInfoExtBo> inquiryList = this.saasSchemePackMapper.qryInquiryCount(packIds, schemeIds);
            if (!CollectionUtils.isEmpty(inquiryList)) {
                inquiryNumMap = !StringUtils.isEmpty((Object)reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode()) ? inquiryList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getSchemeId, SscQryInquiryInfoExtBo::getInquiryNum)) : inquiryList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getPackId, SscQryInquiryInfoExtBo::getInquiryNum));
            }
            if (!CollectionUtils.isEmpty(inquiryQuoteList = this.saasSchemePackMapper.qryInquiryQuoteCount(packIds, schemeIds))) {
                inquiryQuoteLNumMap = !StringUtils.isEmpty((Object)reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode()) ? inquiryQuoteList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getSchemeId, SscQryInquiryInfoExtBo::getQuoteNum)) : inquiryQuoteList.stream().collect(Collectors.toMap(SscQryInquiryInfoExtBo::getPackId, SscQryInquiryInfoExtBo::getQuoteNum));
            }
        }
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer enquiryBookNum = 0;
            Integer quoteBookNum = 0;
            if (!StringUtils.isEmpty((Object)reqBO.getSchemeType()) && reqBO.getSchemeType().equals(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode())) {
                if (inquiryNumMap.containsKey(sscSchemeTrackExtBO.getSchemeId())) {
                    enquiryBookNum = (Integer)inquiryNumMap.get(sscSchemeTrackExtBO.getSchemeId());
                }
                if (inquiryQuoteLNumMap.containsKey(sscSchemeTrackExtBO.getSchemeId())) {
                    quoteBookNum = (Integer)inquiryQuoteLNumMap.get(sscSchemeTrackExtBO.getSchemeId());
                }
            } else {
                if (inquiryNumMap.containsKey(sscSchemeTrackExtBO.getPackId())) {
                    enquiryBookNum = (Integer)inquiryNumMap.get(sscSchemeTrackExtBO.getPackId());
                }
                if (inquiryQuoteLNumMap.containsKey(sscSchemeTrackExtBO.getPackId())) {
                    quoteBookNum = (Integer)inquiryQuoteLNumMap.get(sscSchemeTrackExtBO.getPackId());
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEntrustBook())) {
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    enquiryBookNum = enquiryBookNum + entrustBook;
                }
                catch (Exception entrustBook) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getQuoteBook())) {
                try {
                    Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                    quoteBookNum = quoteBookNum + quoteBook;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sscSchemeTrackExtBO.setEnquiryBook(enquiryBookNum + "");
            sscSchemeTrackExtBO.setQuoteBook(quoteBookNum + "");
        }
    }

    private void getCrcInquiry(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS) {
        List<Object> packIds = new ArrayList();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)) {
            packIds = sscSchemeTrackExtBOS.stream().filter(e -> e.getPackId() != null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)) {
            return;
        }
        Map<Object, Object> packIdMap = new HashMap();
        HashMap<Long, Integer> inquiryIdBdSupCountMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> inquiryIdBdItemCountMap = new HashMap<Long, Integer>();
        HashMap<Long, BigDecimal> inquiryIdBdCjAmountMap = new HashMap<Long, BigDecimal>();
        Map<Object, Object> inquiryIdBjsCountMap = new HashMap();
        if (!CollectionUtils.isEmpty(packIds)) {
            SscInquiryPO qryInquiryPO = new SscInquiryPO();
            qryInquiryPO.setPackIds(packIds);
            List<SscInquiryPO> crcInquiryPOS = this.saasSchemePackMapper.qryInquiryTrackDownList(qryInquiryPO);
            if (!CollectionUtils.isEmpty(crcInquiryPOS)) {
                List<SscInquiryItemDbPO> sscInquiryItemDbPOS;
                List<SscInquiryPO> bjsList;
                packIdMap = crcInquiryPOS.stream().collect(Collectors.groupingBy(SscInquiryPO::getPackId));
                List<Long> inquiryIds = crcInquiryPOS.stream().map(SscInquiryPO::getInquiryId).collect(Collectors.toList());
                ArrayList<Long> qryQuoteInquiryIds = new ArrayList<Long>();
                for (SscInquiryPO inquiryPO : crcInquiryPOS) {
                    Object busiId = null;
                    if (!StringUtils.isEmpty((Object)inquiryPO.getExt7())) {
                        try {
                            busiId = Long.valueOf(inquiryPO.getExt7());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (busiId != null) continue;
                    qryQuoteInquiryIds.add(inquiryPO.getInquiryId());
                }
                if (!CollectionUtils.isEmpty(qryQuoteInquiryIds) && !CollectionUtils.isEmpty(bjsList = this.saasSchemePackMapper.qryInquiryBjsCount(qryQuoteInquiryIds))) {
                    inquiryIdBjsCountMap = bjsList.stream().filter(e -> e.getBjsCount() != null).collect(Collectors.toMap(SscInquiryPO::getInquiryId, SscInquiryPO::getBjsCount));
                }
                if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS = this.saasSchemePackMapper.qryInquiryDbItem(inquiryIds))) {
                    Map<Long, List<SscInquiryItemDbPO>> inquiryIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getInquiryId));
                    for (Long inquiryId : inquiryIdDbMap.keySet()) {
                        HashSet<Long> bdSupIds = new HashSet<Long>();
                        HashSet<Long> bdSchemaItemIds = new HashSet<Long>();
                        BigDecimal cjTotal = BigDecimal.ZERO;
                        for (SscInquiryItemDbPO itemDbPO : inquiryIdDbMap.get(inquiryId)) {
                            if (itemDbPO.getPurchaseCount() == null || itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO) <= 0) continue;
                            bdSupIds.add(itemDbPO.getSupId());
                            bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                            if (itemDbPO.getYzfAmount() != null) {
                                cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                            }
                            if (itemDbPO.getHaveTaxAmount() == null) continue;
                            cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                        }
                        inquiryIdBdSupCountMap.put(inquiryId, bdSupIds.size());
                        inquiryIdBdItemCountMap.put(inquiryId, bdSchemaItemIds.size());
                        inquiryIdBdCjAmountMap.put(inquiryId, cjTotal);
                    }
                }
            }
            for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
                Integer quoteBookNum = 0;
                Integer enquiryResultNum = 0;
                Integer enquirySupplierNum = 0;
                BigDecimal enquiryMoneySum = BigDecimal.ZERO;
                Integer enquiryMatNum = 0;
                if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())) {
                    List inquiryPOS = (List)packIdMap.get(sscSchemeTrackExtBO.getPackId());
                    enquiryResultNum = inquiryPOS.size();
                    for (SscInquiryPO inquiryPO : inquiryPOS) {
                        if (inquiryIdBjsCountMap.containsKey(inquiryPO.getInquiryId())) {
                            quoteBookNum = quoteBookNum + (Integer)inquiryIdBjsCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (inquiryIdBdSupCountMap.containsKey(inquiryPO.getInquiryId())) {
                            enquirySupplierNum = enquirySupplierNum + (Integer)inquiryIdBdSupCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (inquiryIdBdItemCountMap.containsKey(inquiryPO.getInquiryId())) {
                            enquiryMatNum = enquiryMatNum + (Integer)inquiryIdBdItemCountMap.get(inquiryPO.getInquiryId());
                        }
                        if (!inquiryIdBdCjAmountMap.containsKey(inquiryPO.getInquiryId())) continue;
                        enquiryMoneySum = enquiryMoneySum.add((BigDecimal)inquiryIdBdCjAmountMap.get(inquiryPO.getInquiryId()));
                    }
                }
                if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getQuoteBook())) {
                    try {
                        Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                        quoteBookNum = quoteBookNum + quoteBook;
                    }
                    catch (Exception quoteBook) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquiryResult())) {
                    try {
                        Integer enquiryResult = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryResult());
                        enquiryResultNum = enquiryResultNum + enquiryResult;
                    }
                    catch (Exception enquiryResult) {
                        // empty catch block
                    }
                }
                if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquirySupplier())) {
                    try {
                        Integer enquirySupplier = Integer.valueOf(sscSchemeTrackExtBO.getEnquirySupplier());
                        enquirySupplierNum = enquirySupplierNum + enquirySupplier;
                    }
                    catch (Exception enquirySupplier) {
                        // empty catch block
                    }
                }
                if (sscSchemeTrackExtBO.getEnquiryMoney() != null) {
                    enquiryMoneySum = enquiryMoneySum.add(sscSchemeTrackExtBO.getEnquiryMoney());
                }
                if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquiryMat())) {
                    try {
                        Integer enquiryMat = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryMat());
                        enquiryMatNum = enquiryMatNum + enquiryMat;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                sscSchemeTrackExtBO.setQuoteBook(quoteBookNum + "");
                sscSchemeTrackExtBO.setEnquiryResult(enquiryResultNum + "");
                sscSchemeTrackExtBO.setEnquirySupplier(enquirySupplierNum + "");
                sscSchemeTrackExtBO.setEnquiryMoney(enquiryMoneySum);
                sscSchemeTrackExtBO.setEnquiryMat(enquiryMatNum + "");
            }
        }
    }

    private void getCrcEntrust(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS) {
        List<Object> packIds = new ArrayList();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)) {
            packIds = sscSchemeTrackExtBOS.stream().filter(e -> e.getPackId() != null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)) {
            return;
        }
        Map<Object, Object> packIdMap = new HashMap();
        List<Object> allPbResultIds = new ArrayList();
        List<Object> allDbResultIds = new ArrayList();
        HashMap<Long, Integer> resultIdBdSupCountMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> resultIdBdItemCountMap = new HashMap<Long, Integer>();
        HashMap<Long, BigDecimal> resultIdBdCjAmountMap = new HashMap<Long, BigDecimal>();
        Map<Object, Object> resultIdBjsCountMap = new HashMap();
        SscEntrustResultPO qryResultPO = new SscEntrustResultPO();
        qryResultPO.setPackIds(packIds);
        List<SscEntrustResultPO> entrustPOS = this.saasSchemePackMapper.qryResultTrackDownList(qryResultPO);
        if (!CollectionUtils.isEmpty(entrustPOS)) {
            packIdMap = entrustPOS.stream().collect(Collectors.groupingBy(SscEntrustResultPO::getPackId));
            List<Long> resultIds = entrustPOS.stream().filter(e -> e.getResultId() != null).map(SscEntrustResultPO::getResultId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(resultIds)) {
                List<SscInquiryPO> bjsCount;
                List<Long> dbResultIds;
                List<Long> pbResultIds = this.saasSchemePackMapper.qryExistSupPb(resultIds);
                if (!CollectionUtils.isEmpty(pbResultIds)) {
                    allPbResultIds = pbResultIds;
                }
                if (!CollectionUtils.isEmpty(dbResultIds = this.saasSchemePackMapper.qryExistSupDb(resultIds))) {
                    allDbResultIds = dbResultIds;
                    List<SscInquiryItemDbPO> sscInquiryItemDbPOS = this.saasSchemePackMapper.qryResultDbItem(dbResultIds);
                    if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS)) {
                        Map<Long, List<SscInquiryItemDbPO>> resultIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getResultId));
                        for (Long resultId : resultIdDbMap.keySet()) {
                            HashSet<Long> bdSupIds = new HashSet<Long>();
                            HashSet<Long> bdSchemaItemIds = new HashSet<Long>();
                            BigDecimal cjTotal = BigDecimal.ZERO;
                            for (SscInquiryItemDbPO itemDbPO : resultIdDbMap.get(resultId)) {
                                if (itemDbPO.getPurchaseCount() == null || itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO) <= 0) continue;
                                bdSupIds.add(itemDbPO.getSupId());
                                bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                                if (itemDbPO.getYzfAmount() != null) {
                                    cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                                }
                                if (itemDbPO.getHaveTaxAmount() == null) continue;
                                cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                            }
                            resultIdBdSupCountMap.put(resultId, bdSupIds.size());
                            resultIdBdItemCountMap.put(resultId, bdSchemaItemIds.size());
                            resultIdBdCjAmountMap.put(resultId, cjTotal);
                        }
                    }
                }
                if (!CollectionUtils.isEmpty(resultIds) && !CollectionUtils.isEmpty(bjsCount = this.saasSchemePackMapper.qryEntrustResultBjsCount(resultIds))) {
                    resultIdBjsCountMap = bjsCount.stream().collect(Collectors.toMap(SscInquiryPO::getResultId, SscInquiryPO::getBjsCount));
                }
            }
        }
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer entrustBookNum = 0;
            Integer bidReportNum = 0;
            Integer calibrationReportNum = 0;
            Integer bidSupplierNum = 0;
            BigDecimal bidMoneySum = BigDecimal.ZERO;
            Integer bidMatNum = 0;
            Integer bidQuoteBookNum = 0;
            if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())) {
                List entrustResultPOS = (List)packIdMap.get(sscSchemeTrackExtBO.getPackId());
                entrustBookNum = entrustResultPOS.size();
                List resultIds = entrustResultPOS.stream().filter(e -> e.getResultId() != null).map(SscEntrustResultPO::getResultId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(resultIds)) {
                    for (Long resultId : resultIds) {
                        Integer n;
                        Integer n2;
                        if (allPbResultIds.contains(resultId)) {
                            n2 = bidReportNum;
                            n = bidReportNum = Integer.valueOf(bidReportNum + 1);
                        }
                        if (allDbResultIds.contains(resultId)) {
                            n2 = calibrationReportNum;
                            n = calibrationReportNum = Integer.valueOf(calibrationReportNum + 1);
                            if (resultIdBdSupCountMap.containsKey(resultId)) {
                                bidSupplierNum = bidSupplierNum + (Integer)resultIdBdSupCountMap.get(resultId);
                                bidMoneySum = bidMoneySum.add((BigDecimal)resultIdBdCjAmountMap.get(resultId));
                                bidMatNum = bidMatNum + (Integer)resultIdBdItemCountMap.get(resultId);
                            }
                        }
                        if (!resultIdBjsCountMap.containsKey(resultId)) continue;
                        bidQuoteBookNum = bidQuoteBookNum + (Integer)resultIdBjsCountMap.get(resultId);
                    }
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEntrustBook())) {
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    entrustBookNum = entrustBookNum + entrustBook;
                }
                catch (Exception entrustBook) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidReport())) {
                try {
                    Integer bidReport = Integer.valueOf(sscSchemeTrackExtBO.getBidReport());
                    bidReportNum = bidReportNum + bidReport;
                }
                catch (Exception bidReport) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidSupplier())) {
                try {
                    Integer bidSupplier = Integer.valueOf(sscSchemeTrackExtBO.getBidSupplier());
                    bidSupplierNum = bidSupplierNum + bidSupplier;
                }
                catch (Exception bidSupplier) {
                    // empty catch block
                }
            }
            if (sscSchemeTrackExtBO.getBidMoney() != null) {
                bidMoneySum = bidMoneySum.add(sscSchemeTrackExtBO.getBidMoney());
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidMat())) {
                try {
                    Integer bidMat = Integer.valueOf(sscSchemeTrackExtBO.getBidMat());
                    bidMatNum = bidMatNum + bidMat;
                }
                catch (Exception bidMat) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getCalibrationReport())) {
                try {
                    Integer calibrationReport = Integer.valueOf(sscSchemeTrackExtBO.getCalibrationReport());
                    calibrationReportNum = calibrationReportNum + calibrationReport;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sscSchemeTrackExtBO.setEntrustBook(entrustBookNum + "");
            sscSchemeTrackExtBO.setBidReport(bidReportNum + "");
            sscSchemeTrackExtBO.setBidSupplier(bidSupplierNum + "");
            sscSchemeTrackExtBO.setBidMoney(bidMoneySum);
            sscSchemeTrackExtBO.setBidMat(bidMatNum + "");
            sscSchemeTrackExtBO.setCalibrationReport(calibrationReportNum + "");
            sscSchemeTrackExtBO.setBidQuoteBook(bidQuoteBookNum + "");
        }
    }

    private void getCrcFindSource(List<SscSchemeTrackExtBO> sscSchemeTrackExtBOS) {
        ArrayList<Long> packIds = new ArrayList();
        if (!CollectionUtils.isEmpty(sscSchemeTrackExtBOS)) {
            packIds = sscSchemeTrackExtBOS.stream().filter(e -> e.getPackId() != null).map(SscSchemeTrackExtBO::getPackId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(packIds)) {
            return;
        }
        Map<Object, Object> packIdMap = new HashMap();
        Map<Object, Object> sourceIdBjsCountMap = new HashMap();
        List<Object> allPbSourceIds = new ArrayList();
        List<Object> allDbSourceIds = new ArrayList();
        HashMap<Long, Integer> sourceIdBdSupCountMap = new HashMap<Long, Integer>();
        HashMap<Long, Integer> sourceIdBdItemCountMap = new HashMap<Long, Integer>();
        HashMap<Long, BigDecimal> sourceIdBdCjAmountMap = new HashMap<Long, BigDecimal>();
        SScSchemeFindsourcePO searchPO = new SScSchemeFindsourcePO();
        searchPO.setPackIds(packIds);
        List<SScSchemeFindsourcePO> schemeFindsourcePOS = this.saasSchemePackMapper.qryFindSourceTrackDownList(searchPO);
        if (!CollectionUtils.isEmpty(schemeFindsourcePOS)) {
            List<Long> dbSourceIds;
            List<Long> pbSourceIds;
            packIdMap = schemeFindsourcePOS.stream().collect(Collectors.groupingBy(SScSchemeFindsourcePO::getPackId));
            List<Long> sourceIds = schemeFindsourcePOS.stream().map(SScSchemeFindsourcePO::getSourceId).collect(Collectors.toList());
            List<SscFindsourcePbPO> sscFindsourcePbPOS = this.saasSchemePackMapper.qryFindsourceBjsCount(sourceIds);
            if (!CollectionUtils.isEmpty(sscFindsourcePbPOS)) {
                sourceIdBjsCountMap = sscFindsourcePbPOS.stream().collect(Collectors.toMap(SscFindsourcePbPO::getSourceId, SscFindsourcePbPO::getBjsCount));
            }
            if (!CollectionUtils.isEmpty(pbSourceIds = this.saasSchemePackMapper.qryFindsourceExistSupPb(sourceIds))) {
                allPbSourceIds = pbSourceIds;
            }
            if (!CollectionUtils.isEmpty(dbSourceIds = this.saasSchemePackMapper.qryFindsourceExistSupDb(sourceIds))) {
                allDbSourceIds = dbSourceIds;
                List<SscInquiryItemDbPO> sscInquiryItemDbPOS = this.saasSchemePackMapper.qryFindsourceDbItem(dbSourceIds);
                if (!CollectionUtils.isEmpty(sscInquiryItemDbPOS)) {
                    Map<Long, List<SscInquiryItemDbPO>> sourceIdDbMap = sscInquiryItemDbPOS.stream().collect(Collectors.groupingBy(SscInquiryItemDbPO::getSourceId));
                    for (Long sourceId : sourceIdDbMap.keySet()) {
                        HashSet<Long> bdSupIds = new HashSet<Long>();
                        HashSet<Long> bdSchemaItemIds = new HashSet<Long>();
                        BigDecimal cjTotal = BigDecimal.ZERO;
                        for (SscInquiryItemDbPO itemDbPO : sourceIdDbMap.get(sourceId)) {
                            if (itemDbPO.getPurchaseCount() == null || itemDbPO.getPurchaseCount().compareTo(BigDecimal.ZERO) <= 0) continue;
                            bdSupIds.add(itemDbPO.getSupId());
                            bdSchemaItemIds.add(itemDbPO.getSchemaItemId());
                            if (itemDbPO.getYzfAmount() != null) {
                                cjTotal = cjTotal.add(itemDbPO.getYzfAmount());
                            }
                            if (itemDbPO.getHaveTaxAmount() == null) continue;
                            cjTotal = cjTotal.add(itemDbPO.getHaveTaxAmount());
                        }
                        sourceIdBdSupCountMap.put(sourceId, bdSupIds.size());
                        sourceIdBdItemCountMap.put(sourceId, bdSchemaItemIds.size());
                        sourceIdBdCjAmountMap.put(sourceId, cjTotal);
                    }
                }
            }
        }
        for (SscSchemeTrackExtBO sscSchemeTrackExtBO : sscSchemeTrackExtBOS) {
            Integer enquiryBookNum = 0;
            Integer quoteBookNum = 0;
            Integer enquiryResultNum = 0;
            Integer enquirySupplierNum = 0;
            BigDecimal enquiryMoneySum = BigDecimal.ZERO;
            Integer enquiryMatNum = 0;
            Integer entrustBookNum = 0;
            Integer bidReportNum = 0;
            Integer bidSupplierNum = 0;
            BigDecimal bidMoneySum = BigDecimal.ZERO;
            Integer bidMatNum = 0;
            Integer calibrationReportNum = 0;
            Integer bidQuoteBookNum = 0;
            if (packIdMap.containsKey(sscSchemeTrackExtBO.getPackId())) {
                List sourcePOS = (List)packIdMap.get(sscSchemeTrackExtBO.getPackId());
                for (SScSchemeFindsourcePO sourcePO : sourcePOS) {
                    Integer n;
                    Integer n2;
                    Long sourceId = sourcePO.getSourceId();
                    if (sourcePO.getPurchaseType() != null && (sourcePO.getPurchaseType() == 0 || sourcePO.getPurchaseType() == 1)) {
                        if (allPbSourceIds.contains(sourceId)) {
                            n2 = bidReportNum;
                            n = bidReportNum = Integer.valueOf(bidReportNum + 1);
                        }
                        if (allDbSourceIds.contains(sourceId)) {
                            n2 = calibrationReportNum;
                            n = calibrationReportNum = Integer.valueOf(calibrationReportNum + 1);
                            if (sourceIdBdSupCountMap.containsKey(sourceId)) {
                                bidSupplierNum = bidSupplierNum + (Integer)sourceIdBdSupCountMap.get(sourceId);
                                bidMoneySum = bidMoneySum.add((BigDecimal)sourceIdBdCjAmountMap.get(sourceId));
                                bidMatNum = bidMatNum + (Integer)sourceIdBdItemCountMap.get(sourceId);
                            }
                        }
                        if (sourceIdBjsCountMap.containsKey(sourceId)) {
                            bidQuoteBookNum = bidQuoteBookNum + (Integer)sourceIdBjsCountMap.get(sourceId);
                        }
                        if (!allDbSourceIds.contains(sourceId)) continue;
                        n2 = calibrationReportNum;
                        n = calibrationReportNum = Integer.valueOf(calibrationReportNum + 1);
                        continue;
                    }
                    n2 = enquiryResultNum;
                    n = enquiryResultNum = Integer.valueOf(enquiryResultNum + 1);
                    if (sourceIdBdSupCountMap.containsKey(sourceId)) {
                        enquirySupplierNum = enquirySupplierNum + (Integer)sourceIdBdSupCountMap.get(sourceId);
                        enquiryMoneySum = enquiryMoneySum.add((BigDecimal)sourceIdBdCjAmountMap.get(sourceId));
                        enquiryMatNum = enquiryMatNum + (Integer)sourceIdBdItemCountMap.get(sourceId);
                    }
                    if (!sourceIdBjsCountMap.containsKey(sourceId)) continue;
                    quoteBookNum = quoteBookNum + (Integer)sourceIdBjsCountMap.get(sourceId);
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquiryBook())) {
                try {
                    Integer enquiryBook = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryBook());
                    enquiryBookNum = enquiryBookNum + enquiryBook;
                }
                catch (Exception enquiryBook) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getQuoteBook())) {
                try {
                    Integer quoteBook = Integer.valueOf(sscSchemeTrackExtBO.getQuoteBook());
                    quoteBookNum = quoteBookNum + quoteBook;
                }
                catch (Exception quoteBook) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquiryResult())) {
                try {
                    Integer enquiryResult = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryResult());
                    enquiryResultNum = enquiryResultNum + enquiryResult;
                }
                catch (Exception enquiryResult) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquirySupplier())) {
                try {
                    Integer enquirySupplier = Integer.valueOf(sscSchemeTrackExtBO.getEnquirySupplier());
                    enquirySupplierNum = enquirySupplierNum + enquirySupplier;
                }
                catch (Exception enquirySupplier) {
                    // empty catch block
                }
            }
            if (sscSchemeTrackExtBO.getEnquiryMoney() != null) {
                enquiryMoneySum = enquiryMoneySum.add(sscSchemeTrackExtBO.getEnquiryMoney());
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEnquiryMat())) {
                try {
                    Integer enquiryMat = Integer.valueOf(sscSchemeTrackExtBO.getEnquiryMat());
                    enquiryMatNum = enquiryMatNum + enquiryMat;
                }
                catch (Exception enquiryMat) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getEntrustBook())) {
                try {
                    Integer entrustBook = Integer.valueOf(sscSchemeTrackExtBO.getEntrustBook());
                    entrustBookNum = entrustBookNum + entrustBook;
                }
                catch (Exception entrustBook) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidReport())) {
                try {
                    Integer bidReport = Integer.valueOf(sscSchemeTrackExtBO.getBidReport());
                    bidReportNum = bidReportNum + bidReport;
                }
                catch (Exception bidReport) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidSupplier())) {
                try {
                    Integer bidSupplier = Integer.valueOf(sscSchemeTrackExtBO.getBidSupplier());
                    bidSupplierNum = bidSupplierNum + bidSupplier;
                }
                catch (Exception bidSupplier) {
                    // empty catch block
                }
            }
            if (sscSchemeTrackExtBO.getBidMoney() != null) {
                bidMoneySum = bidMoneySum.add(sscSchemeTrackExtBO.getBidMoney());
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getBidMat())) {
                try {
                    Integer bidMat = Integer.valueOf(sscSchemeTrackExtBO.getBidMat());
                    bidMatNum = bidMatNum + bidMat;
                }
                catch (Exception bidMat) {
                    // empty catch block
                }
            }
            if (!StringUtils.isEmpty((Object)sscSchemeTrackExtBO.getCalibrationReport())) {
                try {
                    Integer calibrationReport = Integer.valueOf(sscSchemeTrackExtBO.getCalibrationReport());
                    calibrationReportNum = calibrationReportNum + calibrationReport;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            sscSchemeTrackExtBO.setEnquiryBook(enquiryBookNum + "");
            sscSchemeTrackExtBO.setQuoteBook(quoteBookNum + "");
            sscSchemeTrackExtBO.setEnquiryResult(enquiryResultNum + "");
            sscSchemeTrackExtBO.setEnquirySupplier(enquirySupplierNum + "");
            sscSchemeTrackExtBO.setEnquiryMoney(enquiryMoneySum);
            sscSchemeTrackExtBO.setEnquiryMat(enquiryMatNum + "");
            sscSchemeTrackExtBO.setEntrustBook(entrustBookNum + "");
            sscSchemeTrackExtBO.setBidReport(bidReportNum + "");
            sscSchemeTrackExtBO.setBidSupplier(bidSupplierNum + "");
            sscSchemeTrackExtBO.setBidMoney(bidMoneySum);
            sscSchemeTrackExtBO.setBidMat(bidMatNum + "");
            sscSchemeTrackExtBO.setCalibrationReport(calibrationReportNum + "");
            sscSchemeTrackExtBO.setBidQuoteBook(bidQuoteBookNum + "");
        }
    }
}

