/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeInviteSupPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.repositoryExt.po.UocOrderTaskInstBO;
import com.tydic.dyc.ssc.service.scheme.SscSchemeOperateService;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SSC_GROUP_DEV/3.0.0/com.tydic.dyc.ssc.service.scheme.SscSchemeOperateService"})
public class SscSchemeOperateServiceImpl
implements SscSchemeOperateService {
    private static final Logger log = LoggerFactory.getLogger(SscSchemeOperateServiceImpl.class);
    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Autowired
    private SscSchemeInviteSupPackExtMapper sscSchemeInviteSupPackExtMapper;

    @PostMapping(value={"saveSubmitTime"})
    public SchemeListRspBO saveSubmitTime(@RequestBody SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        SscSchemePO schemePO = new SscSchemePO();
        schemePO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemePO> schemePOList = this.schemePackMapper.getModelBy(schemePO);
        if (CollectionUtils.isEmpty(schemePOList) || Objects.nonNull(schemePOList.get(0).getSubmitTime())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5df2\u8bb0\u5f55\u63d0\u4ea4\u65f6\u95f4 \u4e0d\u4e88\u5904\u7406");
            return rspBO;
        }
        this.schemePackMapper.updateSubmit(reqBO.getSchemeId(), new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"saveAuditTime"})
    public SchemeListRspBO saveAuditTime(@RequestBody SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if (Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return rspBO;
        }
        SscSchemePO schemePO = new SscSchemePO();
        schemePO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemePO> schemePOList = this.schemePackMapper.getModelBy(schemePO);
        if (CollectionUtils.isEmpty(schemePOList)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5355\u636e");
            return rspBO;
        }
        UocOrderTaskInstBO finishTime = this.schemePackMapper.getFinishTime(reqBO.getSchemeId());
        if (Objects.isNull(finishTime) || Objects.isNull(finishTime.getFinishTime())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u6700\u65b0\u7ed3\u675f\u65f6\u95f4\u5931\u8d25");
            return rspBO;
        }
        this.schemePackMapper.updateAuditTime(reqBO.getSchemeId(), finishTime.getFinishTime());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"qrySupExt"})
    public SchemeListRspBO qrySupExt(@RequestBody SscQrySchemePackExtReqBO reqBO) {
        log.info("qrySupExt param:{}", (Object)JSON.toJSONString((Object)reqBO));
        List<String> supExtList = this.sscSchemeInviteSupPackExtMapper.getListByFieldCode(reqBO.getSchemeId(), reqBO.getFiledCode());
        log.info("supExtList result:{}", (Object)JSON.toJSONString((Object)reqBO));
        if (CollectionUtils.isEmpty(supExtList) || 0 == supExtList.size()) {
            return new SchemeListRspBO();
        }
        SchemeListRspBO rspBO = new SchemeListRspBO();
        rspBO.setSupExtList(supExtList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

