/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.common.ISscCommonModel;
import com.tydic.dyc.ssc.model.common.SscCommonDo;
import com.tydic.dyc.ssc.model.common.sub.SscExtInfo;
import com.tydic.dyc.ssc.model.common.sub.SscExtObjInfo;
import com.tydic.dyc.ssc.repository.SscQrySchemePackExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.CrcAllocationRecordMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SchemeBasisFileBuildFailMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SchemeBasisFileInitMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SchemeBasisFileMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscAccessoryExtMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscJoinSignLogMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPlanPackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeChangeDistributionModeLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.CrcAllocationRecordPO;
import com.tydic.dyc.ssc.repositoryExt.po.SaasSchemePackPO;
import com.tydic.dyc.ssc.repositoryExt.po.SchemeBasisFileBuildFailPO;
import com.tydic.dyc.ssc.repositoryExt.po.SchemeBasisFileInitPO;
import com.tydic.dyc.ssc.repositoryExt.po.SchemeBasisFilePO;
import com.tydic.dyc.ssc.repositoryExt.po.SscAccessoryPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscJoinSignLogPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeChangeDistributionModeLogPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeMatDraftExtPO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemeQryPO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeBasisFileBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeBasisFileBuildFailBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeBasisFileInitBO;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeMatExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQryPlanPackBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeExectStatusPackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackRelationExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemeRelationExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeChangeDistributionModeLogBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscSchemeMatCceExtBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SscQrySchemePackExtRepositoryImpl
implements SscQrySchemePackExtRepository {
    private static final Logger log = LoggerFactory.getLogger(SscQrySchemePackExtRepositoryImpl.class);
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    private final String exect_status_0 = "0";
    private final String exect_status_16 = "16";
    private final String exect_status_1 = "1";
    private final String exect_status_2 = "2";
    private final String exect_status_24 = "24";
    private final String exect_status_30 = "30";
    @Autowired
    private SscSchemeChangeDistributionModeLogMapper sscSchemeChangeDistributionModeLogMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private SchemeBasisFileBuildFailMapper schemeBasisFileBuildFailMapper;
    @Autowired
    private SchemeBasisFileInitMapper schemeBasisFileInitMapper;
    @Autowired
    private SchemeBasisFileMapper schemeBasisFileMapper;
    @Autowired
    private SscAccessoryExtMapper sscAccessoryExtMapper;
    @Autowired
    private SscJoinSignLogMapper sscJoinSignLogMapper;
    @Autowired
    private ISscCommonModel iSscCommonModel;
    @Autowired
    private CrcAllocationRecordMapper crcAllocationRecordMapper;

    public SscQrySchemePackExtRspBO qryPackBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        List<SaasSchemePackPO> saasSchemePackPOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds()) && !CollectionUtils.isEmpty(saasSchemePackPOS = this.saasSchemePackMapper.qryPackBySchemeIds(reqBO.getSchemeIds()))) {
            List rows = JSONObject.parseArray((String)JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
            rspBO.setBos(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qrySchemeExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<Object> schemeExectBOs = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<SaasSchemePackPO> saasSchemePackPOS;
            SscSchemePO searchPO = new SscSchemePO();
            searchPO.setSchemeIdList(reqBO.getSchemeIds());
            List<SscSchemePO> sscSchemePOS = this.saasSchemePackMapper.getModelBy(searchPO);
            if (CollectionUtils.isEmpty(sscSchemePOS)) {
                rspBO.setRespCode("0001");
                rspBO.setRespDesc("\u65b9\u6848\u67e5\u8be2\u4e3a\u7a7a");
            }
            List<SscQryPlanPackBO> sscQryPlanPackBOS = this.sscPlanPackMapper.selectSchemePackExtInfoBySchemeIds(sscSchemePOS.stream().map(SscSchemePO::getSchemeId).collect(Collectors.toList()), "\u91c7\u8d2d\u5458\u540d\u79f0");
            Map<Long, String> collect = sscQryPlanPackBOS.stream().collect(Collectors.toMap(SscQryPlanPackBO::getSchemeId, SscQryPlanPackBO::getPurchaseUserName));
            ArrayList<Long> noSimpleSchemeIds = new ArrayList<Long>();
            ArrayList<Long> jcSchemeIds = new ArrayList<Long>();
            for (SscSchemePO sscSchemePO : sscSchemePOS) {
                if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(String.valueOf(sscSchemePO.getSchemeType()))) {
                    SscQrySchemeExectStatusPackExtBO statusPackExtBO = new SscQrySchemeExectStatusPackExtBO();
                    statusPackExtBO.setSchemeId(sscSchemePO.getSchemeId());
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(sscSchemePO.getSchemeExectStatus());
                    statusPackExtBO.setExectStatusList(arrayList);
                    if (StringUtils.isEmpty((Object)sscSchemePO.getSchemeExectStatus()) || sscSchemePO.getSchemeExectStatus().equals("0") || sscSchemePO.getSchemeExectStatus().equals("16") || sscSchemePO.getSchemeExectStatus().equals("24") || sscSchemePO.getSchemeExectStatus().equals("30")) {
                        statusPackExtBO.setIsDearoOperation(Integer.valueOf(1));
                    } else {
                        statusPackExtBO.setIsDearoOperation(Integer.valueOf(0));
                    }
                    schemeExectBOs.add(statusPackExtBO);
                    continue;
                }
                if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(String.valueOf(sscSchemePO.getSchemeType()))) {
                    jcSchemeIds.add(sscSchemePO.getSchemeId());
                }
                noSimpleSchemeIds.add(sscSchemePO.getSchemeId());
            }
            if (!CollectionUtils.isEmpty(noSimpleSchemeIds) && !CollectionUtils.isEmpty(saasSchemePackPOS = this.saasSchemePackMapper.qryPackBySchemeIds(noSimpleSchemeIds))) {
                Map<Long, List<SaasSchemePackPO>> schemeIdMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getSchemeId));
                for (Long l : schemeIdMap.keySet()) {
                    List<SaasSchemePackPO> packPOS = schemeIdMap.get(l);
                    Set packExectStatusSet = packPOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getPackExectStatus())).map(SaasSchemePackPO::getPackExectStatus).collect(Collectors.toSet());
                    SscQrySchemeExectStatusPackExtBO statusPackExtBO = new SscQrySchemeExectStatusPackExtBO();
                    statusPackExtBO.setSchemeId(l);
                    ArrayList exectStatusList = new ArrayList();
                    exectStatusList.addAll(packExectStatusSet);
                    statusPackExtBO.setIsDearoOperation(Integer.valueOf(1));
                    for (String packExectStatus : exectStatusList) {
                        if ("0".equals(packExectStatus) || "16".equals(packExectStatus) || "1".equals(packExectStatus) || "2".equals(packExectStatus) || "24".equals(packExectStatus) || "30".equals(packExectStatus)) continue;
                        statusPackExtBO.setIsDearoOperation(Integer.valueOf(0));
                        break;
                    }
                    statusPackExtBO.setExectStatusList(exectStatusList);
                    schemeExectBOs.add(statusPackExtBO);
                }
            }
            HashMap<Long, Integer> checkMap = new HashMap<Long, Integer>();
            if (!CollectionUtils.isEmpty(jcSchemeIds)) {
                List<SaasSchemePackPO> saasSchemePackPOS2 = this.saasSchemePackMapper.qryPackBySchemeIds(jcSchemeIds);
                if (!CollectionUtils.isEmpty(saasSchemePackPOS2)) {
                    List<Long> packIds = saasSchemePackPOS2.stream().map(e -> e.getPackId()).collect(Collectors.toList());
                    List<Long> list = this.saasSchemePackMapper.qryXyCount(packIds);
                    for (SaasSchemePackPO saasSchemePackPO : saasSchemePackPOS2) {
                        if (!list.contains(saasSchemePackPO.getPackId())) continue;
                        checkMap.put(saasSchemePackPO.getSchemeId(), 0);
                    }
                }
                for (SscQrySchemeExectStatusPackExtBO sscQrySchemeExectStatusPackExtBO : schemeExectBOs) {
                    if (checkMap.get(sscQrySchemeExectStatusPackExtBO.getSchemeId()) == null || (Integer)checkMap.get(sscQrySchemeExectStatusPackExtBO.getSchemeId()) != 0) continue;
                    sscQrySchemeExectStatusPackExtBO.setIsDearoOperation(Integer.valueOf(0));
                }
            }
            List<Object> checkSchemeIds = new ArrayList();
            if (!CollectionUtils.isEmpty(sscSchemePOS)) {
                checkSchemeIds = sscSchemePOS.stream().filter(e -> SscCommConstant.SchemeStatus.CHECK.getCode().equals(e.getSchemeStatus())).map(SscSchemePO::getSchemeId).collect(Collectors.toList());
            }
            for (SscQrySchemeExectStatusPackExtBO sscQrySchemeExectStatusPackExtBO : schemeExectBOs) {
                String isDearoOperationStr;
                if (CollectionUtils.isEmpty(collect) || StringUtils.isEmpty((Object)(isDearoOperationStr = collect.get(sscQrySchemeExectStatusPackExtBO.getSchemeId()))) || checkSchemeIds.contains(sscQrySchemeExectStatusPackExtBO.getSchemeId())) continue;
                sscQrySchemeExectStatusPackExtBO.setIsDearoOperation(Integer.valueOf(0));
            }
            rspBO.setSchemeExectBOs(schemeExectBOs);
        } else {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
        }
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryPackByPackIds(SscQrySchemePackExtReqBO reqBO) {
        List rows;
        List<SaasSchemePackPO> saasSchemePackPOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds()) && !CollectionUtils.isEmpty(saasSchemePackPOS = this.saasSchemePackMapper.qryPackByPackIds(reqBO.getPackIds()))) {
            rows = JSONObject.parseArray((String)JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
            rspBO.setBos(rows);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPurchasePackIds()) && !CollectionUtils.isEmpty(saasSchemePackPOS = this.saasSchemePackMapper.qryPackByPurchasePackIds(reqBO.getPurchasePackIds()))) {
            rows = JSONObject.parseArray((String)JSONObject.toJSONString(saasSchemePackPOS), SscQrySchemePackExtBO.class);
            rspBO.setBos(rows);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateSchemePackImplCodeExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds())) {
            int n = this.saasSchemePackMapper.updateSchemePackImplCodeExect(reqBO.getPackIds());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updatePackPackStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds()) && !StringUtils.isEmpty((Object)reqBO.getPackExectStatus())) {
            SscSchemePO searchPO = new SscSchemePO();
            searchPO.setSchemeIdList(reqBO.getSchemeIds());
            List<SscSchemePO> schemePOS = this.saasSchemePackMapper.getModelBy(searchPO);
            ArrayList<Long> simpleSchemeIds = new ArrayList<Long>();
            ArrayList<Long> purchaseSchemeIds = new ArrayList<Long>();
            ArrayList<Long> focusSchemeIds = new ArrayList<Long>();
            if (!CollectionUtils.isEmpty(schemePOS)) {
                for (SscSchemePO schemePO : schemePOS) {
                    if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(String.valueOf(schemePO.getSchemeType()))) {
                        simpleSchemeIds.add(schemePO.getSchemeId());
                        continue;
                    }
                    if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(String.valueOf(schemePO.getSchemeType()))) {
                        purchaseSchemeIds.add(schemePO.getSchemeId());
                        continue;
                    }
                    focusSchemeIds.add(schemePO.getSchemeId());
                }
            }
            if (SscCommConstant.SchemeExectStatus.JYCGJH.getCode().toString().equals(reqBO.getPackExectStatus())) {
                if (!CollectionUtils.isEmpty(simpleSchemeIds)) {
                    this.saasSchemePackMapper.updateSchemePackStatus(simpleSchemeIds, SscCommConstant.SchemeExectStatus.JYCGJH.getCode().toString());
                }
                if (!CollectionUtils.isEmpty(purchaseSchemeIds)) {
                    this.saasSchemePackMapper.updatePackPackStatus(purchaseSchemeIds, SscCommConstant.SchemeExectStatus.CGFA.getCode().toString());
                }
                if (!CollectionUtils.isEmpty(focusSchemeIds)) {
                    this.saasSchemePackMapper.updatePackPackStatus(focusSchemeIds, SscCommConstant.SchemeExectStatus.JCFA.getCode().toString());
                }
            } else {
                if (!CollectionUtils.isEmpty(simpleSchemeIds)) {
                    this.saasSchemePackMapper.updateSchemePackStatus(simpleSchemeIds, reqBO.getPackExectStatus());
                }
                ArrayList<Long> schemeIds = new ArrayList<Long>();
                schemeIds.addAll(purchaseSchemeIds);
                schemeIds.addAll(focusSchemeIds);
                if (!CollectionUtils.isEmpty(schemeIds)) {
                    int n = this.saasSchemePackMapper.updatePackPackStatus(schemeIds, reqBO.getPackExectStatus());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qrySchemeExist(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        SscQrySchemeExectStatusPackExtBO sscQrySchemeExectStatusPackExtBO = this.saasSchemePackMapper.qrySchemeExist(reqBO.getSchemeId());
        Long id = null;
        if (sscQrySchemeExectStatusPackExtBO != null) {
            id = sscQrySchemeExectStatusPackExtBO.getSchemeId();
        }
        if (id != null) {
            rspBO.setIsSchemeExist(Integer.valueOf(1));
            ArrayList<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = new ArrayList<SscQrySchemeExectStatusPackExtBO>();
            schemeExectBOs.add(sscQrySchemeExectStatusPackExtBO);
            rspBO.setSchemeExectBOs(schemeExectBOs);
        } else {
            rspBO.setIsSchemeExist(Integer.valueOf(0));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qrySchemeAuditProclnstld(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<SscQrySchemeExectStatusPackExtBO> schemeExectBOs = this.saasSchemePackMapper.qrySchemeAuditProclnstld(reqBO.getSchemeIds());
            rspBO.setSchemeExectBOs(schemeExectBOs);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryPackStatusBySchemeIdsOrpackIds(SscQrySchemePackExtReqBO reqBO) {
        List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        ArrayList<SscQrySchemePackExtBO> bos = new ArrayList<SscQrySchemePackExtBO>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds()) && !CollectionUtils.isEmpty(sscQrySchemePackExtBOS = this.saasSchemePackMapper.qrySchemeExectStatusBySchemeIds(reqBO.getSchemeIds()))) {
            bos.addAll(sscQrySchemePackExtBOS);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds()) && !CollectionUtils.isEmpty(sscQrySchemePackExtBOS = this.saasSchemePackMapper.qryPackStatusByByPackIds(reqBO.getPackIds()))) {
            bos.addAll(sscQrySchemePackExtBOS);
        }
        rspBO.setBos(bos);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updatePackageAllocation(SscQrySchemePackExtReqBO reqBO) {
        int num;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getImplId() == null) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[implId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getImplCode())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[implCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getImplName())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[implName]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getPackIds())) {
            throw new BaseBusinessException("291001", "\u5165\u53c2\u5305ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<SaasSchemePackPO> saasSchemePackPOS = this.saasSchemePackMapper.qryPackByPackIds(reqBO.getPackIds());
        if (CollectionUtils.isEmpty(saasSchemePackPOS)) {
            throw new ZTBusinessException("\u67e5\u8be2\u5305\u4fe1\u606f\u5931\u8d25\uff0c\u6570\u636e\u4e3a\u7a7a");
        }
        ArrayList<Long> updatePackStatusIds = new ArrayList<Long>();
        for (SaasSchemePackPO saasSchemePackPO : saasSchemePackPOS) {
            if (!StringUtils.isEmpty((Object)saasSchemePackPO.getPackStatus())) continue;
            updatePackStatusIds.add(saasSchemePackPO.getPackId());
        }
        int count = this.saasSchemePackMapper.updateSchemePackImplCodeByBoExect(reqBO);
        if (count == 0) {
            throw new ZTBusinessException("\u4fee\u6539\u6570\u636e\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(updatePackStatusIds) && (num = this.saasSchemePackMapper.updatePackStatus(updatePackStatusIds, "03")) == 0) {
            throw new ZTBusinessException("\u4fee\u6539\u5305\u72b6\u6001\u6570\u636e\u5931\u8d25");
        }
        this.saveOperateLog(reqBO, saasSchemePackPOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveOperateLog(SscQrySchemePackExtReqBO reqBo, List<SaasSchemePackPO> saasSchemePackPOS) {
        try {
            Map<Long, List<SaasSchemePackPO>> packMap = saasSchemePackPOS.stream().collect(Collectors.groupingBy(SaasSchemePackPO::getPackId));
            List<CrcAllocationRecordPO> crcAllocationRecordPOS = reqBo.getPackIds().stream().map(item -> {
                List schemePackPOS = (List)packMap.get(item);
                if (!CollectionUtils.isEmpty((Collection)schemePackPOS)) {
                    SaasSchemePackPO saasSchemePackPO = (SaasSchemePackPO)schemePackPOS.get(0);
                    CrcAllocationRecordPO recordPO = new CrcAllocationRecordPO();
                    recordPO.setId(Sequence.getInstance().nextId());
                    recordPO.setObjId((Long)item);
                    recordPO.setObjType(1);
                    recordPO.setOperatorId(StringUtils.isEmpty((Object)saasSchemePackPO.getImplId()) ? saasSchemePackPO.getUpdateLoginId() : Long.parseLong(saasSchemePackPO.getImplId()));
                    recordPO.setOperatorCode(StringUtils.isEmpty((Object)saasSchemePackPO.getImplCode()) ? saasSchemePackPO.getUpdateUsername() : saasSchemePackPO.getImplCode());
                    recordPO.setOperatorName(StringUtils.isEmpty((Object)saasSchemePackPO.getImplName()) ? saasSchemePackPO.getUpdateName() : saasSchemePackPO.getImplName());
                    recordPO.setOperatorById(reqBo.getImplId());
                    recordPO.setOperatorByName(reqBo.getImplName());
                    recordPO.setOperatorByCode(reqBo.getImplCode());
                    recordPO.setIsDeleted(0);
                    return recordPO;
                }
                return null;
            }).collect(Collectors.toList());
            this.crcAllocationRecordMapper.batchInsert(crcAllocationRecordPOS);
        }
        catch (Exception e) {
            log.error("updatePackageAllocation saveOperateLog error:{}", (Throwable)e);
        }
    }

    public SscQrySchemePackExtRspBO updateClearSchemeSchemeExectStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null) {
            int n = this.saasSchemePackMapper.updateClearSchemeSchemeExectStatus(reqBO.getSchemeId(), reqBO.getSchemeExectStatus());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryNonRecruitmentIdBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<SscSchemeQryPO> sscSchemeExtList = this.saasSchemePackMapper.getSscSchemeExtList(reqBO.getSchemeIds());
            HashMap<Long, SscQrySchemeExectStatusPackExtBO> schemeIdMap = new HashMap<Long, SscQrySchemeExectStatusPackExtBO>();
            if (!CollectionUtils.isEmpty(sscSchemeExtList)) {
                for (SscSchemeQryPO po : sscSchemeExtList) {
                    SscQrySchemeExectStatusPackExtBO bo;
                    if ("nonRecruitmentId".equals(po.getFieldCode())) {
                        if (schemeIdMap.keySet().contains(po.getSchemeId())) {
                            bo = (SscQrySchemeExectStatusPackExtBO)schemeIdMap.get(po.getSchemeId());
                            bo.setNonRecruitmentId(po.getFieldValue());
                        } else {
                            bo = new SscQrySchemeExectStatusPackExtBO();
                            bo.setSchemeId(po.getSchemeId());
                            bo.setNonRecruitmentId(po.getFieldValue());
                            schemeIdMap.put(po.getSchemeId(), bo);
                        }
                    }
                    if (!"isCanHangUp".equals(po.getFieldCode())) continue;
                    if (schemeIdMap.keySet().contains(po.getSchemeId())) {
                        bo = (SscQrySchemeExectStatusPackExtBO)schemeIdMap.get(po.getSchemeId());
                        bo.setIsCanHangUp(po.getFieldValue());
                        continue;
                    }
                    bo = new SscQrySchemeExectStatusPackExtBO();
                    bo.setSchemeId(po.getSchemeId());
                    bo.setIsCanHangUp(po.getFieldValue());
                    schemeIdMap.put(po.getSchemeId(), bo);
                }
            }
            if (!CollectionUtils.isEmpty(schemeIdMap)) {
                ArrayList schemeExectBOs = new ArrayList();
                for (Long schemeId : schemeIdMap.keySet()) {
                    schemeExectBOs.add(schemeIdMap.get(schemeId));
                }
                rspBO.setSchemeExectBOs(schemeExectBOs);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO syncPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getIsQryDatabaseSync() != null && reqBO.getIsQryDatabaseSync() == 0 && !CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<Integer> types = new ArrayList<Integer>();
            if (CollectionUtils.isEmpty((Collection)reqBO.getTypes())) {
                types.add(1);
                types.add(5);
                types.add(6);
            } else {
                types = reqBO.getTypes();
            }
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS = this.saasSchemePackMapper.groupQryPushStatus(reqBO.getSchemeIds(), types);
            if (!CollectionUtils.isEmpty(sscQrySchemePackExtBOS)) {
                ArrayList<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<SscQrySchemePackExtBO>();
                Map<Long, List<SscQrySchemePackExtBO>> schemeIdMap = sscQrySchemePackExtBOS.stream().filter(e -> e.getPushStatus() != null).collect(Collectors.groupingBy(SscQrySchemePackExtBO::getSchemeId));
                for (Long schemeId : schemeIdMap.keySet()) {
                    SscQrySchemePackExtBO bo = new SscQrySchemePackExtBO();
                    bo.setSchemeId(schemeId);
                    bo.setPushStatus(Integer.valueOf(0));
                    for (SscQrySchemePackExtBO packExtBO : schemeIdMap.get(schemeId)) {
                        if (packExtBO.getPushStatus() != 1) continue;
                        bo.setPushStatus(Integer.valueOf(1));
                        break;
                    }
                    for (SscQrySchemePackExtBO packExtBO : schemeIdMap.get(schemeId)) {
                        if (packExtBO.getPushStatus() != 2) continue;
                        bo.setPushStatus(Integer.valueOf(2));
                    }
                    sscSchemePack.add(bo);
                }
                reqBO.setSscSchemePack(sscSchemePack);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO syncPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getIsQryDatabaseSync() != null && reqBO.getIsQryDatabaseSync() == 0 && !CollectionUtils.isEmpty((Collection)reqBO.getPackIds())) {
            List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS;
            ArrayList<Integer> types = new ArrayList<Integer>();
            if (CollectionUtils.isEmpty((Collection)reqBO.getTypes())) {
                types.add(7);
            } else {
                types = reqBO.getTypes();
            }
            if (reqBO.getIsQryDatabaseSync() != null && reqBO.getIsQryDatabaseSync() == 0 && !CollectionUtils.isEmpty(sscQrySchemePackExtBOS = this.saasSchemePackMapper.groupQryPackPushStatus(reqBO.getPackIds(), types))) {
                ArrayList<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<SscQrySchemePackExtBO>();
                Map<Long, List<SscQrySchemePackExtBO>> packIdMap = sscQrySchemePackExtBOS.stream().filter(e -> e.getPushStatus() != null).collect(Collectors.groupingBy(SscQrySchemePackExtBO::getPackId));
                for (Long packId : packIdMap.keySet()) {
                    SscQrySchemePackExtBO bo = new SscQrySchemePackExtBO();
                    bo.setPackId(packId);
                    bo.setPushStatus(Integer.valueOf(0));
                    for (SscQrySchemePackExtBO packExtBO : packIdMap.get(packId)) {
                        if (packExtBO.getPushStatus() != 1) continue;
                        bo.setPushStatus(Integer.valueOf(1));
                        break;
                    }
                    for (SscQrySchemePackExtBO packExtBO : packIdMap.get(packId)) {
                        if (packExtBO.getPushStatus() != 2) continue;
                        bo.setPushStatus(Integer.valueOf(2));
                    }
                    sscSchemePack.add(bo);
                }
                reqBO.setSscSchemePack(sscSchemePack);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryPushStatus(SscQrySchemePackExtReqBO reqBO) {
        List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        List<Integer> types = new ArrayList<Integer>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getTypes())) {
            types.add(1);
            types.add(5);
            types.add(6);
        } else {
            types = reqBO.getTypes();
        }
        reqBO.setTypes(types);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds()) && !CollectionUtils.isEmpty(sscQrySchemePackExtBOS = this.saasSchemePackMapper.groupQryPushStatus(reqBO.getSchemeIds(), types))) {
            rspBO.setBos(sscQrySchemePackExtBOS);
        }
        if (reqBO.getPageNo() != null && reqBO.getPageSize() != null && reqBO.getSchemeId() != null) {
            Page pg = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<SscQrySchemePackExtBO> bos = this.saasSchemePackMapper.qryPushStatusListPage(reqBO, (Page<SscQrySchemePackExtBO>)pg);
            rspBO.setBos(bos);
            rspBO.setPageNo(Integer.valueOf(pg.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryPackPushStatus(SscQrySchemePackExtReqBO reqBO) {
        List<SscQrySchemePackExtBO> sscQrySchemePackExtBOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        ArrayList<Integer> types = new ArrayList<Integer>();
        if (CollectionUtils.isEmpty((Collection)reqBO.getTypes())) {
            types.add(7);
        } else {
            types = reqBO.getTypes();
        }
        reqBO.setTypes(types);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds()) && !CollectionUtils.isEmpty(sscQrySchemePackExtBOS = this.saasSchemePackMapper.groupQryPackPushStatus(reqBO.getPackIds(), types))) {
            rspBO.setBos(sscQrySchemePackExtBOS);
        }
        if (reqBO.getPageNo() != null && reqBO.getPageSize() != null && reqBO.getPackId() != null) {
            Page pg = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<SscQrySchemePackExtBO> bos = this.saasSchemePackMapper.qryPackPushStatusListPage(reqBO, (Page<SscQrySchemePackExtBO>)pg);
            rspBO.setBos(bos);
            rspBO.setPageNo(Integer.valueOf(pg.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateCommonItemNo(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getPlanId() != null) {
            List<Long> commonItemNoSchemeMatIds;
            ArrayList<Long> schemeMatIds = new ArrayList<Long>();
            int pageNo = 1;
            int pageSize = 1000;
            int curPage = (pageNo - 1) * pageSize;
            while (!CollectionUtils.isEmpty(commonItemNoSchemeMatIds = this.saasSchemePackMapper.getCommonItemNoSchemeMatIds(reqBO.getPlanId(), curPage, pageSize))) {
                schemeMatIds.addAll(commonItemNoSchemeMatIds);
                SchemeMatExtBO schemeMatExtBO = new SchemeMatExtBO();
                schemeMatExtBO.setPlanId(reqBO.getPlanId());
                schemeMatExtBO.setMatCode(reqBO.getItemNo());
                schemeMatExtBO.setMatName(reqBO.getItemName());
                schemeMatExtBO.setMatSpec(reqBO.getSpec());
                schemeMatExtBO.setMatModel(reqBO.getModel());
                schemeMatExtBO.setCatalogCode(reqBO.getCatalogCode());
                schemeMatExtBO.setCatalogName(reqBO.getCatalogName());
                schemeMatExtBO.setRemark(reqBO.getItemDesc());
                if (!StringUtils.isEmpty((Object)reqBO.getItemDesc())) {
                    schemeMatExtBO.setMatName(reqBO.getItemDesc());
                }
                schemeMatExtBO.setMeasureUnitName(reqBO.getMeasureUnitName());
                schemeMatExtBO.setSchemeMatIds(schemeMatIds);
                this.saasSchemePackMapper.updateCommonItemNo(schemeMatExtBO);
                this.saasSchemePackMapper.updateCommonItemNoCollecControlExt(schemeMatIds, reqBO.getInControlsCatalog());
                this.saasSchemePackMapper.updateCommonItemNocollecImplExt(schemeMatIds, reqBO.getInImplementCatalog());
                curPage = (++pageNo - 1) * pageSize;
                if (!CollectionUtils.isEmpty(schemeMatIds)) continue;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO verifySchemeNo(SscQrySchemePackExtReqBO reqBO) {
        List existSchemeIds;
        List<SscQrySchemeExectStatusPackExtBO> bos;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        rspBO.setIsSchemeExist(Integer.valueOf(0));
        if (!(StringUtils.isEmpty((Object)reqBO.getSchemeNo()) || CollectionUtils.isEmpty(bos = this.saasSchemePackMapper.qrySchemeBySchemeNo(reqBO.getSchemeNo())) || CollectionUtils.isEmpty(existSchemeIds = bos.stream().filter(e -> e.getSchemeId() != null && !e.getSchemeId().equals(reqBO.getSchemeId())).map(SscQrySchemeExectStatusPackExtBO::getSchemeId).collect(Collectors.toList())))) {
            rspBO.setIsSchemeExist(Integer.valueOf(1));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updatePackImplCodeDefault(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null && !StringUtils.isEmpty((Object)reqBO.getCreateName()) && !StringUtils.isEmpty((Object)reqBO.getCreateUsername())) {
            List<Long> packIds;
            ArrayList<Long> schemeIds = new ArrayList<Long>();
            schemeIds.add(reqBO.getSchemeId());
            List<SaasSchemePackPO> saasSchemePackPOS = this.saasSchemePackMapper.qryPackBySchemeIds(schemeIds);
            if (!CollectionUtils.isEmpty(saasSchemePackPOS) && !CollectionUtils.isEmpty(packIds = saasSchemePackPOS.stream().map(SaasSchemePackPO::getPackId).collect(Collectors.toList()))) {
                this.saasSchemePackMapper.updatePackImplCodeDefault(packIds, reqBO.getCreateUsername(), reqBO.getCreateName());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryPlanMatBySchemeId(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() == null) {
            rspBO.setRespCode("0001");
            rspBO.setRespDesc("\u5165\u53c2\u67e5\u8be2\u65b9\u6848id\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSchemeType() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u67e5\u8be2\u65b9\u6848\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getQryFlag() == null) {
            throw new ZTBusinessException("\u5165\u53c2\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<Object> sscQryMatExtBOS = new ArrayList();
        if (reqBO.getQryFlag() == 1) {
            if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryDraftPlanMatBySchemeId(reqBO.getSchemeId(), null, null);
            }
            if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryDraftPlanMatBySchemeId(reqBO.getSchemeId(), 1, reqBO.getPurchasePackageIds());
            }
        } else if (reqBO.getQryFlag() == 2) {
            if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryFormalPlanMatBySchemeId(reqBO.getSchemeId(), null);
            }
            if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryFormalPlanMatBySchemeId(reqBO.getSchemeId(), 1);
            }
        } else if (reqBO.getQryFlag() == 3) {
            if (reqBO.getSchemeHisId() == null) {
                throw new ZTBusinessException("\u5165\u53c2\u67e5\u8be2\u5386\u53f2id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (SscCommConstant.SchemeTypeEnum.PURCHASE.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryHislPlanMatBySchemeId(reqBO.getSchemeId(), null, reqBO.getSchemeHisId());
            }
            if (SscCommConstant.SchemeTypeEnum.FOCUS.getCode().equals(reqBO.getSchemeType())) {
                sscQryMatExtBOS = this.saasSchemePackMapper.qryHislPlanMatBySchemeId(reqBO.getSchemeId(), 1, reqBO.getSchemeHisId());
            }
        } else {
            throw new ZTBusinessException("\u5165\u53c2\u67e5\u8be2\u7c7b\u578b\u5f02\u5e38");
        }
        rspBO.setSscQryMatExtBOS(sscQryMatExtBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryTotalExpectMoneySum(SscQrySchemePackExtReqBO reqBO) {
        return null;
    }

    public SscQrySchemePackExtRspBO updateSchemeMatNullValueBatch(SscQrySchemePackExtReqBO reqBO) {
        SscSchemeMatDraftExtPO updatePO;
        List<SscSchemeMatDraftExtPO> list;
        SscSchemeMatDraftExtPO searchPO;
        Page page;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        Integer type = Integer.valueOf(reqBO.getUpdateType());
        List sscSchemeMat = reqBO.getSscSchemeMat();
        if (sscSchemeMat.size() != 1) {
            throw new BaseBusinessException("292001", "sscSchemeMat(\u65b9\u6848\u7269\u6599\u4fe1\u606f)\u6709\u4e14\u53ea\u80fd\u6709\u4e00\u6761\u6570\u636e,\u5f53\u524d\u5b58\u5728" + sscSchemeMat.size());
        }
        ArrayList<SscSchemeMatDraftExtPO> itemInfo = new ArrayList<SscSchemeMatDraftExtPO>();
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_ALL_MAT)) {
            page = new Page();
            page.setPageNo(1);
            page.setPageSize(5000);
            searchPO = new SscSchemeMatDraftExtPO();
            searchPO.setSchemeId(reqBO.getSchemeId());
            searchPO.setPackId(((SscSchemeMatCceExtBO)sscSchemeMat.get(0)).getPackId());
            searchPO.setOrderBy("scheme_mat_id desc");
            list = this.sscPlanPackMapper.getListPage(searchPO, (Page<SscSchemeMatDraftExtPO>)page);
            if (!CollectionUtils.isEmpty(list)) {
                for (SscSchemeMatDraftExtPO po : list) {
                    updatePO = new SscSchemeMatDraftExtPO();
                    updatePO.setSchemeMatId(po.getSchemeMatId());
                    updatePO.setSchemeId(po.getSchemeId());
                    if (po.getTaxRate() == null || po.getNoTaxPrice() == null || po.getPurchaseNum() == null) continue;
                    updatePO.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                    updatePO.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                    updatePO.setExpectPrice(updatePO.getTaxPrice());
                    updatePO.setExpectMoney(updatePO.getTotalTaxPrice());
                    itemInfo.add(updatePO);
                }
                int totalPages = page.getTotalPages();
                if (totalPages > 1) {
                    for (int i = 2; i <= totalPages; ++i) {
                        Page pageParam = new Page();
                        pageParam.setPageNo(i);
                        pageParam.setPageSize(5000);
                        List<SscSchemeMatDraftExtPO> listPage = this.sscPlanPackMapper.getListPage(searchPO, (Page<SscSchemeMatDraftExtPO>)page);
                        for (SscSchemeMatDraftExtPO po : listPage) {
                            SscSchemeMatDraftExtPO updatePO2 = new SscSchemeMatDraftExtPO();
                            updatePO2.setSchemeMatId(po.getSchemeMatId());
                            updatePO2.setSchemeId(po.getSchemeId());
                            if (po.getTaxRate() == null || po.getNoTaxPrice() == null || po.getPurchaseNum() == null) continue;
                            updatePO2.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                            updatePO2.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                            updatePO2.setExpectPrice(updatePO2.getTaxPrice());
                            updatePO2.setExpectMoney(updatePO2.getTotalTaxPrice());
                            itemInfo.add(updatePO2);
                        }
                    }
                }
            }
        }
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_CHECKED)) {
            if (CollectionUtils.isEmpty((Collection)((SscSchemeMatCceExtBO)sscSchemeMat.get(0)).getSchemeMatIds())) {
                throw new BaseBusinessException("292001", "\u5165\u53c2schemeMatIds\u65b9\u6848\u7269\u6599ID\u96c6\u5408\u4e3a\u7a7a");
            }
            page = new Page();
            page.setPageNo(1);
            page.setPageSize(1000);
            searchPO = new SscSchemeMatDraftExtPO();
            searchPO.setSchemeId(reqBO.getSchemeId());
            searchPO.setPackId(((SscSchemeMatCceExtBO)sscSchemeMat.get(0)).getPackId());
            searchPO.setSchemeMatIds(((SscSchemeMatCceExtBO)sscSchemeMat.get(0)).getSchemeMatIds());
            searchPO.setOrderBy("scheme_mat_id desc");
            list = this.sscPlanPackMapper.getListPage(searchPO, (Page<SscSchemeMatDraftExtPO>)page);
            if (!CollectionUtils.isEmpty(list)) {
                for (SscSchemeMatDraftExtPO po : list) {
                    updatePO = new SscSchemeMatDraftExtPO();
                    updatePO.setSchemeMatId(po.getSchemeMatId());
                    updatePO.setSchemeId(po.getSchemeId());
                    if (po.getTaxRate() == null || po.getNoTaxPrice() == null || po.getPurchaseNum() == null) continue;
                    updatePO.setTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP));
                    updatePO.setTotalTaxPrice(po.getNoTaxPrice().multiply(new BigDecimal("1").add(po.getTaxRate().multiply(new BigDecimal("0.01")))).setScale(8, RoundingMode.HALF_UP).multiply(po.getPurchaseNum()).setScale(2, RoundingMode.HALF_UP));
                    updatePO.setExpectPrice(updatePO.getTaxPrice());
                    updatePO.setExpectMoney(updatePO.getTotalTaxPrice());
                    itemInfo.add(updatePO);
                }
            }
        }
        if (type.equals(SscCommConstant.SCHEME_MAT_UPDATE_TYPE.APPLY_NO_WRITE)) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(itemInfo)) {
            this.sscPlanPackMapper.updateSchemeMatNullValueBatch(itemInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO deleteAllInviteSupDraft(SscQrySchemePackExtReqBO reqBO) {
        List<Long> schemeInviteSupId;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null && !CollectionUtils.isEmpty(schemeInviteSupId = this.saasSchemePackMapper.qrySchemeInviteDraft(reqBO.getSchemeId(), reqBO.getPackId()))) {
            this.saasSchemePackMapper.deleteSchemeInviteExtDraftBy(schemeInviteSupId);
            int count = this.saasSchemePackMapper.deleteSchemeInviteDraftBy(schemeInviteSupId);
            if (count == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5220\u9664\u5931\u8d25\uff0c\u5220\u9664\u6210\u529f\u7684\u6761\u6570\u4e3a0\u6761");
                return rspBO;
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateSchemePackAssignStatusExect(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            int n = this.saasSchemePackMapper.updateSchemePackAssignStatusExect(reqBO.getSchemeIds());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qrySchemeSubmitType(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<SscQrySchemePackExtBO> bos = this.saasSchemePackMapper.qrySchemeSubmitType(reqBO.getSchemeIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO addChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getList())) {
            Date nowDate = new Date();
            ArrayList<SscSchemeChangeDistributionModeLogPO> insertPOS = new ArrayList<SscSchemeChangeDistributionModeLogPO>();
            for (SscSchemeChangeDistributionModeLogBO bo : reqBO.getList()) {
                SscSchemeChangeDistributionModeLogPO po = (SscSchemeChangeDistributionModeLogPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), SscSchemeChangeDistributionModeLogPO.class);
                po.setLogId(this.uccBatchSequence.nextId());
                po.setCreateTime(nowDate);
                po.setCreateUserId(reqBO.getUserId());
                po.setCreateName(reqBO.getName());
                po.setCreateUserName(reqBO.getUsername());
                insertPOS.add(po);
            }
            this.sscSchemeChangeDistributionModeLogMapper.insertBatch(insertPOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryChangeDistributionModeLogList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null) {
            ArrayList<Long> schemeIds = new ArrayList<Long>();
            schemeIds.add(reqBO.getSchemeId());
            Page pg = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
            List<SscSchemeChangeDistributionModeLogPO> pos = this.sscSchemeChangeDistributionModeLogMapper.qryListBySchemeIdsPage(schemeIds, (Page<SscSchemeChangeDistributionModeLogPO>)pg);
            if (!CollectionUtils.isEmpty(pos)) {
                List logBOS = JSONObject.parseArray((String)JSONObject.toJSONString(pos), SscSchemeChangeDistributionModeLogBO.class);
                rspBO.setLogBOS(logBOS);
            } else {
                rspBO.setLogBOS(new ArrayList());
            }
            rspBO.setTotal(Integer.valueOf(pg.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(pg.getPageNo()));
            rspBO.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryIsExistChangeDistributionModeLog(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<Long> schemeIds = this.sscSchemeChangeDistributionModeLogMapper.qryIsExistChangeDistributionModeLog(reqBO.getSchemeIds());
            rspBO.setSchemeIds(schemeIds);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qrySchemeOrganizationFormByPackIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds())) {
            List<SscQrySchemePackExtBO> bos = this.saasSchemePackMapper.qrySchemeOrganizationFormByPackIds(reqBO.getPackIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateSchemeNullField(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null) {
            this.saasSchemePackMapper.updateSchemeNullField(reqBO.getSchemeId());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO addBasisFile(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null) {
            this.schemeBasisFileMapper.deleteBySchemeId(reqBO.getSchemeId(), 1);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBasisFileBoList())) {
            List<Long> packIds = reqBO.getBasisFileBoList().stream().filter(e -> e.getPackId() != null).map(SchemeBasisFileBO::getPackId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(packIds)) {
                this.schemeBasisFileMapper.deleteByPackIds(packIds, 1);
            }
            ArrayList<SchemeBasisFilePO> list = new ArrayList<SchemeBasisFilePO>();
            for (SchemeBasisFileBO fileBO : reqBO.getBasisFileBoList()) {
                SchemeBasisFilePO po = (SchemeBasisFilePO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fileBO), SchemeBasisFilePO.class);
                po.setFileId(this.uccBatchSequence.nextId());
                list.add(po);
            }
            this.schemeBasisFileMapper.insertBatch(list);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO addBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBasisFailBoList())) {
            ArrayList<SchemeBasisFileBuildFailPO> list = new ArrayList<SchemeBasisFileBuildFailPO>();
            for (SchemeBasisFileBuildFailBO bo : reqBO.getBasisFailBoList()) {
                SchemeBasisFileBuildFailPO po = (SchemeBasisFileBuildFailPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), SchemeBasisFileBuildFailPO.class);
                po.setFailId(this.uccBatchSequence.nextId());
                list.add(po);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.schemeBasisFileBuildFailMapper.insertBatch(list);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeBasisFileBuildFailBO() != null && reqBO.getSchemeBasisFileBuildFailBO().getFailId() != null) {
            SchemeBasisFileBuildFailPO updatePO = (SchemeBasisFileBuildFailPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO.getSchemeBasisFileBuildFailBO()), SchemeBasisFileBuildFailPO.class);
            this.schemeBasisFileBuildFailMapper.updateByPrimaryKeySelective(updatePO);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFailIds()) && reqBO.getStatus() != null) {
            this.schemeBasisFileBuildFailMapper.updateStatusBatch(reqBO.getFailIds(), reqBO.getStatus());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryBasisFileBuildFail(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        SchemeBasisFileBuildFailPO searchPO = new SchemeBasisFileBuildFailPO();
        searchPO.setStatus(reqBO.getStatus());
        searchPO.setFileType(reqBO.getFileType());
        Page pg = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SchemeBasisFileBuildFailPO> buildFailPOS = this.schemeBasisFileBuildFailMapper.selectByPOPage(searchPO, (Page<SchemeBasisFileBuildFailPO>)pg);
        if (!CollectionUtils.isEmpty(buildFailPOS)) {
            List basisFailBoList = JSONObject.parseArray((String)JSONObject.toJSONString(buildFailPOS), SchemeBasisFileBuildFailBO.class);
            rspBO.setBasisFailBoList(basisFailBoList);
        }
        rspBO.setPageNo(Integer.valueOf(pg.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(pg.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        Page pg = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        SchemeBasisFileInitPO searchPO = new SchemeBasisFileInitPO();
        searchPO.setStatus(reqBO.getStatus());
        List<SchemeBasisFileInitPO> initPOS = this.schemeBasisFileInitMapper.selectByPOPage(searchPO, (Page<SchemeBasisFileInitPO>)pg);
        if (!CollectionUtils.isEmpty(initPOS)) {
            List basisFileInitBOS = JSONObject.parseArray((String)JSONObject.toJSONString(initPOS), SchemeBasisFileInitBO.class);
            rspBO.setBasisFileInitBoList(basisFileInitBOS);
        }
        rspBO.setPageNo(Integer.valueOf(pg.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(pg.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(pg.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateBasisFileInit(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getBasisFileInitBoList())) {
            List collection = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getBasisFileInitBoList()), SchemeBasisFileInitPO.class);
            this.schemeBasisFileInitMapper.updateBatch(collection);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryBasisFileList(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackIds()) && reqBO.getFileType() != null) {
            List<Long> schemeIds;
            List<SchemeBasisFilePO> pos = this.schemeBasisFileMapper.selectByPackIds(reqBO.getPackIds(), reqBO.getFileType());
            if (!CollectionUtils.isEmpty(pos)) {
                List basisFileBoList = JSONObject.parseArray((String)JSONObject.toJSONString(pos), SchemeBasisFileBO.class);
                rspBO.setBasisFileBoList(basisFileBoList);
            }
            if (reqBO.getFileType() == 1 && !CollectionUtils.isEmpty(schemeIds = this.saasSchemePackMapper.getSchemeIdByPackIds(reqBO.getPackIds()))) {
                SscAccessoryPO qrySscAccessoryPO = new SscAccessoryPO();
                qrySscAccessoryPO.setObjIds(schemeIds);
                List<SscAccessoryPO> sscAccessoryPOS = this.sscAccessoryExtMapper.getList(qrySscAccessoryPO);
                if (!CollectionUtils.isEmpty(sscAccessoryPOS)) {
                    List<SchemeBasisFileBO> basisFileBoList = new ArrayList();
                    if (!CollectionUtils.isEmpty((Collection)rspBO.getBasisFileBoList())) {
                        basisFileBoList = rspBO.getBasisFileBoList();
                    }
                    for (SscAccessoryPO sscAccessoryPO : sscAccessoryPOS) {
                        SchemeBasisFileBO fileBO = new SchemeBasisFileBO();
                        fileBO.setFileName(sscAccessoryPO.getAccessoryName());
                        fileBO.setFileUrl(sscAccessoryPO.getAccessoryUrl());
                        basisFileBoList.add(fileBO);
                    }
                    rspBO.setBasisFileBoList(basisFileBoList);
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryImplInfoBySchemeIds(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getSchemeIds())) {
            List<SscQrySchemePackExtBO> bos = this.saasSchemePackMapper.qryImplInfoBySchemeIds(reqBO.getSchemeIds());
            rspBO.setBos(bos);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO addJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getJoinSignLogBOS())) {
            List sscJoinSignLogPOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getJoinSignLogBOS()), SscJoinSignLogPO.class);
            this.sscJoinSignLogMapper.insertBatch(sscJoinSignLogPOS);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryJoinSignLogBOS(SscQrySchemePackExtReqBO reqBO) {
        List<SscJoinSignLogPO> sscJoinSignLogPOS;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getTaskIds()) && !CollectionUtils.isEmpty(sscJoinSignLogPOS = this.sscJoinSignLogMapper.selectByTaskIds(reqBO.getTaskIds()))) {
            List existTaskIds = sscJoinSignLogPOS.stream().map(SscJoinSignLogPO::getTaskId).collect(Collectors.toList());
            rspBO.setExistTaskIds(existTaskIds);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateSchemeLastTime(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null && !StringUtils.isEmpty((Object)reqBO.getProcInstId()) && !StringUtils.isEmpty((Object)reqBO.getFormUrl())) {
            Date lastFinishTime = this.saasSchemePackMapper.getLastFinishTime(reqBO.getProcInstId(), reqBO.getFormUrl());
            if (lastFinishTime == null) {
                lastFinishTime = new Date();
            }
            SscCommonDo deleteSscCommonDo = new SscCommonDo();
            ArrayList<SscExtObjInfo> deleteExtOperObjInfoList = new ArrayList<SscExtObjInfo>();
            SscExtObjInfo deleteSchemeExtInfo = new SscExtObjInfo();
            deleteSchemeExtInfo.setObjType("ssc_scheme_ext");
            deleteSchemeExtInfo.setOrderId(reqBO.getSchemeId());
            deleteSchemeExtInfo.setObjId(reqBO.getSchemeId());
            ArrayList<SscExtInfo> deleteSchemeExtInfoList = new ArrayList<SscExtInfo>();
            SscExtInfo deleteSchemeExtInfo1 = new SscExtInfo();
            deleteSchemeExtInfo1.setFieldCode("lastFinishTime");
            deleteSchemeExtInfoList.add(deleteSchemeExtInfo1);
            SscExtInfo deleteSchemeExtInfo2 = new SscExtInfo();
            deleteSchemeExtInfo2.setFieldCode("lastFinishTimeLong");
            deleteSchemeExtInfoList.add(deleteSchemeExtInfo2);
            deleteSchemeExtInfo.setExtInfo(deleteSchemeExtInfoList);
            deleteExtOperObjInfoList.add(deleteSchemeExtInfo);
            deleteSscCommonDo.setExtObjInfos(deleteExtOperObjInfoList);
            this.iSscCommonModel.deleteExtInfo(deleteSscCommonDo);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            SscCommonDo sscCommonOperDoadd = new SscCommonDo();
            ArrayList<SscExtObjInfo> listOperAdd = new ArrayList<SscExtObjInfo>();
            ArrayList<SscExtInfo> listExtInfos = new ArrayList<SscExtInfo>();
            SscExtInfo ExtInfo1 = new SscExtInfo();
            ExtInfo1.setFieldCode("lastFinishTime");
            ExtInfo1.setFieldName("\u65b9\u6848\u7684\u5ba1\u6279\u4e0a\u4e00\u6b65\u9aa4\u7684\u65f6\u95f4");
            ExtInfo1.setFieldValue(sdf.format(lastFinishTime));
            listExtInfos.add(ExtInfo1);
            SscExtInfo ExtInfo2 = new SscExtInfo();
            ExtInfo2.setFieldCode("lastFinishTimeLong");
            ExtInfo2.setFieldName("\u65b9\u6848\u7684\u5ba1\u6279\u4e0a\u4e00\u6b65\u9aa4\u7684\u65f6\u95f4Long\u578b");
            ExtInfo2.setFieldValue(lastFinishTime.getTime() + "");
            listExtInfos.add(ExtInfo2);
            SscExtObjInfo schemeExtInfo2 = new SscExtObjInfo();
            schemeExtInfo2.setObjType("ssc_scheme_ext");
            schemeExtInfo2.setOrderId(reqBO.getSchemeId());
            schemeExtInfo2.setObjId(reqBO.getSchemeId());
            schemeExtInfo2.setExtInfo(listExtInfos);
            listOperAdd.add(schemeExtInfo2);
            sscCommonOperDoadd.setExtObjInfos(listOperAdd);
            this.iSscCommonModel.addExtInfo(sscCommonOperDoadd);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO qryRelation(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemeRelationExtBO schemeRelation;
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeId() != null && (schemeRelation = this.sscPlanPackMapper.qrySchemeRelation(reqBO.getSchemeId())) != null && schemeRelation.getSchemeId() != null) {
            rspBO.setSchemeRelationExtBO(schemeRelation);
            if (!SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(schemeRelation.getSchemeType())) {
                List<SscQrySchemePackRelationExtBO> packRelationExtBOS = this.sscPlanPackMapper.qrySchemePackRelation(reqBO.getSchemeId());
                rspBO.setPackRelationExtBOS(packRelationExtBOS);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public SscQrySchemePackExtRspBO updateRelation(SscQrySchemePackExtReqBO reqBO) {
        SscQrySchemePackExtRspBO rspBO = new SscQrySchemePackExtRspBO();
        if (reqBO.getSchemeRelationExtBO() != null && reqBO.getSchemeRelationExtBO().getSchemeId() != null) {
            this.sscPlanPackMapper.updateSchemeRelation(reqBO.getSchemeRelationExtBO());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getPackRelationExtBOS())) {
            for (SscQrySchemePackRelationExtBO pack : reqBO.getPackRelationExtBOS()) {
                if (pack.getPackId() != null) continue;
                throw new ZTBusinessException("\u5305id\u4e0d\u80fd\u4e3a\u7a7a");
            }
            this.sscPlanPackMapper.updateSchemePackRelation(reqBO.getPackRelationExtBOS());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

