package com.tydic.dyc.ssc.repositoryExt.dao;

import com.tydic.dyc.ssc.repositoryExt.po.AccessoryAllTempPO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 检验附件是否存在临时表(AccessoryAllTempPO)表数据库访问层
 *
 * @author makejava
 * @since 2024-04-07 11:23:13
 */
public interface AccessoryAllTempMapper {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    AccessoryAllTempPO queryById(Long id);

    /**
     * 查询指定行数据
     *
     * @param accessoryAllTempPO 查询条件
     * @param pageNo        分页对象
     * @param pageSize        分页对象
     * @return 对象列表
     */
    List<AccessoryAllTempPO> queryListByPage(@Param("accessoryAllTempPO") AccessoryAllTempPO accessoryAllTempPO, @Param("pageNo") int pageNo, @Param("pageSize") int pageSize);

    /**
     * 统计总行数
     *
     * @param accessoryAllTempPO 查询条件
     * @return 总行数
     */
    int count(AccessoryAllTempPO accessoryAllTempPO);

    /**
     * 新增数据
     *
     * @param accessoryAllTempPO 实例对象
     * @return 影响行数
     */
    int insert(AccessoryAllTempPO accessoryAllTempPO);

    /**
     * 批量新增数据（MyBatis原生foreach方法）
     *
     * @param entities List<AccessoryAllTempPO> 实例对象列表
     * @return 影响行数
     */
    int insertBatch(@Param("entities") List<AccessoryAllTempPO> entities);

    /**
     * 批量新增或按主键更新数据（MyBatis原生foreach方法）
     *
     * @param entities List<AccessoryAllTempPO> 实例对象列表
     * @return 影响行数
     * @throws org.springframework.jdbc.BadSqlGrammarException 入参是空List的时候会抛SQL语句错误的异常，请自行校验入参
     */
    int insertOrUpdateBatch(@Param("entities") List<AccessoryAllTempPO> entities);

    /**
     * 修改数据
     *
     * @param accessoryAllTempPO 实例对象
     * @return 影响行数
     */
    int update(AccessoryAllTempPO accessoryAllTempPO);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);
    /**
     * 修改数据
     *
     * @param list 实例对象
     * @return 影响行数
     */
    int updateByList(@Param("list") List<AccessoryAllTempPO> list);


}
