package com.tydic.dyc.ssc.repositoryExt.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQryAwardResultExtBO;
import com.tydic.dyc.ssc.model.scheme.qrybo.SscQryAwardResultExtReqBO;
import com.tydic.dyc.ssc.repository.SchemeTenderReportListRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import com.tydic.ppc.ability.api.PlanQryPackCreateUserAbilityService;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityReqBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserAbilityRspBO;
import com.tydic.ppc.ability.bo.PlanQryPackCreateUserBO;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 采购方案定标接口Impl
 *
 * @author hcl
 * @since 2023-07-31 15:26:20
 */
@Slf4j
@Service
public class SchemeTenderReportListRepositoryImpl implements SchemeTenderReportListRepository {

    /**
     * 采购方案明细 Mapper
     */
    @Autowired
    private SscSchemeMatPackExtMapper sscSchemeMatPackExtMapper;

    /**
     * 采购方案明细扩展 Mapper
     */
    @Autowired
    private SscSchemeMatExtPackExtMapper sscSchemeMatExtPackExtMapper;

    /**
     * 采购方案供应商 Mapper
     */
    @Autowired
    private SscSchemeInviteSupPackExtMapper sscSchemeInviteSupPackExtMapper;


    /**
     * 集中采购数据
     */
    @Autowired
    private SaasSchemePackMapper saasSchemePackMapper;

    /**
     * 集中采购
     */
    private final Integer FIND_SOURCE_DATA = 1;


    /**
     * 委托采购
     */
    private final Integer SCHEME_ENTRUST_DATA = 2;


    /**
     * 自行采购
     */
    private final Integer INQUIRY_AMOUNT_DATA = 3;
    /**
     * 补录结果
     */
    private final Integer BL_INQUIRY_RESULT = 4;


    @Autowired
    private SaasSchemePurchaseQuotationMapper saasSchemePurchaseQuotationMapper;
    /**
     * 集采方案类型
     */
    private final String COLLECT_SCHEME_TYPE="4";
    /**
     * 扩展字段的编码
     */
    private final String purchasePackId="purchasePackId";
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    @HTServiceRef
    private PlanQryPackCreateUserAbilityService planQryPackCreateUserAbilityService;
    @Autowired
    private CrcNoticeMapper crcNoticeMapper;
    @Autowired
    private CrcSchemeFindsourceSupNoticeMapper crcSchemeFindsourceSupNoticeMapper;
    @Override
    public SchemeTenderReportListRspBO getTenderReportList(SchemeTenderReportReqBO reqBO) {
        SchemeTenderReportListRspBO rspBO = new SchemeTenderReportListRspBO();
        Page<SscSchemeTenderReportListBO> pg = new Page<SscSchemeTenderReportListBO>(reqBO.getPageNo(), reqBO.getPageSize());
        //1.集中采购数据
        List<SscSchemeTenderReportListBO> TenderReportList = null;
        if (reqBO.getQueryType().equals(FIND_SOURCE_DATA)) {
            TenderReportList = saasSchemePackMapper.getSchemeFindSource(reqBO, pg);
        } else if (reqBO.getQueryType().equals(SCHEME_ENTRUST_DATA)) {
            //委托采购
            TenderReportList = saasSchemePackMapper.getSchemeEntrust(reqBO, pg);
        }
        //拓展字段修改
        this.getSscSchemeMatExt(TenderReportList);
        //拓展字段修改
        this.numberProcessingData(TenderReportList);
        if (CollectionUtils.isEmpty(TenderReportList)) {
            rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
            rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
            rspBO.setRows(new ArrayList<>());
            rspBO.setRecordsTotal(0);
            return rspBO;
        }
        //因为合同要取计划分流原始的打包人，按照逻辑 只有 采购包分配给人做集采方案的这一部包需要查询原始的打包人
        Map<Long,PlanQryPackCreateUserBO> packIdMap = new HashMap<>();//集采包id对应的原始数据
        if (!CollectionUtils.isEmpty(TenderReportList)){
            //查询计划分流的包ids
            List<Long> planPackIds = new ArrayList<>();
            Set<String> collect = TenderReportList.stream().filter(e -> COLLECT_SCHEME_TYPE.equals(e.getSchemeType()) && !StringUtils.isEmpty(e.getPackId())).map(SscSchemeTenderReportListBO::getPackId).collect(Collectors.toSet());
            //原始包id对应现在集采包id Map
            Map<Long,Long> packPurchasePackIdMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(collect)){
                //因为集采方案的包可能是分配过来的，所以要查询原始包Ids
                List<Long> list = new ArrayList<>();
                for (String s : collect) {
                    try {
                        list.add(Long.valueOf(s));
                    }catch (Exception e){
                        log.error("转换包Id失败");
                    }
                }
                if (!CollectionUtils.isEmpty(list)){
                    //查询扩展字段
                    List<SscQryPlanPackBO> sscQryPlanPackBOS = sscPlanPackMapper.selectPurchasePackIdByPackIds(list);
                    for (SscQryPlanPackBO ext : sscQryPlanPackBOS) {
                        if (purchasePackId.equals(ext.getFieldCode()) && !StringUtils.isEmpty(ext.getFieldValue())){
                            //从采购包过来生成的数据
                            try {
                                //采购包id
                                Long packPurchasePackId = Long.valueOf(ext.getFieldValue());
                                planPackIds.add(packPurchasePackId);
                                packPurchasePackIdMap.put(packPurchasePackId,ext.getPackId());
                            }catch (Exception e){
                                log.error("转换包Id失败");
                            }
                        }
                    }
                }
            }
            if (!CollectionUtils.isEmpty(planPackIds)){
                //查询计划原始的打包人
                PlanQryPackCreateUserAbilityReqBO abilityReqBO = new PlanQryPackCreateUserAbilityReqBO();
                abilityReqBO.setPackIds(planPackIds);
                try {
                    PlanQryPackCreateUserAbilityRspBO abilityRspBO = planQryPackCreateUserAbilityService.qryPackCreateUser(abilityReqBO);
                    if (RspConstant.RESP_CODE_SUCCESS.equals(abilityRspBO.getRespCode())){
                        if (!CollectionUtils.isEmpty(abilityRspBO.getBos())){
                            for (PlanQryPackCreateUserBO bo : abilityRspBO.getBos()) {
                                //先拿到集采方案包id
                                Long packId = packPurchasePackIdMap.get(bo.getPackId());
                                if (packId!=null){
                                    packIdMap.put(packId,bo);
                                }
                            }
                        }
                    }else {
                        throw new ZTBusinessException(abilityRspBO.getRespDesc());
                    }
                }catch (Exception e){
                    log.error(e.getMessage());
                    throw new ZTBusinessException("查询原始打包人失败"+e.getMessage());
                }
            }
        }
        //出参集合去重
        /*List<SscSchemeTenderReportListBO> qcCollect = TenderReportList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new
                TreeSet<>(Comparator.comparing(bo -> bo.getCompanyCode() +"-"+ bo.getAwardId()))), ArrayList::new));*/


        /*List<SscSchemeTenderReportListBO> fyCollect = qcCollect.stream().sorted(Comparator.comparing(SscSchemeTenderReportListBO::getCompanyCode)).
                skip((reqBO.getPageNo() - 1) * reqBO.getPageSize()).limit(reqBO.getPageSize()).collect(Collectors.toList());*/
        //获取中标时间
        getBidTime(reqBO,TenderReportList);
        for (SscSchemeTenderReportListBO sscSchemeTenderReportListBO : TenderReportList) {
            //赋值参数erpDeptCode
            sscSchemeTenderReportListBO.setErpDeptCode(sscSchemeTenderReportListBO.getDecCompanyCode());
            // 线下报价的标段编码处理为空值
            if ("2".equals(sscSchemeTenderReportListBO.getQuotationType())) {
                sscSchemeTenderReportListBO.setBdCode(null);
            }
            //转换合同的物资分类字段 materialCategory
            if (sscSchemeTenderReportListBO.getSchemeClass()!=null){
                sscSchemeTenderReportListBO.setMaterialCategory(SscCommConstant.transContractMaterialCategory(sscSchemeTenderReportListBO.getSchemeClass()));
            }
            //判断是否取原始打包人
            if (COLLECT_SCHEME_TYPE.equals(sscSchemeTenderReportListBO.getSchemeType())){
                try {
                    Long packId = Long.valueOf(sscSchemeTenderReportListBO.getPackId());
                    if (packIdMap.containsKey(packId)){
                        PlanQryPackCreateUserBO planQryPackCreateUserBO = packIdMap.get(packId);
                        sscSchemeTenderReportListBO.setAwardEmployeeNumber(planQryPackCreateUserBO.getAwardEmployeeNumber());
                        sscSchemeTenderReportListBO.setAwardUserName(planQryPackCreateUserBO.getAwardUserName());
                    }
                }catch (Exception e){

                }
            }
        }

        Map<String, List<SscSchemeTenderReportListBO>> stringListMap = TenderReportList.stream().collect(Collectors.groupingBy(bo -> bo.getCompanyCode() +"-"+ bo.getAwardId()));

        //标题集合
        List<SscSchemeTenderTitleReportBO> tenderTitleReportBOS = new ArrayList<>();

        for (String key : stringListMap.keySet()) {
            List<SscSchemeTenderReportListBO> itemList = stringListMap.get(key);
            if(!CollectionUtils.isEmpty(itemList)){
                SscSchemeTenderTitleReportBO sscSchemeTenderTitleReportBO = new SscSchemeTenderTitleReportBO();
                SscSchemeTenderReportListBO itemBO = itemList.get(0);
                BeanUtils.copyProperties(itemBO, sscSchemeTenderTitleReportBO);
                List<SscSchemeTenderItemReportBO> returnItemList = JSON.parseArray(JSON.toJSONString(itemList), SscSchemeTenderItemReportBO.class);
                sscSchemeTenderTitleReportBO.setItemResultVoList(returnItemList);
                tenderTitleReportBOS.add(sscSchemeTenderTitleReportBO);
            }
        }
       /* for (SscSchemeTenderReportListBO sscSchemeTenderReportListBO : qcCollect) {
            //标题列表
            SscSchemeTenderTitleReportBO sscSchemeTenderTitleReportBO = new SscSchemeTenderTitleReportBO();
            stringListMap.get(sscSchemeTenderReportListBO.getCompanyCode() + "-" + sscSchemeTenderReportListBO.getAwardId())



        }

        for (String key : stringListMap.keySet()) {
            List<SscSchemeTenderReportListBO> sscSchemeTenderReportListBOS = stringListMap.get(key);
            //标题列表
            SscSchemeTenderTitleReportBO sscSchemeTenderTitleReportBO = new SscSchemeTenderTitleReportBO();
            //明细数据
            List<SscSchemeTenderItemReportBO> sscSchemeTenderItemReportBOS = new ArrayList<>();
            for (SscSchemeTenderReportListBO sscSchemeTenderReportListBO : sscSchemeTenderReportListBOS) {
                BeanUtils.copyProperties(sscSchemeTenderReportListBO, sscSchemeTenderTitleReportBO);
                SscSchemeTenderItemReportBO tenderItemReportBO = new SscSchemeTenderItemReportBO();
                BeanUtils.copyProperties(sscSchemeTenderReportListBO, tenderItemReportBO);
                sscSchemeTenderItemReportBOS.add(tenderItemReportBO);
            }
            sscSchemeTenderTitleReportBO.setItemResultVoList(sscSchemeTenderItemReportBOS);
            tenderTitleReportBOS.add(sscSchemeTenderTitleReportBO);
        }*/
       if (!CollectionUtils.isEmpty(tenderTitleReportBOS)){
           for (SscSchemeTenderTitleReportBO tenderTitleReportBO : tenderTitleReportBOS) {
               //方案跟合同的采购方式常量值不是一样的，增加转换
               translateRspResultItemData(tenderTitleReportBO.getItemResultVoList());
           }
       }
        rspBO.setRecordsTotal(pg.getTotalCount());
        rspBO.setTotal(pg.getTotalPages());
        rspBO.setPageNo(pg.getPageNo());
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        rspBO.setRows(tenderTitleReportBOS);
        return rspBO;
    }

    @Override
    public SscSchemeAmountRspBO updateSchemeAmountDeduction(SscSchemeSchemeAmountDeductionReqBO reqBO) {
        SscSchemeAmountRspBO rspBO = new SscSchemeAmountRspBO();
        //根据来源类型对不同数据进行扣减
//        List<String> schemeMatIds = reqBO.getOrderItem().stream().map(SscSchemeAmountBO::getGoodTypeId).collect(Collectors.toList());
        List<SscSchemeMatNum> updateVerify = new ArrayList<>();
        for (SscSchemeAmountBO sscSchemeAmountBO : reqBO.getOrderItem()) {
            if (sscSchemeAmountBO.getQueryType().equals(FIND_SOURCE_DATA)) {
                List<SscSchemeMatNum> list = saasSchemePackMapper.querySchemeXYFindSourceAmount(Arrays.asList(sscSchemeAmountBO.getGoodTypeId()));
                updateVerify.addAll(list);
            } else if (sscSchemeAmountBO.getQueryType().equals(SCHEME_ENTRUST_DATA)) {
                List<SscSchemeMatNum> list = saasSchemePackMapper.querySchemeXYEntrustResultAmount(Arrays.asList(sscSchemeAmountBO.getGoodTypeId()));
                updateVerify.addAll(list);
            } else if (sscSchemeAmountBO.getQueryType().equals(INQUIRY_AMOUNT_DATA)) {
                List<SscSchemeMatNum> list = saasSchemePackMapper.querySchemeXYInquiryAmount(Arrays.asList(sscSchemeAmountBO.getGoodTypeId()));
                updateVerify.addAll(list);
            } else if (sscSchemeAmountBO.getQueryType().equals(BL_INQUIRY_RESULT)) {
                List<SscSchemeMatNum> list = saasSchemePackMapper.querySchemeBLInquiryAmount(Arrays.asList(sscSchemeAmountBO.getGoodTypeId()));
                updateVerify.addAll(list);
            }
        }
        Map<String, SscSchemeAmountBO> sscSchemeAmountBOMap = reqBO.getOrderItem().stream().collect(Collectors.toMap(SscSchemeAmountBO::getGoodTypeId, i -> i));
        //开始校验
        if (!CollectionUtils.isEmpty(updateVerify)) {
            for (SscSchemeMatNum sscSchemeMatNum : updateVerify) {
                SscSchemeAmountBO sscSchemeAmountBO = sscSchemeAmountBOMap.get(String.valueOf(sscSchemeMatNum.getSchemeMatId()));
                if (reqBO.getTypeAmount().equals(0)) {
                    if (sscSchemeAmountBO.getOperateType() == 1) {
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    } else {
                        sscSchemeMatNum.setContractAmount(sscSchemeMatNum.getContractAmount().add(sscSchemeAmountBO.getOrderNum()));

                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getContractAmountY()) > 0) {
                            rspBO.setRespDesc("退回数量不能大于使用量");
                            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                            return rspBO;
                        }
                    }

                    if (sscSchemeMatNum.getOrderAmountY() != null && sscSchemeMatNum.getOrderAmountY().compareTo(BigDecimal.ZERO) > 0) {
                        rspBO.setRespDesc("合同或者订单只能存在一种");
                        rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                        return rspBO;
                    }
                } else {
                    if (sscSchemeAmountBO.getOperateType() == 1) {
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().subtract(sscSchemeAmountBO.getOrderNum()));
                    } else {
                        sscSchemeMatNum.setOrderAmount(sscSchemeMatNum.getOrderAmount().add(sscSchemeAmountBO.getOrderNum()));
                        if (sscSchemeAmountBO.getOrderNum().compareTo(sscSchemeMatNum.getOrderAmountY()) > 0) {
                            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                            rspBO.setRespDesc("退回数量不能大于使用量");
                            return rspBO;
                        }
                    }

                    if (sscSchemeMatNum.getContractAmountY() != null && sscSchemeMatNum.getContractAmountY().compareTo(BigDecimal.ZERO) > 0) {
                        rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                        rspBO.setRespDesc("合同或者订单只能存在一种");
                        return rspBO;
                    }
                }
                if (sscSchemeMatNum.getOrderAmount().compareTo(BigDecimal.ZERO) < 0) {
                    rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                    rspBO.setRespDesc("方案剩余数量不足");
                    return rspBO;
                }
                if (sscSchemeMatNum.getContractAmount().compareTo(BigDecimal.ZERO) < 0) {
                    rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
                    rspBO.setRespDesc("方案剩余数量不足");
                    return rspBO;
                }

            }
        } else {
            rspBO.setRespCode(RspConstant.RESP_CODE_ERROR);
            rspBO.setRespDesc("该方案不存在");
            return rspBO;
        }
        Map<Long, SscSchemeMatNum> sscSchemeMatNumMap = updateVerify.stream().collect(Collectors.toMap(a -> a.getSchemeMatId(), b -> b));
        for (SscSchemeAmountBO sscSchemeAmountBO : reqBO.getOrderItem()) {
            SscSchemeMatNum updateSscScheme = new SscSchemeMatNum();
            SscSchemeMatNum sscSchemeMatNum = sscSchemeMatNumMap.get(Convert.toLong(sscSchemeAmountBO.getGoodTypeId()));
            if (ObjectUtil.isNotEmpty(sscSchemeMatNum)) {
                updateSscScheme.setSchemeMatId(sscSchemeMatNum.getSchemeMatId());
                setSscSchemeMatNumMapper(reqBO.getTypeAmount(), sscSchemeAmountBO, updateSscScheme, sscSchemeMatNum);
            }
            //判断类型更新
            if (sscSchemeAmountBO.getQueryType().equals(FIND_SOURCE_DATA) && !StringUtils.isEmpty(updateSscScheme.getSchemeMatId())) {
                saasSchemePackMapper.updateXYFindSourceAmount(updateSscScheme);
            } else if (sscSchemeAmountBO.getQueryType().equals(SCHEME_ENTRUST_DATA) && !StringUtils.isEmpty(updateSscScheme.getSchemeMatId())) {
                saasSchemePackMapper.updateXYEntrustResultAmount(updateSscScheme);
            } else if (sscSchemeAmountBO.getQueryType().equals(INQUIRY_AMOUNT_DATA) && !StringUtils.isEmpty(updateSscScheme.getSchemeMatId())) {
                saasSchemePackMapper.updateXYInquiryAmount(updateSscScheme);
            } else if (sscSchemeAmountBO.getQueryType().equals(BL_INQUIRY_RESULT) && !StringUtils.isEmpty(updateSscScheme.getSchemeMatId())) {
                saasSchemePackMapper.updateBLInquiryAmount(updateSscScheme);
            }
        }
        return rspBO;
    }

    @Override
    public SchemePurchaseQuotationRspBO getPurchaseQuotation(SscSchemeSPurchaseQuotationReqBO reqBO) {
        this.purchaseQuotationAllocation(reqBO);
        SchemePurchaseQuotationRspBO rspBO = new SchemePurchaseQuotationRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        List<SchemePurchaseQuotationBO> row = null;
        //判断类型更新
        if (reqBO.getQueryType().equals(FIND_SOURCE_DATA)) {
            row = saasSchemePurchaseQuotationMapper.findSourcePurchaseQuotation(reqBO.getGoodTypeIds());
        } else if (reqBO.getQueryType().equals(SCHEME_ENTRUST_DATA)) {
            row =saasSchemePurchaseQuotationMapper.entrustPurchaseQuotation(reqBO.getGoodTypeIds());

        } else if (reqBO.getQueryType().equals(INQUIRY_AMOUNT_DATA)) {
            row =saasSchemePurchaseQuotationMapper.inquiryPurchaseQuotation(reqBO.getGoodTypeIds());
        } else if (reqBO.getQueryType().equals(BL_INQUIRY_RESULT)) {
            row =saasSchemePurchaseQuotationMapper.blInquiryPurchaseQuotation(reqBO.getGoodTypeIds());
        }
        if (CollectionUtils.isEmpty(row)) {
            rspBO.setRows(new ArrayList<>());
            return rspBO;
        }
        rspBO.setRows(row);
        return rspBO;
    }

    /**
     * 校验
     * @param reqBO
     */
    private void purchaseQuotationAllocation(SscSchemeSPurchaseQuotationReqBO reqBO) {
        if(reqBO == null){
            throw new ZTBusinessException("入参不能为空");
        }
        if (StringUtils.isEmpty(reqBO.getQueryType())) {
            throw new ZTBusinessException("查询类型不能为空");
        }
        if (CollectionUtils.isEmpty(reqBO.getGoodTypeIds())) {
            throw new ZTBusinessException("明细id不能为空");
        }
    }

    /**
     * @param type              合同||订单
     * @param sscSchemeAmountBO 入参
     * @param update            更新数据类
     * @param sscSchemeMat      查询
     */
    private void setSscSchemeMatNumMapper(Integer type, SscSchemeAmountBO sscSchemeAmountBO, SscSchemeMatNum update, SscSchemeMatNum sscSchemeMat) {
        //合同还是订单
        if (type.equals(0)) {
            //操作类型增加还是减少
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                //新实体=查询数量+入参数量
                update.setContractAmount(NumberUtil.add(sscSchemeMat.getContractAmountY(), sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setContractAmount(NumberUtil.sub(sscSchemeMat.getContractAmountY(), sscSchemeAmountBO.getOrderNum()));
            }
        }
        //1订单数量扣减
        else if (type.equals(1)) {
            if (sscSchemeAmountBO.getOperateType().equals(1)) {
                update.setOrderAmount(NumberUtil.add(sscSchemeMat.getOrderAmountY(), sscSchemeAmountBO.getOrderNum()));
            } else if (sscSchemeAmountBO.getOperateType().equals(0)) {
                update.setOrderAmount(NumberUtil.sub(sscSchemeMat.getOrderAmountY(), sscSchemeAmountBO.getOrderNum()));
            }
        }
    }


    /**
     * 获取采购方案明细扩展数据
     */
    private void getSscSchemeMatExt(List<SscSchemeTenderReportListBO> TenderReportList) {
        if (!CollectionUtils.isEmpty(TenderReportList)) {
            //获取方案物料ID集合
            List<Long> schemeMatIds = TenderReportList.stream().map(SscSchemeTenderReportListBO::getSchemaItemId).filter(ObjectUtil::isNotEmpty).collect(Collectors.toList());

            //调用根据方案物料ID查询列表数据
            List<SscSchemeMatExtPackExtPO> sscSchemeMatExtPackExtPOList = new ArrayList<>(10);
            if (!CollectionUtils.isEmpty(schemeMatIds)) {
                sscSchemeMatExtPackExtPOList = this.sscSchemeMatExtPackExtMapper.getListBySchemeMatExtId(schemeMatIds);
            }

            if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOList)) {

                //获取采购方案明细扩展Map
                Map<Long, List<SscSchemeMatExtPackExtPO>> sscSchemeMatExtPackExtPOMap = sscSchemeMatExtPackExtPOList.stream().collect(Collectors.groupingBy(SscSchemeMatExtPackExtPO::getSchemeMatId));

                for (SscSchemeTenderReportListBO sscQryAwardResultExtBO : TenderReportList) {
                    if (!CollectionUtils.isEmpty(sscSchemeMatExtPackExtPOMap.get(sscQryAwardResultExtBO.getSchemaItemId()))) {

                        //获取当前方案物料扩展信息
                        List<SscSchemeMatExtPackExtPO> sscSchemeMatExtPackExtPOS = sscSchemeMatExtPackExtPOMap.get(sscQryAwardResultExtBO.getSchemaItemId());
                        //获取字段编码+字段值Map
                        Map<String, String> fieldMap = sscSchemeMatExtPackExtPOS.stream().filter(bo -> ObjectUtil.isNotEmpty(bo.getFieldCode())).collect(Collectors.toMap(SscSchemeMatExtPackExtPO::getFieldCode, SscSchemeMatExtPackExtPO::getFieldValue, (k1, k2) -> k2));

                        //设置质量技术说明
                        if (ObjectUtil.isNotEmpty(fieldMap.get("qualityRequire"))) {
                            sscQryAwardResultExtBO.setTechnicalNorms(fieldMap.get("qualityRequire"));
                        }
                    }
                }
            }
        }
    }

    /**
     * 号码/编号/数量/数字 数据处理
     */
    private void numberProcessingData(List<SscSchemeTenderReportListBO> sscQryAwardResultExtBOList) {
        if (!CollectionUtils.isEmpty(sscQryAwardResultExtBOList)) {
            for (SscSchemeTenderReportListBO bo : sscQryAwardResultExtBOList) {
                //处理税率 去除小数点后多余的0
                if (ObjectUtil.isNotEmpty(bo.getAwardItemTax())) {
                    BigDecimal awardItemTax = new BigDecimal(bo.getAwardItemTax());
                    //去除小数点后多余的0 并将数据转换成字符串类型
                    bo.setAwardItemTax(awardItemTax.stripTrailingZeros().toPlainString());
                }
            }
        }
    }
    /**
     * 转义结果明细出参数据
     */
    private void translateRspResultItemData(List<SscSchemeTenderItemReportBO> itemResultVoList){
        if (!CollectionUtils.isEmpty(itemResultVoList)){
            //遍历
            for (SscSchemeTenderItemReportBO bo : itemResultVoList) {
                //判断采购方式不为空
                if (ObjectUtil.isNotEmpty(bo.getDycBuyType())){
                    switch (bo.getDycBuyType()){
                        case 0:
                            bo.setDycBuyType(1); //公开招标
                            break;
                        case 1:
                            bo.setDycBuyType(2); //邀请招标
                            break;
                        case 7:
                            bo.setDycBuyType(3); //公开询比
                            break;
                        case 8:
                            bo.setDycBuyType(4); //邀请询比
                            break;
                        case 13:
                            bo.setDycBuyType(5); //公开竞价
                            break;
                        case 14:
                            bo.setDycBuyType(6); //邀请竞价
                            break;
                        case 11:
                            bo.setDycBuyType(7); //公开竞谈
                            break;
                        case 12:
                            bo.setDycBuyType(8); //邀请竞谈
                            break;
                        case 6:
                            bo.setDycBuyType(9); //单一来源
                            break;
                        case 9:
                            bo.setDycBuyType(10); //直接采购
                            break;
                        case 10:
                            bo.setDycBuyType(11); //直接采购(执行协议)
                            break;
                    }
                }
            }
        }
    }
    /**
     * 获取中标时间
     * @param reqBO
     * @param sscQryAwardResultExtBOList
     */
    private void getBidTime(SchemeTenderReportReqBO reqBO, List<SscSchemeTenderReportListBO> sscQryAwardResultExtBOList){
        if (reqBO.getIsQryBidTime()!=null && reqBO.getIsQryBidTime()==1 && !CollectionUtils.isEmpty(sscQryAwardResultExtBOList)){
            /**
             * ①若会发中标通知书，则以中标通知书的审批通过时间，或外部系统接口回传时间，或无需审批时的提交时间进行回传
             * ②若不发中标通知书，以中标审批时间回传
             */
            Set<Long> supTabIdList = sscQryAwardResultExtBOList.stream().filter(e -> e.getSupTabId() != null).map(SscSchemeTenderReportListBO::getSupTabId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(supTabIdList)){
                Map<Long, List<CrcSchemeFindsourceSupNoticePO>> supIdMap = new HashMap<>();
                Map<Long, List<CrcNoticePO>> supTabIdMap = new HashMap<>();

                if (reqBO.getQueryType() == 1){
                    //调用根据条件分页查询 集中采购 询比结果列表数据
                    CrcSchemeFindsourceSupNoticePO searchPO = new CrcSchemeFindsourceSupNoticePO();
                    searchPO.setSupTableIdList(new ArrayList<>(supTabIdList));
                    List<CrcSchemeFindsourceSupNoticePO> supNoticePOS = crcSchemeFindsourceSupNoticeMapper.getList(searchPO);
                    if (!CollectionUtils.isEmpty(supNoticePOS)){
                        supIdMap = supNoticePOS.stream().collect(Collectors.groupingBy(CrcSchemeFindsourceSupNoticePO::getSupId));
                    }
                }
                if (reqBO.getQueryType() == 2 || reqBO.getQueryType() == 3){
                    //调用根据条件分页查询 委托采购 和自行采购
                    CrcNoticePO searchPO = new CrcNoticePO();
                    searchPO.setObjIds(new ArrayList<>(supTabIdList));
                    List<CrcNoticePO> noticePOS = crcNoticeMapper.getList(searchPO);
                    if (!CollectionUtils.isEmpty(noticePOS)){
                        supTabIdMap = noticePOS.stream().collect(Collectors.groupingBy(CrcNoticePO::getSupTableId));
                    }
                }
                SimpleDateFormat dateFormat = new SimpleDateFormat( "yyyy-MM-dd HH:mm:ss");
                for (SscSchemeTenderReportListBO sscQryAwardResultExtBO : sscQryAwardResultExtBOList) {
                    if (reqBO.getQueryType() == 1){
                        if (supIdMap.containsKey(sscQryAwardResultExtBO.getSupTabId())){
                            String ext1 = supIdMap.get(sscQryAwardResultExtBO.getSupTabId()).get(0).getExt1();
                            if (!StringUtils.isEmpty(ext1)){
                                try {
                                    Date noticeTime = dateFormat.parse(ext1);
                                    sscQryAwardResultExtBO.setBidTime(noticeTime);
                                }catch (Exception e){
                                    sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                                }
                            }else {
                                sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                            }
                        }else {
                            sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                        }
                    }
                    if (reqBO.getQueryType() == 2 || reqBO.getQueryType() == 3){
                        if (supTabIdMap.containsKey(sscQryAwardResultExtBO.getSupTabId())){
                            CrcNoticePO crcNoticePO = supTabIdMap.get(sscQryAwardResultExtBO.getSupTabId()).get(0);
                            if (crcNoticePO.getAuditTime()!=null){
                                sscQryAwardResultExtBO.setBidTime(crcNoticePO.getAuditTime());
                            }else if (!StringUtils.isEmpty(crcNoticePO.getExt4())){
                                String ext4 = crcNoticePO.getExt4();
                                try {
                                    Date noticeTime = dateFormat.parse(ext4);
                                    sscQryAwardResultExtBO.setBidTime(noticeTime);
                                }catch (Exception e){
                                    sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                                }
                            }else {
                                sscQryAwardResultExtBO.setBidTime(crcNoticePO.getCreatTime());
                            }
                        }else {
                            sscQryAwardResultExtBO.setBidTime(sscQryAwardResultExtBO.getAuditTime());
                        }
                    }
                }
            }
        }
    }
}


