package com.tydic.dyc.ssc.repositoryExt.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.repository.SscAddApproveNoticeLogExtRepository;
import com.tydic.dyc.ssc.repositoryExt.dao.UocApproveNoticeLogMapper;
import com.tydic.dyc.ssc.repositoryExt.po.UocApproveNoticeLogPO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddApproveNoticeLogExtBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddApproveNoticeLogExtReqBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscAddApproveNoticeLogExtRspBO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述:记录审批抄送人记录
 *
 * @author XiaWD
 * @date 2024/11/25 下午2:59
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Service
public class SscAddApproveNoticeLogExtRepositoryImpl implements SscAddApproveNoticeLogExtRepository {
    @Autowired
    private UocApproveNoticeLogMapper uocApproveNoticeLogMapper;
    /**
     * 雪花序列
     */
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Override
    public SscAddApproveNoticeLogExtRspBO addApproveNoticeLog(SscAddApproveNoticeLogExtReqBO reqBO) {
        if (!StringUtils.isEmpty(reqBO.getTaskId()) && !CollectionUtils.isEmpty(reqBO.getNoticeUserInfo())){
            List<UocApproveNoticeLogPO> addList = new ArrayList<>();
            Date nowDate = new Date();
            for (SscAddApproveNoticeLogExtBO noticeUser : reqBO.getNoticeUserInfo()) {
                UocApproveNoticeLogPO logPO = new UocApproveNoticeLogPO();
                logPO.setLogId(uccBatchSequence.nextId());
                logPO.setTaskId(reqBO.getTaskId());
                logPO.setNoticeUserId(noticeUser.getNoticeUserId());
                logPO.setNoticeUserCode(noticeUser.getNoticeUserCode());
                logPO.setNoticeUserName(noticeUser.getNoticeUserName());
                logPO.setIsDelete(0);
                logPO.setCreateTime(nowDate);
                logPO.setCreateUserId(reqBO.getUserId());
                logPO.setCreateUserCode(reqBO.getUsername());
                logPO.setCreateUserName(reqBO.getName());
                addList.add(logPO);
            }
            uocApproveNoticeLogMapper.insertBatch(addList);
        }
        SscAddApproveNoticeLogExtRspBO rspBO = new SscAddApproveNoticeLogExtRspBO();
        rspBO.setRespCode(SscRspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(SscRspConstant.RSP_DESC_SUCCESS);
        return rspBO;
    }
}
