package com.tydic.dyc.ssc.repositoryExt.impl;

import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscPlanPackMapper;
import com.tydic.dyc.ssc.service.scheme.SscAllSyncSchemeExtService;
import com.tydic.dyc.ssc.service.scheme.SscOneSyncSchemeExtService;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 描述:全量同步方案ES数据（用于索引删除之后的重新同步数据）
 *
 * @author XiaWD
 * @date 2025/2/13 下午2:13
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Slf4j
@HTServiceImpl
public class SscAllSyncSchemeExtServiceImpl implements SscAllSyncSchemeExtService {
    @HTServiceRef
    private SscOneSyncSchemeExtService sscOneSyncSchemeExtService;
    @Autowired
    private SscPlanPackMapper sscPlanPackMapper;
    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @HTServiceRef
    private SscQrySchemePackExtServie schemePackExtServie;
    @Override
    public SscAllSyncSchemeExtRspBO syncSchemeList(SscAllSyncSchemeExtReqBO reqBO) {
        log.info("同步开始：");
        Integer size = 0;
        if (!CollectionUtils.isEmpty(reqBO.getSchemeIds())){
            for (Long schemeId : reqBO.getSchemeIds()) {
                size++;
                sync(schemeId);
            }
        }else {
            Integer index = 0;
            Integer pageSize = 100;
            List<Long> schemeIds = new ArrayList<>();
            do {
                Integer curPageNo = index*pageSize;
                Integer curPageSize = (index+1)*pageSize;
                schemeIds = sscPlanPackMapper.getSchemeIds(curPageNo, curPageSize);
                if (CollectionUtils.isEmpty(schemeIds)){
                    break;
                }
                for (Long schemeId : schemeIds) {
                    size++;
                    sync(schemeId);
                }
                index++;
            }while (!CollectionUtils.isEmpty(schemeIds));
        }
        log.info("同步结束，执行了"+size);
        SscAllSyncSchemeExtRspBO rspBO = new SscAllSyncSchemeExtRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }
    private void sync(Long schemeId){
        SscOneSyncSchemeExtReqBO sscOneSyncSchemeExtReqBO = new SscOneSyncSchemeExtReqBO();
        sscOneSyncSchemeExtReqBO.setSchemeId(schemeId);
        sscOneSyncSchemeExtService.syncSchemeOne(sscOneSyncSchemeExtReqBO);

        Long objId = sscPlanPackMapper.queryNewObjId(schemeId);
        if (null != objId){
            SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
            sscQrySchemePackExtReqBO.setOrderId(schemeId);
            sscQrySchemePackExtReqBO.setObjId(objId);
            schemePackExtServie.syncTaskBySchemeId(sscQrySchemePackExtReqBO);
        }
    }
}
