package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.ssc.repositoryExt.dao.SaasSchemePackMapper;
import com.tydic.dyc.ssc.repositoryExt.dao.SscSchemeInviteSupPackExtMapper;
import com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO;
import com.tydic.dyc.ssc.repositoryExt.po.UocOrderTaskInstBO;
import com.tydic.dyc.ssc.service.scheme.SscSchemeOperateService;
import com.tydic.dyc.ssc.service.scheme.bo.SchemeListRspBO;
import com.tydic.dyc.ssc.service.scheme.bo.SscQrySchemePackExtReqBO;
import lombok.extern.ohaotian.HTServiceImpl;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @Author jmrg
 * @dATE 2025/3/7
 * @Desc
 */
@Slf4j
@HTServiceImpl
public class SscSchemeOperateServiceImpl implements SscSchemeOperateService {

    @Autowired
    private SaasSchemePackMapper schemePackMapper;
    @Autowired
    private SscSchemeInviteSupPackExtMapper sscSchemeInviteSupPackExtMapper;

    @Override
    public SchemeListRspBO saveSubmitTime(SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if(Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())){
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("入参为空");
            return rspBO;
        }
        com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO schemePO = new com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO();
        schemePO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemePO> schemePOList = schemePackMapper.getModelBy(schemePO);

        if(CollectionUtils.isEmpty(schemePOList) || Objects.nonNull(schemePOList.get(0).getSubmitTime())){
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("已记录提交时间 不予处理");
            return rspBO;
        }
        schemePackMapper.updateSubmit(reqBO.getSchemeId(),new Date());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("成功");
        return rspBO;
    }

    @Override
    public SchemeListRspBO saveAuditTime(SscQrySchemePackExtReqBO reqBO) {
        SchemeListRspBO rspBO = new SchemeListRspBO();
        if(Objects.isNull(reqBO) || Objects.isNull(reqBO.getSchemeId())){
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("入参为空");
            return rspBO;
        }
        com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO schemePO = new com.tydic.dyc.ssc.repositoryExt.po.SscSchemePO();
        schemePO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemePO> schemePOList = schemePackMapper.getModelBy(schemePO);
        if(CollectionUtils.isEmpty(schemePOList)){
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("未查询到单据");
            return rspBO;
        }
        UocOrderTaskInstBO finishTime = schemePackMapper.getFinishTime(reqBO.getSchemeId());
        if(Objects.isNull(finishTime) || Objects.isNull(finishTime.getFinishTime())){
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("查询最新结束时间失败");
            return rspBO;
        }
        schemePackMapper.updateAuditTime(reqBO.getSchemeId(), finishTime.getFinishTime());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("成功");
        return rspBO;
    }

    @Override
    public SchemeListRspBO qrySupExt(SscQrySchemePackExtReqBO reqBO) {
        log.info("qrySupExt param:{}", JSON.toJSONString(reqBO));
        List<String> supExtList = sscSchemeInviteSupPackExtMapper.getListByFieldCode(reqBO.getSchemeId(), reqBO.getFiledCode());
        log.info("supExtList result:{}", JSON.toJSONString(supExtList));
        if(CollectionUtils.isEmpty(supExtList) || 0 == supExtList.size()){
            return new SchemeListRspBO();
        }
        SchemeListRspBO rspBO = new SchemeListRspBO();
        rspBO.setSupExtList(supExtList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("成功");
        return rspBO;
    }
}
