package com.tydic.dyc.ssc.repositoryExt.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.ssc.constant.SscCommConstant;
import com.tydic.dyc.ssc.constant.SscRspConstant;
import com.tydic.dyc.ssc.repository.SscSmartApproveRelationRepository;
import com.tydic.dyc.ssc.repository.po.SscSchemeMatPO;
import com.tydic.dyc.ssc.repositoryExt.comb.api.SscPushChangeSmartApproveService;
import com.tydic.dyc.ssc.repositoryExt.comb.bo.*;
import com.tydic.dyc.ssc.repositoryExt.constant.RelationStatusEnum;
import com.tydic.dyc.ssc.repositoryExt.dao.*;
import com.tydic.dyc.ssc.repositoryExt.po.*;
import com.tydic.dyc.ssc.service.scheme.SscQrySchemePackExtServie;
import com.tydic.dyc.ssc.service.scheme.bo.*;
import com.tydic.dyc.ssc.service.scheme.constant.RspConstant;
import lombok.extern.ohaotian.HTServiceRef;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 智慧评审与采购方案关联
 *
 * @author hsw
 * @since 2024-8-16 11:19:58
 */
@Slf4j
@Service
public class SscSmartApproveRelationRepositoryImpl implements SscSmartApproveRelationRepository {

    @Resource
    private PlatFormSscSchemeMapper platFormSscSchemeMapper;
    @Resource
    private PlatFormSscSchemePackMapper platFormSscSchemePackMapper;
    @Resource
    private CrcEntrustMapper crcEntrustMapper;
    @Resource
    private SysDicDictionaryMapper sysDicDictionaryMapper;
    @Resource
    private SscPushChangeLogMapper sscPushChangeLogMapper;
    @Resource
    private SscSchemeMatExtPackExtMapper sscSchemeMatExtPackExtMapper;
    @Resource
    private SscSchemeMatNumMapper sscSchemeMatNumMapper;
    @Resource
    private SscSchemeInviteSupExtDealMapper sscSchemeInviteSupExtDealMapper;
    @Autowired
    private SscPushChangeSmartApproveService sscPushChangeSmartApproveService;
    @HTServiceRef
    private SscQrySchemePackExtServie sscQrySchemePackExtServie;

    /**
     * 智慧评审-简易采购计划关联
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApproveRelationRspBO dealRelationSimpleScheme(SscSmartApproveRelationReqBO reqBO) {
        // 校验简易采购计划是否存在
        List<Long> schemeIdList = reqBO.getData().stream().map(SscSmartApproveRelationReqParamBO::getSchemeId).distinct().collect(Collectors.toList());
        SscSchemePO schemePO = new SscSchemePO();
        schemePO.setSchemeIds(schemeIdList);
        schemePO.setSchemeType(SscCommConstant.SchemeTypeEnum.SIMPLE.getCode());
        List<SscSchemePO> sscSchemePOList = platFormSscSchemeMapper.getList(schemePO);
        if (CollectionUtils.isEmpty(sscSchemePOList) || sscSchemePOList.size() != schemeIdList.size()) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案ID存在未匹配到的简易采购计划！");
        }
        List<SscSchemePO> updateSchemePOList = new ArrayList<>();
        Map<Long,SscSmartApproveRelationReqParamBO> relationReqParamBOMap = reqBO.getData().stream()
                .collect(Collectors.toMap(SscSmartApproveRelationReqParamBO::getSchemeId, Function.identity(), (k1, k2) -> k1));
        // 关联简易采购计划
        if (RelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
            // 判断简易采购计划是否重复关联
            sscSchemePOList.forEach( e -> {
                if (StringUtils.isNotBlank(e.getFileId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案ID:" + e.getSchemeId() + "已经关联" + e.getFileId());
                }
                SscSchemePO updateSchemePO = new SscSchemePO();
                updateSchemePO.setSchemeId(e.getSchemeId());
                updateSchemePO.setRelationStatus(reqBO.getType());
                if (!CollectionUtils.isEmpty(relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getSchemeId())) {
                    updateSchemePO.setFileId(relationReqParamBOMap.get(e.getSchemeId()).getFileId());
                    updateSchemePO.setFileItemId(relationReqParamBOMap.get(e.getSchemeId()).getFileItemId());
                }
                updateSchemePOList.add(updateSchemePO);
            });
        } else {
            // 解除关联
            // 判断简易采购计划是否未关联
            sscSchemePOList.forEach( e -> {
                if (Objects.isNull(e.getFileId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案ID:" + e.getSchemeId() + "尚未关联" );
                }
                SscSchemePO updateSchemePO = new SscSchemePO();
                updateSchemePO.setSchemeId(e.getSchemeId());
                updateSchemePO.setRelationStatus(reqBO.getType());
                updateSchemePO.setFileId(null);
                updateSchemePO.setFileItemId(null);
                updateSchemePOList.add(updateSchemePO);
            });
        }
        // 更新关联关系
        if (!CollectionUtils.isEmpty(updateSchemePOList)) {
            platFormSscSchemeMapper.updateRelationStatus(updateSchemePOList);
        }
        // 同步ES
        SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
        List<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<>();
        schemeIdList.forEach( e -> {
            SscQrySchemePackExtBO packExtBO = new SscQrySchemePackExtBO();
            packExtBO.setSchemeId(e);
            sscSchemePack.add(packExtBO);
        });
        sscQrySchemePackExtReqBO.setSscSchemePack(sscSchemePack);
        sscQrySchemePackExtServie.syncSchemeESBySchemeIds(sscQrySchemePackExtReqBO);

        // 关联/解除关联对应的委托书
        Map<Long, List<CrcEntrustPO>> entrustMap = relationSchemeEntrust(schemeIdList, reqBO.getType(), relationReqParamBOMap);
        List<SscSmartApproveRelationRspParamBO> paramList = new ArrayList<>();
        SscSmartApproveRelationRspBO rspBO = new SscSmartApproveRelationRspBO();
        sscSchemePOList.forEach( e -> {
            SscSmartApproveRelationRspParamBO paramBO = new SscSmartApproveRelationRspParamBO();
            paramBO.setSchemeId(e.getSchemeId());
            paramBO.setSchemeCode(e.getSchemeCode());
            paramBO.setSchemeName(e.getSchemeName());
            paramBO.setSchemeNo(e.getSchemeNo());
            if (!CollectionUtils.isEmpty(entrustMap) && entrustMap.containsKey(e.getSchemeId())) {
                paramBO.setEntrustId(entrustMap.get(e.getSchemeId()).get(0).getEntrustId());
                paramBO.setEntrustCode(entrustMap.get(e.getSchemeId()).get(0).getEntrustCode());
                paramBO.setEntrustName(entrustMap.get(e.getSchemeId()).get(0).getEntrustName());
                paramBO.setEntrustNo(entrustMap.get(e.getSchemeId()).get(0).getEntrustNo());
            }
            paramList.add(paramBO);
        });


        rspBO.setRows(paramList);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 智慧评审-方案包关联
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApproveRelationRspBO dealRelationPack(SscSmartApproveRelationReqBO reqBO) {
        // 校验采购方案包是否存在
        List<Long> packIdList = reqBO.getData().stream().map(SscSmartApproveRelationReqParamBO::getPackId).distinct().collect(Collectors.toList());
        SscSchemePackReqPO packPO = new SscSchemePackReqPO();
        packPO.setPackIds(packIdList);
        List<SscSchemePackReqPO> packExtPOList = platFormSscSchemePackMapper.getList(packPO);
        if (CollectionUtils.isEmpty(packExtPOList) || packExtPOList.size() != packIdList.size()) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案包ID存在未匹配到的采购方案包！");
        }
        List<SscSchemePackReqPO> updatePackExtPOList = new ArrayList<>();
        Map<Long,SscSmartApproveRelationReqParamBO> relationReqParamBOMap = reqBO.getData().stream()
                .collect(Collectors.toMap(SscSmartApproveRelationReqParamBO::getPackId, Function.identity(), (k1, k2) -> k1));
        // 关联采购方案包
        if (RelationStatusEnum.RELATION.getCode().equals(reqBO.getType())) {
            // 判断采购方案包是否重复关联
            packExtPOList.forEach( e -> {
                if (StringUtils.isNotBlank(e.getFileId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案包ID:" + e.getPackId() + "已经关联" + e.getFileId());
                }
                SscSchemePackReqPO updateSchemePackPO = new SscSchemePackReqPO();
                updateSchemePackPO.setPackId(e.getPackId());
                updateSchemePackPO.setRelationStatus(reqBO.getType());
                if (!CollectionUtils.isEmpty(relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getPackId())) {
                    updateSchemePackPO.setFileId(relationReqParamBOMap.get(e.getPackId()).getFileId());
                    updateSchemePackPO.setFileItemId(relationReqParamBOMap.get(e.getPackId()).getFileItemId());
                }
                updatePackExtPOList.add(updateSchemePackPO);
            });
        } else {
            // 解除关联
            // 判断简采购方案包否未关联
            packExtPOList.forEach( e -> {
                if (Objects.isNull(e.getFileId())) {
                    throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "入参方案包ID:" + e.getPackId() + "尚未关联" );
                }
                SscSchemePackReqPO updateSchemePackPO = new SscSchemePackReqPO();
                updateSchemePackPO.setPackId(e.getPackId());
                updateSchemePackPO.setRelationStatus(reqBO.getType());
                updateSchemePackPO.setFileId(null);
                updateSchemePackPO.setFileItemId(null);
                updatePackExtPOList.add(updateSchemePackPO);
            });
        }
        // 更新关联关系
        if (!CollectionUtils.isEmpty(updatePackExtPOList)) {
            platFormSscSchemePackMapper.updateRelationStatus(updatePackExtPOList);
        }
        // 同步方案包es
        List<SscQrySchemePackExtBO> sscSchemePack = new ArrayList<>();
        packIdList.forEach( e -> {
            SscQrySchemePackExtBO packExtBO = new SscQrySchemePackExtBO();
            packExtBO.setPackId(e);
            sscSchemePack.add(packExtBO);
        });
        SscQrySchemePackExtReqBO sscQrySchemePackExtReqBO = new SscQrySchemePackExtReqBO();
        sscQrySchemePackExtReqBO.setSscSchemePack(sscSchemePack);
        sscQrySchemePackExtServie.syncSchemePackES(sscQrySchemePackExtReqBO);

        // 关联/解除关联对应的委托书
        Map<Long, List<CrcEntrustPO>> entrustMap = relationPackEntrust(packIdList, reqBO.getType(), relationReqParamBOMap);

        SscSmartApproveRelationRspBO rspBO = new SscSmartApproveRelationRspBO();
        List<SscSmartApproveRelationRspParamBO> paramList = new ArrayList<>();
        packExtPOList.forEach( e -> {
            SscSmartApproveRelationRspParamBO paramBO = new SscSmartApproveRelationRspParamBO();
            paramBO.setPackId(e.getPackId());
            paramBO.setPackCode(e.getPackCode());
            paramBO.setPackName(e.getPackName());
            paramBO.setPackNo(e.getPackNo());
            if (!CollectionUtils.isEmpty(entrustMap) && entrustMap.containsKey(e.getPackId())) {
                paramBO.setEntrustId(entrustMap.get(e.getPackId()).get(0).getEntrustId());
                paramBO.setEntrustCode(entrustMap.get(e.getPackId()).get(0).getEntrustCode());
                paramBO.setEntrustName(entrustMap.get(e.getPackId()).get(0).getEntrustName());
                paramBO.setEntrustNo(entrustMap.get(e.getPackId()).get(0).getEntrustNo());
            }
            paramList.add(paramBO);
        });


        rspBO.setRows(paramList);
        rspBO.setRespDesc(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        return rspBO;
    }

    /**
     * 变更审批通过后推送变动信息给智能评审
     *
     * @param reqBO
     * @return
     */
    @Override
    public SscSmartApprovePushChangeInfoRspBO dealPushChangeInfo(SscSmartApprovePushChangeInfoReqBO reqBO) {
        SscSmartApprovePushChangeInfoRspBO rspBO = new SscSmartApprovePushChangeInfoRspBO();
        rspBO.setRespCode(RspConstant.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(RspConstant.RESP_DESC_SUCCESS);
        // 查询单据信息 简易采购计划校验是否关联智能评审文件， 采购方案/集采方案校验方案包是否关联评审文件
        SscSchemePO sscSchemePO = new SscSchemePO();
        sscSchemePO.setSchemeId(reqBO.getSchemeId());
        SscSchemePO schemePO = platFormSscSchemeMapper.getBySchemeId(sscSchemePO);
        if (Objects.isNull(schemePO)) {
            throw new BaseBusinessException(SscRspConstant.RSP_CODE_FUNCTION_EMPTY_ERROR, "未查询到方案信息！");
        }
        // 简易采购计划
        if (SscCommConstant.SchemeTypeEnum.SIMPLE.getCode().equals(schemePO.getSchemeType())) {
            pushSimple(reqBO, schemePO);
        } else {
            pushPack(reqBO, schemePO);
        }
        return rspBO;
    }

    /**
     * 推送简易采购计划信息
     *
     * @param reqBO
     * @param schemePO
     */
    private void pushSimple (SscSmartApprovePushChangeInfoReqBO reqBO, SscSchemePO schemePO) {
        SscPushChangeSmartApproveReqBO sscPushChangeSmartApproveReqBO = new SscPushChangeSmartApproveReqBO();
        SscPushChangeSmartApproveReqParam sscPushChangeSmartApproveReqParam = new SscPushChangeSmartApproveReqParam();
        // 未关联文件的简易采购计划无需推送
        if (!RelationStatusEnum.RELATION.getCode().equals(schemePO.getRelationStatus())) {
            return ;
        }

        SimpleInfoBO simpleInfoBO = new SimpleInfoBO();
        BeanUtils.copyProperties(schemePO, simpleInfoBO);
        simpleInfoBO.setPurchaseTypeStr(Objects.isNull(schemePO.getPurchaseType()) ? null : translateDic("PURCH_WAY", String.valueOf(schemePO.getPurchaseType())));
        simpleInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
        simpleInfoBO.setSchemeAuditStatusStr(translateDic("APPROVAL_TYPE", schemePO.getSchemeAuditStatus()));
        simpleInfoBO.setSchemeStatusStr(translateDic("SCHEME_STATUS", schemePO.getSchemeStatus()));
        simpleInfoBO.setCreateTimeStr(DateUtils.dateToStr(schemePO.getCreateTime(), "yyyy-MM-dd HH:mm:ss"));
        SscSchemeMatPO schemeMatPO = new SscSchemeMatPO();
        schemeMatPO.setSchemeId(reqBO.getSchemeId());
        List<SscSchemeMatPO> schemeMatPOList = sscSchemeMatExtPackExtMapper.getSchemeMatList(schemeMatPO);
        if (!CollectionUtils.isEmpty(schemeMatPOList)) {
            simpleInfoBO.setItemInfo(JSON.parseArray(JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
        }
        sscPushChangeSmartApproveReqParam.setSimpleInfo(simpleInfoBO);

        // 判断是否做过委托书
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setSchemeId(reqBO.getSchemeId());
        List<CrcEntrustPO> crcEntrustPOList = crcEntrustMapper.queryList(crcEntrustPO);
        // 做过委托书，委托书未关联，自动关联
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            CrcEntrustPO entrustPO = crcEntrustPOList.get(0);
            if (!RelationStatusEnum.RELATION.getCode().equals(entrustPO.getRelationStatus())) {
                // 关联委托书
                crcEntrustPOList.forEach( e -> {
                    e.setRelationStatus(RelationStatusEnum.RELATION.getCode());
                    e.setFileId(schemePO.getFileId());
                    e.setFileItemId(schemePO.getFileItemId());
                });
                crcEntrustMapper.updateRelationStatus(crcEntrustPOList);
            }
            AttorneyLetterInfoBO attorneyLetterInfoBO = new AttorneyLetterInfoBO();
            BeanUtils.copyProperties(entrustPO, attorneyLetterInfoBO);
            attorneyLetterInfoBO.setEstAmount(entrustPO.getYsje());
            attorneyLetterInfoBO.setPurTypeStr(translateDic("PURCH_WAY", entrustPO.getPurType()));
            attorneyLetterInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
            if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                attorneyLetterInfoBO.setItemInfo(JSON.parseArray(JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
            }
            sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(attorneyLetterInfoBO);
        } else {
            sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(new AttorneyLetterInfoBO());
        }
        sscPushChangeSmartApproveReqParam.setPurchaseProgrammeInfos(new PurchaseProgrammeInfoBO());
        sscPushChangeSmartApproveReqBO.setFileId(schemePO.getFileId());
        sscPushChangeSmartApproveReqBO.setData(Collections.singletonList(sscPushChangeSmartApproveReqParam));
        // 推送智能评审平台
        SscPushChangeSmartApproveRspBO sscPushChangeSmartApproveRspBO = sscPushChangeSmartApproveService.pushChange(sscPushChangeSmartApproveReqBO);
        int pushStatus = 0;
        String rspData = "";
        if (Objects.nonNull(sscPushChangeSmartApproveRspBO)) {
            if (RspConstant.RESP_CODE_SUCCESS.equals(sscPushChangeSmartApproveRspBO.getRespCode())) {
                pushStatus = 1;
            }
            rspData = sscPushChangeSmartApproveRspBO.getRespData();
        }
        // 记录推送日志
        insertLog(reqBO.getSchemeId(), 2, pushStatus, JSON.toJSONString(sscPushChangeSmartApproveReqBO), rspData);
    }

    /**
     * 推送方案包信息
     *
     * @param reqBO
     * @param schemePO
     */
    private void pushPack (SscSmartApprovePushChangeInfoReqBO reqBO, SscSchemePO schemePO) {
        // 查询对应的采购方案包
        SscSchemePackReqPO sscSchemePackReqPO = new SscSchemePackReqPO();
        sscSchemePackReqPO.setSchemeId(reqBO.getSchemeId());
        sscSchemePackReqPO.setPackId(reqBO.getPackId());
        List<SscSchemePackReqPO> packPOList = platFormSscSchemePackMapper.getList(sscSchemePackReqPO);
        // 未查到采购方案包数据直接返回
        if (CollectionUtils.isEmpty(packPOList)) {
            return ;
        }
        List<SscPushChangeSmartApproveReqParam> paramList = new ArrayList<>();
        packPOList.forEach( e -> {
            if (!RelationStatusEnum.RELATION.getCode().equals(e.getRelationStatus())) {
                return;
            }
            // 物资项数
            int matNum = sscSchemeMatNumMapper.getMatNum(e.getPackId());
            // 供应商项数
            int supNum = sscSchemeInviteSupExtDealMapper.getSupNum(e.getPackId());
            // 获取物资明细集合
            SscSchemeMatPO schemeMatPO = new SscSchemeMatPO();
            schemeMatPO.setSchemeId(reqBO.getSchemeId());
            List<SscSchemeMatPO> schemeMatPOList = sscSchemeMatExtPackExtMapper.getSchemeMatList(schemeMatPO);

            SscPushChangeSmartApproveReqParam sscPushChangeSmartApproveReqParam = new SscPushChangeSmartApproveReqParam();
            PurchaseProgrammeInfoBO purchaseProgrammeInfoBO = new PurchaseProgrammeInfoBO();
            BeanUtils.copyProperties(e, purchaseProgrammeInfoBO);
            purchaseProgrammeInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
            purchaseProgrammeInfoBO.setPurTypeStr(Objects.isNull(schemePO.getPurchaseType()) ? null : translateDic("PURCH_WAY", String.valueOf(schemePO.getPurchaseType())));
            purchaseProgrammeInfoBO.setSchemeCode(schemePO.getSchemeCode());
            purchaseProgrammeInfoBO.setSchemeName(schemePO.getSchemeName());
            purchaseProgrammeInfoBO.setSchemeNo(schemePO.getSchemeNo());
            purchaseProgrammeInfoBO.setMatNum(matNum);
            purchaseProgrammeInfoBO.setSupNum(supNum);
            purchaseProgrammeInfoBO.setEstAmount(schemePO.getEstAmount());
            purchaseProgrammeInfoBO.setCreateUsername(schemePO.getCreateUsername());
            purchaseProgrammeInfoBO.setCreateName(schemePO.getCreateName());
            purchaseProgrammeInfoBO.setCreateTime(schemePO.getCreateTime());
            purchaseProgrammeInfoBO.setSchemeVersion(schemePO.getSchemeVersion());
            if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                purchaseProgrammeInfoBO.setItemInfo(JSON.parseArray(JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
            }
            sscPushChangeSmartApproveReqParam.setPurchaseProgrammeInfos(purchaseProgrammeInfoBO);

            // 获取对应的委托书信息
            CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
            crcEntrustPO.setPackId(e.getPackId());
            List<CrcEntrustPO> crcEntrustPOList = crcEntrustMapper.queryList(crcEntrustPO);
            if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
                CrcEntrustPO entrustPO = crcEntrustPOList.get(0);
                // 如果委托书未关联，自动关联委托书
                if (!RelationStatusEnum.RELATION.getCode().equals(entrustPO.getRelationStatus())) {
                    // 关联委托书
                    crcEntrustPOList.forEach( entrust -> {
                        entrust.setRelationStatus(RelationStatusEnum.RELATION.getCode());
                        entrust.setFileId(e.getFileId());
                        entrust.setFileItemId(e.getFileItemId());
                    });
                    crcEntrustMapper.updateRelationStatus(crcEntrustPOList);
                }
                AttorneyLetterInfoBO attorneyLetterInfoBO = new AttorneyLetterInfoBO();
                BeanUtils.copyProperties(entrustPO, attorneyLetterInfoBO);
                attorneyLetterInfoBO.setPurTypeStr(translateDic("PURCH_WAY", entrustPO.getPurType()));
                attorneyLetterInfoBO.setSchemeClassStr(Objects.isNull(schemePO.getSchemeClass()) ? null : translateDic("SCHEME_CLASS", String.valueOf(schemePO.getSchemeClass())));
                if (!CollectionUtils.isEmpty(schemeMatPOList)) {
                    attorneyLetterInfoBO.setItemInfo(JSON.parseArray(JSON.toJSONString(schemeMatPOList), SscSchemeMatExtBO.class));
                }
                sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(attorneyLetterInfoBO);
            } else {
                sscPushChangeSmartApproveReqParam.setAttorneyLetterInfo(new AttorneyLetterInfoBO());
            }
            sscPushChangeSmartApproveReqParam.setSimpleInfo(new SimpleInfoBO());
            paramList.add(sscPushChangeSmartApproveReqParam);
        });
        if (!CollectionUtils.isEmpty(paramList)) {
            SscPushChangeSmartApproveReqBO sscPushChangeSmartApproveReqBO = new SscPushChangeSmartApproveReqBO();
            sscPushChangeSmartApproveReqBO.setFileId(paramList.get(0).getPurchaseProgrammeInfos().getFileId());
            sscPushChangeSmartApproveReqBO.setData(paramList);
            // 推送智能评审平台
            SscPushChangeSmartApproveRspBO sscPushChangeSmartApproveRspBO = sscPushChangeSmartApproveService.pushChange(sscPushChangeSmartApproveReqBO);
            int pushStatus = 0;
            String rspData = "";
            if (Objects.nonNull(sscPushChangeSmartApproveRspBO)) {
                if (RspConstant.RESP_CODE_SUCCESS.equals(sscPushChangeSmartApproveRspBO.getRespCode())) {
                    pushStatus = 1;
                }
                rspData = sscPushChangeSmartApproveRspBO.getRespData();
            }
            // 记录推送日志
            insertLog(reqBO.getSchemeId(), 1, pushStatus, JSON.toJSONString(sscPushChangeSmartApproveReqBO), rspData);
        }
    }
    /**
     * 记录推送智能评审日志
     *
     * @param schemeId
     * @param type
     * @param pushStatus
     * @param pushDate
     * @param respData
     */
    private void insertLog(Long schemeId, int type, int pushStatus, String pushDate, String respData){
        SscPushChangeLogPO sscPushChangeLogPO = new SscPushChangeLogPO();
        sscPushChangeLogPO.setId(Sequence.getInstance().nextId());
        sscPushChangeLogPO.setSchemeId(schemeId);
        sscPushChangeLogPO.setType(type);
        sscPushChangeLogPO.setPushStatus(pushStatus);
        sscPushChangeLogPO.setPushData(pushDate);
        sscPushChangeLogPO.setRespData(respData);
        sscPushChangeLogPO.setPushTime(new Date());
        sscPushChangeLogMapper.insert(sscPushChangeLogPO);
    }


    /**
     * 字典值翻译
     *
     * @param pCode
     * @param str
     * @return
     */
    private String translateDic (String pCode, String str) {
        if (StringUtils.isBlank(str)) {
            return null;
        }
        String descrip = "";
        SysDicDictionaryPO pi = new SysDicDictionaryPO();
        pi.setPCode(pCode);
        List<SysDicDictionaryPO> selectDictionary = sysDicDictionaryMapper.selectDictionary(pi);
        if (!CollectionUtils.isEmpty(selectDictionary)) {
            for (SysDicDictionaryPO dictionaryPO: selectDictionary) {
                if (str.equals(dictionaryPO.getCode())) {
                    descrip = dictionaryPO.getDescrip();
                    break;
                }
            }
        }
        return descrip;
    }

    /**
     * 简易采购计划关联/解除关联对应的委托书
     *
     * @param schemeIdList
     * @param type
     * @param relationReqParamBOMap
     */
    private Map<Long, List<CrcEntrustPO>> relationSchemeEntrust (List<Long> schemeIdList , Integer type, Map<Long,SscSmartApproveRelationReqParamBO> relationReqParamBOMap) {
        Map<Long, List<CrcEntrustPO>> entrustMap = new HashMap<>();
        // 查询是否做过委托书(有效状态)
        List<CrcEntrustPO> updateEntrustPOList = new ArrayList<>();
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setSchemeIds(schemeIdList);
        List<CrcEntrustPO> crcEntrustPOList = crcEntrustMapper.queryList(crcEntrustPO);
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            // 关联简易采购计划
            crcEntrustPOList.forEach( e -> {
                CrcEntrustPO entrustPO = new CrcEntrustPO();
                entrustPO.setEntrustId(e.getEntrustId());
                entrustPO.setRelationStatus(type);
                if (RelationStatusEnum.RELATION.getCode().equals(type)) {
                    // 关联委托书
                    if (!CollectionUtils.isEmpty(relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getSchemeId())) {
                        entrustPO.setFileId(relationReqParamBOMap.get(e.getSchemeId()).getFileId());
                        entrustPO.setFileItemId(relationReqParamBOMap.get(e.getSchemeId()).getFileItemId());
                    }
                } else {
                    // 解除关联
                    entrustPO.setFileId(null);
                    entrustPO.setFileItemId(null);
                }

                updateEntrustPOList.add(entrustPO);
            });
            if (!CollectionUtils.isEmpty(updateEntrustPOList)) {
                crcEntrustMapper.updateRelationStatus(updateEntrustPOList);
            }
            entrustMap = crcEntrustPOList.stream().collect(Collectors.groupingBy(CrcEntrustPO::getSchemeId));
        }
        return entrustMap;
    }

    /**
     * 采购方案包关联/解除关联对应的委托书
     *
     * @param packIdList
     * @param type
     * @param relationReqParamBOMap
     */
    private Map<Long, List<CrcEntrustPO>> relationPackEntrust (List<Long> packIdList,  Integer type, Map<Long,SscSmartApproveRelationReqParamBO> relationReqParamBOMap) {
        Map<Long, List<CrcEntrustPO>> entrustMap = new HashMap<>();
        // 查询是否做过委托书
        List<CrcEntrustPO> updateEntrustPOList = new ArrayList<>();
        CrcEntrustPO crcEntrustPO = new CrcEntrustPO();
        crcEntrustPO.setPackIds(packIdList);
        List<CrcEntrustPO> crcEntrustPOList = crcEntrustMapper.queryList(crcEntrustPO);
        if (!CollectionUtils.isEmpty(crcEntrustPOList)) {
            // 关联简易采购计划
            crcEntrustPOList.forEach( e -> {
                CrcEntrustPO entrustPO = new CrcEntrustPO();
                entrustPO.setEntrustId(e.getEntrustId());
                entrustPO.setRelationStatus(type);
                if (RelationStatusEnum.RELATION.getCode().equals(type)) {
                    // 关联委托书
                    if (!CollectionUtils.isEmpty(relationReqParamBOMap) && relationReqParamBOMap.containsKey(e.getPackId())) {
                        entrustPO.setFileId(relationReqParamBOMap.get(e.getPackId()).getFileId());
                        entrustPO.setFileItemId(relationReqParamBOMap.get(e.getPackId()).getFileItemId());
                    }
                } else {
                    // 解除关联
                    entrustPO.setFileId(null);
                    entrustPO.setFileItemId(null);
                }

                updateEntrustPOList.add(entrustPO);
            });
            if (!CollectionUtils.isEmpty(updateEntrustPOList)) {
                crcEntrustMapper.updateRelationStatus(updateEntrustPOList);
            }
            entrustMap = crcEntrustPOList.stream().collect(Collectors.groupingBy(CrcEntrustPO::getPackId));
        }
        return entrustMap;
    }


}


