package com.tydic.dyc.ssc.repositoryExt.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 委托书实体类
 *
 * @author hsw
 * @since 2024-8-16 17:03:31
 */
@Data
public class CrcEntrustPO implements Serializable {
	private static final long serialVersionUID =  4923408399935186645L;

	/**
	 * 委托书id
	 */
	private Long entrustId;

	/**
	 * 委托书id集合
	 */
	private List<Long> entrustIds;
	/**
	 * 项目进展(1委托退回,2委托书,3评标报告,4结果录入，6定标,7公示通知,8委托完成,9废标,10委托终止)
	 */
	private BigDecimal progress;

	public BigDecimal getProgress() {
		if(progress != null){
			return progress.stripTrailingZeros();
		}
		return null;
	}

	public void setProgress(BigDecimal progress) {
		this.progress = progress;
	}

	/**
	 * 审批状态(1:委托书草稿,2.委托书审批中，3委托书审批驳回,4委托书审批通过,5.定标审批中，6定标审批驳回,7定标审批通过,8.结果公示审批中，9结果公示审批驳回,10结果公示审批通过，11.结果公示审批中，12结果通知审批驳回,13结果通知审批通过)
	 */
	private Integer auditStatus;
	/**
	 * 委托书编码
	 */
	private String entrustCode;
	/**
	 * 委托书名称
	 */
	private String entrustName;
	/**
	 * 委托书编号
	 */
	private String entrustNo;
	/**
	 * 采购方式
	 */
	private String purType;

	/**
	 * 采购方式
	 */
	private List<String> purTypeList;
	/**
	 * 报价方式 1:网上报价,2:线下报价
	 */
	private String quotationType;
	/**
	 * 预算金额
	 */
	private BigDecimal ysje;
	/**
	 * 包id
	 */
	private Long packId;
	/**
	 * 包编码
	 */
	private String packCode;
	/**
	 * 包名称
	 */
	private String packName;
	/**
	 * 采购单位id
	 */
	private Long purId;
	/**
	 * 采购单位编码
	 */
	private String purNo;
	/**
	 * 采购单位名称
	 */
	private String purName;
	/**
	 * 采购单位机构路径
	 */
	private String purPath;
	/**
	 * 制单单位id
	 */
	private Long createOrgId;
	/**
	 * 制单单位编码
	 */
	private String createOrgNo;
	/**
	 * 制单单位名称
	 */
	private String createOrgName;
	/**
	 * 制单单位机构路径
	 */
	private String createOrgPath;
	/**
	 * 制单人id
	 */
	private Long createUserId;
	/**
	 * 制单人编码
	 */
	private String createUsername;
	/**
	 * 制单人名称
	 */
	private String createName;
	/**
	 * 定标人id
	 */
	private String dbUserId;
	/**
	 * 定标人姓名
	 */
	private String dbUserName;
	/**
	 * 定标人编码
	 */
	private String dbUserCode;
	/**
	 * 合同类型
	 */
	private String contractType;
	/**
	 * 成交方式（1总价，2单价，3费率）
	 */
	private String cjType;
	/**
	 * 采购联系人电话
	 */
	private String purContactMoblie;
	/**
	 * 采购联系人
	 */
	private String purContactMan;
	/**
	 * 资金来源
	 */
	private String zjly;
	/**
	 * 落实情况
	 */
	private String lsqk;
	/**
	 * 报价类型（10- 含税报价，20-不含税报价，30-费率）
	 */
	private Integer pQuoteTypes;
	/**
	 * 条款id
	 */
	private Long tkId;
	/**
	 * 报价要求
	 */
	private String bjyq;
	/**
	 * 模板非招id
	 */
	private String mbId;
	/**
	 * 模板编码
	 */
	private String mbCode;
	/**
	 * 模板内容
	 */
	private String mbContent;
	private String auditKey;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 审批时间
	 */
	private Date auditTime;
	private Date auditTimeStart;
	private Date auditTimeEnd;
	/**
	 * 修改时间
	 */
	private Date updateTime;
	private Date updateTimeStart;
	private Date updateTimeEnd;
	/*
	 *委托书来源(1:采购方案,2简易采购计划)
	 */
	private String ext1;
	private String ext2;
	private String ext3;
	private String ext4;
	private String ext5;
	private String ext6;
	private String ext7;
	private String ext8;
	/**
	 * 排序
	 */
	private String orderBy;

	/**
	 * 方案id
	 */
	private Long schemeId;
	/**
	 * 采购方式 0-公开招标，1-邀请招标，2-公开竞争性谈判，3-邀请竞争性谈判，4-公开询价，5-邀请询价，6-单一来源 7-公开询比 8-邀请询比 9-直接采购(定商定价) 10-直接采购(执行协议)，11-公开竞谈，12-邀请竞谈，13-公开竞价，14-邀请竞价， 50-(协议类)公开招标,53-(协议类)邀请招标
	 */
	private Integer purchaseType;
	/**
	 *包编号或者方案编号
	 */
	private String packNo;
	/**
	 *方案名称
	 */
	private String schemeName;
	/**
	 * 方案编号
	 */
	private String schemeNo;
	/**
	 * 方案编码
	 */
	private String schemeCode;

	/**
	 * 寻源分配状态(0 未分配, 1 已分配 ,2 已退回)
	 */
	private Integer xyFpStatus;

	/**
	 * 寻源人编码
	 */
	private String xyUserCode;
	/**
	 * 寻源人编码
	 */
	private Long xyUserId;
	/**
	 * 寻源人名字
	 */
	private String xyUserName;
	/**
	 * 寻源人分配操作人id
	 */
	private String operUserId;






	/**
	 *退回操作人编码
	 */
	private String thUserCode;
	/**
	 * 退回操作人名称
	 */
	private String thUserMame;
	/**
	 * 退回描述
	 */
	private String thRemarkDesc;
	/**
	 * 退回时间
	 */
	private Date thOperTime;


	/**
	 * 项目进展(1委托退回,2委托书,3评标报告,4结果录入，6定标,7公示通知,8委托完成,9废标,10委托终止)
	 */
	private List<BigDecimal> progressList;
	/**
	 * 方案ids
	 */
	private List<Long> schemeIds;
	/**
	 * 包idS
	 */
	private List<Long> packIds;
	/**
	 * 向下穿透单位
	 */
	private String orgPath;
	/**
	 * 寻源id
	 */
	private Long resultId;
	/**
	 * 联系人邮箱
	 */
	private String contactEmail;
	/**
	 * 采购单位地址
	 */
	private String purOrgAddr;
	/**
	 * 部门经理姓名
	 */
	private String departManagerName;
	/**
	 * 部门经理手机号
	 */
	private String departManagerMobile;
	/**
	 * 项目经理姓名
	 */
	private String projectManagerName;
	/**
	 * 项目经理手机号
	 */
	private String projectManagerMobile;

	private Long userId;

	/**
	 * 单位权限
	 */
	private List<String> orgTreePaths;
	/**
	 * 为1表示,查询是否有非委托终止且已分配的数据
	 */
	private Integer searchTh;
	/**
	 * 页签
	 */
	private Integer tabId;
	/**
	 * 物资类别筛选集合
	 */
	private List<Integer> schemeClassList;
	/**
	 * 综合查询菜单标识
	 */
	private Integer zhcx;
	/**
	 * 物资类别  0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件
	 */
	private String schemeClass;
	/**
	 * 物资类别  0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件
	 */
	private String schemeClassStr;
	/**
	 * 评标下一步报价日期
	 */
	private Date pbBjDate;
	/**
	 *  是否国际标 1是 0否
	 */
	private Integer isInternationalBid;
	/**
	 * 是否工程量清单
	 */
	private Integer engineeringList;
	/**
	 * 情况说明
	 */
	private String situationDesc;

	/**
	 * 评审方法
	 * 1 最低评审价格法  2 综合评估法
	 */
	private Integer reviewMethods;

	/**
	 * 关联状态：1-关联、0未关联
	 */
	private Integer relationStatus;
	/**
	 * 采购文件id
	 */
	private String fileId;
	/**
	 * 采购文件明细id
	 */
	private String fileItemId;

}
