package com.tydic.dyc.ssc.repositoryExt.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述:
 *
 * @author XiaWD
 * @date 2024/11/14 下午3:47
 * @Copyright: 2022 www.tydic.com Inc. All rights reserved.
 * 注意：本内容仅限于深圳天源迪科信息技术股份有限公司内部传阅，禁止外泄以及用于其他的商业目
 */
@Data
public class SScSchemeFindsourcePO implements Serializable {
    /**
     * 寻源id
     */
    private Long sourceId;
    /**
     * 同步表id
     */
    private Long syncId;
    /**
     * 集采方案包id
     */
    private Long packId;

    /**
     * 集采方案包id
     */
    private List<Long> packIds;
    /**
     * 集采方案包code
     */
    private String packCode;
    /**
     * 标段编码
     */
    private String bdCode;
    /**
     * 标段名称
     */
    private String bdName;
    /**
     * 招标项目编码
     */
    private String projectCode;
    /**
     * 招标项目名称
     */
    private String projectName;
    /**
     * 项目联系人
     */
    private String contactName;
    /**
     * 项目电话
     */
    private String contactTel;
    /**
     * 项目负责人
     */
    private String projectLeader;
    /**
     * 部门负责人
     */
    private String departmentLeader;
    /**
     * 非招(招标)项目进展
     */
    private String fzzbProgress;
    /**
     * 审批状态(1:集采方案审批通过,2定标审批驳回,3定标审批通过)
     */
    private Integer auditStatus;
    /**
     * 项目进度
     */
    private BigDecimal projectStatus;
    /**
     * 项目进度(排除)
     */
    private BigDecimal projectStatusExc;
    public BigDecimal getProjectStatus() {
        if(projectStatus != null){
            return projectStatus.stripTrailingZeros();
        }
        return null;
    }

    public void setProjectStatus(BigDecimal projectStatus) {
        this.projectStatus = projectStatus;
    }
    /**
     * 项目进度(区分招标和非招标)
     */
    private List<BigDecimal> projectStatusList;
    /**
     * 采购方式
     */
    private Integer purchaseType;
    /**
     * 审批时间
     */
    private Date auditTime;
    private Date auditTimeStart;
    private Date auditTimeEnd;
    /**
     * 定标人id
     */
    private String dbUserId;
    /**
     * 定标人姓名
     */
    private String dbUserName;
    /**
     * 定标人编码
     */
    private String dbUserCode;
    /**
     * 创建时间
     */
    private Date createTime;
    private Date createTimeStart;
    private Date createTimeEnd;
    /**
     * 同步状态(0:同步中,1待同步,2同步失败,3:同步成功)
     */
    private Integer syncStatus;
    /**
     * 定标意见(废标意见)
     */
    private String remarkDesc;
    /**
     * 废标操作人编码
     */
    private String fbUserCode;
    /**
     * 废标操作人名称
     */
    private String fbUserName;
    /**
     * 废标操作时间
     */
    private Date fbOperTime;
    private Date fbOperTimeStart;
    private Date fbOperTimeEnd;
    /**
     * 询价状态(1正常,0废标)
     */
    private Integer xjStatus;
    /**
     * 成交方式1.总价成交2.单价成交3.费率成交
     */
    private String ext1;
    private String ext2;
    private String ext3;
    private String ext4;
    private String ext5;
    private String ext6;
    private String ext7;
    private String ext8;
    /**
     * 排序
     */
    private String orderBy;

    /**
     * 采购包名称
     */
    private String packName;
    /**
     * 采购包编号
     */
    private String packNo;
    /**
     * 采购单位编码
     */
    private String createCompanyCode;
    /**
     * 采购单位名称
     */
    private String createCompanyName;
    /**
     * 合同类型
     */
    private String contactType;
    /**
     * 制单人编码
     */
    private String createUsername;
    /**
     * 制单人Id
     */
    private Long createLoginId;
    /**
     * 制单人名称
     */
    private String createName;
    /**
     *制单单位编码
     */
    private String createOrgCode;
    /**
     * 制单单位名称
     */
    private String createOrgName;


    /**
     * 寻源id集合
     */
    private List<Long> sourceIdList;

    /**
     * 预算金额
     */
    private BigDecimal estAmount;
    /**
     * 审批处理人id
     */
    private Long dealId;

    /**
     * 审批状态(1:集采方案审批通过,2定标审批驳回,3定标审批通过)
     */
    private List<Integer> auditStatusList;
    /**
     * 是否紧急采购  0否1是
     */
    private Integer emergencyFlag;
    /**
     * 是否进口 0国产 1进口
     */
    private Integer importFlag;
    /**
     * 方案id
     */
    private  Long schemeId;
    /**
     * 审批流程实例id
     */
    private String procInstId;
    /**
     * 任务实例id
     */
    private String taskInstId;
    /**
     * 流程key定义
     */
    private String procDefId;
    /**
     * 完结标志0未完结1已完结
     */
    private Integer finishTag;
    /**
     * 提交单位编码
     */
    private String dbOrgCode;
    /**
     * 提交单位名称
     */
    private String dbOrgName;
    /**
     * 比价时间
     */
    private String bjTime;
    /**
     * 处理人
     */
    private String dealName;
    /**
     * 处理时间
     */
    private Date dealTime;
    /**
     * 处理类型
     */
    private String dealType;
    /**
     * 机构树
     */
    private String orgPath;
    /**
     * 提交时间起始
     */
    private String submitTimeStart;
    /**
     * 提交时间截止
     */
    private String submitTimeEnd;

    /**
     * 单位权限
     */
    private List<String> orgTreePaths;

    private Long userId;
    /**
     *
     */
    private String setSyncStatus;
    /**
     * 物料编码
     */
    private String matCode;
    /**
     * 计划编号
     */
    private String planCode;
    /**
     * 申报单位编码
     */
    private String declareUnitCode;
    /**
     * 申报单位名称
     */
    private String declareUnitName;
    /**
     * 综合查询关联mat表标志
     */
    private String glMat;
    /**
     * 综合查询关联task表标志
     */
    private String glTask;
    /**
     * 是否综合查询
     */
    private String isZhCx;
    /**
     * 审核人编码
     */
    private String dealOperName;
    /**
     * 计划Id
     */
    private Long planId;
    /**
     * 物资类别  0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件
     */
    private String schemeClass;
    /**
     * 物资类别  0:工程 1:货物 2:服务 3:金属 4:非金属 5:设备 6:配件
     */
    private String schemeClassStr;
    /**
     * 评标下一步报价时间
     */
    private Date pbBjDate;

    /**
     * 处理备注
     */
    private String dealRemark;
}
