package com.tydic.dyc.ssc.repositoryExt.po;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题：采购方案明细 PO
 * 时间：2023/07/25
 */
@Data
public class SscSchemeMatPackExtPO implements Serializable {
    private static final long serialVersionUID = 423452930045058920L;

    /**
     * 方案id
     */
    private Long schemeId;

    /**
     * 方案编码
     */
    private String schemeCode;

    /**
     * 方案名称
     */
    private String schemeName;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 方案类别
     */
    private Integer schemeClass;

    /**
     * 标段ID
     */
    private Long packId;

    /**
     * 执行人编码
     */
    private String implCode;

    /**
     * 执行人名称
     */
    private String implName;

    /**
     * 包编码
     */
    private String packCode;

    /**
     * 包名称
     */
    private String packName;

    /**
     * 方案物料ID
     */
    private Long schemeMatId;

    /**
     * 申报单位ID
     */
    private Long declareUnitId;

    /**
     * 申报单位编码
     */
    private String declareUnitCode;

    /**
     * 申报单位名称
     */
    private String declareUnitName;

    /**
     * 计划编号
     */
    private String planCode;

    /**
     * 物料编码
     */
    private String matCode;

    /**
     * 物料名称
     */
    private String matName;

    /**
     * 计量单位名称
     */
    private String measureUnitName;

    /**
     * 采购数量
     */
    private BigDecimal purchaseNum;

    /**
     * 税率
     */
    private BigDecimal taxRate;

    /**
     * 不含税单价
     */
    private BigDecimal noTaxPrice;

    /**
     * 交货时间
     */
    private Date deliveryDate;

    /**
     * 备注
     */
    private String remark;

    /**
     * 计划ID
     */
    private Long planId;

    /**
     * 审核时间
     */
    private Date auditTime;

    /**
     * 创建人单位单位编码
     */
    private String createOrgCode;

    /**
     * 创建人单位名称
     */
    private String createOrgName;

    /**
     * 创建人名称
     */
    private String createName;

    /**
     * 预计总金额
     */
    private BigDecimal estAmount;
    private BigDecimal budgetAmount;

    /**
     * 合同数量
     */
    private BigDecimal contractAmount;

    /**
     * 订单数量
     */
    private BigDecimal orderAmount;

    /**
     * 合同剩余数量
     */
    private BigDecimal contractRemainingNum;

    /**
     * 订单剩余数量
     */
    private BigDecimal orderRemainingNum;

    /**
     * 方案类型
     */
    private String schemeType;

    /**
     * 采购方式
     */
    private Integer purchaseType;

    /**
     * 审批状态
     */
    private String schemeAuditStatus;

    /**
     * 方案状态
     */
    private String schemeStatus;

    /**
     * 合同类型字段编码
     */
    private String contractTypeFieldCode;

    /**
     * 合同类型字段值
     */
    private String contractTypeFieldValue;

    /**
     * 创建人用户名
     */
    private String createUsername;

    /**
     * 标段编号
     */
    private String packNo;

    /**
     * 计划类型字段编码
     */
    private String planTypeFieldCode;

    /**
     * 计划类型字段值
     */
    private String planTypeFieldValue;

    /**
     * 需求单位名称
     */
    private String reqUnitName;

    /**
     * 查询类型 1合同 2订单
     */
    private Integer queryType;

    /**
     * 方案物料ID集合
     */
    private List<Long> schemeMatIds;

    /**
     * 排序
     */
    private String orderBy;

    /**
     * 单位权限ID集合
     */
    List<String> authOrgIds;

    /**
     * 供应商编号
     */
    private String supCode;

    /**
     * 方案分交方式字段编码
     */
    private String schemeSubmitTypeFieldCode;

    /**
     * 方案分交方式字段值
     */
    private String schemeSubmitTypeFieldValue;


    /**
     *是否查找简易采购计划
     */
    private boolean isFindJY=false;

    /**
     * 产地品牌
     */
    private String brand;
    /**
     * 采购单位编码
     */
    private String createCompanyCode;

    /**
     * 采购单位名称
     */
    private String createCompanyName;
    /**
     * 是否合同系统调用查询，因为要设置固定的值,不为空代表是
     */
    private Integer isHtQryGc;
    /**
     * 是否紧急采购 0否1是
     */
    private Integer emergencyFlag;

}
