/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.bo.UccBatchSkuBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccApproveCreationAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuPutCirAtomService;
import com.tydic.commodity.busibase.atom.api.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccApproveCreationAtomRspBO;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.busibase.atom.bo.UccSkuUpdateStatusBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccStatusChangeUpdateSpuAtomRspBO;
import com.tydic.commodity.busibase.busi.api.UccUpAndOffApplyBusiService;
import com.tydic.commodity.busibase.busi.bo.ExtReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityReqBO;
import com.tydic.commodity.busibase.busi.bo.UccUpAndOffApplyAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccMaterlSkuInfoBO;
import com.tydic.commodity.common.ability.bo.UccQryMaterialClassRspBO;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.ListUtils;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.commodity.utils.PropertiesUtil;
import com.tydic.uac.ability.UacNoTaskAuditCancelAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCancelRspBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpAndOffApplyBusiServiceImpl
implements UccUpAndOffApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpAndOffApplyBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccApproveCreationAtomService uccApproveCreationAtomService;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UacNoTaskAuditCancelAbilityService uacNoTaskAuditCancelAbilityService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="welfareActiveCalatalogUccProvider")
    private ProxyMessageProducer welfareActiveCalatalogUccProvider;
    @Value(value="${ACTIVE_SKU_CATALOG_TOPIC:ACTIVE_SKU_CATALOG_TOPIC}")
    private String ACTIVE_SKU_CATALOG_TOPIC;
    @Value(value="${ACTIVE_SKU_CATALOG_TAG:*}")
    private String ACTIVE_SKU_CATALOG_TAG;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Resource(name="uccNotificationMqServiceProvider")
    private ProxyMessageProducer uccNotificationMqServiceProvider;
    @Value(value="${es.UCC_NOTIFICATION_TOPIC:UCC_NOTIFICATION_TOPIC}")
    private String uccNotificationTopic;
    @Value(value="${es.UCC_NOTIFICATION_TAG:UCC_NOTIFICATION_TAG}")
    private String uccNotificationTag;

    @Override
    public UccUpAndOffApplyAbilityRspBO dealUpAndOffApply(UccUpAndOffApplyAbilityReqBO reqBO, ExtReqBO extReqBO) {
        UccUpAndOffApplyAbilityRspBO rspBO = new UccUpAndOffApplyAbilityRspBO();
        if (CollectionUtils.isEmpty(reqBO.getBatchSkuList())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u7533\u8bf7\u5355\u54c1\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        if (StringUtils.isEmpty((Object)extReqBO.getProcess())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5ba1\u6279\u6d41\u83dc\u5355\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBO;
        }
        Map<Long, List<UccBatchSkuBO>> mapSku = reqBO.getBatchSkuList().stream().collect(Collectors.groupingBy(UccBatchSkuBO::getSupplierShopId));
        ArrayList<Long> skus = new ArrayList();
        Iterator<Long> iteratorSku = mapSku.keySet().iterator();
        ArrayList<Long> skuActiveList = new ArrayList<Long>();
        while (iteratorSku.hasNext()) {
            Long supplierShopId = iteratorSku.next();
            skus = mapSku.get(supplierShopId).stream().map(UccBatchSkuBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPo> uccSkuPos = null;
            uccSkuPos = this.uccSkuMapper.batchQrySku(skus, supplierShopId);
            ArrayList<Long> failIds = new ArrayList();
            ArrayList<Long> failIdAudit = new ArrayList();
            HashSet<Long> editSpu = new HashSet<Long>();
            if (uccSkuPos.size() < skus.size()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5b58\u5728\u65e0\u6548\u5355\u54c1\uff0c\u8bf7\u68c0\u67e5\u5165\u53c2");
                return rspBO;
            }
            try {
                SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO;
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(uccSkuPos)) {
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (extReqBO.getStatusOld().contains(uccSkuPo.getSkuStatus())) continue;
                        failIds.add(uccSkuPo.getSkuId());
                    }
                    for (UccSkuPo uccSkuPo : uccSkuPos) {
                        if (uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_GO || uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_GO || uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_GO) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (uccSkuPo.getApprovalStatus() == ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO && !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                            failIdAudit.add(uccSkuPo.getSkuId());
                        }
                        if (uccSkuPo.getApprovalStatus() != ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_GO || !ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) continue;
                        editSpu.add(uccSkuPo.getCommodityId());
                    }
                }
                if (!CollectionUtils.isEmpty(failIds = ListUtils.removeNull(failIds)) && reqBO.getIsSkuRelateMdmbatchSubmit() != null) {
                    if (rspBO.getFailIds() == null) {
                        rspBO.setFailIds(failIds);
                    } else {
                        rspBO.getFailIds().addAll(failIds);
                    }
                    skus.removeAll(failIds);
                    syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(failIds));
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(skus)) continue;
                }
                if (!CollectionUtils.isEmpty(failIdAudit) && reqBO.getIsSkuRelateMdmbatchSubmit() != null) {
                    if (rspBO.getFailIds() == null) {
                        rspBO.setFailIds(failIdAudit);
                    } else {
                        rspBO.getFailIds().addAll(failIdAudit);
                    }
                    skus.removeAll(failIdAudit);
                    syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(failIdAudit));
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                    }
                    if (CollectionUtils.isEmpty(skus)) continue;
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIds) && reqBO.getIsSkuRelateMdmbatchSubmit() == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + ((Object)failIds).toString() + "\u5f53\u524d\u72b6\u6001\u4e0d\u6b63\u786e");
                    return rspBO;
                }
                if (!org.apache.commons.collections.CollectionUtils.isEmpty(failIdAudit = ListUtils.removeNull(failIdAudit)) && reqBO.getIsSkuRelateMdmbatchSubmit() == null) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5355\u54c1" + ((Object)failIdAudit).toString() + "\u6b63\u5728\u5ba1\u6279\u4e2d");
                    return rspBO;
                }
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ArrayList<Long> editSpuAray = new ArrayList<Long>(editSpu);
            if (!CollectionUtils.isEmpty(editSpuAray)) {
                UacNoTaskAuditCancelReqBO uacNoTaskAuditCancelReqBO = null;
                for (Long cancelEach : editSpuAray) {
                    uacNoTaskAuditCancelReqBO = new UacNoTaskAuditCancelReqBO();
                    uacNoTaskAuditCancelReqBO.setObjId(cancelEach.toString());
                    uacNoTaskAuditCancelReqBO.setObjType(ModelRuleConstant.UAC_APPROVAL_TYPE_EDIT);
                    uacNoTaskAuditCancelReqBO.setOperDept(reqBO.getCompanyName());
                    uacNoTaskAuditCancelReqBO.setOperId(reqBO.getUserId().toString());
                    uacNoTaskAuditCancelReqBO.setCancelOperId(reqBO.getUserId().toString());
                    uacNoTaskAuditCancelReqBO.setCancelReason("\u5355\u54c1\u5f3a\u5236\u4e0b\u67b6");
                    UacNoTaskAuditCancelRspBO uacNoTaskAuditCancelRspBO = this.uacNoTaskAuditCancelAbilityService.auditCancel(uacNoTaskAuditCancelReqBO);
                    if ("0000".equals(uacNoTaskAuditCancelRspBO.getRespCode())) continue;
                    throw new BusinessException("8888", uacNoTaskAuditCancelRspBO.getRespDesc());
                }
                try {
                    this.uccCommodityMapper.batchUpdateSpuApprovalStatus(editSpuAray, null, supplierShopId);
                    this.uccCommodityMapper.batchUpdateStep(editSpuAray, null, supplierShopId);
                }
                catch (Exception e) {
                    throw new BusinessException("8888", e.getMessage());
                }
            }
            UccApproveCreationAtomReqBO approveCreationAtomReqBO = new UccApproveCreationAtomReqBO();
            BeanUtils.copyProperties((Object)((Object)reqBO), (Object)((Object)approveCreationAtomReqBO));
            approveCreationAtomReqBO.setObjId(skus);
            approveCreationAtomReqBO.setMenuId(extReqBO.getProcess());
            approveCreationAtomReqBO.setObjType(extReqBO.getAuditObjType());
            approveCreationAtomReqBO.setOrderId(supplierShopId);
            approveCreationAtomReqBO.setUserId(reqBO.getUserId());
            UccApproveCreationAtomRspBO uccApproveCreationAtomRspBO = null;
            try {
                uccApproveCreationAtomRspBO = this.uccApproveCreationAtomService.createApprove(approveCreationAtomReqBO);
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), e.getMessage());
            }
            if (!"0000".equals(uccApproveCreationAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.UAC_NOTASK_AUDIT_CREATE_FAIL.code(), uccApproveCreationAtomRspBO.getRespDesc());
            }
            try {
                UccSkuPo uccSkuPo = uccSkuPos.get(0);
                UccCommodityPo commodityById = this.uccCommodityMapper.getCommodityById(uccSkuPo.getCommodityId());
                log.info("\u5546\u54c1\u72b6\u6001\u53d8\u66f4\u901a\u77e5\u5f85\u529e extReqBO\uff1a{},skuSource:{},IsSupermarketStaff:{}", new Object[]{JSON.toJSONString((Object)extReqBO), uccSkuPo.getSkuSource(), commodityById.getIsSupermarketStaff()});
                skus.forEach($ -> {
                    TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO = new TodoUccWaitAbilityReqBO();
                    todoUccWaitAbilityReqBO.setObjId((Long)$);
                    switch (extReqBO.getStatusOld().get(0)) {
                        case 3: {
                            if (2 == uccSkuPo.getSkuSource()) {
                                todoUccWaitAbilityReqBO.setBusiCode("2002");
                                todoUccWaitAbilityReqBO.setBusiName("\u7535\u5546\u5546\u54c1\u4e0b\u67b6");
                                break;
                            }
                            if (3 == uccSkuPo.getSkuSource()) {
                                if (Objects.nonNull(commodityById.getIsSupermarketStaff()) && 1 == commodityById.getIsSupermarketStaff()) {
                                    todoUccWaitAbilityReqBO.setBusiCode("2015");
                                    todoUccWaitAbilityReqBO.setBusiName("\u5458\u5de5\u8d85\u5e02\u534f\u8bae\u5546\u54c1\u4e0b\u67b6");
                                    break;
                                }
                                todoUccWaitAbilityReqBO.setBusiCode("2006");
                                todoUccWaitAbilityReqBO.setBusiName("\u534f\u8bae\u5546\u54c1\u4e0b\u67b6");
                                break;
                            }
                            if (1 != uccSkuPo.getSkuSource()) break;
                            todoUccWaitAbilityReqBO.setBusiCode("2010");
                            todoUccWaitAbilityReqBO.setBusiName("\u65e0\u534f\u8bae\u5546\u54c1\u4e0b\u67b6");
                            break;
                        }
                        case 2: {
                            if (2 == extReqBO.getStatusApply()) {
                                if (3 == uccSkuPo.getSkuSource()) {
                                    if (Objects.nonNull(commodityById.getIsSupermarketStaff()) && 1 == commodityById.getIsSupermarketStaff()) {
                                        todoUccWaitAbilityReqBO.setBusiCode("2013");
                                        todoUccWaitAbilityReqBO.setBusiName("\u5458\u5de5\u8d85\u5e02\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                                        break;
                                    }
                                    todoUccWaitAbilityReqBO.setBusiCode("2004");
                                    todoUccWaitAbilityReqBO.setBusiName("\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                                    break;
                                }
                                if (1 != uccSkuPo.getSkuSource()) break;
                                todoUccWaitAbilityReqBO.setBusiCode("2008");
                                todoUccWaitAbilityReqBO.setBusiName("\u65e0\u534f\u8bae\u5546\u54c1\u7f16\u8f91");
                                break;
                            }
                            if (2 == uccSkuPo.getSkuSource()) {
                                todoUccWaitAbilityReqBO.setBusiCode("2001");
                                todoUccWaitAbilityReqBO.setBusiName("\u7535\u5546\u5546\u54c1\u4e0a\u67b6");
                                break;
                            }
                            if (3 == uccSkuPo.getSkuSource()) {
                                if (Objects.nonNull(commodityById.getIsSupermarketStaff()) && 1 == commodityById.getIsSupermarketStaff()) {
                                    todoUccWaitAbilityReqBO.setBusiCode("2014");
                                    todoUccWaitAbilityReqBO.setBusiName("\u5458\u5de5\u8d85\u5e02\u534f\u8bae\u5546\u54c1\u4e0a\u67b6");
                                    break;
                                }
                                todoUccWaitAbilityReqBO.setBusiCode("2005");
                                todoUccWaitAbilityReqBO.setBusiName("\u534f\u8bae\u5546\u54c1\u4e0a\u67b6");
                                break;
                            }
                            if (1 != uccSkuPo.getSkuSource()) break;
                            todoUccWaitAbilityReqBO.setBusiCode("2009");
                            todoUccWaitAbilityReqBO.setBusiName("\u65e0\u534f\u8bae\u5546\u54c1\u4e0a\u67b6");
                            break;
                        }
                        case 5: 
                        case 7: 
                        case 10: 
                        case 11: {
                            if (2 == uccSkuPo.getSkuSource()) {
                                todoUccWaitAbilityReqBO.setBusiCode("2003");
                                todoUccWaitAbilityReqBO.setBusiName("\u7535\u5546\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                                break;
                            }
                            if (3 == uccSkuPo.getSkuSource()) {
                                if (Objects.nonNull(commodityById.getIsSupermarketStaff()) && 1 == commodityById.getIsSupermarketStaff()) {
                                    todoUccWaitAbilityReqBO.setBusiCode("2016");
                                    todoUccWaitAbilityReqBO.setBusiName("\u5458\u5de5\u8d85\u5e02\u534f\u8bae\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                                    break;
                                }
                                todoUccWaitAbilityReqBO.setBusiCode("2007");
                                todoUccWaitAbilityReqBO.setBusiName("\u534f\u8bae\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                                break;
                            }
                            if (1 != uccSkuPo.getSkuSource()) break;
                            todoUccWaitAbilityReqBO.setBusiCode("2011");
                            todoUccWaitAbilityReqBO.setBusiName("\u65e0\u534f\u8bae\u5546\u54c1\u6062\u590d\u4e0a\u67b6");
                            break;
                        }
                        default: {
                            log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b:{},skus:{}", (Object)JSON.toJSONString((Object)extReqBO), (Object)JSON.toJSONString((Object)$));
                        }
                    }
                    todoUccWaitAbilityReqBO.setCenterCode("commodity");
                    todoUccWaitAbilityReqBO.setOperatorType("0");
                    this.taskTodoWaitService.handler(todoUccWaitAbilityReqBO);
                });
            }
            catch (Exception e) {
                log.error("\u5546\u54c1\u4e0a\u4e0b\u67b6\u901a\u77e5\u5f85\u529e\u4e2d\u5fc3\u5f02\u5e38:{}", (Throwable)e);
            }
            if (uccApproveCreationAtomRspBO.getNotFindFlag().booleanValue() || uccApproveCreationAtomRspBO.getFinish().booleanValue()) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO;
                this.updateSkuStatus(extReqBO.getStatusApproval(), "", "", skus, supplierShopId, reqBO);
                if (ModelRuleConstant.UAC_APPROVAL_TYPE_DOWN.equals(extReqBO.getAuditObjType())) {
                    try {
                        for (Long skuId : skus) {
                            uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                            uccSkuPutCirReqBO.setSkuId(skuId);
                            uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                            uccSkuPutCirReqBO.setDownType(extReqBO.getOperate());
                            uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr(new Date()));
                            uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                            uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                            this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                        }
                    }
                    catch (Exception e) {
                        throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                    }
                }
                if (!ModelRuleConstant.UAC_APPROVAL_TYPE_ON_SHELF.equals(extReqBO.getAuditObjType())) continue;
                try {
                    for (Long skuId : skus) {
                        uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                        uccSkuPutCirReqBO.setSkuId(skuId);
                        uccSkuPutCirReqBO.setSupplierShopId(supplierShopId);
                        uccSkuPutCirReqBO.setUptype(extReqBO.getOperate());
                        uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr(new Date()));
                        uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                        uccSkuPutCirReqBO.setRemark(extReqBO.getRemark());
                        this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                        skuActiveList.add(skuId);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new BusinessException("8888", "\u66f4\u65b0\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            try {
                this.updateSkuStatus(extReqBO.getStatusApply(), extReqBO.getAuditStatusApply(), uccApproveCreationAtomRspBO.getStepId(), skus, supplierShopId, reqBO);
                UccSendNotificationExtAtomReqBO notificationExtAtomReqBO = new UccSendNotificationExtAtomReqBO();
                notificationExtAtomReqBO.setUserId(reqBO.getUserId());
                notificationExtAtomReqBO.setObjIds(skus);
                notificationExtAtomReqBO.setFinish(false);
                notificationExtAtomReqBO.setObjType(extReqBO.getAuditObjType());
                notificationExtAtomReqBO.setNotificationType(UccConstants.UCC_NOTIFICATION_TYPE.ECOM_COMMODITY_UP_AUDIT);
                this.uccNotificationMqServiceProvider.send(new ProxyMessage(this.uccNotificationTopic, this.uccNotificationTag, JSONObject.toJSONString((Object)((Object)notificationExtAtomReqBO))));
            }
            catch (Exception e) {
                throw new BusinessException(RspConstantEnums.QUERY_DATA_EXCEPTION.code(), e.getMessage());
            }
        }
        this.newlyAddedActivite(skuActiveList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void updateSkuStatus(Integer newStatus, String newApprovalStatus, String newStepId, List<Long> skus, Long supplierShopId, UccUpAndOffApplyAbilityReqBO reqBO) {
        UccStatusChangeUpdateSpuAtomRspBO statusChangeUpdateSpuAtomRspBO = null;
        UccStatusChangeUpdateSpuAtomReqBO uccStatusChangeUpdateSpuAtomReqBO = new UccStatusChangeUpdateSpuAtomReqBO();
        ArrayList<UccSkuUpdateStatusBO> skuUpdateStatusBOS = new ArrayList<UccSkuUpdateStatusBO>();
        UccSkuUpdateStatusBO bo = null;
        for (Long each : skus) {
            bo = new UccSkuUpdateStatusBO();
            bo.setSkuId(each);
            bo.setSkuStatus(newStatus);
            if (newStatus == ModelRuleConstant.SKU_STATUS_ON_SHELF) {
                bo.setOnShelveTime(new Date());
            }
            skuUpdateStatusBOS.add(bo);
        }
        uccStatusChangeUpdateSpuAtomReqBO.setSkuStatusList(skuUpdateStatusBOS);
        uccStatusChangeUpdateSpuAtomReqBO.setSupplierShopId(supplierShopId);
        uccStatusChangeUpdateSpuAtomReqBO.setUserId(reqBO.getUserId());
        uccStatusChangeUpdateSpuAtomReqBO.setApprovalStatus(newApprovalStatus);
        uccStatusChangeUpdateSpuAtomReqBO.setStepId(newStepId);
        try {
            statusChangeUpdateSpuAtomRspBO = this.uccSkuStatusUpdatesAtomService.delaStatusChange(uccStatusChangeUpdateSpuAtomReqBO);
            if (!"0000".equals(statusChangeUpdateSpuAtomRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), statusChangeUpdateSpuAtomRspBO.getRespDesc());
            }
        }
        catch (Exception e) {
            throw new BusinessException(RspConstantEnums.SKU_CHANGE_UPDATE_SPU_FAIL.code(), e.getMessage());
        }
    }

    private void newlyAddedActivite(List<Long> skuActiveList) {
        if (!CollectionUtils.isEmpty(skuActiveList)) {
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.selectMaterialCatalogWelfare(null, skuActiveList);
            UccQryMaterialClassRspBO classRspBO = new UccQryMaterialClassRspBO();
            List collect = uccSkuPos.stream().map(obj -> {
                UccMaterlSkuInfoBO infoBO = new UccMaterlSkuInfoBO();
                BeanUtils.copyProperties((Object)obj, (Object)infoBO);
                if (obj.getSkuPrice() != null) {
                    infoBO.setBuyPrice(MoneyUtils.haoToYuan(obj.getSkuPrice()));
                }
                return infoBO;
            }).collect(Collectors.toList());
            classRspBO.setMaterlSkuInfoBOS(collect);
            log.info("\u4e0a\u67b6\u7533\u8bf7-\u6d3b\u52a8\u7c7b\u76ee\u53d1\u9001\u6d88\u606f\u5165\u53c2{}", (Object)JSON.toJSONString((Object)classRspBO));
            this.welfareActiveCalatalogUccProvider.send(new ProxyMessage(this.ACTIVE_SKU_CATALOG_TOPIC, this.ACTIVE_SKU_CATALOG_TAG, JSON.toJSONString((Object)classRspBO)));
        }
    }
}

