/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.openservices.shade.com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomReqBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomRspBO;
import com.tydic.commodity.dao.UccPushLogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccPushLogPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.utils.ESBParamUtil;
import com.tydic.commodity.utils.HSHttpHelper;
import com.tydic.commodity.utils.HSNHttpHeader;
import com.tydic.commodity.utils.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDataGovernPushSkuStateAtomServiceImpl
implements UccDataGovernPushSkuStateAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccDataGovernPushSkuStateAtomServiceImpl.class);
    @Value(value="${DATA_GOVERN_SKU_STATE_PUSH_URL:DATA_GOVERN_SKU_STATE_PUSH_URL}")
    private String DATA_GOVERN_SKU_STATE_PUSH_URL;
    @Value(value="${DATA_GOVERN_SKU_STATE_PUSH_ALL_URL:DATA_GOVERN_SKU_STATE_PUSH_ALL_URL}")
    private String DATA_GOVERN_SKU_STATE_PUSH_ALL_URL;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccPushLogMapper uccPushLogMapper;

    @Override
    public UccDataGovernPushSkuStateAtomRspBO dealDataGovernPushSkuState(UccDataGovernPushSkuStateAtomReqBO reqBo) {
        UccDataGovernPushSkuStateAtomRspBO atomRspBO = new UccDataGovernPushSkuStateAtomRspBO();
        atomRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBo.getCommodityIds()) && CollectionUtils.isEmpty(reqBo.getSkuIds()) && CollectionUtils.isEmpty(reqBo.getPushSkuList())) {
            atomRspBO.setRespDesc("\u5165\u53c2\u4fe1\u606f\u4e3a\u7a7a");
            return atomRspBO;
        }
        try {
            if (CollectionUtils.isEmpty(reqBo.getPushSkuList())) {
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setSkuIds(reqBo.getSkuIds());
                skuPo.setCommodityIds(reqBo.getCommodityIds());
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.getListByIds(skuPo);
                if (!CollectionUtils.isEmpty(uccSkuPos)) {
                    this.pushState(reqBo, uccSkuPos);
                }
            } else {
                this.pushState(reqBo, null);
            }
        }
        catch (Exception e) {
            log.error("\u63a8\u9001\u5546\u54c1\u72b6\u6001\u5230\u6570\u636e\u6cbb\u7406\u5931\u8d25 {}", (Object)e.getMessage());
        }
        return atomRspBO;
    }

    @Override
    public UccDataGovernPushSkuStateAtomRspBO dealDataGovernPushSkuStateBatch(UccDataGovernPushSkuStateAtomReqBO reqBo) {
        UccDataGovernPushSkuStateAtomRspBO atomRspBO = new UccDataGovernPushSkuStateAtomRspBO();
        atomRspBO.setRespCode("0000");
        if (CollectionUtils.isEmpty(reqBo.getCommodityIds()) && CollectionUtils.isEmpty(reqBo.getSkuIds()) && CollectionUtils.isEmpty(reqBo.getPushSkuList())) {
            atomRspBO.setRespDesc("\u5165\u53c2\u4fe1\u606f\u4e3a\u7a7a");
            return atomRspBO;
        }
        this.pushStateBatch(reqBo, null);
        return atomRspBO;
    }

    private void pushState(UccDataGovernPushSkuStateAtomReqBO reqBo, List<UccSkuPo> uccSkuPos) {
        List<UccDataGovernPushSkuStateAtomBO> pushDataList = reqBo.getPushSkuList();
        if (CollectionUtils.isEmpty(pushDataList)) {
            pushDataList = uccSkuPos.stream().map(e -> {
                UccDataGovernPushSkuStateAtomBO skuStateAtomBO = new UccDataGovernPushSkuStateAtomBO();
                skuStateAtomBO.setSkuStatus(e.getSkuStatus());
                Date date = e.getUpdateTime() != null ? e.getUpdateTime() : e.getCreateTime();
                skuStateAtomBO.setChangeTime(DateUtils.dateToStrLong((Date)date));
                skuStateAtomBO.setSkuId(e.getSkuId());
                return skuStateAtomBO;
            }).collect(Collectors.toList());
        }
        ArrayList<UccPushLogPO> uccPushLogPOS = new ArrayList<UccPushLogPO>();
        log.error("=========\u63a8\u9001\u6570\u636e\u6cbb\u7406(\u63a8\u9001\u5546\u54c1\u72b6\u6001)============" + (Object)((Object)reqBo));
        for (UccDataGovernPushSkuStateAtomBO pushData : pushDataList) {
            try {
                JSONObject data = new JSONObject();
                JSONObject jsonObject = JSONObject.parseObject((String)JSONObject.toJSONString((Object)pushData));
                data.put("data", (Object)jsonObject);
                data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
                String reqStr = data.toJSONString();
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5165\u53c2(\u63a8\u9001\u5546\u54c1\u72b6\u6001)\uff1a" + reqStr);
                UccPushLogPO uccPushLogPO = new UccPushLogPO();
                uccPushLogPO.setId(Sequence.getInstance().nextId());
                uccPushLogPO.setCreateTime(new Date());
                uccPushLogPO.setType(10);
                uccPushLogPO.setReqJson(reqStr);
                try {
                    HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.DATA_GOVERN_SKU_STATE_PUSH_URL), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
                    log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u51fa\u53c2(\u63a8\u9001\u5546\u54c1\u72b6\u6001) {}", (Object)JSON.toJSONString((Object)httpRetBean));
                    if (httpRetBean.getStatus() != 200) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5931\u8d25\uff08\u63a8\u9001\u5546\u54c1\u72b6\u6001\uff09\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
                    }
                    String returnString = httpRetBean.getStr();
                    if (StringUtils.isEmpty((Object)returnString)) {
                        throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406(\u63a8\u9001\u5546\u54c1\u72b6\u6001)-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                    }
                    JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                    if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                        uccPushLogPO.setStatus(0);
                    } else {
                        uccPushLogPO.setStatus(1);
                    }
                    uccPushLogPO.setRspJson(returnString);
                }
                catch (Exception e2) {
                    log.error("\u63a8\u9001\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
                    uccPushLogPO.setStatus(0);
                    uccPushLogPO.setRspJson(e2.getMessage());
                }
                uccPushLogPO.setSkuId(pushData.getSkuId() + "");
                uccPushLogPO.setNewType(10);
                uccPushLogPOS.add(uccPushLogPO);
            }
            catch (Exception e3) {
                log.error("\u63a8\u9001\u5546\u54c1\u72b6\u6001\u5931\u8d25 {}", (Object)e3.getMessage());
            }
        }
        try {
            if (!CollectionUtils.isEmpty(uccPushLogPOS)) {
                this.uccPushLogMapper.insertBatch(uccPushLogPOS);
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
            log.error("\u63a8\u9001\u5546\u54c1\u72b6\u6001\u5931\u8d25\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25 {}", (Object)e4.getMessage());
        }
    }

    private void pushStateBatch(UccDataGovernPushSkuStateAtomReqBO reqBo, List<UccSkuPo> uccSkuPos) {
        List<UccDataGovernPushSkuStateAtomBO> pushDataList = reqBo.getPushSkuList();
        if (CollectionUtils.isEmpty(pushDataList)) {
            pushDataList = uccSkuPos.stream().map(e -> {
                UccDataGovernPushSkuStateAtomBO skuStateAtomBO = new UccDataGovernPushSkuStateAtomBO();
                skuStateAtomBO.setSkuStatus(e.getSkuStatus());
                Date date = e.getUpdateTime() != null ? e.getUpdateTime() : e.getCreateTime();
                skuStateAtomBO.setChangeTime(DateUtils.dateToStrLong((Date)date));
                skuStateAtomBO.setSkuId(e.getSkuId());
                return skuStateAtomBO;
            }).collect(Collectors.toList());
        }
        ArrayList<UccPushLogPO> uccPushLogPOS = new ArrayList<UccPushLogPO>();
        log.error("=========\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5168\u91cf(\u63a8\u9001\u5546\u54c1\u72b6\u6001)============" + (Object)((Object)reqBo));
        try {
            JSONObject data = new JSONObject();
            JSONArray arr = JSONObject.parseArray((String)JSONObject.toJSONString(pushDataList));
            JSONObject skuStatusObj = new JSONObject();
            skuStatusObj.put("skuStatuslist", (Object)arr);
            data.put("data", (Object)skuStatusObj);
            data.put("serialNo", (Object)ESBParamUtil.getSerialNumber());
            String reqStr = data.toJSONString();
            log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5168\u91cf\u5165\u53c2(\u63a8\u9001\u5546\u54c1\u72b6\u6001)\uff1a" + reqStr);
            UccPushLogPO uccPushLogPO = new UccPushLogPO();
            uccPushLogPO.setId(Sequence.getInstance().nextId());
            uccPushLogPO.setCreateTime(new Date());
            uccPushLogPO.setType(11);
            uccPushLogPO.setReqJson(reqStr);
            try {
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(this.DATA_GOVERN_SKU_STATE_PUSH_ALL_URL), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
                log.info("\u8c03\u7528\u6570\u636e\u6cbb\u7406\u5168\u91cf\u51fa\u53c2(\u63a8\u9001\u5546\u54c1\u72b6\u6001) {}", (Object)JSON.toJSONString((Object)httpRetBean));
                if (httpRetBean.getStatus() != 200) {
                    throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5168\u91cf\u5931\u8d25\uff08\u63a8\u9001\u5546\u54c1\u72b6\u6001\uff09\uff0c\u94fe\u63a5\u672a\u54cd\u5e94");
                }
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((Object)returnString)) {
                    throw new RuntimeException("\u63a8\u9001\u6570\u636e\u6cbb\u7406\u5168\u91cf(\u63a8\u9001\u5546\u54c1\u72b6\u6001)-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
                if (!"0000".equals(rspJsonObject.get((Object)"respCode"))) {
                    uccPushLogPO.setStatus(0);
                } else {
                    uccPushLogPO.setStatus(1);
                }
                uccPushLogPO.setRspJson(returnString);
            }
            catch (Exception e2) {
                log.error("\u63a8\u9001\u5f02\u5e38\uff1a{}", (Object)e2.getMessage());
                uccPushLogPO.setStatus(0);
                uccPushLogPO.setRspJson(e2.getMessage());
            }
            uccPushLogPO.setSkuId(pushDataList.stream().map(UccDataGovernPushSkuStateAtomBO::getSkuId).collect(Collectors.toList()).toString());
            uccPushLogPO.setNewType(11);
            uccPushLogPOS.add(uccPushLogPO);
        }
        catch (Exception e3) {
            log.error("\u63a8\u9001\u5546\u54c1\u72b6\u6001\u5931\u8d25\u5168\u91cf {}", (Object)e3.getMessage());
        }
        try {
            if (!CollectionUtils.isEmpty(uccPushLogPOS)) {
                this.uccPushLogMapper.insertBatch(uccPushLogPOS);
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
            log.error("\u63a8\u9001\u5546\u54c1\u72b6\u6001\u5168\u91cf\u5931\u8d25\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25 {}", (Object)e4.getMessage());
        }
    }
}

