/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.nacos.client.naming.utils.CollectionUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.busi.api.updateBranNameService;
import com.tydic.commodity.config.ThreadPoolExecutorUtil;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccBrandDealPO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class updateBranNameServiceImpl
implements updateBranNameService {
    private static final Logger log = LoggerFactory.getLogger(updateBranNameServiceImpl.class);
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private static final ThreadPoolExecutor threadPoolExecutor = ThreadPoolExecutorUtil.poolExecutor;
    @Value(value="${PAGE_SIZE:10}")
    private int UCC_PAGE_SIZE;

    @Override
    public void updateBranName(UccBrandDealPO brandDealPO) {
        if (!ObjectUtils.isEmpty((Object)brandDealPO) && null != brandDealPO.getBrandId()) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                log.error("\u540c\u6b65ES\u7761\u7720\u9519\u8bef");
                Thread.currentThread().interrupt();
            }
            log.error("\u540c\u6b65ES\u5165\u53c2:" + brandDealPO);
            ArrayList<Long> brandIds = new ArrayList<Long>();
            brandIds.add(brandDealPO.getBrandId());
            List<UccMallBrandRelPO> brandList = this.uccMallBrandRelMapper.getBrandList(brandIds);
            List<Long> brandIdList = brandList.stream().map(UccMallBrandRelPO::getBrandId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(brandIdList)) {
                int skuIdCount = this.uccSkuMapper.queryAllBrandIdsCount(brandIdList);
                int pageskuIdCount = skuIdCount % this.UCC_PAGE_SIZE == 0 ? skuIdCount / this.UCC_PAGE_SIZE : skuIdCount / this.UCC_PAGE_SIZE + 1;
                for (int i = 1; i <= pageskuIdCount; ++i) {
                    Page page = new Page();
                    page.setPageNo(i);
                    page.setPageSize(this.UCC_PAGE_SIZE);
                    this.dealData((Page<Long>)page, brandIdList, i);
                }
            }
        }
    }

    private void dealData(Page<Long> page, List<Long> brandDealPO, int i) {
        Runnable runnable = () -> {
            log.error("\u7b2c" + i + "\u7ebf\u7a0b\u5f00\u542f");
            List<Long> skuIdList = this.uccSkuMapper.qeryByBrandIds(brandDealPO, page);
            SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
            log.error("\u540c\u6b65ES\u5165\u53c2:" + skuIdList);
            syncSceneCommodityToEsReqBO.setSkuIds(skuIdList);
            syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
            syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
            syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
        };
        threadPoolExecutor.submit(runnable);
    }
}

