/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.task.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.commodity.busibase.atom.api.CommodityDealWaitParamsAtomService;
import com.tydic.commodity.busibase.atom.api.WaitDoneLogAtomService;
import com.tydic.commodity.busibase.atom.bo.TodoWaitAbilityAtomRspBO;
import com.tydic.commodity.dao.ApplyShelvesFormMapper;
import com.tydic.commodity.dao.BrandApplyMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccUocOrdTaskApproveEntrustMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.ApplyShelvesFormPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccUocOrdTaskApproveEntrustPO;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.WaitDoneLogBusiService;
import com.tydic.commodity.task.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.task.bo.TodoWaitAbilityAssembleReqBO;
import com.tydic.commodity.task.bo.TodoWaitAbilityReqBO;
import com.tydic.commodity.task.bo.WaitDoneLogReqBO;
import com.tydic.commodity.task.util.DycUccTodoWaitDoneProvider;
import com.tydic.commodity.task.util.TaskWaitDoneEnum;
import com.tydic.todo.ability.api.TodoWaitDoneWriteAbilityService;
import com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityRspBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.todo.ability.bo.TodoCancelWaitDoneAbilityRspBO;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class TaskTodoWaitServiceImpl
implements TaskTodoWaitService {
    private static final Logger log = LoggerFactory.getLogger(TaskTodoWaitServiceImpl.class);
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private DycUccTodoWaitDoneProvider dycUccTodoWaitDoneProviderService;
    @Autowired
    private BrandApplyMapper brandApplyMapper;
    @Autowired
    private ApplyShelvesFormMapper applyShelvesFormMapper;
    @Autowired
    private CommodityDealWaitParamsAtomService commodityDealWaitParamsAtomService;
    @Autowired
    private WaitDoneLogBusiService waitDoneLogBusiService;
    @Value(value="${dyc.ucc.add.todo.wait.done.topic:TODO_ADD_WAIT_DONE_TOPIC}")
    private String addWaitTodoTopic;
    @Value(value="${dyc.ucc.cancel.todo.wait.done.topic:TODO_CANCEL_WAIT_DONE_TOPIC}")
    private String cancelWaitTodoTopic;
    @Value(value="${dyc.ucc.done.todo.wait.done.topic:TODO_ADD_ALREADY_DONE_TOPIC}")
    private String DoneWaitTodoTopic;
    @Autowired
    private TodoWaitDoneWriteAbilityService todoWaitDoneWriteAbilityService;
    @Autowired
    private WaitDoneLogAtomService waitDoneLogAtomService;
    @Autowired
    private UccUocOrdTaskApproveEntrustMapper uocOrdTaskApproveEntrustMapper;

    @Override
    public void brandHandler(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        log.info("brandHandler todoUccWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
        this.assertParam(todoUccWaitAbilityReqBO);
        try {
            if (StringUtils.isEmpty((Object)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr())) {
                return;
            }
            UocApprovalLogPO uocApprovalLogPO = (UocApprovalLogPO)JSON.parseObject((String)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr(), UocApprovalLogPO.class);
            switch (todoUccWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmitBrand(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    if (uocApprovalLogPO.getFinish() == 0) {
                        log.error("\u8fdb\u5165\u4e8c\u7ea7\u5ba1\u6279\u903b\u8f91");
                        TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorAddBrandApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                        todoAddPassWaitAbilityReqBO.setIsFirstAddWait("0");
                        todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("brandHandler error:{}", (Throwable)e);
        }
    }

    @Override
    public void newBrandHandler(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        log.info("newBrandHandler todoUccWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
        this.assertParam(todoUccWaitAbilityReqBO);
        try {
            if (StringUtils.isEmpty((Object)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr())) {
                return;
            }
            UocApprovalLogPO uocApprovalLogPO = (UocApprovalLogPO)JSON.parseObject((String)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr(), UocApprovalLogPO.class);
            switch (todoUccWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmitBrand(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    if (uocApprovalLogPO.getFinish() == 0) {
                        TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorAddBrandApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                        todoAddPassWaitAbilityReqBO.setIsFirstAddWait("0");
                        todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("newBrandHandler error:{}", (Throwable)e);
        }
    }

    @Override
    public void productApplyHandler(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        log.info("TaskTodoWaitService productApplyHandler:{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
        this.assertParam(todoUccWaitAbilityReqBO);
        try {
            if (StringUtils.isEmpty((Object)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr())) {
                return;
            }
            UocApprovalLogPO uocApprovalLogPO = (UocApprovalLogPO)JSON.parseObject((String)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr(), UocApprovalLogPO.class);
            switch (todoUccWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorProductSubmit(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorProductDoneApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorProductCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    if (Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                        TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorProductAddApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                        todoAddPassWaitAbilityReqBO.setIsFirstAddWait("0");
                        todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoWaitAbilityReqBO = this.operatorProductCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.cancelTodoWait(todoWaitAbilityReqBO);
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService productApplyHandler error:{}", (Throwable)e);
        }
    }

    @Override
    public void handler(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoUccWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
        this.assertParam(todoUccWaitAbilityReqBO);
        try {
            if (StringUtils.isEmpty((Object)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr())) {
                return;
            }
            UocApprovalLogPO uocApprovalLogPO = (UocApprovalLogPO)JSON.parseObject((String)todoUccWaitAbilityReqBO.getUocApprovalLogPOStr(), UocApprovalLogPO.class);
            String ext2 = null;
            String ext3 = null;
            UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(todoUccWaitAbilityReqBO.getObjId().toString());
            if (Objects.isNull(uccSkuPo)) {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setCommodityId(todoUccWaitAbilityReqBO.getObjId());
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPos)) {
                    Assert.notEmpty(uccSkuPos, (String)"\u672a\u77e5\u7684OBJ_ID\u7c7b\u578b");
                }
                uccSkuPo = uccSkuPos.get(0);
                Long supplierShopId = uccSkuPo.getSupplierShopId();
                ext3 = supplierShopId.toString();
                ext2 = uccSkuPo.getSkuId().toString();
            } else {
                Long supplierShopId = uccSkuPo.getSupplierShopId();
                ext3 = supplierShopId.toString();
                ext2 = uccSkuPo.getCommodityId().toString();
            }
            switch (todoUccWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    log.error("\u63d0\u4ea4\u5ba1\u6279-\u5f00\u59cb");
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmit(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    if (Objects.nonNull(todoSubmitWaitAbilityReqBO)) {
                        todoSubmitWaitAbilityReqBO.setExt2(ext2);
                        todoSubmitWaitAbilityReqBO.setExt3(ext3);
                        log.error("\u63d0\u4ea4\u5ba1\u6279-\u65b0\u589e\u5f85\u529e");
                        this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    }
                    break;
                }
                case "1": {
                    log.error("\u5ba1\u6279\u64cd\u4f5c-\u5f00\u59cb");
                    log.error("\u5ba1\u6279\u5904\u7406\u6d41\u7a0b\u4e2d\u67e5\u8be2\u51fa\u7684\u4fe1\u606f:" + JSON.toJSONString((Object)uocApprovalLogPO));
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    todoDonePassWaitAbilityReqBO.setExt2(ext2);
                    todoDonePassWaitAbilityReqBO.setExt3(ext3);
                    log.error("\u5ba1\u6279\u64cd\u4f5c-\u6dfb\u52a0\u5df2\u529e\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)todoDonePassWaitAbilityReqBO));
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    todoCancelPassWaitAbilityReqBO.setWaitPushStatus(todoDonePassWaitAbilityReqBO.getWaitPushStatus());
                    log.error("\u5ba1\u6279\u64cd\u4f5c-\u53d6\u6d88\u5f85\u529e\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)todoCancelPassWaitAbilityReqBO));
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    log.error("\u8fdb\u5165lyh-bug\u8c03\u8bd5,\u5f85\u529e\u65b0\u589e\u524dnextStationId = " + uocApprovalLogPO.getNextStationId());
                    if (Objects.nonNull(uocApprovalLogPO.getNextStationId())) {
                        log.error("\u8fdb\u5165lyh-bug\u8c03\u8bd5,\u5f85\u529e\u65b0\u589e\u903b\u8f91");
                        TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorAddApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                        todoAddPassWaitAbilityReqBO.setExt2(ext2);
                        todoAddPassWaitAbilityReqBO.setExt3(ext3);
                        todoAddPassWaitAbilityReqBO.setIsFirstAddWait("0");
                        todoAddPassWaitAbilityReqBO.setWaitPushStatus(todoCancelPassWaitAbilityReqBO.getWaitPushStatus());
                        log.error("\u5ba1\u6279\u64cd\u4f5c-\u65b0\u589e\u5f85\u529e\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)todoAddPassWaitAbilityReqBO));
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                case "2": {
                    TodoWaitAbilityReqBO todoWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.cancelTodoWait(todoWaitAbilityReqBO);
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService handler error:{}", (Throwable)e);
        }
    }

    public void addTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        log.error("\u7ec4\u88c5\u65b0\u589e\u5f85\u529e\u5f00\u59cb\uff0c\u5165\u53c2\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
            TodoWaitAbilityAssembleReqBO todoWaitAbilityAssembleReqBO = new TodoWaitAbilityAssembleReqBO();
            BeanUtils.copyProperties((Object)todoWaitAbilityReqBO, (Object)todoWaitAbilityAssembleReqBO);
            TodoWaitAbilityAtomRspBO todoWaitAbilityAtomRspBO = this.commodityDealWaitParamsAtomService.uccDealTodoAddWaitParams(todoWaitAbilityAssembleReqBO);
            log.error("\u5f53\u524d\u8fd4\u56de\u5f97todoWaitAbilityAtomRspBO\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)((Object)todoWaitAbilityAtomRspBO)));
            if (todoWaitAbilityAtomRspBO.getRespCode().equals("0000") && todoWaitAbilityAtomRspBO.getTodoWaitAbilityAssembleRspBO() != null) {
                TodoWaitAbilityReqBO abilityReqBO = new TodoWaitAbilityReqBO();
                BeanUtils.copyProperties((Object)todoWaitAbilityAtomRspBO.getTodoWaitAbilityAssembleRspBO(), (Object)abilityReqBO);
                abilityReqBO.setStepId(todoWaitAbilityReqBO.getNextStepId());
                todoWaitAbilityReqBO = abilityReqBO;
            }
            try {
                if (!todoWaitAbilityReqBO.getWaitPushStatus().booleanValue()) {
                    throw new ZTBusinessException("\u4e0a\u4e00\u6b65\u53d6\u6d88\u5f85\u529e\u63a8\u9001\u5931\u8d25");
                }
                com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<com.tydic.todo.ability.bo.TodoAddWaitDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoAddWaitDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.addWaitDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                }
                waitDoneLogReqBO.setWaitDoneType(1);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getWaitDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5f85\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(1);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getWaitDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    private void addWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String addWaitTodoTopic, String addWaitTodoTag) {
        List<TodoAddWaitDoneAbilityReqBO> waitDoneList = todoWaitAbilityReqBO.getWaitDoneList();
        TodoAddWaitDoneAbilityReqBO todoAddWaitDone = waitDoneList.get(0);
        WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
        waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
        waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        waitDoneLogReqBO.setWaitDoneStatus(1);
        waitDoneLogReqBO.setWaitDoneType(1);
        waitDoneLogReqBO.setTitle(todoAddWaitDone.getTitle());
        waitDoneLogReqBO.setMqTopic(addWaitTodoTopic);
        waitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(waitDoneLogReqBO);
    }

    public void cancelTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        log.error("\u7ec4\u88c5\u53d6\u6d88\u5f85\u529e\u5f00\u59cb\uff0c\u5165\u53c2\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
            try {
                if (!todoWaitAbilityReqBO.getWaitPushStatus().booleanValue()) {
                    throw new ZTBusinessException("\u4e0a\u4e00\u6b65\u65b0\u589e\u5df2\u529e\u63a8\u9001\u5931\u8d25");
                }
                TodoCancelWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (TodoCancelWaitDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<TodoCancelWaitDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoCancelWaitDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.cancelWaitDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                }
                waitDoneLogReqBO.setWaitDoneType(2);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
                    com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getCancelList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u53d6\u6d88\u5f85\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(2);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
                    com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getCancelList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    private void addCancelTodoWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String doneWaitTodoTopic, String addWaitTodoTag) {
        List<com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO> cancelList = todoWaitAbilityReqBO.getCancelList();
        WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
        if (!CollectionUtils.isEmpty(cancelList)) {
            com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO todoAddWaitDone = cancelList.get(0);
            waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
        }
        waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        waitDoneLogReqBO.setWaitDoneStatus(1);
        waitDoneLogReqBO.setWaitDoneType(2);
        waitDoneLogReqBO.setMqTopic(doneWaitTodoTopic);
        waitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(waitDoneLogReqBO);
    }

    public void doneTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        log.error("\u7ec4\u88c5\u65b0\u589e\u5df2\u529e\u5f00\u59cb\uff0c\u5165\u53c2\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
            try {
                com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = (com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)todoWaitAbilityReqBO), (TypeReference)new TypeReference<com.tydic.todo.ability.bo.TodoAddAlreadyDoneAbilityReqBO>(){}, (Feature[])new Feature[0]);
                TodoAddAlreadyDoneAbilityRspBO doneAbilityRspBO = this.todoWaitDoneWriteAbilityService.AddAlreadyDone(todoAddWaitDoneAbilityReqBO);
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                if ("0000".equals(doneAbilityRspBO.getRespCode())) {
                    waitDoneLogReqBO.setWaitDoneStatus(1);
                } else {
                    waitDoneLogReqBO.setWaitDoneStatus(2);
                    waitDoneLogReqBO.setFailNum(0);
                    waitDoneLogReqBO.setExt1(doneAbilityRspBO.getRespDesc().length() > 200 ? doneAbilityRspBO.getRespDesc().substring(0, 200) : doneAbilityRspBO.getRespDesc());
                    todoWaitAbilityReqBO.setWaitPushStatus(false);
                }
                waitDoneLogReqBO.setWaitDoneType(3);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
                    TodoAddAlreadyDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
            }
            catch (Exception e) {
                log.error("\u65b0\u589e\u5df2\u529e\u63a8\u9001\u9519\u8bef\uff1a{}", (Object)JSON.toJSONString((Object)e));
                WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
                waitDoneLogReqBO.setWaitDoneStatus(2);
                waitDoneLogReqBO.setFailNum(0);
                waitDoneLogReqBO.setExt1(e.getMessage().length() > 200 ? e.getMessage().substring(0, 200) : e.getMessage());
                waitDoneLogReqBO.setWaitDoneType(3);
                if (!ObjectUtil.isEmpty((Object)todoWaitAbilityReqBO) && !CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
                    TodoAddAlreadyDoneAbilityReqBO todoAddWaitDone = todoWaitAbilityReqBO.getDoneList().get(0);
                    waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
                }
                waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
                waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
                waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
                this.waitDoneLogAtomService.addWaitDoneLog(waitDoneLogReqBO);
                todoWaitAbilityReqBO.setWaitPushStatus(false);
            }
        }
    }

    private void addTodoWaitDoneLog(TodoWaitAbilityReqBO todoWaitAbilityReqBO, String addWaitTodoTopic, String addWaitTodoTag) {
        log.error("\u65b0\u589e\u5df2\u529e\u63a8\u9001\u65e5\u5fd7\u5f00\u59cb\uff0c\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
        List<TodoAddAlreadyDoneAbilityReqBO> doneList = todoWaitAbilityReqBO.getDoneList();
        WaitDoneLogReqBO waitDoneLogReqBO = new WaitDoneLogReqBO();
        if (!CollectionUtils.isEmpty(doneList)) {
            TodoAddAlreadyDoneAbilityReqBO todoAddWaitDone = doneList.get(0);
            waitDoneLogReqBO.setObjId(Long.valueOf(todoAddWaitDone.getObjId()));
        }
        waitDoneLogReqBO.setBusiCode(todoWaitAbilityReqBO.getBusiCode());
        waitDoneLogReqBO.setBusiName(todoWaitAbilityReqBO.getBusiName());
        waitDoneLogReqBO.setMsgContent(JSON.toJSONString((Object)todoWaitAbilityReqBO));
        waitDoneLogReqBO.setWaitDoneStatus(1);
        waitDoneLogReqBO.setWaitDoneType(3);
        waitDoneLogReqBO.setMqTopic(addWaitTodoTopic);
        waitDoneLogReqBO.setMqTag(addWaitTodoTag);
        this.waitDoneLogBusiService.addWaitDoneLog(waitDoneLogReqBO);
    }

    private TodoWaitAbilityReqBO operatorAddBrandApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        if (!CollectionUtils.isEmpty(userCode) && userCode.size() > 0) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        }
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        Long id = uocApprovalLogPO.getId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString(), uocApprovalLogPO.getTaskId())) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorAddBrandApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            todoPassWaitAbilityReqBO.setExt1(todoUccWaitAbilityReqBO.getObjNo());
            if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getSubOperId())) {
                List<Long> submitUserId;
                List<MemberAbilityBO> submitUsers;
                String operName = uocApprovalLogPO.getSubOperName();
                String operid = uocApprovalLogPO.getSubOperId();
                if (!StringUtils.isEmpty((Object)operid) && !CollectionUtils.isEmpty(submitUsers = this.getUserCode(submitUserId = Collections.singletonList(Long.parseLong(operid))))) {
                    todoPassWaitAbilityReqBO.setCreateId(submitUsers.get(0).getRegAccount());
                    todoPassWaitAbilityReqBO.setCreateName(operName);
                }
            }
            todoPassWaitAbilityReqBO.setExt7(auditOrderId + "");
            todoPassWaitAbilityReqBO.setExt8(id + "");
            todoPassWaitAbilityReqBO.setRemark(nextStepName);
            todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(todoUccWaitAbilityReqBO.getObjNo());
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        if (Objects.nonNull(nextStationId)) {
            log.error("\u8fdb\u5165lyh\u8c03\u8bd5\u903b\u8f91: + nextStationId = " + nextStationId);
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString(), uocApprovalLogPO.getTaskId());
            if (dycStationOrgSelectUserNameRspBO1 != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
                log.error("\u8fdb\u5165lyh\u8c03\u8bd5\u903b\u8f91: + userList = " + JSON.toJSONString((Object)dycStationOrgSelectUserNameRspBO1.getUserList()));
                List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
                log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
                UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(objId.toString());
                if (Objects.isNull(uccSkuPo)) {
                    uccSkuPo = new UccSkuPo();
                    uccSkuPo.setCommodityId(objId);
                    List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                    if (CollectionUtils.isEmpty(uccSkuPos)) {
                        Assert.notEmpty(uccSkuPos, (String)"\u672a\u77e5\u7684OBJ_ID\u7c7b\u578b");
                    }
                    uccSkuPo = uccSkuPos.get(0);
                }
                if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getSubOperId())) {
                    List<Long> submitUserId;
                    List<MemberAbilityBO> submitUsers;
                    String operName = uocApprovalLogPO.getSubOperName();
                    String operid = uocApprovalLogPO.getSubOperId();
                    if (!StringUtils.isEmpty((Object)operid) && !CollectionUtils.isEmpty(submitUsers = this.getUserCode(submitUserId = Collections.singletonList(Long.parseLong(operid))))) {
                        todoPassWaitAbilityReqBO.setCreateId(submitUsers.get(0).getRegAccount());
                        todoPassWaitAbilityReqBO.setCreateName(operName);
                    }
                }
                todoPassWaitAbilityReqBO.setExt1(uccSkuPo.getSkuCode());
                UccSkuPo finalUccSkuPo = uccSkuPo;
                todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalUccSkuPo.getSkuCode());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorProductAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorProductAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        if (!CollectionUtils.isEmpty(userCode)) {
            String regAccount = userCode.get(0).getRegAccount();
            todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        }
        todoPassWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString(), uocApprovalLogPO.getTaskId())) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorProductAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            ApplyShelvesFormPO applyShelvesFormPo = new ApplyShelvesFormPO();
            applyShelvesFormPo.setApplyId(todoUccWaitAbilityReqBO.getObjId());
            ApplyShelvesFormPO modelBy = this.applyShelvesFormMapper.getModelBy(applyShelvesFormPo);
            if (Objects.isNull(modelBy)) {
                log.error("TaskTodoWaitService handler error:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
                throw new ZTBusinessException("\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6 \u83b7\u53d6\u5355\u636e\u5931\u8d25");
            }
            todoPassWaitAbilityReqBO.setExt1(modelBy.getApplyCode());
            todoPassWaitAbilityReqBO.setCreateId(modelBy.getCreateUserCode());
            todoPassWaitAbilityReqBO.setCreateName(modelBy.getCreateUserName());
            todoPassWaitAbilityReqBO.setExt7(auditOrderId + "");
            todoPassWaitAbilityReqBO.setExt8(id + "");
            todoPassWaitAbilityReqBO.setRemark(nextStepName);
            todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(modelBy.getApplyCode());
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorProductCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        String regAccount;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        log.error("\u53d6\u6d88\u5f85\u529e-operatorProductCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)objId);
        com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO();
        todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
        String string = regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : null;
        if (!"2".equals(todoUccWaitAbilityReqBO.getOperatorType())) {
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
            todoCancelWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        }
        todoPassWaitAbilityReqBO.setCancelList(Collections.singletonList(todoCancelWaitDoneAbilityReqBO));
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        if (!"2".equals(todoUccWaitAbilityReqBO.getOperatorType())) {
            List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
            List<MemberAbilityBO> userCode = this.getUserCode(strings);
            log.info("operatorCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)objId);
            String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : null;
            todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        }
        String stationId = todoUccWaitAbilityReqBO.getStationId();
        com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO();
        todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
        todoCancelWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        todoPassWaitAbilityReqBO.setCancelList(Collections.singletonList(todoCancelWaitDoneAbilityReqBO));
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorProductDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorProductDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : null;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setObjId(todoUccWaitAbilityReqBO.getObjId().toString());
        todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setAuditTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        ApplyShelvesFormPO applyShelvesFormPo = new ApplyShelvesFormPO();
        applyShelvesFormPo.setApplyId(todoUccWaitAbilityReqBO.getObjId());
        ApplyShelvesFormPO modelBy = this.applyShelvesFormMapper.getModelBy(applyShelvesFormPo);
        todoPassWaitAbilityReqBO.setCreateId(modelBy.getCreateUserCode());
        todoPassWaitAbilityReqBO.setCreateName(modelBy.getCreateUserName());
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        String regAccount = !CollectionUtils.isEmpty(userCode) ? userCode.get(0).getRegAccount() : null;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setOperatorId(regAccount);
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setObjId(todoUccWaitAbilityReqBO.getObjId().toString());
        log.error("\u5f53\u524d\u5ba1\u6279\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)uocApprovalLogPO));
        todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setAuditTime(new Date());
        todoAddAlreadyDoneAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
        todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getSubOperId())) {
            List<Long> userIds;
            List<MemberAbilityBO> users;
            String operName = uocApprovalLogPO.getSubOperName();
            String operid = uocApprovalLogPO.getSubOperId();
            if (!StringUtils.isEmpty((Object)operid) && !CollectionUtils.isEmpty(users = this.getUserCode(userIds = Collections.singletonList(Long.parseLong(operid))))) {
                todoPassWaitAbilityReqBO.setCreateId(users.get(0).getRegAccount());
                todoPassWaitAbilityReqBO.setCreateName(operName);
            }
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorProductSubmit(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if (Objects.nonNull(nextStationId)) {
            ApplyShelvesFormPO applyShelvesFormPo = new ApplyShelvesFormPO();
            applyShelvesFormPo.setApplyId(todoUccWaitAbilityReqBO.getObjId());
            ApplyShelvesFormPO modelBy = this.applyShelvesFormMapper.getModelBy(applyShelvesFormPo);
            if (Objects.isNull(modelBy)) {
                log.error("TaskTodoWaitService handler error:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
                throw new ZTBusinessException("\u5546\u54c1\u7533\u8bf7\u4e0a\u67b6 \u83b7\u53d6\u5355\u636e\u5931\u8d25");
            }
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId.toString(), uocApprovalLogPO.getTaskId());
            if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
                todoWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
                todoWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
                todoWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
                todoWaitAbilityReqBO.setExt1(modelBy.getApplyCode());
                todoWaitAbilityReqBO.setCreateId(modelBy.getCreateUserCode());
                todoWaitAbilityReqBO.setCreateName(modelBy.getCreateUserName());
                todoWaitAbilityReqBO.setExt7(auditOrderId + "");
                todoWaitAbilityReqBO.setExt8(id + "");
                todoWaitAbilityReqBO.setRemark(nextStepName);
                if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                    List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                    List<MemberAbilityBO> userCode = this.getUserCode(strings);
                    if (!CollectionUtils.isEmpty(userCode)) {
                        todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                    }
                    todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
                }
                todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
                ApplyShelvesFormPO finalBrandApplyPo = modelBy;
                todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalBrandApplyPo.getApplyCode());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorSubmitBrand(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long auditOrderId = uocApprovalLogPO.getAuditOrderId();
        Long id = uocApprovalLogPO.getId();
        String nextStepName = uocApprovalLogPO.getNextStepName();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId, uocApprovalLogPO.getTaskId())) != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO.getUserList();
            log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
            todoWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
            todoWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
            todoWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
            todoWaitAbilityReqBO.setExt1(todoUccWaitAbilityReqBO.getObjNo());
            todoWaitAbilityReqBO.setStepId(uocApprovalLogPO.getStepId());
            todoWaitAbilityReqBO.setNextStepId(uocApprovalLogPO.getNextStepId());
            if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getSubOperId())) {
                List<Long> strings;
                List<MemberAbilityBO> userCode;
                String operName = uocApprovalLogPO.getSubOperName();
                String operid = uocApprovalLogPO.getSubOperId();
                if (!StringUtils.isEmpty((Object)operid) && !CollectionUtils.isEmpty(userCode = this.getUserCode(strings = Collections.singletonList(Long.parseLong(operid))))) {
                    todoWaitAbilityReqBO.setCreateId(userCode.get(0).getRegAccount());
                    todoWaitAbilityReqBO.setCreateName(operName);
                }
            }
            todoWaitAbilityReqBO.setExt7(auditOrderId + "");
            todoWaitAbilityReqBO.setExt8(id + "");
            todoWaitAbilityReqBO.setRemark(nextStepName);
            if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getOperid())) {
                List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                List<MemberAbilityBO> userCode = this.getUserCode(strings);
                if (!CollectionUtils.isEmpty(userCode)) {
                    todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                }
                todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
            }
            todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
            todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(todoUccWaitAbilityReqBO.getObjNo());
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoWaitAbilityReqBO;
    }

    private UocApprovalLogPO getSubmitUser(Long objId) {
        return this.uocApprovalObjMapper.queryApproverLog(objId).stream().filter(item -> Objects.isNull(item.getAuditResult())).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private TodoWaitAbilityReqBO operatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
            return null;
        }
        String nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        UccSkuPo uccSkuPo = null;
        if (Objects.nonNull(nextStationId)) {
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
            uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(objId.toString());
            if (Objects.isNull(uccSkuPo)) {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setCommodityId(objId);
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPos)) {
                    Assert.notEmpty(uccSkuPos, (String)"\u672a\u77e5\u7684OBJ_ID\u7c7b\u578b");
                }
                uccSkuPo = uccSkuPos.get(0);
            }
            if ((dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId.toString(), uocApprovalLogPO.getTaskId())) != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
                todoWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
                todoWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
                todoWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
                todoWaitAbilityReqBO.setExt1(uccSkuPo.getSkuCode());
                if (!StringUtils.isEmpty((Object)uocApprovalLogPO.getSubOperId())) {
                    List<Long> strings;
                    List<MemberAbilityBO> userCode;
                    String operName = uocApprovalLogPO.getSubOperName();
                    String operid = uocApprovalLogPO.getSubOperId();
                    if (!StringUtils.isEmpty((Object)operid) && !CollectionUtils.isEmpty(userCode = this.getUserCode(strings = Collections.singletonList(Long.parseLong(operid))))) {
                        todoWaitAbilityReqBO.setCreateId(userCode.get(0).getRegAccount());
                        todoWaitAbilityReqBO.setCreateName(operName);
                    }
                }
                if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                    List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                    List<MemberAbilityBO> userCode = this.getUserCode(strings);
                    if (!CollectionUtils.isEmpty(userCode)) {
                        todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                    }
                    todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
                }
                todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
                UccSkuPo finalUccSkuPo = uccSkuPo;
                todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalUccSkuPo.getSkuCode());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    todoAddWaitDoneAbilityReqBO.setStepId(uocApprovalLogPO.getNextStepId());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoWaitAbilityReqBO;
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    private DycStationOrgSelectUserNameRspBO listUser(String nextStationId, String taskId) {
        List<UccUocOrdTaskApproveEntrustPO> entrustPOS;
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)nextStationId)) {
            return null;
        }
        String[] stationIds = nextStationId.split(",");
        if (stationIds.length == 0) {
            return null;
        }
        ArrayList<Long> nextStationIds = new ArrayList<Long>();
        for (String stationId : stationIds) {
            nextStationIds.add(Long.parseLong(stationId));
        }
        HashSet<Long> entrustUserIds = new HashSet<Long>();
        HashSet<Long> commissionedUserIds = new HashSet<Long>();
        if (!StringUtils.isEmpty((Object)taskId) && !CollectionUtils.isEmpty(entrustPOS = this.uocOrdTaskApproveEntrustMapper.selectByTaskId(taskId))) {
            for (UccUocOrdTaskApproveEntrustPO entrustPO : entrustPOS) {
                entrustUserIds.add(entrustPO.getEntrustUserId());
                commissionedUserIds.add(entrustPO.getCommissionedUserId());
            }
        }
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationIds(nextStationIds);
        if (!CollectionUtils.isEmpty(entrustUserIds)) {
            dycStationOrgSelectUserNameReqBO.setEntrustUserIds(new ArrayList(entrustUserIds));
            dycStationOrgSelectUserNameReqBO.setCommissionedUserIds(new ArrayList(commissionedUserIds));
        }
        log.error("dycStationOrgSelectUserNameReqBO:{}", (Object)JSON.toJSONString((Object)dycStationOrgSelectUserNameReqBO));
        return this.dycStationOrgSelectUserNameService.selectUserNameList(dycStationOrgSelectUserNameReqBO);
    }

    @Override
    public UocApprovalLogPO listApproval(Long objId) {
        return this.uocApprovalObjMapper.queryApproverLog(objId).stream().filter($ -> Objects.nonNull($)).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private void assertParam(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        Assert.notNull((Object)todoUccWaitAbilityReqBO, (String)"PARAM_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getObjId(), (String)"OBJID_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getOperatorType(), (String)"OPERATOR_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getBusiCode(), (String)"\u5c0f\u5206\u7c7b\u5f85\u529e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

