/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.commodity.base.bo.FolderBO;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpCollectionUtil {
    private String username;
    private String password;
    private String ftpHostName;
    private int port = 21;
    private FTPClient ftpClient = new FTPClient();
    private FileOutputStream fos = null;
    private static final Logger logger = LoggerFactory.getLogger(FtpCollectionUtil.class);
    private static String encoding = System.getProperty("file.encoding");
    private static final String SEP_SLASH = "/";
    private int id = 0;

    public FtpCollectionUtil(String username, String password, String ftpHostName, int port) {
        this.username = username;
        this.password = password;
        this.ftpHostName = ftpHostName;
        this.port = port;
    }

    private void connect() {
        try {
            logger.debug("\u5f00\u59cb\u8fde\u63a5");
            this.ftpClient.connect(this.ftpHostName, this.port);
            int reply = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                this.ftpClient.disconnect();
            }
            this.ftpClient.login(this.username, this.password);
            this.ftpClient.setBufferSize(256);
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            logger.debug("\u767b\u5f55\u6210\u529f\uff01");
            logger.debug("\u5f00\u59cb\u767b\u5f55\uff01");
        }
        catch (SocketException e) {
            logger.error("", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    private void close(FileOutputStream fos) {
        try {
            if (fos != null) {
                fos.close();
            }
            this.ftpClient.logout();
            logger.info("\u9000\u51fa\u767b\u5f55");
            this.ftpClient.disconnect();
            logger.info("\u5173\u95ed\u8fde\u63a5");
        }
        catch (IOException e) {
            logger.error("", (Throwable)e);
        }
    }

    public boolean down(String ftpFileName, String localDir) {
        this.connect();
        return this.downFileOrDir(ftpFileName, localDir);
    }

    public void downToMap(String ftpFileName, Map<String, File> map) {
        this.connect();
        this.downFile(ftpFileName, map);
    }

    public void downToInputStream(String ftpFileName, Map<String, InputStream> inputStreamMap) {
        this.connect();
        this.downFileToInputStream(ftpFileName, inputStreamMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean downFileOrDir(String ftpFileName, String localDir) {
        boolean result = false;
        try {
            FTPFile[] listFiles;
            File file = new File(new String(ftpFileName.getBytes("iso-8859-1"), "GBK"));
            File temp = new File(localDir);
            if (!temp.exists()) {
                temp.mkdirs();
            }
            if ((listFiles = this.ftpClient.listFiles(ftpFileName)).length > 0) {
                if (this.isDir(ftpFileName)) {
                    String[] names = this.ftpClient.listNames();
                    for (int i = 0; i < names.length; ++i) {
                        System.out.println(names[i] + "^^^^^^^^^^^^^^");
                        if (this.isDir(names[i])) {
                            this.downFileOrDir(ftpFileName + '/' + names[i], localDir + File.separator + names[i]);
                            this.ftpClient.changeToParentDirectory();
                            continue;
                        }
                        File localfile = new File(localDir + File.separator + names[i]);
                        if (!localfile.exists()) {
                            this.fos = new FileOutputStream(localfile);
                            this.ftpClient.retrieveFile(names[i], (OutputStream)this.fos);
                            continue;
                        }
                        logger.debug("\u5f00\u59cb\u5220\u9664\u6587\u4ef6");
                        if (file.delete()) {
                            logger.debug("\u6587\u4ef6\u5df2\u7ecf\u5220\u9664");
                        }
                        this.fos = new FileOutputStream(localfile);
                        this.ftpClient.retrieveFile(ftpFileName, (OutputStream)this.fos);
                    }
                } else {
                    File localfile = new File(localDir + File.separator + file.getName());
                    if (!localfile.exists()) {
                        this.fos = new FileOutputStream(localfile);
                        this.ftpClient.retrieveFile(ftpFileName, (OutputStream)this.fos);
                    } else {
                        logger.debug("\u5f00\u59cb\u5220\u9664\u6587\u4ef6");
                        if (file.delete()) {
                            logger.debug("\u6587\u4ef6\u5df2\u7ecf\u5220\u9664");
                        }
                        this.fos = new FileOutputStream(localfile);
                        this.ftpClient.retrieveFile(ftpFileName, (OutputStream)this.fos);
                    }
                    this.ftpClient.changeToParentDirectory();
                }
                result = true;
                logger.info("\u4e0b\u8f7d\u6210\u529f\uff01");
            } else {
                result = false;
                logger.info("\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (SocketException e) {
            logger.error("\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
            boolean bl = result;
            return bl;
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
            boolean bl = result;
            return bl;
        }
        finally {
            this.close(this.fos);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downFile(String ftpFileName, Map<String, File> map) {
        try {
            File file = new File(new String(ftpFileName.getBytes("iso-8859-1"), "GBK"));
            FTPFile[] listFiles = this.ftpClient.listFiles(ftpFileName);
            if (listFiles.length > 0) {
                if (this.isDir(ftpFileName)) {
                    String[] names = this.ftpClient.listNames();
                    for (int i = 0; i < names.length; ++i) {
                        System.out.println(names[i] + "^^^^^^^^^^^^^^");
                        if (this.isDir(names[i])) {
                            this.downFile(ftpFileName + '/' + names[i], map);
                            this.ftpClient.changeToParentDirectory();
                            continue;
                        }
                        File file1 = new File(new String(ftpFileName.getBytes("iso-8859-1"), "GBK") + '/' + names[i]);
                        map.put(names[i].substring(0, names[i].indexOf(".")), file1);
                    }
                } else {
                    map.put(file.getName().substring(0, file.getName().indexOf(".")), file);
                }
                logger.info("\u4e0b\u8f7d\u6210\u529f\uff01");
            } else {
                logger.info("\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (SocketException e) {
            logger.error("\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            this.close(this.fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downFileToInputStream(String ftpFileName, Map<String, InputStream> map) {
        try {
            File file = new File(new String(ftpFileName.getBytes("iso-8859-1"), "GBK"));
            FTPFile[] listFiles = this.ftpClient.listFiles(ftpFileName);
            if (listFiles.length > 0) {
                if (this.isDir(ftpFileName)) {
                    String[] names = this.ftpClient.listNames();
                    for (FTPFile file1 : listFiles) {
                        InputStream inputStream = this.ftpClient.retrieveFileStream(file1.getName());
                        map.put(file1.getName().substring(0, file1.getName().indexOf(".")), inputStream);
                        inputStream.close();
                        this.ftpClient.completePendingCommand();
                    }
                }
                logger.info("\u4e0b\u8f7d\u6210\u529f\uff01");
            } else {
                logger.info("\u76ee\u6807\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
        }
        catch (SocketException e) {
            logger.error("\u8fde\u63a5\u5931\u8d25\uff01", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("\u4e0b\u8f7d\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            this.close(this.fos);
        }
    }

    public boolean isDir(String fileName) {
        try {
            boolean falg = this.ftpClient.changeWorkingDirectory(fileName);
            return falg;
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return false;
        }
    }

    public static void main(String[] args) {
        try {
            FtpCollectionUtil ftpUtil = new FtpCollectionUtil("vsftpd", "JKH234Asdjjkd", "172.16.100.26", 21);
            ArrayList<FolderBO> folderList = new ArrayList<FolderBO>();
            ftpUtil.listFolders("/home/vsftpd/vsftpd/pageOffice/doc", folderList);
            System.out.println("folderList = " + folderList);
        }
        catch (Exception e) {
            logger.error("" + e);
        }
    }

    public void listFolders(String path, List<FolderBO> folderList) {
        this.connect();
        logger.error("path----------:" + path);
        if (null == folderList) {
            folderList = new ArrayList<FolderBO>();
        }
        try {
            logger.info("\u5f00\u59cb\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5217\u8868\u3002");
            this.ftpClient.enterLocalPassiveMode();
            Object[] ftpFiles = null;
            if (StringUtils.isEmpty((String)path)) {
                ftpFiles = this.ftpClient.listDirectories();
            } else {
                if (path.startsWith(SEP_SLASH) && !"/home".equals(path)) {
                    path = path.substring(1);
                }
                ftpFiles = this.ftpClient.listDirectories(path);
            }
            logger.error("ftpFiles----------:" + Arrays.toString(ftpFiles));
            for (int i = 0; i < ftpFiles.length; ++i) {
                if (!ftpFiles[i].isDirectory()) continue;
                logger.info("ftpFiles----------:" + ftpFiles[i].getName());
                if (".".equals(ftpFiles[i].getName()) || "..".equals(ftpFiles[i].getName())) continue;
                String folderName = ftpFiles[i].getName();
                String tempDir = "";
                tempDir = path.equals(SEP_SLASH) ? SEP_SLASH + folderName : path + SEP_SLASH + folderName;
                this.ftpClient.setFileType(2);
                FolderBO folder = new FolderBO();
                folder.setId(Integer.valueOf(++this.id));
                folder.setName(folderName);
                folder.setType(1);
                String[] paths = tempDir.split(SEP_SLASH);
                String parentFolder = "home";
                if (paths != null) {
                    parentFolder = paths.length > 2 ? paths[paths.length - 2] : folderName;
                }
                folder.setPath(tempDir);
                folder.setParentName(parentFolder);
                if (!path.equals(SEP_SLASH)) {
                    folder.setParentId(this.findParentIdByPath(folderList, tempDir));
                }
                folderList.add(folder);
            }
            logger.info("\u5f00\u59cb\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5217\u8868\u5b8c\u6210\u3002");
        }
        catch (IOException e) {
            logger.error("\u83b7\u53d6ftp\u6587\u4ef6\u5939\u5931\u8d25\uff01");
        }
    }

    private Integer findParentIdByPath(List<FolderBO> folderList, String path) {
        logger.error("path----------:" + path);
        String[] dirs = path.split(SEP_SLASH);
        String matchPath = path;
        if (dirs != null && dirs.length > 1) {
            matchPath = path.substring(0, path.lastIndexOf(SEP_SLASH));
        }
        String matchPathLbd = matchPath;
        logger.error("matchPathLbd----------:" + matchPathLbd);
        List matchFolderList = folderList.stream().filter(folder -> folder.getPath().equals(matchPathLbd)).collect(Collectors.toList());
        if (matchFolderList.size() > 0) {
            return ((FolderBO)matchFolderList.get(0)).getId();
        }
        logger.error("matchPathLbd----------:" + matchFolderList);
        return null;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getFtpHostName() {
        return this.ftpHostName;
    }

    public void setFtpHostName(String ftpHostName) {
        this.ftpHostName = ftpHostName;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }
}

