/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.busibase.busi.api.UccQryTaxTypeTreeBusiService;
import com.tydic.commodity.busibase.busi.bo.UccQryTaxTypeTreeBo;
import com.tydic.commodity.busibase.busi.bo.UccQryTaxTypeTreeBusiReqBo;
import com.tydic.commodity.busibase.busi.bo.UccQryTaxTypeTreeBusiRspBo;
import com.tydic.commodity.dao.UccCommodityTaxTypeMapper;
import com.tydic.commodity.po.UccCommodityTaxTypePO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccQryTaxTypeTreeBusiServiceImpl
implements UccQryTaxTypeTreeBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccQryTaxTypeTreeBusiServiceImpl.class);
    @Autowired
    private UccCommodityTaxTypeMapper uccCommodityTaxTypeMapper;

    @Override
    public UccQryTaxTypeTreeBusiRspBo qryTaxTypeTree(UccQryTaxTypeTreeBusiReqBo reqBo) {
        UccQryTaxTypeTreeBusiRspBo rspBo = new UccQryTaxTypeTreeBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        UccCommodityTaxTypePO uccCommodityTaxTypePO = new UccCommodityTaxTypePO();
        List<UccCommodityTaxTypePO> uccCommodityTaxTypePOS = this.uccCommodityTaxTypeMapper.getList(uccCommodityTaxTypePO);
        if (!CollectionUtils.isEmpty(uccCommodityTaxTypePOS)) {
            List bos = JSONObject.parseArray((String)JSONObject.toJSONString(uccCommodityTaxTypePOS), UccQryTaxTypeTreeBo.class);
            List<UccQryTaxTypeTreeBo> result = this.translationTree(bos);
            rspBo.setRows(result);
        }
        return rspBo;
    }

    private List<UccQryTaxTypeTreeBo> translationTree(List<UccQryTaxTypeTreeBo> bos) {
        List<UccQryTaxTypeTreeBo> highest = bos.stream().filter(a -> "0".equals(a.getUpTaxId().toString())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(highest)) {
            this.getChilds(bos, highest);
        }
        return highest;
    }

    private void getChilds(List<UccQryTaxTypeTreeBo> bos, List<UccQryTaxTypeTreeBo> result) {
        for (UccQryTaxTypeTreeBo each : result) {
            List<UccQryTaxTypeTreeBo> childs = bos.stream().filter(a -> a.getUpTaxId().equals(each.getTaxId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(childs)) continue;
            this.getChilds(bos, childs);
            each.setRows(childs);
        }
    }
}

