/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.task.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UocApprovalLogPO;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoAddAlreadyDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoAddWaitDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoCancelWaitDoneAbilityReqBO;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import com.tydic.commodity.task.bo.TodoWaitAbilityReqBO;
import com.tydic.commodity.task.util.DycUccTodoWaitDoneProvider;
import com.tydic.commodity.task.util.TaskWaitDoneEnum;
import com.tydic.umc.daiban.UmcAddTaskAbilityService;
import com.tydic.umc.daiban.bo.UmcTaskReqBO;
import com.tydic.umc.daiban.bo.UmcTaskRspBO;
import com.tydic.umc.general.ability.bo.MemberAbilityBO;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class TaskTodoWaitServiceImpl
implements TaskTodoWaitService {
    private static final Logger log = LoggerFactory.getLogger(TaskTodoWaitServiceImpl.class);
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private UmcAddTaskAbilityService umcAddTaskAbilityService;
    @Autowired
    private DycUccTodoWaitDoneProvider dycUccTodoWaitDoneProviderService;

    @Override
    public void handler(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        log.info("TaskTodoWaitService todoUccWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoUccWaitAbilityReqBO));
        this.assertParam(todoUccWaitAbilityReqBO);
        try {
            UocApprovalLogPO uocApprovalLogPO = this.listApproval(todoUccWaitAbilityReqBO.getObjId());
            switch (todoUccWaitAbilityReqBO.getOperatorType()) {
                case "0": {
                    TodoWaitAbilityReqBO todoSubmitWaitAbilityReqBO = this.operatorSubmit(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.addTodoWait(todoSubmitWaitAbilityReqBO);
                    break;
                }
                case "1": {
                    TodoWaitAbilityReqBO todoDonePassWaitAbilityReqBO = this.operatorDoneApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.doneTodoWait(todoDonePassWaitAbilityReqBO);
                    TodoWaitAbilityReqBO todoCancelPassWaitAbilityReqBO = this.operatorCancelApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                    this.cancelTodoWait(todoCancelPassWaitAbilityReqBO);
                    if (uocApprovalLogPO.getFinish() == 0) {
                        TodoWaitAbilityReqBO todoAddPassWaitAbilityReqBO = this.operatorAddApproval(uocApprovalLogPO, todoUccWaitAbilityReqBO);
                        this.addTodoWait(todoAddPassWaitAbilityReqBO);
                    }
                    break;
                }
                default: {
                    log.error("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                    throw new RuntimeException("\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
                }
            }
        }
        catch (Exception e) {
            log.error("TaskTodoWaitService handler error:{}", (Throwable)e);
        }
    }

    public void addTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getWaitDoneList())) {
            log.info("addTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycUccTodoWaitDoneProviderService.dycUccAddTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    public void cancelTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getCancelList())) {
            log.info("cancelTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycUccTodoWaitDoneProviderService.dycUccCancelTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    public void doneTodoWait(TodoWaitAbilityReqBO todoWaitAbilityReqBO) {
        if (!CollectionUtils.isEmpty(todoWaitAbilityReqBO.getDoneList())) {
            log.info("doneTodoWait todoWaitAbilityReqBO:{}", (Object)JSON.toJSONString((Object)todoWaitAbilityReqBO));
            this.dycUccTodoWaitDoneProviderService.dycUccDoneTodoWaitDoneProvider(todoWaitAbilityReqBO);
        }
    }

    private TodoWaitAbilityReqBO operatorAddApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO1;
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorAddApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        String regAccount = userCode.get(0).getRegAccount();
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        Long nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        if (Objects.nonNull(nextStationId) && (dycStationOrgSelectUserNameRspBO1 = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO1.getUserList() != null && dycStationOrgSelectUserNameRspBO1.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO1.getUserList();
            log.info("operatorAddApproval add userCode:{},objId:{}", (Object)JSON.toJSONString((Object)userList), (Object)objId);
            UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(objId.toString());
            todoPassWaitAbilityReqBO.setExt1(uccSkuPo.getSkuCode());
            todoPassWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                todoAddWaitDoneAbilityReqBO.setObjNo(uccSkuPo.getSkuCode());
                todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                return todoAddWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorCancelApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        log.info("operatorCancelApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)objId);
        String regAccount = userCode.get(0).getRegAccount();
        String stationId = todoUccWaitAbilityReqBO.getStationId();
        DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.listUser(stationId);
        if (dycStationOrgSelectUserNameRspBO != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
            List userList = dycStationOrgSelectUserNameRspBO.getUserList();
            List collect = userList.stream().filter($ -> !$.getLoginName().equals(regAccount)).collect(Collectors.toList());
            log.info("operatorCancelApproval cancel userCode:{},ObjId:{}", (Object)JSON.toJSONString(collect), (Object)objId);
            todoPassWaitAbilityReqBO.setCancelList(collect.stream().map(user -> {
                TodoCancelWaitDoneAbilityReqBO todoCancelWaitDoneAbilityReqBO = new TodoCancelWaitDoneAbilityReqBO();
                todoCancelWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                todoCancelWaitDoneAbilityReqBO.setObjId(objId.toString());
                return todoCancelWaitDoneAbilityReqBO;
            }).collect(Collectors.toList()));
        }
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorDoneApproval(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
        List<MemberAbilityBO> userCode = this.getUserCode(strings);
        log.info("operatorDoneApproval done userCode:{},objId:{}", (Object)JSON.toJSONString(userCode), (Object)todoUccWaitAbilityReqBO.getObjId());
        String regAccount = userCode.get(0).getRegAccount();
        TodoWaitAbilityReqBO todoPassWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        todoPassWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
        todoPassWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
        todoPassWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
        todoPassWaitAbilityReqBO.setHandleUserNo(regAccount);
        todoPassWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
        TodoAddAlreadyDoneAbilityReqBO todoAddAlreadyDoneAbilityReqBO = new TodoAddAlreadyDoneAbilityReqBO();
        todoAddAlreadyDoneAbilityReqBO.setObjId(todoUccWaitAbilityReqBO.getObjId().toString());
        todoAddAlreadyDoneAbilityReqBO.setAuditStatus(uocApprovalLogPO.getAuditResult() == 0 ? Boolean.TRUE : Boolean.FALSE);
        todoAddAlreadyDoneAbilityReqBO.setFinishYn(uocApprovalLogPO.getFinish() == 0 ? Boolean.FALSE : Boolean.TRUE);
        todoAddAlreadyDoneAbilityReqBO.setFinishTime(new Date());
        todoPassWaitAbilityReqBO.setDoneList(Collections.singletonList(todoAddAlreadyDoneAbilityReqBO));
        return todoPassWaitAbilityReqBO;
    }

    private TodoWaitAbilityReqBO operatorSubmit(UocApprovalLogPO uocApprovalLogPO, TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        if (Objects.isNull(uocApprovalLogPO)) {
            log.info("uocApprovalLogPO is null objId:{}", (Object)todoUccWaitAbilityReqBO.getObjId());
            return null;
        }
        Long nextStationId = uocApprovalLogPO.getNextStationId();
        Long objId = todoUccWaitAbilityReqBO.getObjId();
        TodoWaitAbilityReqBO todoWaitAbilityReqBO = new TodoWaitAbilityReqBO();
        UccSkuPo uccSkuPo = null;
        if (Objects.nonNull(nextStationId)) {
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO;
            uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(objId.toString());
            if (Objects.isNull(uccSkuPo)) {
                uccSkuPo = new UccSkuPo();
                uccSkuPo.setCommodityId(objId);
                List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty(uccSkuPos)) {
                    Assert.notEmpty(uccSkuPos, (String)"\u672a\u77e5\u7684OBJ_ID\u7c7b\u578b");
                }
                uccSkuPo = uccSkuPos.get(0);
            }
            if ((dycStationOrgSelectUserNameRspBO = this.listUser(nextStationId.toString())) != null && dycStationOrgSelectUserNameRspBO.getUserList() != null && dycStationOrgSelectUserNameRspBO.getUserList().size() > 0) {
                List userList = dycStationOrgSelectUserNameRspBO.getUserList();
                log.info("dycStationOrgSelectUserNameRspBO userList:{}", (Object)JSON.toJSONString((Object)userList));
                todoWaitAbilityReqBO.setBusiCode(todoUccWaitAbilityReqBO.getBusiCode());
                todoWaitAbilityReqBO.setBusiName(todoUccWaitAbilityReqBO.getBusiName());
                todoWaitAbilityReqBO.setCenterCode(todoUccWaitAbilityReqBO.getCenterCode());
                todoWaitAbilityReqBO.setExt1(uccSkuPo.getSkuCode());
                if (Objects.nonNull(uocApprovalLogPO.getOperid())) {
                    List<Long> strings = Collections.singletonList(Long.parseLong(uocApprovalLogPO.getOperid()));
                    List<MemberAbilityBO> userCode = this.getUserCode(strings);
                    todoWaitAbilityReqBO.setOperatorId(userCode.get(0).getRegAccount());
                    todoWaitAbilityReqBO.setOperatorName(uocApprovalLogPO.getOperName());
                }
                todoWaitAbilityReqBO.setSystemCode(TaskWaitDoneEnum.YG);
                UccSkuPo finalUccSkuPo = uccSkuPo;
                todoWaitAbilityReqBO.setWaitDoneList(userList.stream().map(user -> {
                    TodoAddWaitDoneAbilityReqBO todoAddWaitDoneAbilityReqBO = new TodoAddWaitDoneAbilityReqBO();
                    todoAddWaitDoneAbilityReqBO.setObjId(objId.toString());
                    todoAddWaitDoneAbilityReqBO.setObjNo(finalUccSkuPo.getSkuCode());
                    todoAddWaitDoneAbilityReqBO.setHandleUserNo(user.getLoginName());
                    todoAddWaitDoneAbilityReqBO.setHandleUserName(user.getName());
                    return todoAddWaitDoneAbilityReqBO;
                }).collect(Collectors.toList()));
            }
        }
        return todoWaitAbilityReqBO;
    }

    private List<MemberAbilityBO> getUserCode(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return null;
        }
        UmcTaskReqBO umcTaskReqBO = new UmcTaskReqBO();
        umcTaskReqBO.setMemIds(userIds);
        UmcTaskRspBO user = this.umcAddTaskAbilityService.qryTaskUser(umcTaskReqBO);
        if (Objects.isNull(user) || CollectionUtils.isEmpty((Collection)user.getList())) {
            return null;
        }
        return user.getList();
    }

    private DycStationOrgSelectUserNameRspBO listUser(String nextStationId) {
        DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
        dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(Long.parseLong(nextStationId)));
        return this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
    }

    @Override
    public UocApprovalLogPO listApproval(Long objId) {
        return this.uocApprovalObjMapper.queryApproverLog(objId).stream().filter($ -> Objects.nonNull($)).max(Comparator.comparing(UocApprovalLogPO::getDealTime)).orElse(null);
    }

    private void assertParam(TodoUccWaitAbilityReqBO todoUccWaitAbilityReqBO) {
        Assert.notNull((Object)todoUccWaitAbilityReqBO, (String)"PARAM_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getObjId(), (String)"OBJID_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getOperatorType(), (String)"OPERATOR_IS_NULL");
        Assert.notNull((Object)todoUccWaitAbilityReqBO.getBusiCode(), (String)"\u5c0f\u5206\u7c7b\u5f85\u529e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
    }
}

