/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.base.bo.OrderColumBo;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.SearchEsSQLService;
import com.tydic.commodity.busibase.busi.bo.SearchEsSQLReqBO;
import com.tydic.commodity.busibase.busi.bo.SearchEsSQLRspBO;
import com.tydic.commodity.busibase.busi.bo.UccFieldsSearchEsBo;
import com.tydic.commodity.busibase.busi.bo.UccFieldsSearchExtEsBo;
import com.tydic.commodity.busibase.comb.bo.QueryParamBO;
import com.tydic.commodity.busibase.comb.bo.SourceCatalogBo;
import com.tydic.commodity.busibase.comb.bo.SourceTypeBo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.index.query.functionscore.ScoreFunctionBuilder;
import org.elasticsearch.index.query.functionscore.WeightBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchEsSQLServiceImpl
implements SearchEsSQLService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEsSQLServiceImpl.class);
    @Value(value="${search_phrase}")
    private String searchPhrase;
    @Autowired
    private CacheClient cacheClient;
    @Value(value="${analyzer_tokens}")
    private Boolean analyzerTokens;

    /*
     * WARNING - void declaration
     */
    @Override
    public SearchEsSQLRspBO buildSQL(SearchEsSQLReqBO searchEsSQLReqBO) {
        void var8_36;
        long[] skus;
        int i;
        SearchEsSQLRspBO searchBarEsSQLRspBO = new SearchEsSQLRspBO();
        searchBarEsSQLRspBO.setLevel(searchEsSQLReqBO.getLevel());
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder inBoolQueryBuilder = QueryBuilders.boolQuery();
        if (searchEsSQLReqBO.getSceneId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"scene_id", (Object)searchEsSQLReqBO.getSceneId()));
        }
        if (searchEsSQLReqBO.getSkuStatus() != null && searchEsSQLReqBO.getSkuStatus().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", searchEsSQLReqBO.getSkuStatus()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        if (searchEsSQLReqBO.getSearchChannel() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)searchEsSQLReqBO.getSearchChannel()));
        }
        if (searchEsSQLReqBO.getSupplierShopIds() != null && searchEsSQLReqBO.getSupplierShopIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_shop_id", searchEsSQLReqBO.getSupplierShopIds()));
        }
        if (searchEsSQLReqBO.getSupplierId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)searchEsSQLReqBO.getSupplierId()));
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getMerchantId() != null) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)searchEsSQLReqBO.getMerchantId()));
        }
        if (searchEsSQLReqBO.getBrandIds() != null && searchEsSQLReqBO.getBrandIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"brand_id", searchEsSQLReqBO.getBrandIds()));
        }
        if (searchEsSQLReqBO.getVendorId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)searchEsSQLReqBO.getVendorId()));
        }
        if (searchEsSQLReqBO.getTypeId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)searchEsSQLReqBO.getTypeId()));
        }
        if (StringUtils.isNotEmpty((String)searchEsSQLReqBO.getTypeName())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_name", (String)searchEsSQLReqBO.getTypeName()));
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getSourceAssort())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sourceAssort", searchEsSQLReqBO.getSourceAssort()));
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getIgnoreSourceAssort())) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sourceAssort", searchEsSQLReqBO.getIgnoreSourceAssort()));
        }
        if (searchEsSQLReqBO.getCommdIds() != null && searchEsSQLReqBO.getCommdIds().size() > 0) {
            long[] commd = new long[searchEsSQLReqBO.getCommdIds().size()];
            for (i = 0; i < searchEsSQLReqBO.getCommdIds().size(); ++i) {
                commd[i] = searchEsSQLReqBO.getCommdIds().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (long[])commd));
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getExtSkuIds())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"ext_sku_id.keyword", searchEsSQLReqBO.getExtSkuIds()));
        }
        if (searchEsSQLReqBO.getSkuList() != null && searchEsSQLReqBO.getSkuList().size() > 0) {
            skus = new long[searchEsSQLReqBO.getSkuList().size()];
            for (i = 0; i < searchEsSQLReqBO.getSkuList().size(); ++i) {
                skus[i] = searchEsSQLReqBO.getSkuList().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (!StringUtils.isEmpty((String)searchEsSQLReqBO.getSkuName())) {
            WildcardQueryBuilder queryBuilder1 = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + searchEsSQLReqBO.getSkuName() + "*"));
            extBoolQueryBuilder.must((QueryBuilder)queryBuilder1);
        }
        if (searchEsSQLReqBO.getIgnoreList() != null && searchEsSQLReqBO.getIgnoreList().size() > 0) {
            skus = new long[searchEsSQLReqBO.getIgnoreList().size()];
            for (i = 0; i < searchEsSQLReqBO.getIgnoreList().size(); ++i) {
                skus[i] = searchEsSQLReqBO.getIgnoreList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (searchEsSQLReqBO.getIgnoreCommdList() != null && searchEsSQLReqBO.getIgnoreCommdList().size() > 0) {
            long[] spus = new long[searchEsSQLReqBO.getIgnoreCommdList().size()];
            for (i = 0; i < searchEsSQLReqBO.getIgnoreCommdList().size(); ++i) {
                spus[i] = searchEsSQLReqBO.getIgnoreCommdList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (long[])spus));
        }
        if (searchEsSQLReqBO.getIgnoreAgrList() != null && searchEsSQLReqBO.getIgnoreAgrList().size() > 0) {
            long[] agrs = new long[searchEsSQLReqBO.getIgnoreAgrList().size()];
            for (i = 0; i < searchEsSQLReqBO.getIgnoreAgrList().size(); ++i) {
                agrs[i] = searchEsSQLReqBO.getIgnoreAgrList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_id", (long[])agrs));
        }
        if (searchEsSQLReqBO.getCategoryIds() != null && searchEsSQLReqBO.getCategoryIds().size() > 0 && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", searchEsSQLReqBO.getCategoryIds()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", searchEsSQLReqBO.getCategoryIds()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", searchEsSQLReqBO.getCategoryIds()));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SearchEsSQLServiceImpl \uff1a \u8d70\u67e5\u8be2\u8ff7\u7cca\u5339\u914d search_phrase\uff1a" + this.searchPhrase);
        }
        float minScore = 4.0f;
        if (!StringUtils.isEmpty((String)searchEsSQLReqBO.getQueryStr())) {
            boolean isFunction;
            Object fields;
            void var8_19;
            FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder);
            Iterator<Serializable> obj = this.cacheClient.get("UCC_FIELDS_SEARCH");
            Object var8_17 = null;
            if (obj != null) {
                try {
                    UccFieldsSearchEsBo uccFieldsSearchEsBo = (UccFieldsSearchEsBo)JSONObject.parseObject((String)JSONObject.toJSONString(obj), UccFieldsSearchEsBo.class);
                }
                catch (Exception e) {
                    LOGGER.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a " + JSONObject.toJSONString(obj));
                }
            }
            if (var8_19 != null) {
                minScore = var8_19.getMinScore().floatValue();
                fields = new HashedMap();
                HashedMap fieldsf = new HashedMap();
                if ((!this.analyzerTokens.booleanValue() || searchEsSQLReqBO.getIsAnalyzer() != null) && searchEsSQLReqBO.getIsAnalyzer().booleanValue()) {
                    fieldsf.put("sku_name", Float.valueOf(1.0f));
                    fieldsf.put("commodity_name", Float.valueOf(1.0f));
                    fieldsf.put("search_name", Float.valueOf(1.0f));
                } else {
                    Map<Integer, List<UccFieldsSearchExtEsBo>> fieldsListMap = this.groupByfieldsType(var8_19.getFields());
                    if (!fieldsListMap.isEmpty()) {
                        for (Map.Entry<Integer, List<UccFieldsSearchExtEsBo>> entry : fieldsListMap.entrySet()) {
                            if (entry.getKey() == 3) {
                                fields = entry.getValue().stream().collect(Collectors.toMap(UccFieldsSearchExtEsBo::getFields, UccFieldsSearchExtEsBo::getBoot));
                                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$") && fields.containsKey("properties")) {
                                    fields.remove("properties");
                                }
                            }
                            if (!searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$") || entry.getKey() != 1) continue;
                            for (UccFieldsSearchExtEsBo field : entry.getValue()) {
                                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field.getFields(), (Object)searchEsSQLReqBO.getQueryStr()).boost(field.getBoot().floatValue()));
                            }
                        }
                    }
                    for (Map.Entry<Integer, List<UccFieldsSearchExtEsBo>> entry : fields.entrySet()) {
                        fieldsf.put(entry.getKey(), Float.valueOf(((BigDecimal)((Object)entry.getValue())).floatValue()));
                    }
                }
                if ("true".equals(this.searchPhrase)) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).type((Object)var8_19.getParseField()).tieBreaker(1.0f).type((Object)"phrase").slop(var8_19.getSlop().intValue()));
                } else {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).minimumShouldMatch(new StringBuffer(var8_19.getAnalysisModulus().toString()).append("%").toString()).type((Object)var8_19.getParseField()).analyzer(var8_19.getAnalyzer())).boost();
                }
            } else if ("true".equals(this.searchPhrase)) {
                String[] fileNames = new String[]{"ext_sku_id", "sku_name", "commodity_name", "brand_name", "supplier_name", "l2_category_name", "l3_category_name", "properties", "manufacturer", "figure", "model", "material_name", "l4mg_category_name"};
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])fileNames).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).tieBreaker(1.0f).type((Object)"phrase").slop(20));
                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)searchEsSQLReqBO.getQueryStr()));
                }
            } else {
                fields = new HashedMap();
                if ((!this.analyzerTokens.booleanValue() || searchEsSQLReqBO.getIsAnalyzer() != null) && searchEsSQLReqBO.getIsAnalyzer().booleanValue()) {
                    fields.put("sku_name", Float.valueOf(1.0f));
                    fields.put("commodity_name", Float.valueOf(1.0f));
                    fields.put("search_name", Float.valueOf(1.0f));
                } else {
                    fields.put("type_name", Float.valueOf(20.0f));
                    fields.put("brand_name", Float.valueOf(12.0f));
                    fields.put("supplier_name", Float.valueOf(10.0f));
                    fields.put("l3_category_name", Float.valueOf(10.0f));
                    fields.put("l2_category_name", Float.valueOf(7.0f));
                    fields.put("sku_name", Float.valueOf(5.0f));
                    fields.put("ext_sku_id", Float.valueOf(1.0f));
                    fields.put("properties", Float.valueOf(1.0f));
                    fields.put("manufacturer", Float.valueOf(1.0f));
                    fields.put("figure", Float.valueOf(1.0f));
                    fields.put("model", Float.valueOf(1.0f));
                    fields.put("material_name", Float.valueOf(1.0f));
                    fields.put("l4mg_category_name", Float.valueOf(1.0f));
                }
                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$") && fields.containsKey("properties")) {
                    fields.remove("properties");
                }
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fields).minimumShouldMatch("95%").type(MultiMatchQueryBuilder.Type.MOST_FIELDS).analyzer("ik_smart")).boost();
                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)searchEsSQLReqBO.getQueryStr())).boost(20.0f);
                }
            }
            extBoolQueryBuilder.must((QueryBuilder)inBoolQueryBuilder);
            boolean bl = this.analyzerTokens != false && searchEsSQLReqBO.getIsAnalyzer() == null ? false : (isFunction = searchEsSQLReqBO.getIsAnalyzer() != false && !CollectionUtils.isEmpty(searchEsSQLReqBO.getCategoryIds()));
            if (isFunction) {
                ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder> functionBuilder = new ArrayList<FunctionScoreQueryBuilder.FilterFunctionBuilder>();
                int categoryIdSize = searchEsSQLReqBO.getCategoryIds().size();
                for (int i2 = 0; i2 < categoryIdSize; ++i2) {
                    WeightBuilder weightBuilder = new WeightBuilder();
                    weightBuilder.setWeight((float)Math.pow(2.0, (double)categoryIdSize - (double)i2));
                    TermQueryBuilder termQuery = QueryBuilders.termQuery((String)"l3_category_id", (Object)searchEsSQLReqBO.getCategoryIds().get(i2));
                    FunctionScoreQueryBuilder.FilterFunctionBuilder category = new FunctionScoreQueryBuilder.FilterFunctionBuilder((QueryBuilder)termQuery, (ScoreFunctionBuilder)weightBuilder);
                    functionBuilder.add(category);
                }
                functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder, (FunctionScoreQueryBuilder.FilterFunctionBuilder[])functionBuilder.toArray(new FunctionScoreQueryBuilder.FilterFunctionBuilder[functionBuilder.size()]));
                searchBarEsSQLRspBO.setLevel(null);
            }
            functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.SUM);
            functionScoreQueryBuilder.boostMode(CombineFunction.MULTIPLY);
            functionScoreQueryBuilder.maxBoost(minScore);
            if (!StringUtils.isEmpty((String)searchEsSQLReqBO.getQueryStr())) {
                functionScoreQueryBuilder.setMinScore(minScore);
            }
            searchBarEsSQLRspBO.setFunctionScoreQueryBuilder(functionScoreQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getSearchSourceList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (SourceCatalogBo sourceCatalogBo : searchEsSQLReqBO.getSearchSourceList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (sourceCatalogBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)sourceCatalogBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty(sourceCatalogBo.getCatalog())) {
                    if (sourceCatalogBo.getCatalogLevel() != null && sourceCatalogBo.getCatalogLevel() == 1) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", sourceCatalogBo.getCatalog()));
                    } else if (sourceCatalogBo.getCatalogLevel() != null && sourceCatalogBo.getCatalogLevel() == 2) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", sourceCatalogBo.getCatalog()));
                    } else {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", sourceCatalogBo.getCatalog()));
                    }
                }
                if (sourceCatalogBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)sourceCatalogBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getSearchLevelList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (SourceCatalogBo sourceCatalogBo : searchEsSQLReqBO.getSearchLevelList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (!CollectionUtils.isEmpty(sourceCatalogBo.getCatalog())) {
                    if (sourceCatalogBo.getCatalogLevel() != null && sourceCatalogBo.getCatalogLevel() == 1) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", sourceCatalogBo.getCatalog()));
                    } else if (sourceCatalogBo.getCatalogLevel() != null && sourceCatalogBo.getCatalogLevel() == 2) {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", sourceCatalogBo.getCatalog()));
                    } else {
                        authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", sourceCatalogBo.getCatalog()));
                    }
                }
                authorityextBoolQueryBuilder.must((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getSearchTypeList())) {
            BoolQueryBuilder authorityextBoolQueryBuilder = QueryBuilders.boolQuery();
            for (SourceTypeBo sourceTypeBo : searchEsSQLReqBO.getSearchTypeList()) {
                BoolQueryBuilder authorityinBoolQueryBuilder = QueryBuilders.boolQuery();
                if (sourceTypeBo.getSkuSource() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)sourceTypeBo.getSkuSource()));
                }
                if (!CollectionUtils.isEmpty(sourceTypeBo.getType())) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", sourceTypeBo.getType()));
                }
                if (sourceTypeBo.getVendorId() != null) {
                    authorityinBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)sourceTypeBo.getVendorId()));
                }
                authorityextBoolQueryBuilder.should((QueryBuilder)authorityinBoolQueryBuilder);
            }
            extBoolQueryBuilder.must((QueryBuilder)authorityextBoolQueryBuilder);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i3 = 0; i3 < searchEsSQLReqBO.getQueryParams().size(); ++i3) {
                int j;
                QueryParamBO queryParamBO = searchEsSQLReqBO.getQueryParams().get(i3);
                hiddenParamsForRsp.add(queryParamBO.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(queryParamBO.getFilterId())) {
                    for (j = 0; j < queryParamBO.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_name.keyword", (String)queryParamBO.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(queryParamBO.getFilterId())) {
                    for (j = 0; j < queryParamBO.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_name.keyword", (String)queryParamBO.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("l3_category_id_name".equals(queryParamBO.getFilterId())) {
                    for (j = 0; j < queryParamBO.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_name.keyword", (String)queryParamBO.getFilterValues().get(j))));
                    }
                    if (!this.analyzerTokens.booleanValue()) continue;
                    hiddenParamsForRsp.remove(queryParamBO.getFilterId());
                    continue;
                }
                if ("vendor_id_name".equals(queryParamBO.getFilterId())) {
                    for (j = 0; j < queryParamBO.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name.keyword", (String)queryParamBO.getFilterValues().get(j))));
                    }
                    continue;
                }
                for (j = 0; j < queryParamBO.getFilterValues().size(); ++j) {
                    extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.matchQuery((String)"properties", (Object)queryParamBO.getFilterValues().get(j))));
                }
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                extBoolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String string = "";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                String string2 = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                String string3 = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                String string4 = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                String string5 = "discounts";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 5) {
                String string6 = "comment_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 7) {
                String string7 = "ecommerce_sale";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 6) {
                String string8 = "view_order";
            }
        }
        List<Object> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (!var8_36.isEmpty()) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)var8_36).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        if (!CollectionUtils.isEmpty(searchEsSQLReqBO.getOrderColum()) && searchEsSQLReqBO.getOrderByColumn() == 0) {
            fieldSortBuilders = !org.apache.commons.collections.CollectionUtils.isEmpty(searchBarEsSQLRspBO.getSortQuery()) ? searchBarEsSQLRspBO.getSortQuery() : new ArrayList();
            for (OrderColumBo each : searchEsSQLReqBO.getOrderColum()) {
                orderType = SortOrder.DESC;
                if (each.getOrderType() != null && each.getOrderType() == 1) {
                    orderType = SortOrder.ASC;
                }
                fieldSortBuilders.add((FieldSortBuilder)SortBuilders.fieldSort((String)each.getOrderByColumn()).order(orderType));
            }
            searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        }
        searchBarEsSQLRspBO.setBoolQueryBuilder(extBoolQueryBuilder);
        searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchBarEsSQLRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        return searchBarEsSQLRspBO;
    }

    private Map<Integer, List<UccFieldsSearchExtEsBo>> groupByfieldsType(List<UccFieldsSearchExtEsBo> fields) {
        Object map = new HashedMap();
        if (CollectionUtils.isEmpty(fields)) {
            return map;
        }
        map = fields.stream().collect(Collectors.groupingBy(UccFieldsSearchExtEsBo::getFieldsType));
        return map;
    }
}

