/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.config;

import com.alibaba.fastjson.JSONObject;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElasticsearchUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchUtil.class);
    @Autowired
    private RestHighLevelClient client;
    private static ObjectMapper mapper = new ObjectMapper();
    private static final int batchSize = 1000;

    public boolean deleteIndex(String index) {
        DeleteIndexRequest request = new DeleteIndexRequest(index);
        try {
            DeleteIndexResponse indexResponse = this.client.indices().delete(request, new Header[0]);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u5220\u9664\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public void updateIndex(Map<String, Object> map, String index, String type, String id) {
        try {
            XContentBuilder builder = XContentFactory.jsonBuilder();
            builder.startObject();
            for (String key : map.keySet()) {
                builder.field(key, map.get(key));
            }
            builder.endObject();
            UpdateRequest updateRequest = new UpdateRequest(index, type, id).doc(builder);
            this.client.update(updateRequest, new Header[0]);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25\uff1a" + e);
        }
    }

    public boolean createIndex(String index) {
        CreateIndexRequest request = new CreateIndexRequest(index);
        try {
            CreateIndexResponse indexResponse = this.client.indices().create(request, new Header[0]);
            if (indexResponse.isAcknowledged()) {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u6210\u529f");
            } else {
                LOGGER.info("\u521b\u5efa\u7d22\u5f15\u5931\u8d25");
            }
            return indexResponse.isAcknowledged();
        }
        catch (IOException e) {
            LOGGER.error("\u521b\u5efa\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public String addData(String index, String type, String id, JSONObject object) {
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)object), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest(index, type, id);
            updateRequest.doc(mapper.writeValueAsString((Object)object), XContentType.JSON).upsert(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, new Header[0]);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
            return rspose.getId();
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return null;
        }
    }

    public void addBatch(String index, String type, List<Map<String, JSONObject>> list) {
        if (list.isEmpty()) {
            return;
        }
        int pages = (int)Math.ceil((double)list.size() / 1000.0);
        for (int i = 0; i < pages; ++i) {
            List<Map<String, JSONObject>> subList = this.subList(list, 1000, i);
            this.dealBatch(index, type, subList);
            LOGGER.info("\u6279\u91cf\u5904\u7406\u7b2c--" + i + "\u6b21,\u5171\u8ba1:" + subList.size() + "--\u6761...");
        }
        LOGGER.info("\u63d2\u5165\u5b8c\u6bd5\uff0c\u5171\u8ba1:" + list.size() + "--\u6761...");
    }

    public List<Map<String, JSONObject>> subList(List<Map<String, JSONObject>> dataList, int pageSize, int currentPage) {
        ArrayList<Map<String, JSONObject>> currentPageList = new ArrayList<Map<String, JSONObject>>();
        if (dataList != null && dataList.size() > 0) {
            int currIdx = currentPage > 0 ? currentPage * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Map<String, JSONObject> map = dataList.get(currIdx + i);
                currentPageList.add(map);
            }
        }
        return currentPageList;
    }

    private void dealBatch(String index, String type, List<Map<String, JSONObject>> list) {
        BulkRequest request = new BulkRequest();
        list.forEach(map -> {
            for (Map.Entry entry : map.entrySet()) {
                IndexRequest indexRequest = new IndexRequest(index, type, (String)entry.getKey());
                try {
                    indexRequest.source(mapper.writeValueAsString(entry.getValue()), XContentType.JSON);
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("json\u5e8f\u5217\u5316\u5931\u8d25", (Throwable)e);
                }
                request.add(indexRequest);
            }
        });
        try {
            BulkResponse responses = this.client.bulk(request, new Header[0]);
            if (responses.hasFailures()) {
                LOGGER.info("\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e!");
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6279\u91cf\u63d2\u5165\u6709\u5931\u8d25\u6570\u636e\uff1a" + e);
        }
    }

    public Boolean deleteDataByCondition(String endPoint, JSONObject qryJson) {
        boolean deleteResult = false;
        try (NStringEntity entity = new NStringEntity(qryJson.toJSONString(), ContentType.APPLICATION_JSON);){
            JSONObject deleteResultJson;
            int deleteCount;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (StringUtils.isNotBlank((CharSequence)result) && (deleteCount = (deleteResultJson = JSONObject.parseObject((String)result)).getInteger("deleted").intValue()) > 0) {
                deleteResult = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("\u6839\u636e\u6761\u4ef6\u5220\u9664ES\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
        return deleteResult;
    }

    public Boolean updateData(String index, String type, String id, JSONObject qryJson) {
        boolean deleteResult = false;
        IndexRequest indexRequest = new IndexRequest(index, type, id);
        try {
            indexRequest.source(mapper.writeValueAsString((Object)qryJson), XContentType.JSON);
            UpdateRequest updateRequest = new UpdateRequest(index, type, id);
            updateRequest.doc(indexRequest);
            UpdateResponse rspose = this.client.update(updateRequest, new Header[0]);
            LOGGER.info(JSONObject.toJSONString((Object)rspose));
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("es \u66f4\u65b0\u5f02\u5e38\uff1a" + e.getMessage());
            return false;
        }
        return deleteResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String updateByQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_update_by_query";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        try (NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);){
            String result;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String string = result = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String doPostSendQuery(String index, String type, String qryJson) {
        String endPoint = "/" + index + "/" + type + "/_search";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        try (NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);){
            String result;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String string = result = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }

    public void bulkPutIndex(String index, String type, List<Map<String, Object>> list, String id) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        BulkRequest request = new BulkRequest();
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = list.get(i);
            if (!StringUtils.isEmpty((CharSequence)id)) {
                request.add(new IndexRequest(index, type, String.valueOf(map.get(id))).source(map, XContentType.JSON));
                continue;
            }
            if (map.containsKey("id")) {
                request.add(new IndexRequest(index, type, String.valueOf(map.remove("id"))).source(map, XContentType.JSON));
                continue;
            }
            request.add(new IndexRequest(index, type, null).source(map, XContentType.JSON));
        }
        try {
            this.client.bulk(request, new Header[0]);
        }
        catch (IOException e) {
            LOGGER.error("\u6279\u91cf\u63d2\u5165es \u5931\u8d25\uff1a" + e.getMessage());
        }
    }

    public boolean checkIndexExist(String index) {
        try {
            Response response = this.client.getLowLevelClient().performRequest("HEAD", index, new Header[0]);
            boolean exist = response.getStatusLine().getReasonPhrase().equals("OK");
            return exist;
        }
        catch (IOException e) {
            LOGGER.error("\u68c0\u67e5\u7d22\u5f15\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    public RestClient getLowLevelClient() {
        return this.client.getLowLevelClient();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getIndexAnalyze(String index, String qryJson) {
        String endPoint = "/" + index + "/_analyze";
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("source---->" + qryJson);
        }
        try (NStringEntity entity = new NStringEntity(qryJson, ContentType.APPLICATION_JSON);){
            String result;
            Response response = this.client.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String string = result = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            return "";
        }
    }
}

