/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateAtomService;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateCompareAbilityService;
import com.tydic.commodity.busibase.atom.bo.EsStorageSpuInfoBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomReqBO;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDataGovernPushSkuStateCompareAbilityServiceImpl
implements UccDataGovernPushSkuStateCompareAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDataGovernPushSkuStateCompareAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccDataGovernPushSkuStateAtomService uccDataGovernPushSkuStateAtomService;

    @Override
    public void compareDataGovernPushSkuState(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        this.batchPush1(esStorageSpuInfoBOS);
    }

    private void batchPush1(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        try {
            if (!CollectionUtils.isEmpty(esStorageSpuInfoBOS)) {
                List<Long> collect = esStorageSpuInfoBOS.stream().map(EsStorageSpuInfoBO::getSku_id).collect(Collectors.toList());
                BoolQueryBuilder boolQueryBuilder = this.buildEsSql(collect);
                String s = this.excuteEsSql(collect.size(), 1, boolQueryBuilder);
                String result = this.searchInfo(s);
                List<UccCombEsCommodityBo> esCommodityBos = this.dealSearchData(result);
                log.info("\u67e5\u8be2\u51fa\u6765\u7684\u539f\u5546\u54c1\u4fe1\u606f {}", (Object)JSON.toJSONString(esCommodityBos));
                if (!CollectionUtils.isEmpty(esCommodityBos)) {
                    Map<Long, Integer> oldStateMap = esCommodityBos.stream().collect(Collectors.toMap(UccCombEsCommodityBo::getSku_id, UccCombEsCommodityBo::getSku_status));
                    List<EsStorageSpuInfoBO> pushList = esStorageSpuInfoBOS.stream().filter(spuInfoBO -> oldStateMap.containsKey(spuInfoBO.getSku_id()) && !ObjectUtil.equal(oldStateMap.get(spuInfoBO.getSku_id()), (Object)spuInfoBO.getSku_status())).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(pushList)) {
                        this.dealPush1(pushList);
                    } else {
                        log.info("\u6ca1\u6709\u9700\u8981\u63a8\u9001\u72b6\u6001\u53d8\u66f4\u7684\u5546\u54c1");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u540c\u6b65\u6570\u636e\u6cbb\u7406\u72b6\u6001\u5904\u7406\u5931\u8d25" + e.getMessage());
        }
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private List<UccCombEsCommodityBo> dealSearchData(String result) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
            log.debug("result\u6570\u636e" + result);
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (!listObject.isEmpty()) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        return commodityModels;
    }

    private BoolQueryBuilder buildEsSql(List<Long> skuIds) {
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", skuIds));
        return boolQueryBuilder;
    }

    private String excuteEsSql(int pageSize, int pageNo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)pageSize);
        queryJson.put("from", (Object)(pageSize * (pageNo - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        JSONObject sourceFiltering = new JSONObject();
        sourceFiltering.put("includes", (Object)new String[]{"sku_id", "sku_status"});
        queryJson.put("_source", (Object)sourceFiltering);
        return queryJson.toString();
    }

    private void dealPush1(List<EsStorageSpuInfoBO> esStorageSpuInfoBOS) {
        try {
            List<UccDataGovernPushSkuStateAtomBO> pushList = esStorageSpuInfoBOS.stream().map(e -> {
                UccDataGovernPushSkuStateAtomBO atomBO = new UccDataGovernPushSkuStateAtomBO();
                atomBO.setSkuId(e.getSku_id());
                atomBO.setChangeTime(DateUtils.dateToStrLong((Date)new Date()));
                atomBO.setSkuStatus(e.getSku_status());
                return atomBO;
            }).collect(Collectors.toList());
            UccDataGovernPushSkuStateAtomReqBO stateAtomReqBO = new UccDataGovernPushSkuStateAtomReqBO();
            stateAtomReqBO.setPushSkuList(pushList);
            this.uccDataGovernPushSkuStateAtomService.dealDataGovernPushSkuState(stateAtomReqBO);
        }
        catch (Exception e1) {
            log.error("\u63a8\u9001\u72b6\u6001\u4fe1\u606f\u5931\u8d25 {}", (Object)e1.getMessage());
        }
    }
}

