/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.bo.UccDealHandlerTaskJobAbilityReqBO;
import com.tydic.commodity.base.bo.UccDealHandlerTaskJobAbilityRspBO;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerService;
import com.tydic.commodity.busibase.busi.api.UccDealHandlerTaskJobBusiService;
import com.tydic.commodity.dao.UccDealHandlerMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccDealHandlerPO;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.task.TaskTodoWaitService;
import com.tydic.commodity.task.bo.TodoUccWaitAbilityReqBO;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDealHandlerTaskJobBusiServiceImpl
implements UccDealHandlerTaskJobBusiService {
    @Autowired
    private UccDealHandlerMapper uccDealHandlerMapper;
    @Value(value="${ucc.handler.qryCount:10}")
    private Integer limitNum;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private UccDealHandlerService uccDealHandlerService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccDealHandlerTaskJobAbilityRspBO dealHandlerTaskJob(UccDealHandlerTaskJobAbilityReqBO reqBO) {
        this.val(reqBO);
        UccDealHandlerTaskJobAbilityRspBO rspBO = new UccDealHandlerTaskJobAbilityRspBO();
        if (reqBO.getAbPush().booleanValue()) {
            UccDealHandlerPO qryHandlerPO = new UccDealHandlerPO();
            qryHandlerPO.setExcuteStatus(0);
            List<UccDealHandlerPO> list = this.uccDealHandlerMapper.getList(qryHandlerPO);
            if (CollectionUtils.isEmpty(list)) {
                rspBO.setRespCode("0000");
                rspBO.setRespCode("\u6210\u529f");
                return rspBO;
            }
            List<Long> ids = list.stream().map(e -> e.getId()).collect(Collectors.toList());
            UccDealHandlerPO updatePO = new UccDealHandlerPO();
            updatePO.setIds(ids);
            updatePO.setExcuteStatus(1);
            updatePO.setOldExcuteStatus(0);
            int count = this.uccDealHandlerMapper.updateByIds(updatePO);
            if (count != ids.size()) {
                throw new BusinessException("8888", "\u6267\u884c\u5e42\u7b49\u5360\u7528\u5931\u8d25");
            }
            Map<String, List<UccDealHandlerPO>> typeMap = list.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOperatorType())).collect(Collectors.groupingBy(e -> e.getOperatorType()));
            this.dealHandler(typeMap.get("0"));
            this.dealHandler(typeMap.get("1"));
            this.dealHandler(typeMap.get("2"));
            updatePO = new UccDealHandlerPO();
            updatePO.setIds(ids);
            updatePO.setExcuteStatus(2);
            updatePO.setOldExcuteStatus(1);
            count = this.uccDealHandlerMapper.updateByIds(updatePO);
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u6210\u529f");
            return rspBO;
        }
        UccDealHandlerPO qryObjIdPO = new UccDealHandlerPO();
        qryObjIdPO.setLimitNum(this.limitNum);
        qryObjIdPO.setModNum(reqBO.getModNum());
        qryObjIdPO.setExcuteStatus(0);
        List<Long> objIds = this.uccDealHandlerMapper.getObjIdList(qryObjIdPO);
        if (CollectionUtils.isEmpty(objIds)) {
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u6210\u529f");
            return rspBO;
        }
        UccDealHandlerPO qryByObjIds = new UccDealHandlerPO();
        qryByObjIds.setObjIds(objIds);
        qryByObjIds.setExcuteStatus(0);
        List<UccDealHandlerPO> list = this.uccDealHandlerMapper.getList(qryByObjIds);
        if (CollectionUtils.isEmpty(list)) {
            rspBO.setRespCode("0000");
            rspBO.setRespCode("\u6210\u529f");
            return rspBO;
        }
        List<Long> ids = list.stream().map(e -> e.getId()).collect(Collectors.toList());
        UccDealHandlerPO updatePO = new UccDealHandlerPO();
        updatePO.setIds(ids);
        updatePO.setExcuteStatus(1);
        updatePO.setOldExcuteStatus(0);
        int count = this.uccDealHandlerMapper.updateByIds(updatePO);
        if (count != ids.size()) {
            throw new BusinessException("8888", "\u6267\u884c\u5e42\u7b49\u5360\u7528\u5931\u8d25");
        }
        Map<String, List<UccDealHandlerPO>> typeMap = list.stream().filter(e -> !StringUtils.isEmpty((Object)e.getOperatorType())).collect(Collectors.groupingBy(e -> e.getOperatorType()));
        this.dealHandler(typeMap.get("0"));
        this.dealHandler(typeMap.get("1"));
        this.dealHandler(typeMap.get("2"));
        updatePO = new UccDealHandlerPO();
        updatePO.setIds(ids);
        updatePO.setExcuteStatus(2);
        updatePO.setOldExcuteStatus(1);
        count = this.uccDealHandlerMapper.updateByIds(updatePO);
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccDealHandlerTaskJobAbilityRspBO dealUpdateHandlerStatus(UccDealHandlerTaskJobAbilityReqBO reqBO) {
        UccDealHandlerPO updatePO = new UccDealHandlerPO();
        updatePO.setIds(reqBO.getHandlerId());
        updatePO.setExcuteStatus(reqBO.getExcuteStatus());
        updatePO.setOldExcuteStatus(reqBO.getOldExcuteStatus());
        this.uccDealHandlerMapper.updateByIds(updatePO);
        UccDealHandlerTaskJobAbilityRspBO rspBO = new UccDealHandlerTaskJobAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }

    private void val(UccDealHandlerTaskJobAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!reqBO.getAbPush().booleanValue() && reqBO.getModNum() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[modNum]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void dealHandler(List<UccDealHandlerPO> pos) {
        if (!CollectionUtils.isEmpty(pos)) {
            pos = pos.stream().sorted(Comparator.comparing(UccDealHandlerPO::getCreateTime)).collect(Collectors.toList());
            for (UccDealHandlerPO po : pos) {
                TodoUccWaitAbilityReqBO todoAddWait = (TodoUccWaitAbilityReqBO)JSON.parseObject((String)JSON.toJSONString((Object)po), TodoUccWaitAbilityReqBO.class);
                todoAddWait.setUocApprovalLogPOStr(po.getExt1());
                if ("handler".equals(po.getHandleName())) {
                    UccSkuPo uccSkuPo = this.uccSkuMapper.querySkuInfoBySkuId(po.getObjId() + "");
                    if ("0".equals(po.getOperatorType()) && uccSkuPo != null && uccSkuPo.getApprovalStatus() == null) {
                        return;
                    }
                    this.taskTodoWaitService.handler(todoAddWait);
                    continue;
                }
                if ("brandHandler".equals(po.getHandleName())) {
                    this.taskTodoWaitService.brandHandler(todoAddWait);
                    continue;
                }
                if ("productApplyHandler".equals(po.getHandleName())) {
                    this.taskTodoWaitService.productApplyHandler(todoAddWait);
                    continue;
                }
                if (!"newBrandHandler".equals(po.getHandleName())) continue;
                this.taskTodoWaitService.newBrandHandler(todoAddWait);
            }
        }
    }
}

