/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.constant.PCodeConstant;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.UccEMdmCatalogEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuManagementListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuManagementListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UocApprovalObjMapper;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UocApprovalObjPO;
import com.tydic.commodity.po.UocSpuApproverLogPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuManagementListQryCombServiceImpl
implements UccSkuManagementListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuManagementListQryCombServiceImpl.class);
    private static final long serialVersionUID = 1956659951572577168L;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UocApprovalObjMapper uocApprovalObjMapper;
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${exclude_standard_com_tag:false}")
    private Boolean excludeStandardComTag;

    @Override
    public UccSkuManagementListQryCombRspBO getSkuManagementListQry(UccSkuManagementListQryCombReqBO reqBO) {
        BoolQueryBuilder extBoolQueryBuilder;
        String queryString;
        String result;
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        if (reqBO.getIsNoAgrSku() != null && reqBO.getOrgId() != null) {
            if ("0".equals(reqBO.getIsprofess())) {
                if (!StringUtils.isEmpty((Object)reqBO.getRunMainBodyId()) && !reqBO.getOrgPath().contains(reqBO.getRunMainBodyId())) {
                    rspBo.setTotal(0);
                    rspBo.setRespCode("0000");
                    rspBo.setRecordsTotal(0);
                    rspBo.setRows(new ArrayList());
                    return rspBo;
                }
                if (StringUtils.isEmpty((Object)reqBO.getRunMainBodyId())) {
                    String[] orgIds = reqBO.getOrgPath().split("-");
                    reqBO.setRunMainBodyIds(Arrays.asList(orgIds));
                }
            } else {
                reqBO.setSupplierOrgId(reqBO.getOrgId().toString());
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            rspBo.getRows().forEach(rspS -> {
                if (null != rspS.getIsSupermarketStaff()) {
                    if (rspS.getIsSupermarketStaff() == 0) {
                        rspS.setIsSupermarketStaffStr("\u7535\u5b50\u8d85\u5e02");
                    } else if (rspS.getIsSupermarketStaff() == 1) {
                        rspS.setIsSupermarketStaffStr("\u5458\u5de5\u8d85\u5e02");
                    } else if (rspS.getIsSupermarketStaff() == 2) {
                        rspS.setIsSupermarketStaffStr("\u7535\u5b50\u8d85\u5e02\u548c\u5458\u5de5\u8d85\u5e02");
                    }
                } else {
                    rspS.setIsSupermarketStaffStr("\u7535\u5b50\u8d85\u5e02");
                    rspS.setIsSupermarketStaff(0);
                }
            });
            List<Long> skus = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            if (!CollectionUtils.isEmpty(bathPrice)) {
                Map<Long, List<UccSkuPricePo>> UccSkuPricePoMap = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSkuId));
                for (UccSkuManagementListCombQryBO uccSkuManagementListCombQryBO : rspBo.getRows()) {
                    Iterator uccSkuPricePo;
                    List<UccSkuPricePo> uccSkuPricePos = UccSkuPricePoMap.get(uccSkuManagementListCombQryBO.getSkuId());
                    if (CollectionUtils.isEmpty(uccSkuPricePos) || ((UccSkuPricePo)((Object)(uccSkuPricePo = uccSkuPricePos.get(0)))).getReferencePriceEndSnapshot() == null || ((UccSkuPricePo)((Object)uccSkuPricePo)).getReferencePriceStartSnapshot() == null) continue;
                    Long l = ((UccSkuPricePo)((Object)uccSkuPricePo)).getReferencePriceStartSnapshot();
                    Long referencePriceEndSnapshot = ((UccSkuPricePo)((Object)uccSkuPricePo)).getReferencePriceEndSnapshot();
                    String referenceSnapshotStr = MoneyUtils.haoToYuan(l) + "-" + MoneyUtils.haoToYuan(referencePriceEndSnapshot);
                    uccSkuManagementListCombQryBO.setReferenceSnapshotStr(referenceSnapshotStr);
                }
            }
            SkuDataGovernSamePricePO pricePo = new SkuDataGovernSamePricePO();
            pricePo.setSkuIds(skus);
            pricePo.setType(1);
            List<SkuDataGovernSamePricePO> list = this.skuDataGovernSamePriceMapper.getList(pricePo);
            if (!CollectionUtils.isEmpty(list)) {
                Map<Long, List<SkuDataGovernSamePricePO>> skuSamePriceMap = list.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
                HashMap skuPriceMap = new HashMap();
                for (Map.Entry entry : skuSamePriceMap.entrySet()) {
                    List pricePOS = ((List)entry.getValue()).stream().filter(a -> a.getPrice() != null).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(pricePOS)) continue;
                    BigDecimal lowestPrice = ((SkuDataGovernSamePricePO)pricePOS.get(0)).getPrice();
                    for (SkuDataGovernSamePricePO pricePO : pricePOS) {
                        if (pricePO.getPrice().compareTo(lowestPrice) >= 0) continue;
                        lowestPrice = pricePO.getPrice();
                    }
                    skuPriceMap.put(entry.getKey(), lowestPrice);
                }
                for (UccSkuManagementListCombQryBO uccSkuManagementListCombQryBO : rspBo.getRows()) {
                    uccSkuManagementListCombQryBO.setLowestComPrice((BigDecimal)skuPriceMap.get(uccSkuManagementListCombQryBO.getSkuId()));
                }
            }
            if ((groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                Map<Long, List<UccLadderPricePO>> map = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = map.keySet().iterator();
                HashMap<Long, List> longListMap = new HashMap<Long, List>();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = map.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class);
                    eachBo.sort(new Comparator<UccEstoreLadderPriceBO>(){

                        @Override
                        public int compare(UccEstoreLadderPriceBO o1, UccEstoreLadderPriceBO o2) {
                            return o2.getStart().compareTo(o1.getStart());
                        }
                    });
                    for (UccEstoreLadderPriceBO each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccSkuManagementListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
            List<Long> ObjIds = rspBo.getRows().stream().map(UccSkuManagementListCombQryBO::getSkuId).collect(Collectors.toList());
            UocApprovalObjPO uocApprovalObjPO = new UocApprovalObjPO();
            uocApprovalObjPO.setObjIds(ObjIds);
            List<UocApprovalObjPO> list2 = this.uocApprovalObjMapper.getAuditOrderId(uocApprovalObjPO);
            Map<Object, Object> collect = new HashMap();
            if (!CollectionUtils.isEmpty(list2)) {
                collect = list2.parallelStream().collect(Collectors.toMap(UocApprovalObjPO::getObjId, Function.identity(), (c1, c2) -> c1.getCreateTime().getTime() > c2.getCreateTime().getTime() ? c1 : c2));
            }
            HashMap finalCollect = collect;
            rspBo.getRows().forEach($ -> {
                UocApprovalObjPO uocApprovalObjPOS;
                if (MapUtils.isNotEmpty((Map)finalCollect) && Objects.nonNull(uocApprovalObjPOS = (UocApprovalObjPO)finalCollect.get($.getSkuId()))) {
                    $.setObjType(uocApprovalObjPOS.getObjType());
                }
            });
        }
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        try {
            Response response = this.elasticsearchUtil.getLowLevelClient().performRequest("POST", endPoint, Collections.emptyMap(), (HttpEntity)entity, new Header[0]);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryCombReqBO reqBo) {
        BoolQueryBuilder boolQueryBuilderSon3;
        BoolQueryBuilder boolQueryBuilderSon2;
        RangeQueryBuilder abnormalFloat;
        RangeQueryBuilder referencePriceQb;
        WildcardQueryBuilder wildcardQuery;
        WildcardQueryBuilder wildcardQuery2;
        BoolQueryBuilder extBuilder;
        BoolQueryBuilder boolQueryBuilderSon32;
        BoolQueryBuilder boolQueryBuilderSon22;
        BoolQueryBuilder boolQueryBuilderSon1;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        log.info("--------------------\u67e5\u8be2\u53c2\u6570\uff1areqBo");
        if (reqBo.getIfMaterialCode() != null) {
            if (1 == reqBo.getIfMaterialCode()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"material_code"));
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_type", (int)2));
            } else {
                BoolQueryBuilder boolQueryBuilderSon12 = QueryBuilders.boolQuery();
                BoolQueryBuilder boolQueryBuilderSon23 = QueryBuilders.boolQuery();
                BoolQueryBuilder boolQueryBuilderSon33 = QueryBuilders.boolQuery();
                boolQueryBuilderSon23.must((QueryBuilder)QueryBuilders.termQuery((String)"material_type", (int)1));
                boolQueryBuilderSon23.must((QueryBuilder)QueryBuilders.existsQuery((String)"material_code"));
                boolQueryBuilderSon33.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"material_code"));
                boolQueryBuilderSon12.should((QueryBuilder)boolQueryBuilderSon23);
                boolQueryBuilderSon12.should((QueryBuilder)boolQueryBuilderSon33);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon12);
            }
        }
        RangeQueryBuilder soldNumberQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSoldNumberStart())) {
            soldNumberQb = QueryBuilders.rangeQuery((String)"sold_number").gte((Object)reqBo.getSoldNumberStart());
            boolQueryBuilder.must((QueryBuilder)soldNumberQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSoldNumberEnd())) {
            soldNumberQb = QueryBuilders.rangeQuery((String)"sold_number").lte((Object)reqBo.getSoldNumberEnd());
            boolQueryBuilder.must((QueryBuilder)soldNumberQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getGovernanceStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"governance_status.keyword", (String)reqBo.getGovernanceStatus()));
        }
        if (reqBo.getStandardComId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"standard_com_id", (Object)reqBo.getStandardComId()));
        }
        if (reqBo.getStandardFlagQry() != null && reqBo.getStandardFlagQry() == 1) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"standard_com_id"));
        }
        if (reqBo.getStandardFlagQry() != null && reqBo.getStandardFlagQry() == 2) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"standard_com_id"));
        }
        if (reqBo.getSurpassVpt() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"surpassVpt"));
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"surpassVpt", (Object)reqBo.getSurpassVpt()));
        }
        if ("1".equals(reqBo.getIgnoreStandardPriceSku())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"standardPrice"));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSurpassStandardPriceFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"surpassStandardPriceFlag", (String)reqBo.getSurpassStandardPriceFlag()));
            if ("1".equals(reqBo.getSurpassStandardPriceFlag())) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"surpassStandardPriceFlag", (String)reqBo.getSurpassStandardPriceFlag()));
            } else {
                boolQueryBuilderSon1 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22 = QueryBuilders.boolQuery();
                boolQueryBuilderSon32 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22.must((QueryBuilder)QueryBuilders.termQuery((String)"surpassStandardPriceFlag", (String)reqBo.getSurpassStandardPriceFlag()));
                boolQueryBuilderSon32.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"surpassStandardPriceFlag"));
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon22);
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon32);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
            }
        }
        if (reqBo.getIfGovern() != null) {
            if (1 == reqBo.getIfGovern()) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
            } else {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
            }
        }
        if (reqBo.getGovernResult() != null) {
            if (reqBo.getGovernResult() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"govern_result", (Object)reqBo.getGovernResult()));
            } else {
                boolQueryBuilderSon1 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22 = QueryBuilders.boolQuery();
                boolQueryBuilderSon32 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22.must((QueryBuilder)QueryBuilders.termQuery((String)"govern_result", (Object)reqBo.getGovernResult()));
                boolQueryBuilderSon32.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"govern_result"));
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon22);
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon32);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
            }
        }
        if (reqBo.getDataGovernFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"data_govern_flag", (Object)reqBo.getDataGovernFlag()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getGovernanceStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"governance_status.keyword", (String)reqBo.getGovernanceStatus()));
        }
        if (reqBo.getMaterialType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"material_type", (Object)reqBo.getMaterialType()));
        }
        if (reqBo.getShelfType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"onShelveWay", (Object)reqBo.getShelfType()));
        }
        if (reqBo.getBrandVerify() != null) {
            if (reqBo.getBrandVerify() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_verify", (Object)reqBo.getBrandVerify()));
            } else {
                boolQueryBuilderSon1 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22 = QueryBuilders.boolQuery();
                boolQueryBuilderSon32 = QueryBuilders.boolQuery();
                boolQueryBuilderSon22.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_verify", (Object)reqBo.getBrandVerify()));
                boolQueryBuilderSon32.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"brand_verify"));
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon22);
                boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon32);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
            }
        }
        if (reqBo.getTradeMode() != null && reqBo.getTradeMode() == 2) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBo.getTradeMode()));
        } else if (reqBo.getTradeMode() != null && reqBo.getTradeMode() == 1) {
            boolQueryBuilderSon1 = QueryBuilders.boolQuery();
            boolQueryBuilderSon22 = QueryBuilders.boolQuery();
            boolQueryBuilderSon32 = QueryBuilders.boolQuery();
            boolQueryBuilderSon22.must((QueryBuilder)QueryBuilders.termQuery((String)"tradeMode", (Object)reqBo.getTradeMode()));
            boolQueryBuilderSon32.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"tradeMode"));
            boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon22);
            boolQueryBuilderSon1.should((QueryBuilder)boolQueryBuilderSon32);
            boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon1);
        }
        if (reqBo.getBelongModule() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"belongModule", (Object)reqBo.getBelongModule()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getRunMainBodyId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"runMainBodyId.keyword", (String)reqBo.getRunMainBodyId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getRunMainBodyIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"runMainBodyId.keyword", reqBo.getRunMainBodyIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getBrandVerifyResultList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"brandVerifyResult", reqBo.getBrandVerifyResultList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sourceAssort", (Object)reqBo.getSourceAssort()));
        }
        if (reqBo.getApprovalStatus() != null) {
            if (reqBo.getApprovalStatus().equals(0)) {
                boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"sku_approval_status"));
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_approval_status", (Object)reqBo.getApprovalStatus()));
            }
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatusList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", reqBo.getApprovalStatusList()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSupplierIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_id", reqBo.getSupplierIds()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityTypeIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"type_id", reqBo.getCommodityTypeIds()));
        }
        if (reqBo.getSkuAddPrice() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"skuAddPrice", (Object)reqBo.getSkuAddPrice()));
        }
        try {
            Long timeBegin;
            RangeQueryBuilder qb = null;
            if (reqBo.getCreateTimeStart() != null && reqBo.getCreateTimeEnd() != null) {
                timeBegin = reqBo.getCreateTimeStart().getTime();
                String[] timeEnd = Long.valueOf(reqBo.getCreateTimeEnd().getTime());
                qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin).to((Object)timeEnd);
            } else {
                if (reqBo.getCreateTimeStart() != null) {
                    timeBegin = reqBo.getCreateTimeStart().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").from((Object)timeBegin);
                }
                if (reqBo.getCreateTimeEnd() != null) {
                    Long timeEnd = reqBo.getCreateTimeEnd().getTime();
                    qb = QueryBuilders.rangeQuery((String)"create_time").to((Object)timeEnd);
                }
            }
            if (qb != null) {
                boolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException("\u521b\u5efa\u65f6\u95f4\u8303\u56f4\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            if (reqBo.getExtSpuId().contains(",")) {
                String[] extSpuIds;
                extBuilder = QueryBuilders.boolQuery();
                for (String extSpuId : extSpuIds = reqBo.getExtSpuId().split(",")) {
                    wildcardQuery2 = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)(extSpuId + "*"));
                    extBuilder.should((QueryBuilder)wildcardQuery2);
                }
                boolQueryBuilder.must((QueryBuilder)extBuilder);
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)(reqBo.getExtSpuId() + "*")));
            }
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            if (reqBo.getExtSkuId().contains(",")) {
                String[] extSkuIds;
                extBuilder = QueryBuilders.boolQuery();
                for (String extSkuId : extSkuIds = reqBo.getExtSkuId().split(",")) {
                    extBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"ext_sku_id.keyword", (String[])new String[]{extSkuId}));
                }
                boolQueryBuilder.must((QueryBuilder)extBuilder);
            } else {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"ext_sku_id.keyword", (String)reqBo.getExtSkuId()));
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getIsSupermarketStaff() != null) {
            if (reqBo.getIsSupermarketStaff() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (Object)reqBo.getIsSupermarketStaff()));
            }
            if (reqBo.getIsSupermarketStaff() == 2) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (Object)reqBo.getIsSupermarketStaff()));
            }
            if (reqBo.getIsSupermarketStaff() == 0) {
                BoolQueryBuilder conditionsBuilder = QueryBuilders.boolQuery();
                BoolQueryBuilder conditionsBuilder1 = QueryBuilders.boolQuery();
                conditionsBuilder1.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"isSupermarketStaff"));
                conditionsBuilder.should((QueryBuilder)conditionsBuilder1);
                String[] conditionsBuilder2 = QueryBuilders.boolQuery();
                conditionsBuilder2.must((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (int)0));
                conditionsBuilder.should((QueryBuilder)conditionsBuilder2);
                boolQueryBuilder.must((QueryBuilder)conditionsBuilder);
            }
        } else {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"isSupermarketStaff", (String)"1"));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreVendorIds())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"vendor_id", reqBo.getIgnoreVendorIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreSupplierIds())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_id", reqBo.getIgnoreSupplierIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIsSupermarketStaffTow()) && reqBo.getIsSupermarketStaffTow().size() > 0) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"channel_id", reqBo.getIsSupermarketStaffTow()));
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getQueryField())) {
            BoolQueryBuilder queryFieldBuilder = new BoolQueryBuilder();
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)(reqBo.getQueryField() + "*")));
            queryFieldBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"type_name", (String)("*" + reqBo.getQueryField() + "*")));
            boolQueryBuilder.must((QueryBuilder)queryFieldBuilder);
        }
        if (ObjectUtil.isNotEmpty((Object)reqBo.getBrandVerifyResult())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brandVerifyResult", (Object)reqBo.getBrandVerifyResult()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)(reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)(reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)(reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getLongDesc())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"long_desc.keyword", (String)("*" + reqBo.getLongDesc() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            if (reqBo.getCommodityCode().contains(",")) {
                String[] commodityCodes;
                BoolQueryBuilder commodityCodeBuilder = QueryBuilders.boolQuery();
                for (String commodityCode : commodityCodes = reqBo.getCommodityCode().split(",")) {
                    wildcardQuery2 = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)(commodityCode + "*"));
                    commodityCodeBuilder.should((QueryBuilder)wildcardQuery2);
                }
                boolQueryBuilder.must((QueryBuilder)commodityCodeBuilder);
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)(reqBo.getCommodityCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            if (reqBo.getSkuCode().contains(",")) {
                String[] skuCodes;
                BoolQueryBuilder skuCodeBuilder = QueryBuilders.boolQuery();
                for (String skuCode : skuCodes = reqBo.getSkuCode().split(",")) {
                    wildcardQuery2 = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(skuCode + "*"));
                    skuCodeBuilder.should((QueryBuilder)wildcardQuery2);
                }
                boolQueryBuilder.must((QueryBuilder)skuCodeBuilder);
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)(reqBo.getSkuCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)(reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (reqBo.getUpCount() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"up_count", (Object)reqBo.getUpCount()));
        }
        RangeQueryBuilder discountQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            discountQb = QueryBuilders.rangeQuery((String)"discounts").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getReferencePriceStart())) {
            referencePriceQb = QueryBuilders.rangeQuery((String)"reference_price_start").gte((Object)reqBo.getReferencePriceStart());
            boolQueryBuilder.must((QueryBuilder)referencePriceQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getReferencePriceEnd())) {
            referencePriceQb = QueryBuilders.rangeQuery((String)"reference_price_end").lte((Object)reqBo.getReferencePriceEnd());
            boolQueryBuilder.must((QueryBuilder)referencePriceQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getAbnormalFloatStart())) {
            abnormalFloat = QueryBuilders.rangeQuery((String)"abnormal_float").gte((Object)reqBo.getAbnormalFloatStart());
            boolQueryBuilder.must((QueryBuilder)abnormalFloat);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getAbnormalFloatEnd())) {
            abnormalFloat = QueryBuilders.rangeQuery((String)"abnormal_float").lte((Object)reqBo.getAbnormalFloatEnd());
            boolQueryBuilder.must((QueryBuilder)abnormalFloat);
        }
        RangeQueryBuilder abnormalFloatStrQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getReferencePriceStart())) {
            abnormalFloatStrQb = QueryBuilders.rangeQuery((String)"abnormal_float_str").gte((Object)reqBo.getAbnormalFloatStrStart());
            boolQueryBuilder.must((QueryBuilder)abnormalFloatStrQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getReferencePriceEnd())) {
            abnormalFloatStrQb = QueryBuilders.rangeQuery((String)"abnormal_float_str").lte((Object)reqBo.getAbnormalFloatStrEnd());
            boolQueryBuilder.must((QueryBuilder)abnormalFloatStrQb);
        }
        if (this.excludeStandardComTag.booleanValue()) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"standard_flag", (int)1));
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (reqBo.getDiscountLimitValue() != null) {
            if (reqBo.getDiscountLimitValue() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"discountLimitValue", (Object)reqBo.getDiscountLimitValue()));
            } else {
                BoolQueryBuilder boolQueryBuilderSon13 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2 = QueryBuilders.boolQuery();
                boolQueryBuilderSon3 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2.must((QueryBuilder)QueryBuilders.termQuery((String)"discountLimitValue", (Object)reqBo.getDiscountLimitValue()));
                boolQueryBuilderSon3.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"discountLimitValue"));
                boolQueryBuilderSon13.should((QueryBuilder)boolQueryBuilderSon2);
                boolQueryBuilderSon13.should((QueryBuilder)boolQueryBuilderSon3);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon13);
            }
        }
        if (reqBo.getHide() != null) {
            if (reqBo.getHide() == 1) {
                boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"hide", (Object)reqBo.getHide()));
            } else {
                BoolQueryBuilder boolQueryBuilderSon14 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2 = QueryBuilders.boolQuery();
                boolQueryBuilderSon3 = QueryBuilders.boolQuery();
                boolQueryBuilderSon2.must((QueryBuilder)QueryBuilders.termQuery((String)"hide", (Object)reqBo.getHide()));
                boolQueryBuilderSon3.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"hide"));
                boolQueryBuilderSon14.should((QueryBuilder)boolQueryBuilderSon2);
                boolQueryBuilderSon14.should((QueryBuilder)boolQueryBuilderSon3);
                boolQueryBuilder.must((QueryBuilder)boolQueryBuilderSon14);
            }
        }
        if (!ObjectUtils.isEmpty((Object)reqBo.getClassifyManager())) {
            WildcardQueryBuilder wildcardQuery3 = QueryBuilders.wildcardQuery((String)"classify_manager.keyword", (String)("*" + reqBo.getClassifyManager() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery3);
        }
        if (!ObjectUtils.isEmpty(reqBo.getECategoryFlags())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"e_category_flag", reqBo.getECategoryFlags()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStandardComCode())) {
            WildcardQueryBuilder wildcardQuery4 = QueryBuilders.wildcardQuery((String)"standard_com_code.keyword", (String)("*" + reqBo.getStandardComCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery4);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStandardComName())) {
            WildcardQueryBuilder wildcardQuery5 = QueryBuilders.wildcardQuery((String)"standard_com_name.keyword", (String)("*" + reqBo.getStandardComName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery5);
        }
        if (reqBo.getStandardFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"standard_flag", (Object)reqBo.getStandardFlag()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExcludeSkuStatus())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getExcludeSkuStatus()));
        }
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuManagementListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        ArrayList<Object> fieldSortBuilders = new ArrayList<Object>();
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        fieldSortBuilders.add(SortBuilders.fieldSort((String)"sku_id").order(orderType));
        queryJson.put("sort", (Object)JSONObject.parseArray((String)((Object)fieldSortBuilders).toString()));
        return queryJson.toString();
    }

    private UccSkuManagementListQryCombRspBO dealSearchData(String result, UccSkuManagementListQryCombReqBO reqBo) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = hitsObj.getInteger("total");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
            log.debug("result\u6570\u636e" + result);
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize());
        return rspBo;
    }

    private UccSkuManagementListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize) {
        UccSkuManagementListQryCombRspBO rspBo = new UccSkuManagementListQryCombRspBO();
        ArrayList<UccSkuManagementListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuManagementListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int size = pageSize;
            int totalPage = 0;
            int add = 0;
            Integer total = 0;
            totalPage = totalNum / size;
            add = totalNum % size == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                List<UccEMdmMaterialPO> uccEMdmMaterialPOS;
                List<UccEMdmCatalogPO> uccEMdmCatalogPOList;
                List<Long> catalogs = commodityModels.stream().filter(a -> a.getL4mg_category_id() != null).map(a -> a.getL4mg_category_id()).collect(Collectors.toList());
                Map<Object, Object> catalogMap = new HashMap();
                if (!CollectionUtils.isEmpty(catalogs) && !CollectionUtils.isEmpty(uccEMdmCatalogPOList = this.uccEMdmCatalogMapper.queryByCatIds(catalogs))) {
                    catalogMap = uccEMdmCatalogPOList.stream().collect(Collectors.toMap(a -> a.getCatalogId(), a -> a, (first, second) -> first));
                }
                Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS.toString());
                Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_STATUS.toString());
                Map<String, String> skuApprovalStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_APPROVAL_STATUS.toString());
                Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString());
                Map<String, String> belongModuleMap = this.uccDictionaryAtomService.queryBypCodeBackMap("BELONG_MODULE");
                Map<String, String> tradeMode = this.uccDictionaryAtomService.queryBypCodeBackMap("TRADE_MODE");
                Map<String, String> standardFlagMap = this.uccDictionaryAtomService.queryBypCodeBackMap(UccEMdmCatalogEnum.UCC_E_MDM_CATALOG_STANDARD_FLAG.toString());
                Map<String, String> abnormalDescMap = this.uccDictionaryAtomService.queryBypCodeBackMap("GOVERN_PRICE_EXP_STATE");
                Map<String, String> expStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(PCodeConstant.UCC_PRICE_WARN_TYPE_DIC.getCode());
                List<Long> skuIds = commodityModels.stream().map(a -> a.getSku_id()).collect(Collectors.toList());
                List<UocSpuApproverLogPO> uocSpuApproverLogPOS = this.uocApprovalObjMapper.qryApproverLogBuyObjIds(skuIds, 4);
                Map<Object, Object> skuAuditMap = new HashMap();
                if (!CollectionUtils.isEmpty(uocSpuApproverLogPOS)) {
                    try {
                        skuAuditMap = uocSpuApproverLogPOS.stream().collect(Collectors.toMap(a -> a.getObjId(), a -> a.getAuditAdvice(), (first, second) -> first));
                    }
                    catch (Exception e) {
                        log.error(e.getMessage());
                    }
                }
                List<String> materialCodes = commodityModels.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterial_code())).map(a -> a.getMaterial_code()).distinct().collect(Collectors.toList());
                Map<Object, Object> materialMap = new HashMap();
                if (!CollectionUtils.isEmpty(materialCodes) && !CollectionUtils.isEmpty(uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.queryListByCodes(materialCodes, null, null))) {
                    materialMap = uccEMdmMaterialPOS.stream().filter(a -> !StringUtils.isEmpty((Object)a.getMaterialCode()) && !StringUtils.isEmpty((Object)a.getTexture())).collect(Collectors.toMap(a -> a.getMaterialCode(), a -> a.getTexture(), (first, second) -> first));
                }
                log.debug("commodityModelscommodityModels-----------{}", (Object)JSON.toJSONString(commodityModels));
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccEMdmCatalogPO uccEMdmCatalogPO;
                    UccSkuManagementListCombQryBO uccSkuManagementListQryBO = new UccSkuManagementListCombQryBO();
                    uccSkuManagementListQryBO.setShelfType(cnncEsCommodityBo.getOnShelveWay());
                    uccSkuManagementListQryBO.setGovernanceStatus(cnncEsCommodityBo.getGovernance_status());
                    uccSkuManagementListQryBO.setSoldNumber(cnncEsCommodityBo.getSoldNumber());
                    uccSkuManagementListQryBO.setIsSupermarketStaff(cnncEsCommodityBo.getIsSupermarketStaff());
                    uccSkuManagementListQryBO.setBrandVerifyFailReason(cnncEsCommodityBo.getBrandVerifyFailReason());
                    uccSkuManagementListQryBO.setTradeMode(cnncEsCommodityBo.getTradeMode());
                    uccSkuManagementListQryBO.setSurpassStandardPriceFlag(cnncEsCommodityBo.getSurpassStandardPriceFlag());
                    uccSkuManagementListQryBO.setStandardPrice(cnncEsCommodityBo.getStandardPrice());
                    uccSkuManagementListQryBO.setSurpassVpt(cnncEsCommodityBo.getSurpassVpt());
                    uccSkuManagementListQryBO.setGovernResult(cnncEsCommodityBo.getGovern_result());
                    uccSkuManagementListQryBO.setMaterialType(cnncEsCommodityBo.getMaterial_type());
                    uccSkuManagementListQryBO.setIfGovernDesc(cnncEsCommodityBo.getGovern_result() == null ? "\u5426" : "\u662f");
                    if (null == cnncEsCommodityBo.getData_govern_flag() || 0 == cnncEsCommodityBo.getData_govern_flag()) {
                        uccSkuManagementListQryBO.setDataGovernFlagDesc("\u5426");
                    } else {
                        uccSkuManagementListQryBO.setDataGovernFlagDesc("\u662f");
                    }
                    uccSkuManagementListQryBO.setBrandVerifyDesc(cnncEsCommodityBo.getBrand_verify() == null ? "\u5426" : (cnncEsCommodityBo.getBrand_verify() == 1 ? "\u662f" : "\u5426"));
                    uccSkuManagementListQryBO.setRegularPrice(cnncEsCommodityBo.getRegular_price());
                    uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
                    uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
                    uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
                    uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
                    uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
                    uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
                    uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
                    uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
                    uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
                    uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
                    uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
                    uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getBrand_id());
                    uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getBrand_name());
                    uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
                    uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
                    uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
                    uccSkuManagementListQryBO.setLongDesc(cnncEsCommodityBo.getLong_desc());
                    uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
                    uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
                    uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
                    uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
                    uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
                    uccSkuManagementListQryBO.setUpCount(cnncEsCommodityBo.getUp_count());
                    uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
                    uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
                    uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
                    uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
                    uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
                    uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
                    uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
                    uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
                    uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
                    uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
                    uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
                    uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
                    uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
                    uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
                    uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
                    uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
                    uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
                    uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
                    uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
                    uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
                    uccSkuManagementListQryBO.setRunMainBodyId(cnncEsCommodityBo.getRunMainBodyId());
                    uccSkuManagementListQryBO.setRunMainBodyName(cnncEsCommodityBo.getRunMainBodyName());
                    uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
                    uccSkuManagementListQryBO.setAgreementDetailsId(cnncEsCommodityBo.getAgreement_details_id());
                    uccSkuManagementListQryBO.setBrandVerifyResult(cnncEsCommodityBo.getBrandVerifyResult());
                    uccSkuManagementListQryBO.setOnTheShelfRemarks(cnncEsCommodityBo.getOn_the_shelf_remarks());
                    uccSkuManagementListQryBO.setRejectedToSupplierRemarks(cnncEsCommodityBo.getRejected_to_supplier_remarks());
                    if (uccSkuManagementListQryBO.getCatalogId() != null && Objects.nonNull(uccEMdmCatalogPO = (UccEMdmCatalogPO)catalogMap.get(uccSkuManagementListQryBO.getCatalogId()))) {
                        uccSkuManagementListQryBO.setCatalogCode(uccEMdmCatalogPO.getCatalogCode());
                        uccSkuManagementListQryBO.setElcBuy(uccEMdmCatalogPO.getElcBuy());
                    }
                    uccSkuManagementListQryBO.setCommodityStatusDesc(commodityStatusMap.get(uccSkuManagementListQryBO.getCommodityStatus().toString()));
                    if (skuStatusMap != null) {
                        uccSkuManagementListQryBO.setSkuStatusDesc(skuStatusMap.get("" + cnncEsCommodityBo.getSku_status()));
                        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.EC_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.ENFORCE_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.WARN_DOWN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status()) || SkuStatusEnum.FROZEN_STATUS.getStatus().equals(cnncEsCommodityBo.getSku_status())) {
                            uccSkuManagementListQryBO.setDownTypeDesc(skuStatusMap.get("" + cnncEsCommodityBo.getSku_status()));
                        }
                    }
                    uccSkuManagementListQryBO.setDownReason((String)skuAuditMap.get(uccSkuManagementListQryBO.getSkuId()));
                    if (uccSkuManagementListQryBO.getTradeMode() != null) {
                        uccSkuManagementListQryBO.setTradeModeStr(tradeMode.get(uccSkuManagementListQryBO.getTradeMode().toString()));
                    } else {
                        uccSkuManagementListQryBO.setTradeModeStr("\u96c6\u91c7\u96c6\u4f9b-\u81ea\u8425\u6a21\u5f0f");
                    }
                    if (skuApprovalStatusMap != null) {
                        uccSkuManagementListQryBO.setApprovalStatusDesc(skuApprovalStatusMap.get("" + cnncEsCommodityBo.getSku_approval_status()));
                    }
                    if (skuSourceMap != null) {
                        uccSkuManagementListQryBO.setSkuSourceDesc(skuSourceMap.get("" + uccSkuManagementListQryBO.getSkuSource()));
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
                        uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
                    }
                    if (cnncEsCommodityBo.getDown_time() != null) {
                        uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
                    }
                    if (cnncEsCommodityBo.getUp_time() != null) {
                        uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
                    }
                    if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
                        uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
                    } else {
                        uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
                    }
                    uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
                    if (cnncEsCommodityBo.getComment_number() != null) {
                        uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
                    } else {
                        uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
                    }
                    if (cnncEsCommodityBo.getCreate_time() != null) {
                        uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
                    }
                    if (cnncEsCommodityBo.getAudit_time() != null) {
                        uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
                    }
                    if (!StringUtils.isEmpty((Object)uccSkuManagementListQryBO.getMaterialCode())) {
                        uccSkuManagementListQryBO.setTexture((String)materialMap.get(uccSkuManagementListQryBO.getMaterialCode()));
                    }
                    uccSkuManagementListQryBO.setBelongModule(cnncEsCommodityBo.getBelongModule());
                    uccSkuManagementListQryBO.setCreateOperName(cnncEsCommodityBo.getCreate_oper_name());
                    uccSkuManagementListQryBO.setOrgName(cnncEsCommodityBo.getSupplier_org_name());
                    if (cnncEsCommodityBo.getBelongModule() != null && belongModuleMap != null) {
                        uccSkuManagementListQryBO.setBelongModuleStr(belongModuleMap.get("" + cnncEsCommodityBo.getBelongModule()));
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getHide())) {
                        uccSkuManagementListQryBO.setHide(cnncEsCommodityBo.getHide());
                    }
                    if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscountLimitValue())) {
                        uccSkuManagementListQryBO.setDiscountLimitValue(cnncEsCommodityBo.getDiscountLimitValue());
                    }
                    if (!CollectionUtils.isEmpty(cnncEsCommodityBo.getChannel_Name())) {
                        uccSkuManagementListQryBO.setIsSupermarketStaffTowStr(cnncEsCommodityBo.getChannel_Name().stream().collect(Collectors.joining(",")));
                    }
                    if (!ObjectUtils.isEmpty((Object)cnncEsCommodityBo.getClassify_manager())) {
                        uccSkuManagementListQryBO.setClassifyManager(cnncEsCommodityBo.getClassify_manager());
                    }
                    if (!ObjectUtils.isEmpty((Object)cnncEsCommodityBo.getE_category_flag())) {
                        uccSkuManagementListQryBO.setECategoryFlag(cnncEsCommodityBo.getE_category_flag());
                    }
                    if (!ObjectUtil.isEmpty((Object)cnncEsCommodityBo.getReference_price_start())) {
                        uccSkuManagementListQryBO.setReferencePriceStart(cnncEsCommodityBo.getReference_price_start());
                    }
                    if (!ObjectUtil.isEmpty((Object)cnncEsCommodityBo.getReference_price_end())) {
                        uccSkuManagementListQryBO.setReferencePricerEnd(cnncEsCommodityBo.getReference_price_end());
                    }
                    uccSkuManagementListQryBO.setAbnormalDesc(cnncEsCommodityBo.getAbnormal_desc());
                    uccSkuManagementListQryBO.setAbnormalFloatStr(cnncEsCommodityBo.getAbnormal_float_str());
                    uccSkuManagementListQryBO.setStandardComCode(cnncEsCommodityBo.getStandard_com_code());
                    uccSkuManagementListQryBO.setStandardComName(cnncEsCommodityBo.getStandard_com_name());
                    uccSkuManagementListQryBO.setStandardComId(cnncEsCommodityBo.getStandard_com_id());
                    uccSkuManagementListQryBO.setStandardFlag(cnncEsCommodityBo.getStandard_flag());
                    if (uccSkuManagementListQryBO.getStandardFlag() != null) {
                        uccSkuManagementListQryBO.setStandardFlagStr(standardFlagMap.get(uccSkuManagementListQryBO.getStandardFlag().toString()));
                    }
                    if (!StringUtils.isEmpty((Object)uccSkuManagementListQryBO.getAbnormalDesc())) {
                        uccSkuManagementListQryBO.setAbnormalDescStr(abnormalDescMap.get(uccSkuManagementListQryBO.getAbnormalDesc()));
                    }
                    if (uccSkuManagementListQryBO.getReferencePriceStart() != null && uccSkuManagementListQryBO.getReferencePricerEnd() != null) {
                        String referencePriceStart = uccSkuManagementListQryBO.getReferencePriceStart().setScale(2, RoundingMode.HALF_UP).toString();
                        String referencePricerEnd = uccSkuManagementListQryBO.getReferencePricerEnd().setScale(2, RoundingMode.HALF_UP).toString();
                        uccSkuManagementListQryBO.setReferencePriceStr(referencePriceStart + "-" + referencePricerEnd);
                    }
                    uccSkuManagementListQryBO.setIntMinPrice(cnncEsCommodityBo.getIntMinPrice());
                    uccSkuManagementListQryBO.setIntMaxPrice(cnncEsCommodityBo.getIntMaxPrice());
                    uccSkuManagementListQryBO.setIntVagPrice(cnncEsCommodityBo.getIntVagPrice());
                    uccSkuManagementListQryBO.setSameIntSkuIdPrice(cnncEsCommodityBo.getSameIntSkuIdPrice());
                    uccSkuManagementListQryBO.setAbnormalPriceStatusDesc(cnncEsCommodityBo.getAbnormalPriceStatusDesc());
                    if (!StringUtils.isEmpty((Object)uccSkuManagementListQryBO.getAbnormalPriceStatusDesc())) {
                        String s = UccSkuManagementListQryCombServiceImpl.translateString(uccSkuManagementListQryBO.getAbnormalPriceStatusDesc(), expStateMap, "\uff0c");
                        uccSkuManagementListQryBO.setAbnormalPriceStatusDescStr(s);
                    }
                    uccSkuManagementListQryBO.setAbnormalFloatingRateDesc(cnncEsCommodityBo.getAbnormalFloatingRateDesc());
                    uccSkuManagementListQryBO.setSurpassVptStr(cnncEsCommodityBo.getSurpassVptStr());
                    uccSkuManagementListQryBO.setAbnormalDescStr(uccSkuManagementListQryBO.getAbnormalPriceStatusDescStr());
                    uccSkuManagementListQryBO.setAbnormalFloatTranslate(uccSkuManagementListQryBO.getAbnormalFloatingRateDesc());
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public static String translateString(String input, Map<String, String> dictionary, String delimiter) {
        String[] numbers = input.split(delimiter);
        StringBuilder translatedString = new StringBuilder();
        for (int i = 0; i < numbers.length; ++i) {
            String translated = dictionary.getOrDefault(numbers[i], numbers[i]) + "\u5f02\u5e38";
            if (i > 0) {
                translatedString.append(delimiter);
            }
            translatedString.append(translated);
        }
        return translatedString.toString();
    }

    @Autowired
    public void setSkuDataGovernSamePriceMapper(SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper) {
        this.skuDataGovernSamePriceMapper = skuDataGovernSamePriceMapper;
    }
}

