/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.DycSyncMaterialEsService;
import com.tydic.commodity.common.ability.bo.DycSyncMaterialEsBo;
import com.tydic.commodity.common.ability.bo.DycSyncMaterialEsReqBo;
import com.tydic.commodity.common.ability.bo.DycSyncMaterialEsRspBo;
import com.tydic.commodity.common.busi.api.DycSyncMaterialEsFailBusiService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialErpMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccEMdmMaterialErpPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.DycSyncMaterialEsService"})
public class DycSyncMaterialEsServiceImpl
implements DycSyncMaterialEsService {
    private static final Logger log = LoggerFactory.getLogger(DycSyncMaterialEsServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccEMdmMaterialErpMapper uccEMdmMaterialErpMapper;
    @Autowired
    private DycSyncMaterialEsFailBusiService dycSyncMaterialEsFailService;

    @PostMapping(value={"syncMaterialEs"})
    public DycSyncMaterialEsRspBo syncMaterialEs(@RequestBody DycSyncMaterialEsReqBo reqBo) {
        DycSyncMaterialEsRspBo rspBo = new DycSyncMaterialEsRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBo.getMaterialCodes())) {
            return rspBo;
        }
        ArrayList<String> fail = new ArrayList<String>();
        List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.queryListByCodes(reqBo.getMaterialCodes(), null, null);
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) {
            List catalogIds = uccEMdmMaterialPOS.stream().map(a -> a.getCatalogId()).distinct().collect(Collectors.toList());
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                Map<Long, String> catIdAndCode = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCatalogId(), b -> b.getCatalogCode(), (o, n) -> o));
                uccEMdmMaterialPOS.forEach(each -> each.setCatalogCode((String)catIdAndCode.get(each.getCatalogId())));
            }
            List materialCodes = uccEMdmMaterialPOS.stream().map(a -> a.getMaterialCode()).distinct().collect(Collectors.toList());
            List uccEMdmMaterialErpPOS = this.uccEMdmMaterialErpMapper.getListByMaterialCodes(materialCodes);
            HashMap erpCodeMap = new HashMap();
            HashMap erpNameMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialErpPOS)) {
                Map<String, List<UccEMdmMaterialErpPO>> codeAndPos = uccEMdmMaterialErpPOS.stream().collect(Collectors.groupingBy(a -> a.getMaterialCode()));
                codeAndPos.forEach((k, v) -> {
                    List erpCodes = v.stream().map(a -> a.getErpCode()).distinct().collect(Collectors.toList());
                    List erpNames = v.stream().map(a -> a.getErpName()).distinct().collect(Collectors.toList());
                    erpCodeMap.put(k, erpCodes);
                    erpNameMap.put(k, erpNames);
                });
            }
            ArrayList<DycSyncMaterialEsBo> dycSyncMaterialEsBos = new ArrayList<DycSyncMaterialEsBo>();
            uccEMdmMaterialPOS.forEach(each -> {
                DycSyncMaterialEsBo dycSyncMaterialEsBo = new DycSyncMaterialEsBo();
                BeanUtils.copyProperties((Object)each, (Object)dycSyncMaterialEsBo);
                dycSyncMaterialEsBo.setErpCodes((List)erpCodeMap.get(each.getMaterialCode()));
                dycSyncMaterialEsBo.setErpNames((List)erpNameMap.get(each.getMaterialCode()));
                dycSyncMaterialEsBos.add(dycSyncMaterialEsBo);
            });
            this.syncEs(dycSyncMaterialEsBos, fail);
            rspBo.setFail(fail);
        }
        return rspBo;
    }

    @PostMapping(value={"syncAllMaterialEs"})
    public DycSyncMaterialEsRspBo syncAllMaterialEs(@RequestBody DycSyncMaterialEsReqBo reqBo) {
        DycSyncMaterialEsRspBo rspBo = new DycSyncMaterialEsRspBo();
        int num = 1;
        int total = 0;
        do {
            Page page = new Page(num, reqBo.getSyncNum().intValue());
            List syncMaterialCodes = this.uccEMdmMaterialMapper.queryCodesPage(reqBo.getMaterialCodes(), page);
            List uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.queryListByCodesPage(syncMaterialCodes);
            if (total == 0) {
                total = page.getTotalPages();
                System.out.println("\u603b\u9875\u6570\u4e3a\uff1a" + total);
            }
            ArrayList<String> fail = new ArrayList<String>();
            if (CollectionUtils.isEmpty((Collection)uccEMdmMaterialPOS)) continue;
            List catalogIds = uccEMdmMaterialPOS.stream().map(a -> a.getCatalogId()).distinct().collect(Collectors.toList());
            List uccEMdmCatalogPOS = this.uccEMdmCatalogMapper.queryByCatIds(catalogIds);
            if (!CollectionUtils.isEmpty((Collection)uccEMdmCatalogPOS)) {
                Map<Long, String> catIdAndCode = uccEMdmCatalogPOS.stream().collect(Collectors.toMap(a -> a.getCatalogId(), b -> b.getCatalogCode(), (o, n) -> o));
                uccEMdmMaterialPOS.forEach(each -> each.setCatalogCode((String)catIdAndCode.get(each.getCatalogId())));
            }
            List materialCodes = uccEMdmMaterialPOS.stream().map(a -> a.getMaterialCode()).distinct().collect(Collectors.toList());
            List uccEMdmMaterialErpPOS = this.uccEMdmMaterialErpMapper.getListByMaterialCodes(materialCodes);
            HashMap erpCodeMap = new HashMap();
            HashMap erpNameMap = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialErpPOS)) {
                Map<String, List<UccEMdmMaterialErpPO>> codeAndPos = uccEMdmMaterialErpPOS.stream().collect(Collectors.groupingBy(a -> a.getMaterialCode()));
                codeAndPos.forEach((k, v) -> {
                    List erpCodes = v.stream().map(a -> a.getErpCode()).distinct().collect(Collectors.toList());
                    List erpNames = v.stream().map(a -> a.getErpName()).distinct().collect(Collectors.toList());
                    erpCodeMap.put(k, erpCodes);
                    erpNameMap.put(k, erpNames);
                });
            }
            ArrayList<DycSyncMaterialEsBo> dycSyncMaterialEsBos = new ArrayList<DycSyncMaterialEsBo>();
            uccEMdmMaterialPOS.forEach(each -> {
                DycSyncMaterialEsBo dycSyncMaterialEsBo = new DycSyncMaterialEsBo();
                BeanUtils.copyProperties((Object)each, (Object)dycSyncMaterialEsBo);
                dycSyncMaterialEsBo.setErpCodes((List)erpCodeMap.get(each.getMaterialCode()));
                dycSyncMaterialEsBo.setErpNames((List)erpNameMap.get(each.getMaterialCode()));
                dycSyncMaterialEsBos.add(dycSyncMaterialEsBo);
            });
            this.syncEs(dycSyncMaterialEsBos, fail);
        } while (++num <= total);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void syncEs(List<DycSyncMaterialEsBo> dycSyncMaterialEsBos, List<String> fail) {
        if (!CollectionUtils.isEmpty(dycSyncMaterialEsBos)) {
            for (DycSyncMaterialEsBo dycSyncMaterialEsBo : dycSyncMaterialEsBos) {
                String jsonStr = JSONObject.toJSONString((Object)dycSyncMaterialEsBo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
                JSONObject jsonObject = JSONObject.parseObject((String)jsonStr);
                String esId = "" + dycSyncMaterialEsBo.getMaterialId();
                String id = this.elasticsearchUtil.addData(this.esConfig.getMaterialIndexName(), this.esConfig.getMaterialEsType(), esId, jsonObject);
                if (!StringUtils.isBlank((CharSequence)id)) continue;
                log.error("\u7269\u8d44\u4fe1\u606f[" + esId + "]\u540c\u6b65\u5931\u8d25!");
                fail.add(dycSyncMaterialEsBo.getMaterialCode());
            }
        }
    }

    @PostMapping(value={"dealMaterialFailLog"})
    public DycSyncMaterialEsRspBo dealMaterialFailLog(@RequestBody DycSyncMaterialEsReqBo reqBo) {
        return this.dycSyncMaterialEsFailService.dealMaterialFailLog(reqBo);
    }
}

