/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccGetPriceReferenceApprovalListAbilityService;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceApprovalListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceApprovalListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccPriceReferenceApprovalBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccPriceReferenceMapper;
import com.tydic.commodity.po.UccPriceReferencePO;
import com.tydic.xwgl.ability.constants.XwglConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGetPriceReferenceApprovalListAbilityService"})
public class UccGetPriceReferenceApprovalListAbilityServiceImpl
implements UccGetPriceReferenceApprovalListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGetPriceReferenceApprovalListAbilityServiceImpl.class);
    public static final String DSP = "1001";
    public static final String YSP = "1002";
    @Autowired
    private UccPriceReferenceMapper uccPriceReferenceMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getPriceReferenceApprovalList"})
    public UccGetPriceReferenceApprovalListAbilityRspBO getPriceReferenceApprovalList(@RequestBody UccGetPriceReferenceApprovalListAbilityReqBO reqBo) {
        UccGetPriceReferenceApprovalListAbilityRspBO rspBO = new UccGetPriceReferenceApprovalListAbilityRspBO();
        UccPriceReferencePO qryUccPriceReferencePo = (UccPriceReferencePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBo), UccPriceReferencePO.class);
        qryUccPriceReferencePo.setDealOperId(reqBo.getUserId());
        if (DSP.equals(reqBo.getTabId())) {
            qryUccPriceReferencePo.setReferenceStatus("0");
            qryUccPriceReferencePo.setFinishTag(XwglConstants.NO_INT);
        } else if (YSP.equals(reqBo.getTabId())) {
            qryUccPriceReferencePo.setFinishTag(XwglConstants.YES_INT);
        }
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List uccPriceReferencePos = this.uccPriceReferenceMapper.getPriceReferenceApprovalList(qryUccPriceReferencePo, page);
        if (CollectionUtils.isEmpty((Collection)uccPriceReferencePos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            return rspBO;
        }
        List<UccPriceReferenceApprovalBo> rows = this.transData(uccPriceReferencePos);
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccPriceReferenceApprovalBo> transData(List<UccPriceReferencePO> uccPriceReferencePos) {
        ArrayList<UccPriceReferenceApprovalBo> rows = new ArrayList<UccPriceReferenceApprovalBo>(uccPriceReferencePos.size());
        Map<String, String> uccPriceReferenceStatusDic = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_PRICE_REFERENCE_STATUS_DIC");
        Map<String, String> eMaterielCategory = this.uccDictionaryAtomService.queryBypCodeBackMap("E_MATERIEL_CATEGORY");
        for (UccPriceReferencePO each : uccPriceReferencePos) {
            UccPriceReferenceApprovalBo uccPriceReferenceBo = new UccPriceReferenceApprovalBo();
            BeanUtils.copyProperties((Object)each, (Object)uccPriceReferenceBo);
            if (each.getECategoryFlag() != null) {
                uccPriceReferenceBo.setECategoryFlagStr(eMaterielCategory.get(each.getECategoryFlag().toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)each.getReferenceStatus())) {
                uccPriceReferenceBo.setReferenceStatusStr(uccPriceReferenceStatusDic.get(each.getReferenceStatus()));
            }
            rows.add(uccPriceReferenceBo);
        }
        return rows;
    }
}

