/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccGetPriceReferenceHistoryListAbilityService;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceHistoryListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceHistoryListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccOtherAccessoryBo;
import com.tydic.commodity.common.ability.bo.UccPriceReferenceHistoryBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.OtherAccessoryMapper;
import com.tydic.commodity.dao.UccPriceReferenceHistoryMapper;
import com.tydic.commodity.po.OtherAccessoryPO;
import com.tydic.commodity.po.UccPriceReferenceHistoryPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGetPriceReferenceHistoryListAbilityService"})
public class UccGetPriceReferenceHistoryListAbilityServiceImpl
implements UccGetPriceReferenceHistoryListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGetPriceReferenceHistoryListAbilityServiceImpl.class);
    @Autowired
    private UccPriceReferenceHistoryMapper uccPriceReferenceHistoryMapper;
    @Autowired
    private OtherAccessoryMapper otherAccessoryMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getPriceReferenceHistoryList"})
    public UccGetPriceReferenceHistoryListAbilityRspBO getPriceReferenceHistoryList(@RequestBody UccGetPriceReferenceHistoryListAbilityReqBO reqBO) {
        UccGetPriceReferenceHistoryListAbilityRspBO rspBO = new UccGetPriceReferenceHistoryListAbilityRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccPriceReferenceHistoryPO qryUccPriceReferenceHistoryPo = new UccPriceReferenceHistoryPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryUccPriceReferenceHistoryPo);
        qryUccPriceReferenceHistoryPo.setSupplierId(reqBO.getSupplierIdWeb());
        List uccPriceReferenceHistoryPos = this.uccPriceReferenceHistoryMapper.getListPage(qryUccPriceReferenceHistoryPo, page);
        if (CollectionUtils.isEmpty((Collection)uccPriceReferenceHistoryPos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            return rspBO;
        }
        Map<Long, List<OtherAccessoryPO>> otherAccessoryMap = this.getOtherAccessoryMap(uccPriceReferenceHistoryPos);
        ArrayList<UccPriceReferenceHistoryBo> rows = new ArrayList<UccPriceReferenceHistoryBo>(uccPriceReferenceHistoryPos.size());
        Map<String, String> uccPriceReferenceStatusDic = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_PRICE_REFERENCE_STATUS_DIC");
        for (UccPriceReferenceHistoryPO each : uccPriceReferenceHistoryPos) {
            List<OtherAccessoryPO> otherAccessoryPOList;
            UccPriceReferenceHistoryBo uccPriceReferenceHistoryBo = new UccPriceReferenceHistoryBo();
            BeanUtils.copyProperties((Object)each, (Object)uccPriceReferenceHistoryBo);
            if (StringUtils.isNotBlank((CharSequence)each.getReferenceStatus())) {
                uccPriceReferenceHistoryBo.setReferenceStatusStr(uccPriceReferenceStatusDic.get(each.getReferenceStatus()));
            }
            if (MapUtil.isNotEmpty(otherAccessoryMap) && !CollectionUtils.isEmpty(otherAccessoryPOList = otherAccessoryMap.get(each.getId()))) {
                ArrayList<UccOtherAccessoryBo> uccOtherAccessoryBos = new ArrayList<UccOtherAccessoryBo>(otherAccessoryPOList.size());
                UccOtherAccessoryBo uccOtherAccessoryBo = (UccOtherAccessoryBo)JSONObject.parseObject((String)JSONObject.toJSONString(otherAccessoryPOList), UccOtherAccessoryBo.class);
                uccOtherAccessoryBos.add(uccOtherAccessoryBo);
                uccPriceReferenceHistoryBo.setUccOtherAccessoryBos(uccOtherAccessoryBos);
            }
            rows.add(uccPriceReferenceHistoryBo);
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Map<Long, List<OtherAccessoryPO>> getOtherAccessoryMap(List<UccPriceReferenceHistoryPO> uccPriceReferenceHistoryPos) {
        List ids = uccPriceReferenceHistoryPos.stream().map(UccPriceReferenceHistoryPO::getId).collect(Collectors.toList());
        OtherAccessoryPO qryOtherAccessoryPo = new OtherAccessoryPO();
        qryOtherAccessoryPo.setRelIds(ids);
        qryOtherAccessoryPo.setType(UccConstants.OtherAccessoryType.JGCKWH_HISTORY);
        List otherAccessoryPos = this.otherAccessoryMapper.getList(qryOtherAccessoryPo);
        Map<Long, List<OtherAccessoryPO>> otherAccessoryMap = new HashMap<Long, List<OtherAccessoryPO>>(16);
        if (!CollectionUtils.isEmpty((Collection)otherAccessoryPos)) {
            otherAccessoryMap = otherAccessoryPos.stream().collect(Collectors.groupingBy(OtherAccessoryPO::getRelId));
        }
        return otherAccessoryMap;
    }
}

