/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccGetPriceReferenceListAbilityService;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceListAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccGetPriceReferenceListAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccPriceReferenceBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccPriceReferenceMapper;
import com.tydic.commodity.po.UccPriceReferencePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccGetPriceReferenceListAbilityService"})
public class UccGetPriceReferenceListAbilityServiceImpl
implements UccGetPriceReferenceListAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccGetPriceReferenceListAbilityServiceImpl.class);
    public static final String TABID_DWH = "1001";
    public static final String TABID_YWH = "1002";
    @Autowired
    private UccPriceReferenceMapper uccPriceReferenceMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getPriceReferenceList"})
    public UccGetPriceReferenceListAbilityRspBO getPriceReferenceList(@RequestBody UccGetPriceReferenceListAbilityReqBO reqBO) {
        UccGetPriceReferenceListAbilityRspBO rspBO = new UccGetPriceReferenceListAbilityRspBO();
        UccPriceReferencePO qryUccPriceReferencePo = new UccPriceReferencePO();
        BeanUtils.copyProperties((Object)reqBO, (Object)qryUccPriceReferencePo);
        ArrayList<String> referenceStatusList = new ArrayList<String>(1);
        if (TABID_DWH.equals(reqBO.getTabId())) {
            referenceStatusList.add("3");
        } else if (TABID_YWH.equals(reqBO.getTabId())) {
            referenceStatusList.add("0");
            referenceStatusList.add("1");
            referenceStatusList.add("2");
        }
        qryUccPriceReferencePo.setSupplierId(reqBO.getSupId());
        qryUccPriceReferencePo.setReferenceStatusList(referenceStatusList);
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List uccPriceReferencePos = this.uccPriceReferenceMapper.getPriceReferenceListPage(qryUccPriceReferencePo, page);
        if (CollectionUtils.isEmpty((Collection)uccPriceReferencePos)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff01");
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
            return rspBO;
        }
        List<UccPriceReferenceBo> rows = this.transData(uccPriceReferencePos);
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<UccPriceReferenceBo> transData(List<UccPriceReferencePO> uccPriceReferencePos) {
        ArrayList<UccPriceReferenceBo> rows = new ArrayList<UccPriceReferenceBo>(uccPriceReferencePos.size());
        Map<String, String> uccPriceReferenceStatusDic = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_PRICE_REFERENCE_STATUS_DIC");
        Map<String, String> eMaterielCategory = this.uccDictionaryAtomService.queryBypCodeBackMap("E_MATERIEL_CATEGORY");
        for (UccPriceReferencePO each : uccPriceReferencePos) {
            UccPriceReferenceBo uccPriceReferenceBo = new UccPriceReferenceBo();
            BeanUtils.copyProperties((Object)each, (Object)uccPriceReferenceBo);
            if (each.getECategoryFlag() != null) {
                uccPriceReferenceBo.setECategoryFlagStr(eMaterielCategory.get(each.getECategoryFlag().toString()));
            }
            if (StringUtils.isNotBlank((CharSequence)each.getReferenceStatus())) {
                uccPriceReferenceBo.setReferenceStatusStr(uccPriceReferenceStatusDic.get(each.getReferenceStatus()));
            }
            rows.add(uccPriceReferenceBo);
        }
        return rows;
    }
}

