/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.enumType.Brand;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccBrandSelectReqBO;
import com.tydic.commodity.common.ability.bo.UccBrandSelectRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccBrandSelectBusiService;
import com.tydic.commodity.common.busi.bo.UccBrandDateBO;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.UccBrandDealPO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccBrandSelectBusiServiceImpl
implements UccBrandSelectBusiService {
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    UccBrandSelectRspBO rspBO = new UccBrandSelectRspBO();

    @Override
    public UccBrandSelectRspBO selectBrand(UccBrandSelectReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRows(null);
            return this.rspBO;
        }
        this.rspBO = new UccBrandSelectRspBO();
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List result = null;
        try {
            result = this.mapper.selectBrand(brandDealPO, page);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
            ArrayList<UccBrandDateBO> dataList = new ArrayList<UccBrandDateBO>();
            UccBrandDateBO result1 = null;
            DicDictionaryPo dicDictionaryPo = null;
            for (UccBrandDealPO po : result) {
                result1 = new UccBrandDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(po.getBrandStatus()), Brand.BRAND_STATUS.toString());
                if (dicDictionaryPo != null) {
                    result1.setBrandStatusTranslation(dicDictionaryPo.getTitle());
                }
                String isRel = po.getSupplierShopId() != null ? "\u5df2\u5173\u8054" : "\u672a\u5173\u8054";
                result1.setIsRel(isRel);
                dataList.add(result1);
            }
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        }
        return this.rspBO;
    }

    public boolean judge(UccBrandSelectReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u54c1\u724c\u72b6\u6001");
            return false;
        }
        return true;
    }
}

