/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccDealPriceReferenceAuditReqBo;
import com.tydic.commodity.common.ability.bo.UccDealPriceReferenceAuditReqBoAuditInfo;
import com.tydic.commodity.common.ability.bo.UccDealPriceReferenceAuditRspBo;
import com.tydic.commodity.common.busi.api.UccDealPriceReferenceAuditBusiService;
import com.tydic.commodity.dao.UccOrderTaskInstMapper;
import com.tydic.commodity.dao.UccPriceReferenceHistoryMapper;
import com.tydic.commodity.po.UccOrderTaskInstPO;
import com.tydic.commodity.po.UccPriceReferenceHistoryPO;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.xwgl.ability.constants.XwglConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccDealPriceReferenceAuditBusiServiceImpl
implements UccDealPriceReferenceAuditBusiService {
    public static final Integer YES_INT = 1;
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private UccOrderTaskInstMapper uccOrderTaskInstMapper;
    @Autowired
    private UccPriceReferenceHistoryMapper uccPriceReferenceHistoryMapper;

    @Override
    public UccDealPriceReferenceAuditRspBo dealPriceReferenceAudit(UccDealPriceReferenceAuditReqBo reqBo) {
        this.val(reqBo);
        EacApproveAbilityReqBO abilityReqBO = this.getEacApproveAbilityReqBO(reqBo);
        EacApproveAbilityRspBO approve = this.eacRuTaskAbilityService.approveByMq(abilityReqBO);
        if (!"0000".equals(approve.getRespCode())) {
            throw new BusinessException(approve.getRespCode(), approve.getRespDesc());
        }
        Map<String, UccDealPriceReferenceAuditReqBoAuditInfo> map = reqBo.getAuditInfo().stream().collect(Collectors.toMap(UccDealPriceReferenceAuditReqBoAuditInfo::getProcInstId, a -> a));
        for (EacApproveAbilityRspInfoBO infoBO : approve.getData()) {
            UccDealPriceReferenceAuditReqBoAuditInfo auditInfo = map.get(infoBO.getApproveInstId());
            if (auditInfo == null) continue;
            this.dealTask(reqBo, auditInfo, infoBO);
            UccPriceReferenceHistoryPO update = new UccPriceReferenceHistoryPO();
            update.setId(auditInfo.getObjId());
            if (!infoBO.getIsFinish().booleanValue()) continue;
            if (UccConstants.AuditFlag.BY.equals(auditInfo.getAuditFlag())) {
                update.setReferenceStatus("1");
            } else {
                update.setReferenceStatus("2");
            }
            update.setUpdateTime(new Date());
            update.setUpdateOperId(reqBo.getUsername() + "");
            update.setUpdateOperName(reqBo.getName());
            this.uccPriceReferenceHistoryMapper.updateById(update);
        }
        UccDealPriceReferenceAuditRspBo rspBo = new UccDealPriceReferenceAuditRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealTask(UccDealPriceReferenceAuditReqBo reqBo, UccDealPriceReferenceAuditReqBoAuditInfo auditInfo, EacApproveAbilityRspInfoBO infoBO) {
        UccOrderTaskInstPO instPo = new UccOrderTaskInstPO();
        instPo.setObjType(auditInfo.getObjType());
        instPo.setObjId(auditInfo.getObjId());
        instPo.setFinishTag(YES_INT);
        instPo.setDealOperId(reqBo.getUserId());
        instPo.setDealOperName(reqBo.getUsername());
        instPo.setDealName(reqBo.getName());
        instPo.setProcInstId(auditInfo.getProcInstId());
        instPo.setTaskInstId(auditInfo.getTaskInstId());
        instPo.setDealResult(auditInfo.getAuditFlag());
        instPo.setDealRemark(auditInfo.getRemark());
        instPo.setFinishTime(new Date());
        instPo.setOrderId(instPo.getObjId());
        int i = this.uccOrderTaskInstMapper.updateDone(instPo);
        if (i == 0) {
            throw new BusinessException("8888", "\u66f4\u65b0\u5df2\u529e\u5931\u8d25");
        }
        if (StringUtils.hasText((String)infoBO.getLinkJudge()) && Boolean.parseBoolean(infoBO.getLinkJudge())) {
            UccOrderTaskInstPO dealInstPo = new UccOrderTaskInstPO();
            dealInstPo.setObjType(instPo.getObjType());
            dealInstPo.setObjId(instPo.getObjId());
            dealInstPo.setOrderId(instPo.getOrderId());
            dealInstPo.setFinishTag(XwglConstants.NO_INT);
            dealInstPo.setProcInstId(auditInfo.getProcInstId());
            dealInstPo.setIsDeleted("1");
            dealInstPo.setUpdateTime(new Date());
            this.uccOrderTaskInstMapper.updateDel(dealInstPo);
        }
    }

    private EacApproveAbilityReqBO getEacApproveAbilityReqBO(UccDealPriceReferenceAuditReqBo reqBo) {
        EacApproveAbilityReqBO abilityReqBO = new EacApproveAbilityReqBO();
        ArrayList<EacApproveAbilityReqInfoBO> data = new ArrayList<EacApproveAbilityReqInfoBO>();
        for (UccDealPriceReferenceAuditReqBoAuditInfo auditInfo : reqBo.getAuditInfo()) {
            EacApproveAbilityReqInfoBO infoBO = new EacApproveAbilityReqInfoBO();
            infoBO.setApproveAdvice(auditInfo.getRemark());
            infoBO.setTaskId(Long.valueOf(Long.parseLong(auditInfo.getTaskInstId())));
            if (UccConstants.AuditFlag.BY.equals(auditInfo.getAuditFlag())) {
                infoBO.setApproveResult("pass");
            } else {
                infoBO.setApproveResult("reject");
            }
            data.add(infoBO);
        }
        abilityReqBO.setData(data);
        return abilityReqBO;
    }

    private void val(UccDealPriceReferenceAuditReqBo reqBo) {
        if (null == reqBo) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAuditInfo())) {
            throw new BusinessException("0001", "\u5165\u53c2[auditInfo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (UccDealPriceReferenceAuditReqBoAuditInfo info : reqBo.getAuditInfo()) {
            if (info.getObjId() == null) {
                throw new BusinessException("0001", "\u5165\u53c2[objId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (info.getAuditFlag() == null || info.getAuditFlag() != 1 && info.getAuditFlag() != 2) {
                throw new BusinessException("0001", "\u5165\u53c2[auditFlag]\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
            }
            if (info.getObjType() == null) {
                throw new BusinessException("0001", "\u5165\u53c2[objType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (info.getTaskInstId() == null) {
                throw new BusinessException("0001", "\u5165\u53c2[taskInstId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (info.getProcInstId() != null) continue;
            throw new BusinessException("0001", "\u5165\u53c2[procInstId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

