/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccSendNotificationExtAtomService;
import com.tydic.commodity.common.ability.bo.UccOtherAccessoryBo;
import com.tydic.commodity.common.ability.bo.UccUpdatePriceReferenceAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccUpdatePriceReferenceAbilityRspBO;
import com.tydic.commodity.common.busi.api.UccUpdatePriceReferenceBusiService;
import com.tydic.commodity.dao.OtherAccessoryMapper;
import com.tydic.commodity.dao.UccPriceReferenceMapper;
import com.tydic.commodity.po.OtherAccessoryPO;
import com.tydic.commodity.po.UccPriceReferencePO;
import com.tydic.osworkflow.approve.ability.EacProjectAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacStartProjectAbilityRspInfoBO;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class UccUpdatePriceReferenceBusiServiceImpl
implements UccUpdatePriceReferenceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccUpdatePriceReferenceBusiServiceImpl.class);
    @Autowired
    private UccPriceReferenceMapper uccPriceReferenceMapper;
    @Autowired
    private OtherAccessoryMapper otherAccessoryMapper;
    @Value(value="${process.sysCode:UCC}")
    private String processSysCode;
    @Autowired
    private EacProjectAbilityService eacProjectAbilityService;
    @Autowired
    private UccSendNotificationExtAtomService uccSendNotificationExtAtomService;

    @Override
    public UccUpdatePriceReferenceAbilityRspBO updatePriceReference(UccUpdatePriceReferenceAbilityReqBO reqBO) {
        UccPriceReferencePO qryUccPriceReferencePo = new UccPriceReferencePO();
        qryUccPriceReferencePo.setId(reqBO.getId());
        UccPriceReferencePO modelBy = this.uccPriceReferenceMapper.getModelBy(qryUccPriceReferencePo);
        if (modelBy == null) {
            throw new BusinessException("0001", "\u4ef7\u683c\u53c2\u8003\u7ef4\u62a4\u4fe1\u606f\u67e5\u8be2\u4e3a\u7a7a");
        }
        if (!"3".equals(modelBy.getReferenceStatus()) && !"2".equals(modelBy.getReferenceStatus())) {
            throw new BusinessException("0001", "\u53ea\u6709\u5f85\u7ef4\u62a4\u6216\u8005\u5931\u6548\u72b6\u6001\u53ef\u4ee5\u63d0\u4ea4");
        }
        this.savePriceReference(reqBO);
        this.saveOtherAccessoryList(reqBO, modelBy);
        this.startProjectByMq(reqBO, modelBy);
        UccUpdatePriceReferenceAbilityRspBO rspBo = new UccUpdatePriceReferenceAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void startProjectByMq(UccUpdatePriceReferenceAbilityReqBO reqBO, UccPriceReferencePO modelBy) {
        EacStartProjectAbilityReqBO eacStartProjectAbilityReqBO = new EacStartProjectAbilityReqBO();
        eacStartProjectAbilityReqBO.setSysCode(this.processSysCode);
        eacStartProjectAbilityReqBO.setProcDefKey(reqBO.getProcDefKey());
        eacStartProjectAbilityReqBO.setPartitionKey(modelBy.getId().toString());
        eacStartProjectAbilityReqBO.setUserId(String.valueOf(reqBO.getUserId()));
        eacStartProjectAbilityReqBO.setUserName(reqBO.getName());
        eacStartProjectAbilityReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        eacStartProjectAbilityReqBO.setOrgName(reqBO.getOrgName());
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put("auditOrderId", modelBy.getId());
        variables.put("auditId", modelBy.getId());
        variables.put("submitUserId", reqBO.getUserId());
        variables.put("submitUserCode", reqBO.getOccupation());
        eacStartProjectAbilityReqBO.setVariables(variables);
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(modelBy.getId().toString());
        eacStartProjectAbilityReqBO.setBusinessIdList(strings);
        log.info("\u89c4\u5219\u914d\u7f6e\u53d8\u66f4\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5165\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityReqBO));
        EacStartProjectAbilityRspBO eacStartProjectAbilityRspBO = this.eacProjectAbilityService.startProjectByMq(eacStartProjectAbilityReqBO);
        log.info("\u89c4\u5219\u914d\u7f6e\u53d8\u66f4\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)eacStartProjectAbilityRspBO));
        if (!"0000".equals(eacStartProjectAbilityRspBO.getRespCode())) {
            throw new BusinessException("0001", "\u8c03\u7528\u6d41\u7a0b\u5ba1\u6279\u542f\u52a8\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacStartProjectAbilityRspBO.getRespCode() + "\u3011," + eacStartProjectAbilityRspBO.getRespDesc());
        }
        String approveInstId = ((EacStartProjectAbilityRspInfoBO)eacStartProjectAbilityRspBO.getData().get(0)).getApproveInstId();
        UccPriceReferencePO updateUccPriceReferencePo = new UccPriceReferencePO();
        updateUccPriceReferencePo.setId(modelBy.getId());
        updateUccPriceReferencePo.setExtField1(approveInstId);
        this.uccPriceReferenceMapper.updateById(updateUccPriceReferencePo);
    }

    private void savePriceReference(UccUpdatePriceReferenceAbilityReqBO reqBO) {
        UccPriceReferencePO uccPriceReferencePo = new UccPriceReferencePO();
        uccPriceReferencePo.setMinReferencePrice(reqBO.getMinReferencePrice());
        uccPriceReferencePo.setRemarks(reqBO.getRemarks());
        uccPriceReferencePo.setUpdateOperId(reqBO.getUsername());
        uccPriceReferencePo.setUpdateOperName(reqBO.getName());
        uccPriceReferencePo.setUpdateTime(new Date());
        uccPriceReferencePo.setReferenceStatus("0");
        uccPriceReferencePo.setId(reqBO.getId());
        int i = this.uccPriceReferenceMapper.updatePriceReference(uccPriceReferencePo);
        if (i != 1) {
            throw new BusinessException("0001", "\u4fee\u6539\u4ef7\u683c\u53c2\u8003\u7ef4\u62a4\u4fe1\u606f\u5931\u8d25");
        }
    }

    private void saveOtherAccessoryList(UccUpdatePriceReferenceAbilityReqBO reqBO, UccPriceReferencePO modelBy) {
        OtherAccessoryPO delOtherAccessoryPo = new OtherAccessoryPO();
        delOtherAccessoryPo.setRelId(modelBy.getId());
        this.otherAccessoryMapper.deleteBy(delOtherAccessoryPo);
        ArrayList<OtherAccessoryPO> otherAccessoryPos = new ArrayList<OtherAccessoryPO>(reqBO.getUccOtherAccessoryBos().size());
        for (UccOtherAccessoryBo each : reqBO.getUccOtherAccessoryBos()) {
            OtherAccessoryPO otherAccessoryPo = new OtherAccessoryPO();
            otherAccessoryPo.setId(each.getId());
            otherAccessoryPo.setRelId(modelBy.getId());
            otherAccessoryPo.setAccessoryName(each.getAccessoryName());
            otherAccessoryPo.setAccessoryUrl(each.getAccessoryUrl());
            otherAccessoryPo.setCreateTime(new Date());
            otherAccessoryPo.setCreateUserId(reqBO.getUserId().toString());
            otherAccessoryPo.setCreateUserName(reqBO.getName());
            otherAccessoryPo.setCreateUserCode(reqBO.getOccupation());
            otherAccessoryPo.setType(UccConstants.OtherAccessoryType.JGCKWH);
            otherAccessoryPos.add(otherAccessoryPo);
        }
        this.otherAccessoryMapper.insertBatch(otherAccessoryPos);
    }
}

