/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.mq;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.busibase.atom.api.UccSendNotificationExtAtomService;
import com.tydic.commodity.busibase.atom.bo.UccSendNotificationExtAtomReqBO;
import com.tydic.commodity.common.ability.api.UccWaitDoneLogAbilityService;
import com.tydic.commodity.common.ability.bo.UccProcessTaskInfoWithInstAbilityBo;
import com.tydic.commodity.common.ability.bo.UccWaitDoneLogReqBo;
import com.tydic.commodity.common.ability.bo.UccWaitDoneLogRspBo;
import com.tydic.commodity.common.busi.api.UccAuditTaskBusiService;
import com.tydic.commodity.common.busi.bo.UccAuditTaskBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccAuditTaskBusiRspBo;
import com.tydic.commodity.common.busi.bo.UccProcessTaskInfoWithInstBo;
import com.tydic.commodity.dao.UccPriceReferenceMapper;
import com.tydic.commodity.po.UccPriceReferencePO;
import java.text.MessageFormat;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class UccAuditTaskConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccAuditTaskConsumer.class);
    @Value(value="${ucc.PriceReference.tag:UCC_MANAGEMENT_TAG}")
    private String uccPriceReferenceTag;
    @Autowired
    private UccAuditTaskBusiService xwglAuditTaskBusiService;
    @Autowired
    private UccWaitDoneLogAbilityService uccWaitDoneLogAbilityService;
    @Autowired
    private UccPriceReferenceMapper uccPriceReferenceMapper;
    @Value(value="${ucc.message.user:10301981}")
    private List<Long> messageUserList;
    @Value(value="${ucc.message.ip:http://egovue2.ego-test.chinacoal.com/#/index/}")
    private String IP;
    @Autowired
    private UccSendNotificationExtAtomService uccSendNotificationExtAtomService;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        String content = proxyMessage.getContent();
        log.info("\u6d41\u7a0b\u4efb\u52a1\u6d88\u8d39\u8005\u6536\u5230\uff0c\u6570\u636e\u5185\u5bb9\u5982\u4e0b{}", (Object)content);
        UccProcessTaskInfoWithInstBo withInstBo = (UccProcessTaskInfoWithInstBo)JSON.parseObject((String)content, UccProcessTaskInfoWithInstBo.class);
        if (this.uccPriceReferenceTag.equals(proxyMessage.getTag())) {
            withInstBo.setObjType(10);
        } else {
            log.error("\u6d41\u7a0b\u914d\u7f6e\u9519\u8bef\uff0c\u4e0d\u662f\u89c4\u5219\u5e93\u7684\u5ba1\u6279\u6d41");
        }
        UccAuditTaskBusiReqBo auditTaskBusiReqBo = new UccAuditTaskBusiReqBo();
        auditTaskBusiReqBo.setWithInstBo(withInstBo);
        UccAuditTaskBusiRspBo auditTaskBusiRspBo = this.xwglAuditTaskBusiService.dealAuditTask(auditTaskBusiReqBo);
        if (!"0000".equals(auditTaskBusiRspBo.getRespCode())) {
            log.error("\u5ba1\u6279\u4efb\u52a1\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)auditTaskBusiRspBo.getRespDesc());
        }
        if (auditTaskBusiRspBo.getRespCode().equals("0000")) {
            UccWaitDoneLogRspBo uccWaitDoneLogRspBo = this.dealPushWaitDone(withInstBo);
            if (!"0000".equals(uccWaitDoneLogRspBo.getRespCode())) {
                log.error("\u5f85\u529e\u63a8\u9001\u5904\u7406\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}", (Object)uccWaitDoneLogRspBo.getRespDesc());
            }
            this.sendInSiteMessage(withInstBo);
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void sendInSiteMessage(UccProcessTaskInfoWithInstBo withInstBo) {
        try {
            log.error("\u7ad9\u5185\u4fe1\u63a5\u6536\u4eba\u4e3a\uff1a{}", (Object)JSON.toJSONString(this.messageUserList));
            String objId = withInstBo.getProcessType();
            UccPriceReferencePO priceReferencePO = new UccPriceReferencePO();
            priceReferencePO.setId(Long.valueOf(objId));
            UccPriceReferencePO modelBy = this.uccPriceReferenceMapper.getModelBy(priceReferencePO);
            String extSkuId = modelBy.getExtSkuId();
            String title = MessageFormat.format("{0}_\u6700\u4f4e\u53c2\u8003\u4ef7\u7ef4\u62a4\u5f85\u5ba1\u6838", extSkuId);
            String text = MessageFormat.format("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5355\u54c1{0}_\u6700\u4f4e\u53c2\u8003\u4ef7\u7ef4\u62a4\u5f85\u5ba1\u6838\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002", extSkuId);
            String textUrl = this.IP + MessageFormat.format("orderDetail?type=1&routerPathName=ecMyOrder&upperVoucherNo={0}&upperOrderId={1}&orderId={2}&saleVoucherId={3}&isScFlag=0&erpAccountAliasName=-", extSkuId);
            String noticeText = this.convertUrl(text, textUrl);
            UccSendNotificationExtAtomReqBO uccSendNotificationExtAtomReqBO = new UccSendNotificationExtAtomReqBO();
            uccSendNotificationExtAtomReqBO.setText(noticeText);
            uccSendNotificationExtAtomReqBO.setTitel(title);
            uccSendNotificationExtAtomReqBO.setReceiveIds(this.messageUserList);
            uccSendNotificationExtAtomReqBO.setUserId(Long.valueOf(1L));
            this.uccSendNotificationExtAtomService.sendNotification(uccSendNotificationExtAtomReqBO);
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u7ad9\u5185\u4fe1\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private String convertUrl(String text, String textUrl) {
        String noticeText = "";
        noticeText = !StringUtils.isEmpty((Object)textUrl) ? "<a href=\"" + textUrl + "\">" + text + "</a>" : text;
        return noticeText;
    }

    private UccWaitDoneLogRspBo dealPushWaitDone(UccProcessTaskInfoWithInstBo withInstBo) {
        UccWaitDoneLogRspBo uccWaitDoneLogRspBo = new UccWaitDoneLogRspBo();
        try {
            UccWaitDoneLogReqBo waitDoneLogReqBo = new UccWaitDoneLogReqBo();
            UccProcessTaskInfoWithInstAbilityBo uccProcessTaskInfoWithInstAbilityBo = new UccProcessTaskInfoWithInstAbilityBo();
            BeanUtils.copyProperties((Object)withInstBo, (Object)uccProcessTaskInfoWithInstAbilityBo);
            waitDoneLogReqBo.setWithInstBo(uccProcessTaskInfoWithInstAbilityBo);
            uccWaitDoneLogRspBo = this.uccWaitDoneLogAbilityService.dealRePushFinal(waitDoneLogReqBo);
        }
        catch (Exception e) {
            log.error("\u5f85\u529e\u63a8\u9001\u5904\u7406\u8fdc\u7a0b\uff1a", (Throwable)e);
        }
        return uccWaitDoneLogRspBo;
    }
}

