/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMaterialInfoQueryAbilityRspBo;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccEMdmMaterialPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccMaterialInfoQueryAbilityService"})
public class UccMaterialInfoQueryAbilityServiceImpl
implements UccMaterialInfoQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccMaterialInfoQueryAbilityServiceImpl.class);
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    @Autowired
    private UccEMdmCatalogMapper uccMdmCatalogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"getUccMaterialInfo"})
    public UccMaterialInfoQueryAbilityRspBo getUccMaterialInfo(@RequestBody UccMaterialInfoQueryAbilityReqBo reqBo) {
        UccMaterialInfoQueryAbilityRspBo rspBo = new UccMaterialInfoQueryAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (reqBo.isQueryErpFlag() && StringUtils.isEmpty((Object)reqBo.getUserErpCode()) && !"0".equals(reqBo.getIsprofess())) {
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        UccEMdmMaterialPO uccEMdmMaterialPo = new UccEMdmMaterialPO();
        uccEMdmMaterialPo.setCatalogId(reqBo.getCatalogId());
        uccEMdmMaterialPo.setCatalogName(reqBo.getCatalogName());
        uccEMdmMaterialPo.setMaterialName(reqBo.getMaterialName());
        uccEMdmMaterialPo.setMaterialId(reqBo.getMaterialId());
        uccEMdmMaterialPo.setQueryString(reqBo.getQueryString());
        uccEMdmMaterialPo.setFreezeFlag(reqBo.getFreezeFlag());
        uccEMdmMaterialPo.setMaterialCode(reqBo.getMaterialCode());
        uccEMdmMaterialPo.setCatalogCode(reqBo.getCatalogCode());
        uccEMdmMaterialPo.setUserErpCode(reqBo.getUserErpCode());
        ArrayList<UccMaterialInfoQueryAbilityBo> uccMaterialInfoQueryAbilityBos = new ArrayList<UccMaterialInfoQueryAbilityBo>();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        List uccEMdmMaterialPos = this.uccEMdmMaterialMapper.queryList(page, uccEMdmMaterialPo);
        if (!CollectionUtils.isEmpty((Collection)uccEMdmMaterialPos)) {
            Map<String, String> freezeFlagMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FREEZE_FLAG");
            for (UccEMdmMaterialPO uccEMdmMaterialPo1 : uccEMdmMaterialPos) {
                UccMaterialInfoQueryAbilityBo uccMaterialInfoQueryAbilityBo = new UccMaterialInfoQueryAbilityBo();
                BeanUtils.copyProperties((Object)uccEMdmMaterialPo1, (Object)uccMaterialInfoQueryAbilityBo);
                uccMaterialInfoQueryAbilityBo.setCatalogId(uccEMdmMaterialPo1.getCatalogId());
                uccMaterialInfoQueryAbilityBo.setMaterialId(uccEMdmMaterialPo1.getMaterialId().toString());
                uccMaterialInfoQueryAbilityBo.setMaterialName(uccEMdmMaterialPo1.getMaterialName());
                uccMaterialInfoQueryAbilityBo.setMaterialDesc(uccEMdmMaterialPo1.getLongDesc());
                uccMaterialInfoQueryAbilityBo.setMaterialModel(uccEMdmMaterialPo1.getModel());
                uccMaterialInfoQueryAbilityBo.setMaterialSpec(uccEMdmMaterialPo1.getSpec());
                uccMaterialInfoQueryAbilityBo.setUnit(uccEMdmMaterialPo1.getMeasure());
                uccMaterialInfoQueryAbilityBo.setMaterialCode(uccEMdmMaterialPo1.getMaterialCode());
                uccMaterialInfoQueryAbilityBo.setCatalogCode(uccEMdmMaterialPo1.getCatalogCode());
                uccMaterialInfoQueryAbilityBo.setBrandId(uccEMdmMaterialPo1.getBrandId());
                uccMaterialInfoQueryAbilityBo.setBrandName(uccEMdmMaterialPo1.getBrandName());
                uccMaterialInfoQueryAbilityBo.setMeasureId(uccEMdmMaterialPo1.getMeasureId());
                this.getAllName(uccMaterialInfoQueryAbilityBo);
                if (uccMaterialInfoQueryAbilityBo.getFreezeFlag() != null && !CollectionUtils.isEmpty(freezeFlagMap)) {
                    uccMaterialInfoQueryAbilityBo.setFreezeFlagDesc(freezeFlagMap.get(uccMaterialInfoQueryAbilityBo.getFreezeFlag().toString()));
                }
                uccMaterialInfoQueryAbilityBos.add(uccMaterialInfoQueryAbilityBo);
            }
        }
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uccMaterialInfoQueryAbilityBos);
        return rspBo;
    }

    private void getAllName(UccMaterialInfoQueryAbilityBo bo) {
        UccEMdmCatalogPO uccEMdmCatalogPO;
        if (null != bo && bo.getCatalogId() != null && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(bo.getCatalogId())) != null) {
            StringBuffer name = new StringBuffer(uccEMdmCatalogPO.getCatalogName());
            while (uccEMdmCatalogPO.getParentCatalogId() != null && uccEMdmCatalogPO.getParentCatalogId() != 0L && (uccEMdmCatalogPO = this.uccMdmCatalogMapper.queryByCatId(uccEMdmCatalogPO.getParentCatalogId())) != null) {
                name = new StringBuffer(uccEMdmCatalogPO.getCatalogName()).append("/").append(name);
            }
            bo.setCatalogNameAll(name.toString());
        }
    }
}

