/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.FuzzyFieldsEnum;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.comb.api.UccConfigurationparametersDetailCombService;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccConfigurationparametersDetailCombRspBO;
import com.tydic.commodity.common.ability.api.SearchCommodityManageAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityReqBo;
import com.tydic.commodity.common.ability.bo.SearchCommodityManageAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolRelDataQryListAbilityBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccSkuPoolSkuListQryAbilityRspBo;
import com.tydic.commodity.dao.UccAddCoefficientMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuAddCoefficientMapper;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.commodity.po.UccSkuAddCoefficientPO;
import com.tydic.commodity.utils.ValidatorUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuPoolSkuListQryAbilityService"})
public class UccSkuPoolSkuListQryAbilityServiceImpl
implements UccSkuPoolSkuListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuPoolSkuListQryAbilityServiceImpl.class);
    @Autowired
    private SearchCommodityManageAbilityService searchCommodityManageAbilityService;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccAddCoefficientMapper uccAddCoefficientMapper;
    @Autowired
    private UccSkuAddCoefficientMapper uccSkuAddCoefficientMapper;
    @Autowired
    private UccConfigurationparametersDetailCombService uccConfigurationparametersDetailAbilityService;

    @PostMapping(value={"qrySkuPoolskuList"})
    public UccSkuPoolSkuListQryAbilityRspBo qrySkuPoolskuList(@RequestBody UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            rspBo.setRespDesc(e.getMessage());
            rspBo.setRespCode("8888");
            return rspBo;
        }
        switch (reqBo.getSearchType()) {
            case 0: {
                rspBo = this.getNRelSkuList(reqBo);
                break;
            }
            case 1: {
                rspBo = this.getRelSkuList(reqBo);
            }
        }
        this.markupRatePv(rspBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        cnncRelPoolCommodityPo.setPoolRelated(UccConstants.PoolRelatedType.relBySku);
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        List<Long> relSkuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos) && reqBo.getSkuId() == null) {
            relSkuIds = cnncRelPoolCommodityPos.stream().map(a -> a.getSource()).collect(Collectors.toList());
        }
        if (reqBo.getSkuId() != null) {
            relSkuIds.add(reqBo.getSkuId());
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        searchCommodityManageAbilityReqBo.setPoolIds((List)Lists.newArrayList((Object[])new Long[]{reqBo.getPoolId()}));
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setSkuList(relSkuIds);
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }

    private UccSkuPoolSkuListQryAbilityRspBo getNRelSkuList(UccSkuPoolSkuListQryAbilityReqBo reqBo) {
        SearchCommodityManageAbilityRspBo searchCommodityManageAbilityRspBo;
        UccSkuPoolSkuListQryAbilityRspBo rspBo = new UccSkuPoolSkuListQryAbilityRspBo();
        ArrayList uccSkuPoolRelDataQryListAbilityBos = new ArrayList();
        Page page = new Page(-1, reqBo.getPageSize());
        UccRelPoolCommodityPo cnncRelPoolCommodityPo = new UccRelPoolCommodityPo();
        cnncRelPoolCommodityPo.setPoolId(reqBo.getPoolId());
        List<Object> relDatas = new ArrayList();
        Map<Object, Object> typeAndPos = new HashMap();
        List cnncRelPoolCommodityPos = this.uccRelPoolCommodityMapper.queryPageList(page, cnncRelPoolCommodityPo);
        if (!CollectionUtils.isEmpty((Collection)cnncRelPoolCommodityPos)) {
            typeAndPos = cnncRelPoolCommodityPos.stream().collect(Collectors.groupingBy(a -> a.getPoolRelated()));
        }
        SearchCommodityManageAbilityReqBo searchCommodityManageAbilityReqBo = new SearchCommodityManageAbilityReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)searchCommodityManageAbilityReqBo);
        for (Map.Entry<Object, Object> each2 : typeAndPos.entrySet()) {
            relDatas = ((List)each2.getValue()).stream().map(a -> a.getSource()).collect(Collectors.toList());
            switch ((Integer)each2.getKey()) {
                case 1: {
                    searchCommodityManageAbilityReqBo.setIgnoreTypeIds(relDatas);
                    break;
                }
                case 2: {
                    searchCommodityManageAbilityReqBo.setIgnoreAgrIds(relDatas);
                    break;
                }
                case 3: {
                    searchCommodityManageAbilityReqBo.setIgnoreVendorIds(relDatas);
                    break;
                }
                case 4: {
                    searchCommodityManageAbilityReqBo.setIgnoreList(relDatas);
                    break;
                }
                case 5: {
                    searchCommodityManageAbilityReqBo.setIgnorSpuList(relDatas);
                }
            }
        }
        if (reqBo.getSkuId() != null) {
            searchCommodityManageAbilityReqBo.setSkuList((List)Lists.newArrayList((Object[])new Long[]{reqBo.getSkuId()}));
        }
        searchCommodityManageAbilityReqBo.setCommodityName(reqBo.getCommodityName());
        searchCommodityManageAbilityReqBo.setCommodityCode(reqBo.getCommodityCode());
        searchCommodityManageAbilityReqBo.setSkuCode(reqBo.getSkuCode());
        searchCommodityManageAbilityReqBo.setSkuName(reqBo.getSkuName());
        searchCommodityManageAbilityReqBo.setTypeId(reqBo.getCommodityTypeId());
        searchCommodityManageAbilityReqBo.setVendorId(reqBo.getVendorId());
        searchCommodityManageAbilityReqBo.setAgreementIds(reqBo.getAgreementIds());
        searchCommodityManageAbilityReqBo.setBrandId(reqBo.getBrandId());
        searchCommodityManageAbilityReqBo.setPageSize(Integer.valueOf(reqBo.getPageSize()));
        searchCommodityManageAbilityReqBo.setPageNo(Integer.valueOf(reqBo.getPageNo()));
        List fuzzyFields = FuzzyFieldsEnum.getAllField();
        fuzzyFields.add("commodityName");
        fuzzyFields.add("commodityCode");
        searchCommodityManageAbilityReqBo.setFuzzyFields(fuzzyFields);
        searchCommodityManageAbilityReqBo.setMinDiscounts(reqBo.getDiscountStar());
        searchCommodityManageAbilityReqBo.setMaxDiscounts(reqBo.getDiscountEnd());
        searchCommodityManageAbilityReqBo.setMinSalesPrice(reqBo.getSalePriceStar());
        searchCommodityManageAbilityReqBo.setMaxSalesPrice(reqBo.getSalePriceEnd());
        searchCommodityManageAbilityReqBo.setMinMarketPrice(reqBo.getMarketPriceStar());
        searchCommodityManageAbilityReqBo.setMaxMarketPrice(reqBo.getMarketPriceEnd());
        if (!StringUtils.isEmpty((Object)reqBo.getStatus())) {
            searchCommodityManageAbilityReqBo.setSkuStatus(Arrays.asList(reqBo.getStatus()));
        }
        if (reqBo.getType() == 1) {
            searchCommodityManageAbilityReqBo.setIsFieldSku(Boolean.valueOf(false));
        }
        if ("0000".equals((searchCommodityManageAbilityRspBo = this.searchCommodityManageAbilityService.searchCommodity(searchCommodityManageAbilityReqBo)).getRespCode())) {
            if (!CollectionUtils.isEmpty((Collection)searchCommodityManageAbilityRspBo.getResult())) {
                searchCommodityManageAbilityRspBo.getResult().forEach(each -> {
                    UccSkuPoolRelDataQryListAbilityBo uccSkuPoolRelDataQryListAbilityBo = new UccSkuPoolRelDataQryListAbilityBo();
                    BeanUtils.copyProperties((Object)each, (Object)uccSkuPoolRelDataQryListAbilityBo);
                    if (uccSkuPoolRelDataQryListAbilityBo.getAgreementId() != null && uccSkuPoolRelDataQryListAbilityBo.getAgreementId() == 0L) {
                        uccSkuPoolRelDataQryListAbilityBo.setAgreementId(null);
                    }
                    uccSkuPoolRelDataQryListAbilityBo.setPicUrl(each.getComPicUrl());
                    uccSkuPoolRelDataQryListAbilityBos.add(uccSkuPoolRelDataQryListAbilityBo);
                });
            }
            rspBo.setRecordsTotal(searchCommodityManageAbilityRspBo.getRecordsTotal());
            rspBo.setTotal(searchCommodityManageAbilityRspBo.getTotal());
            rspBo.setPageNo(searchCommodityManageAbilityRspBo.getPageNo());
        }
        rspBo.setRows(uccSkuPoolRelDataQryListAbilityBos);
        return rspBo;
    }

    private void markupRatePv(UccSkuPoolSkuListQryAbilityRspBo rspBO) {
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            List addCoefficientPOS;
            List skus = rspBO.getRows().stream().map(a -> a.getSkuId()).collect(Collectors.toList());
            List uccSkuAddCoefficientPOList = this.uccSkuAddCoefficientMapper.selectBySkuIds(skus);
            Map<Object, Object> skuCoefficient = new HashMap();
            if (!CollectionUtils.isEmpty((Collection)uccSkuAddCoefficientPOList)) {
                skuCoefficient = uccSkuAddCoefficientPOList.stream().collect(Collectors.toMap(UccSkuAddCoefficientPO::getSkuId, UccSkuAddCoefficientPO::getAddCoefficient));
            }
            HashSet catalogIds = new HashSet();
            rspBO.getRows().forEach(a -> {
                if (a.getL4mgCategoryId() != null) {
                    catalogIds.add(a.getL4mgCategoryId());
                }
            });
            HashMap typeCoefficient = new HashMap();
            if (!catalogIds.isEmpty() && !CollectionUtils.isEmpty((Collection)(addCoefficientPOS = this.uccAddCoefficientMapper.qryCoefficientByCatalogIds(new ArrayList(catalogIds), null)))) {
                addCoefficientPOS.forEach(a -> typeCoefficient.put("" + a.getCatalogId() + a.getSupplierShopId(), a.getAddCoefficient()));
            }
            BigDecimal defaultCoefficient = null;
            UccConfigurationparametersDetailCombReqBO parametersDetailAbilityReqBO = new UccConfigurationparametersDetailCombReqBO();
            parametersDetailAbilityReqBO.setParamsCode("ESTORE_DEFAULT_COEFFICIENT");
            UccConfigurationparametersDetailCombRspBO detailAbilityRspBO = this.uccConfigurationparametersDetailAbilityService.getparametersDetail(parametersDetailAbilityReqBO);
            if ("0000".equals(detailAbilityRspBO.getRespCode()) && !CollectionUtils.isEmpty((Collection)detailAbilityRspBO.getRows())) {
                defaultCoefficient = new BigDecimal(((UccConfigurationparametersCombQryBO)detailAbilityRspBO.getRows().get(0)).getRule());
            }
            for (UccSkuPoolRelDataQryListAbilityBo each : rspBO.getRows()) {
                if (skuCoefficient.containsKey(each.getSkuId())) {
                    each.setMarkupRate((BigDecimal)skuCoefficient.get(each.getSkuId()));
                    continue;
                }
                if (typeCoefficient.containsKey("" + each.getL4mgCategoryId() + each.getSupplierShopId())) {
                    each.setMarkupRate((BigDecimal)typeCoefficient.get("" + each.getL4mgCategoryId() + each.getSupplierShopId()));
                    continue;
                }
                if (defaultCoefficient == null) continue;
                each.setMarkupRate(defaultCoefficient);
            }
        }
    }
}

