/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccStandardPriceListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccStandardPriceBO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccStandardPriceListQryAbilityRspBO;
import com.tydic.commodity.dao.UccSkuPriceLogMapper;
import com.tydic.commodity.dao.UccStandardPriceListQryAbilityMapper;
import com.tydic.commodity.po.UccSkuPriceLogPo;
import com.tydic.commodity.po.UccStandardPriceListQryAbilityPO;
import com.tydic.commodity.utils.MoneyUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccStandardPriceListQryAbilityService"})
public class UccStandardPriceListQryAbilityServiceImpl
implements UccStandardPriceListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccStandardPriceListQryAbilityServiceImpl.class);
    @Autowired
    private UccStandardPriceListQryAbilityMapper uccStandardPriceListQryAbilityMapper;
    @Autowired
    private UccBaseDictionaryAtomService uccEstoreDictionaryAtomService;
    @Autowired
    private UccSkuPriceLogMapper uccSkuPriceLogMapper;
    @Value(value="${discount_digit:6}")
    private String digit;

    @PostMapping(value={"qryStandardPriceList"})
    public UccStandardPriceListQryAbilityRspBO qryStandardPriceList(@RequestBody UccStandardPriceListQryAbilityReqBO reqBO) {
        UccStandardPriceListQryAbilityRspBO rspBO = new UccStandardPriceListQryAbilityRspBO();
        if (reqBO.getSkuStatus() != null && reqBO.getSkuStatus() == 5) {
            reqBO.setSkuStatusList((List)Lists.newArrayList((Object[])new Integer[]{5, 7, 10, 11}));
        }
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        List res = this.uccStandardPriceListQryAbilityMapper.qryStandardPriceList(reqBO, page);
        if (res == null || res.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("0000");
            return rspBO;
        }
        List<UccStandardPriceBO> rows = this.packageRsp(res);
        int sequence = 1;
        if (rows != null && rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                UccStandardPriceBO uccStandardPriceBO = rows.get(i);
                uccStandardPriceBO.setSerialNumber(Integer.valueOf(sequence));
                ++sequence;
            }
        }
        rspBO.setRows(rows);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public List<UccStandardPriceBO> packageRsp(List<UccStandardPriceListQryAbilityPO> res) {
        Map skuStatus = this.uccEstoreDictionaryAtomService.queryBypCodeBackMap("SKU_STATUS");
        ArrayList<UccStandardPriceBO> rows = new ArrayList<UccStandardPriceBO>();
        ArrayList<Integer> skuSoldOutStatusList = new ArrayList<Integer>(Arrays.asList(5, 7, 10, 11));
        for (UccStandardPriceListQryAbilityPO re : res) {
            UccStandardPriceBO uccStandardPriceBO = new UccStandardPriceBO();
            BeanUtils.copyProperties((Object)re, (Object)uccStandardPriceBO);
            BigDecimal marketPriceHao = re.getMarketPrice();
            BigDecimal agreementPriceHao = re.getAgreementPrice();
            if (marketPriceHao != null && agreementPriceHao != null) {
                BigDecimal marketPriceYuan = MoneyUtils.haoToYuan((BigDecimal)marketPriceHao);
                BigDecimal agreementPriceYuan = MoneyUtils.haoToYuan((BigDecimal)agreementPriceHao);
                BigDecimal discount = agreementPriceYuan.divide(marketPriceYuan, (int)Integer.valueOf(this.digit), 5);
                BigDecimal standardPrice = re.getStandardPrice();
                uccStandardPriceBO.setMarketPrice(marketPriceYuan);
                uccStandardPriceBO.setAgreementPrice(agreementPriceYuan);
                uccStandardPriceBO.setDiscount(discount);
                uccStandardPriceBO.setOldDiscount(discount);
                uccStandardPriceBO.setOldMarketPrice(marketPriceYuan);
                BigDecimal floatPriceDifference = agreementPriceYuan.subtract(standardPrice);
                uccStandardPriceBO.setFloatPriceDifference(floatPriceDifference);
                BigDecimal multiply = floatPriceDifference.divide(standardPrice, 4, 5).multiply(new BigDecimal(100));
                uccStandardPriceBO.setFloatRate(multiply);
                int i = agreementPriceYuan.compareTo(standardPrice);
                if (i == 1) {
                    uccStandardPriceBO.setSurpassStandardPriceFlag(Integer.valueOf(1));
                    uccStandardPriceBO.setSurpassStandardPriceFlagStr("\u662f");
                } else {
                    uccStandardPriceBO.setSurpassStandardPriceFlag(Integer.valueOf(0));
                    uccStandardPriceBO.setSurpassStandardPriceFlagStr("\u5426");
                }
            } else {
                uccStandardPriceBO.setSurpassStandardPriceFlag(Integer.valueOf(0));
                uccStandardPriceBO.setSurpassStandardPriceFlagStr("\u5426");
            }
            if (re.getSkuStatus() != null) {
                if (skuSoldOutStatusList.contains(re.getSkuStatus())) {
                    uccStandardPriceBO.setSkuStatusStr("\u5df2\u4e0b\u67b6");
                } else {
                    uccStandardPriceBO.setSkuStatusStr((String)skuStatus.get(uccStandardPriceBO.getSkuStatus().toString()));
                }
            }
            if (uccStandardPriceBO.getBrandVerifyFlag() != null) {
                uccStandardPriceBO.setBrandVerifyFlagStr(uccStandardPriceBO.getBrandVerifyFlag() == 1 ? "\u662f" : "\u5426");
            } else {
                uccStandardPriceBO.setBrandVerifyFlag(Integer.valueOf(0));
                uccStandardPriceBO.setBrandVerifyFlagStr("\u5426");
            }
            if (uccStandardPriceBO.getSkuId() != null) {
                uccStandardPriceBO.setPutInStorageFlag(Integer.valueOf(1));
                uccStandardPriceBO.setPutInStorageFlagStr("\u662f");
            } else {
                uccStandardPriceBO.setPutInStorageFlag(Integer.valueOf(0));
                uccStandardPriceBO.setPutInStorageFlagStr("\u5426");
            }
            if (re.getUpRatio() != null) {
                uccStandardPriceBO.setUpRatio(re.getUpRatio());
            }
            UccSkuPriceLogPo skuPriceLogPo = new UccSkuPriceLogPo();
            skuPriceLogPo.setSkuId(re.getSkuId());
            skuPriceLogPo.setOrderBy("CREATE_TIME");
            List uccSkuPriceLogPos = this.uccSkuPriceLogMapper.conditiQrySkuLog(skuPriceLogPo);
            if (uccSkuPriceLogPos != null && uccSkuPriceLogPos.size() > 0) {
                UccSkuPriceLogPo uccSkuPriceLogPo = (UccSkuPriceLogPo)uccSkuPriceLogPos.get(0);
                Long logMarketPrice = uccSkuPriceLogPo.getMarketPrice();
                Long logAgreementPrice = uccSkuPriceLogPo.getAgreementPrice();
                if (logMarketPrice != null && logAgreementPrice != null && !logMarketPrice.equals(0)) {
                    BigDecimal logOldDiscount = MoneyUtils.haoToYuan((Long)logAgreementPrice).divide(MoneyUtils.haoToYuan((Long)logMarketPrice), (int)Integer.valueOf(this.digit), 5);
                    uccStandardPriceBO.setOldDiscount(logOldDiscount);
                }
                if (!StringUtils.isEmpty((Object)logMarketPrice)) {
                    uccStandardPriceBO.setOldMarketPrice(MoneyUtils.haoToYuan((Long)logMarketPrice));
                }
            }
            rows.add(uccStandardPriceBO);
        }
        return rows;
    }
}

