/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccUpperTaxCatCodeQryAbilityRspBo;
import com.tydic.commodity.dao.UccCommodityTaxTypeMapper;
import com.tydic.commodity.po.UccCommodityTaxTypePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccUpperTaxCatCodeQryAbilityService"})
public class UccUpperTaxCatCodeQryAbilityServiceImpl
implements UccUpperTaxCatCodeQryAbilityService {
    @Autowired
    private UccCommodityTaxTypeMapper uccCommodityTaxTypeMapper;

    @PostMapping(value={"qryUpperTaxCatCode"})
    public UccUpperTaxCatCodeQryAbilityRspBo qryUpperTaxCatCode(@RequestBody UccUpperTaxCatCodeQryAbilityReqBo reqBo) {
        UccUpperTaxCatCodeQryAbilityRspBo rspBo = new UccUpperTaxCatCodeQryAbilityRspBo();
        UccCommodityTaxTypePO uccCommodityTaxTypePO = new UccCommodityTaxTypePO();
        List uccCommodityTaxTypePOS = this.uccCommodityTaxTypeMapper.getList(uccCommodityTaxTypePO);
        HashMap<String, List<Long>> taxCatCodeMap = new HashMap<String, List<Long>>();
        if (!CollectionUtils.isEmpty((Collection)uccCommodityTaxTypePOS) && !CollectionUtils.isEmpty((Collection)reqBo.getTaxCodes())) {
            for (String taxCode : reqBo.getTaxCodes()) {
                List<Long> taxIds = this.getUpperIds(taxCode, uccCommodityTaxTypePOS);
                taxCatCodeMap.put(taxCode, taxIds);
            }
        }
        rspBo.setTaxCatCodeMap(taxCatCodeMap);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> getUpperIds(String taxCode, List<UccCommodityTaxTypePO> pos) {
        ArrayList<Long> taxIds = new ArrayList<Long>();
        List poList = pos.stream().filter(a -> a.getTaxCode().equals(taxCode)).collect(Collectors.toList());
        UccCommodityTaxTypePO nowPo = (UccCommodityTaxTypePO)poList.get(0);
        taxIds.add(Long.valueOf(nowPo.getTaxCode()));
        Long upTaxId = nowPo.getUpTaxId();
        int i = 1;
        while (upTaxId != null && upTaxId != 0L && i <= 999) {
            ++i;
            boolean flag = true;
            for (UccCommodityTaxTypePO po : pos) {
                if (!upTaxId.equals(po.getTaxId())) continue;
                upTaxId = po.getUpTaxId();
                taxIds.add(Long.valueOf(po.getTaxCode()));
                flag = false;
                break;
            }
            if (!flag) continue;
            break;
        }
        Collections.reverse(taxIds);
        return taxIds;
    }
}

