/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccWarehouseBuyerAbilityService;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerAddAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerAddAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerAddBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerImportAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerImportAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerListPageQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerListPageQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerUpdateAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseBuyerUpdateAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.common.busi.api.UccWarehouseBuyerBusiService;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerAddBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerImportBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerImportBusiRspBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerUpdateBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccWarehouseBuyerUpdateBusiRspBO;
import com.tydic.commodity.common.external.util.BatchImportUtils;
import com.tydic.commodity.dao.UccWarehouseBuyerMapper;
import com.tydic.commodity.po.UccWarehouseBuyerPO;
import com.tydic.umc.general.ability.api.CnncUmcFileImpLogAbilityService;
import com.tydic.umc.general.ability.api.UmcDycEnterpriseOrgQryListPageAbilityService;
import com.tydic.umc.general.ability.bo.BusinessChangeFileAnnoxBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityReqBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogAbilityRspBO;
import com.tydic.umc.general.ability.bo.CnncUmcFileImpLogDetailBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryListPageAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgQryListPageAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccWarehouseBuyerAbilityService"})
public class UccWarehouseBuyerAbilityServiceImpl
implements UccWarehouseBuyerAbilityService {
    @Autowired
    private UccWarehouseBuyerMapper uccWarehouseBuyerMapper;
    @Autowired
    private UccWarehouseBuyerBusiService uccWarehouseBuyerBusiService;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private CnncUmcFileImpLogAbilityService cnncUmcFileImpLogAbilityService;
    @Autowired
    private UmcDycEnterpriseOrgQryListPageAbilityService umcDycEnterpriseOrgQryListPageAbilityService;

    @PostMapping(value={"addWarehouseBuyer"})
    public UccWarehouseBuyerAddAbilityRspBO addWarehouseBuyer(@RequestBody UccWarehouseBuyerAddAbilityReqBO reqBO) {
        if (reqBO.getWarehouseId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> buyerNoList = new ArrayList<String>();
        for (UccWarehouseBuyerAddBO uccWarehouseBuyerAddBO : reqBO.getBuyerList()) {
            if (uccWarehouseBuyerAddBO.getOrgIdWeb() == null) {
                throw new BusinessException("0001", "\u5165\u53c2[orgIdWeb]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)uccWarehouseBuyerAddBO.getOrgCodeWeb())) {
                throw new BusinessException("0001", "\u5165\u53c2[orgCodeWeb]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)uccWarehouseBuyerAddBO.getOrgNameWeb())) {
                throw new BusinessException("0001", "\u5165\u53c2[orgNameWeb]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)uccWarehouseBuyerAddBO.getBuynerName())) {
                throw new BusinessException("0001", "\u5165\u53c2[buynerName]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            buyerNoList.add(uccWarehouseBuyerAddBO.getOrgCodeWeb());
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UccWarehouseBuyerAddBusiReqBO busiReqBO = (UccWarehouseBuyerAddBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UccWarehouseBuyerAddBusiReqBO.class));
        busiReqBO.setOrgCodeList(buyerNoList);
        UccWarehouseBuyerAddBusiRspBO busiRspBO = this.uccWarehouseBuyerBusiService.addWarehouseBuyer(busiReqBO);
        return (UccWarehouseBuyerAddAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), UccWarehouseBuyerAddAbilityRspBO.class);
    }

    @PostMapping(value={"updateWarehouseBuyer"})
    public UccWarehouseBuyerUpdateAbilityRspBO updateWarehouseBuyer(@RequestBody UccWarehouseBuyerUpdateAbilityReqBO reqBO) {
        if (reqBO.getWarehouseId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UccWarehouseBuyerUpdateBusiReqBO busiReqBO = (UccWarehouseBuyerUpdateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UccWarehouseBuyerUpdateBusiReqBO.class));
        UccWarehouseBuyerUpdateBusiRspBO busiRspBO = this.uccWarehouseBuyerBusiService.updateWarehouseBuyer(busiReqBO);
        return (UccWarehouseBuyerUpdateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), UccWarehouseBuyerUpdateAbilityRspBO.class);
    }

    @PostMapping(value={"qryWarehouseBuyerList"})
    public UccWarehouseBuyerListPageQryAbilityRspBO qryWarehouseBuyerList(@RequestBody UccWarehouseBuyerListPageQryAbilityReqBO reqBO) {
        if (reqBO.getWarehouseId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        UccWarehouseBuyerPO buyerPO = new UccWarehouseBuyerPO();
        buyerPO.setOrgCode(reqBO.getOrgCodeWeb());
        buyerPO.setOrgName(reqBO.getOrgNameWeb());
        buyerPO.setStatus(reqBO.getStatus());
        buyerPO.setUpdateTimeStart(reqBO.getUpdateTimeStart());
        buyerPO.setWarehouseId(reqBO.getWarehouseId());
        buyerPO.setUpdateTimeEnd(reqBO.getUpdateTimeEnd());
        buyerPO.setUpdateUserName(reqBO.getUpdateUserName());
        buyerPO.setIds(reqBO.getIds());
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List list = this.uccWarehouseBuyerMapper.getListPage(buyerPO, page);
        UccWarehouseBuyerListPageQryAbilityRspBO rspBO = new UccWarehouseBuyerListPageQryAbilityRspBO();
        List orgCodeList = this.uccWarehouseBuyerMapper.getAllOrgCode();
        rspBO.setOrgCodeList(orgCodeList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(reqBO.getPageNo());
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRecordsTotal(0);
            rspBO.setTotal(0);
            return rspBO;
        }
        Map<String, String> statusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("UCC_WAREHOUSE_STATUS");
        ArrayList<UccWarehouseBuyerBO> rows = new ArrayList<UccWarehouseBuyerBO>(list.size());
        for (UccWarehouseBuyerPO uccWarehouseBuyerPO : list) {
            UccWarehouseBuyerBO buyerBO = new UccWarehouseBuyerBO();
            BeanUtils.copyProperties((Object)uccWarehouseBuyerPO, (Object)buyerBO);
            buyerBO.setStatusStr(statusMap.get(buyerBO.getStatus() + ""));
            rows.add(buyerBO);
        }
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalCount());
        return rspBO;
    }

    @PostMapping(value={"dealImportWarehouseBuyer"})
    public UccWarehouseBuyerImportAbilityRspBO dealImportWarehouseBuyer(@RequestBody UccWarehouseBuyerImportAbilityReqBO reqBO) {
        List<List<String>> importDataMap;
        this.validImport(reqBO);
        UccWarehouseBuyerImportAbilityRspBO rspBO = new UccWarehouseBuyerImportAbilityRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u5355\u4f4d\u7f16\u7801");
        title.add("\u5355\u4f4d\u540d\u79f0");
        title.add("\u4e70\u53d7\u4eba\u540d\u79f0");
        title.add("\u505c\u7528/\u542f\u7528");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<UccWarehouseBuyerBO> batchImportUtils = new BatchImportUtils<UccWarehouseBuyerBO>(title, data, UccWarehouseBuyerBO.class);
            batchImportUtils.batchImport(reqBO.getFileUrl(), 0, 1, -1);
            importDataMap = batchImportUtils.getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        Integer failCount = 0;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<UccWarehouseBuyerBO> list = new ArrayList<UccWarehouseBuyerBO>();
        ArrayList<String> orgCodeList = new ArrayList<String>();
        ArrayList<CnncUmcFileImpLogDetailBO> logDetailBOS = new ArrayList<CnncUmcFileImpLogDetailBO>();
        for (List<String> row : importDataMap) {
            UccWarehouseBuyerBO uccWarehouseBuyerBO = new UccWarehouseBuyerBO();
            uccWarehouseBuyerBO.setSerialNumber(row.get(0));
            uccWarehouseBuyerBO.setOrgCode(row.get(1));
            uccWarehouseBuyerBO.setOrgName(row.get(2));
            uccWarehouseBuyerBO.setBuynerName(row.get(3));
            orgCodeList.add(uccWarehouseBuyerBO.getOrgCode());
            list.add(uccWarehouseBuyerBO);
        }
        ArrayList<UccWarehouseBuyerPO> buyerPOAddList = new ArrayList<UccWarehouseBuyerPO>(importDataMap.size());
        ArrayList<UccWarehouseBuyerPO> buyerPOUpdList = new ArrayList<UccWarehouseBuyerPO>();
        Map<Object, Object> enterpriseMap = new HashMap();
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            UmcDycEnterpriseOrgQryListPageAbilityReqBO enterpriseOrgQryListPageAbilityReqBO = new UmcDycEnterpriseOrgQryListPageAbilityReqBO();
            enterpriseOrgQryListPageAbilityReqBO.setOrgCodeList(orgCodeList);
            enterpriseOrgQryListPageAbilityReqBO.setPageSize(Integer.valueOf(orgCodeList.size()));
            enterpriseOrgQryListPageAbilityReqBO.setQueryType("03");
            enterpriseOrgQryListPageAbilityReqBO.setIntExtPropertys(Collections.singletonList("101"));
            UmcDycEnterpriseOrgQryListPageAbilityRspBO enterpriseOrgQryListPageAbilityRspBO = this.umcDycEnterpriseOrgQryListPageAbilityService.qryEnterpriseOrgListPage(enterpriseOrgQryListPageAbilityReqBO);
            if (!enterpriseOrgQryListPageAbilityRspBO.getRespCode().equals("0000")) {
                stringBuilder.append("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38:").append(enterpriseOrgQryListPageAbilityRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)enterpriseOrgQryListPageAbilityRspBO.getRows())) {
                stringBuilder.append("\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            enterpriseMap = enterpriseOrgQryListPageAbilityRspBO.getRows().stream().collect(Collectors.toMap(UmcDycEnterpriseOrgBO::getOrgCode, Function.identity(), (k1, k2) -> k1));
        }
        UccWarehouseBuyerPO warehouseBuyerPO = new UccWarehouseBuyerPO();
        warehouseBuyerPO.setWarehouseId(reqBO.getWarehouseId());
        warehouseBuyerPO.setOrgCodeList(orgCodeList);
        List warehouseBuyerPOList = this.uccWarehouseBuyerMapper.getList(warehouseBuyerPO);
        Map warehouseMap = warehouseBuyerPOList.stream().collect(Collectors.toMap(UccWarehouseBuyerPO::getOrgCode, Function.identity(), (k1, k2) -> k1));
        warehouseBuyerPO.setWarehouseId(null);
        warehouseBuyerPO.setWarehouseIdNot(reqBO.getWarehouseId());
        warehouseBuyerPO.setOrgCodeList(orgCodeList);
        warehouseBuyerPO.setStatus(UccConstants.WarehouseState.VALID);
        List hadList = this.uccWarehouseBuyerMapper.getList(warehouseBuyerPO);
        Map hadMap = hadList.stream().collect(Collectors.toMap(UccWarehouseBuyerPO::getOrgCode, Function.identity(), (k1, k2) -> k1));
        StringBuilder header = new StringBuilder();
        header.append("\u5e8f\u53f7");
        header.append("##");
        header.append("\u5355\u4f4d\u7f16\u7801");
        header.append("##");
        header.append("\u5355\u4f4d\u540d\u79f0");
        header.append("##");
        header.append("\u4e70\u53d7\u4eba\u540d\u79f0");
        for (UccWarehouseBuyerBO buyerBO : list) {
            Integer n;
            Integer n2;
            Integer n3;
            Integer n4;
            StringBuilder builder = new StringBuilder();
            builder.append(buyerBO.getSerialNumber());
            builder.append("##");
            builder.append(StringUtils.isEmpty((Object)buyerBO.getOrgCode()) ? " " : buyerBO.getOrgCode());
            builder.append("##");
            builder.append(StringUtils.isEmpty((Object)buyerBO.getOrgName()) ? " " : buyerBO.getOrgName());
            builder.append("##");
            builder.append(StringUtils.isEmpty((Object)buyerBO.getBuynerName()) ? " " : buyerBO.getBuynerName());
            CnncUmcFileImpLogDetailBO detailBO = new CnncUmcFileImpLogDetailBO();
            detailBO.setImpId(reqBO.getTempId());
            detailBO.setDataJson(builder.toString());
            if (StringUtils.isEmpty((Object)buyerBO.getOrgCode())) {
                n4 = failCount;
                n3 = failCount = Integer.valueOf(failCount + 1);
                detailBO.setStatus(Integer.valueOf(1));
                detailBO.setFailureReasons("\u5355\u4f4d\u7f16\u7801\u4e3a\u7a7a\uff01");
                logDetailBOS.add(detailBO);
                continue;
            }
            if (StringUtils.isEmpty((Object)buyerBO.getOrgName())) {
                n4 = failCount;
                n3 = failCount = Integer.valueOf(failCount + 1);
                detailBO.setStatus(Integer.valueOf(1));
                detailBO.setFailureReasons("\u5355\u4f4d\u540d\u79f0\u4e3a\u7a7a\uff01");
                logDetailBOS.add(detailBO);
                continue;
            }
            UccWarehouseBuyerPO buyerPO = new UccWarehouseBuyerPO();
            BeanUtils.copyProperties((Object)buyerBO, (Object)buyerPO);
            buyerPO.setUpdateUserAccount(reqBO.getUsername());
            buyerPO.setUpdateUserId(reqBO.getUserId());
            buyerPO.setUpdateUserName(reqBO.getName());
            buyerPO.setUpdateTime(new Date());
            UccWarehouseBuyerPO oldBuyerPO = (UccWarehouseBuyerPO)warehouseMap.get(buyerBO.getOrgCode());
            UccWarehouseBuyerPO hadBuyerPO = (UccWarehouseBuyerPO)hadMap.get(buyerBO.getOrgCode());
            UmcDycEnterpriseOrgBO umcDycEnterpriseOrgBO = (UmcDycEnterpriseOrgBO)enterpriseMap.get(buyerBO.getOrgCode());
            if (hadBuyerPO != null) {
                n2 = failCount;
                n = failCount = Integer.valueOf(failCount + 1);
                detailBO.setStatus(Integer.valueOf(1));
                detailBO.setFailureReasons("\u5b58\u5728\u5355\u4f4d\u5df2\u7ecf\u88ab\u9009\u62e9\uff0c\u8bf7\u5148\u8fdb\u884c\u505c\u7528\u4e4b\u540e\u91cd\u65b0\u9009\u62e9\uff01");
                logDetailBOS.add(detailBO);
                continue;
            }
            if (oldBuyerPO != null) {
                buyerPO.setId(oldBuyerPO.getId());
                buyerPOUpdList.add(buyerPO);
            } else {
                if (ObjectUtils.isEmpty((Object)umcDycEnterpriseOrgBO) || StringUtils.isEmpty((Object)umcDycEnterpriseOrgBO.getOrgCode())) {
                    n2 = failCount;
                    n = failCount = Integer.valueOf(failCount + 1);
                    detailBO.setStatus(Integer.valueOf(1));
                    detailBO.setFailureReasons("\u5355\u4f4d\u7f16\u7801[" + buyerBO.getOrgCode() + "]\u672a\u67e5\u8be2\u5230\u673a\u6784\u4fe1\u606f\uff01");
                    logDetailBOS.add(detailBO);
                    continue;
                }
                buyerPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                buyerPO.setOrgId(umcDycEnterpriseOrgBO.getOrgId());
                buyerPO.setErpOrgCode(umcDycEnterpriseOrgBO.getErpOrgCode());
                buyerPO.setWarehouseId(reqBO.getWarehouseId());
                buyerPO.setStatus(UccConstants.WarehouseState.VALID);
                buyerPO.setCreateUserName(reqBO.getName());
                buyerPO.setCreateUserId(reqBO.getUserId());
                buyerPO.setCreateUserAccount(reqBO.getUsername());
                buyerPO.setCreateTime(new Date());
                buyerPO.setUpdateTime(new Date());
                buyerPOAddList.add(buyerPO);
            }
            detailBO.setStatus(Integer.valueOf(0));
            logDetailBOS.add(detailBO);
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        UccWarehouseBuyerImportBusiReqBO busiReqBO = (UccWarehouseBuyerImportBusiReqBO)((Object)JSONObject.parseObject((String)reqString, UccWarehouseBuyerImportBusiReqBO.class));
        busiReqBO.setBuyerPOUpdList(buyerPOUpdList);
        busiReqBO.setBuyerPOAddList(buyerPOAddList);
        busiReqBO.setFailCount(failCount);
        busiReqBO.setSuccessCount(importDataMap.size() - failCount);
        busiReqBO.setFailReason(stringBuilder.toString());
        UccWarehouseBuyerImportBusiRspBO busiRspBO = this.uccWarehouseBuyerBusiService.dealImportWarehouseBuyer(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new BusinessException("8888", "\u5b58\u50a8\u6570\u636e\u5931\u8d25\uff01");
        }
        CnncUmcFileImpLogAbilityReqBO abilityReqBO = new CnncUmcFileImpLogAbilityReqBO();
        abilityReqBO.setImpId(reqBO.getTempId());
        abilityReqBO.setDataColumns(header.toString());
        abilityReqBO.setImpTime(new Date());
        abilityReqBO.setImpCount(Long.valueOf(importDataMap.size()));
        abilityReqBO.setSuccessCount(Long.valueOf(busiReqBO.getSuccessCount().intValue()));
        abilityReqBO.setFailureCount(Long.valueOf(failCount.intValue()));
        abilityReqBO.setMemIdIn(reqBO.getMemIdIn());
        abilityReqBO.setOutImpId(UccConstants.WarehouseImportType.BUYER_TEM_ID);
        abilityReqBO.setImpType("UCC_BUYER_IMPORT");
        abilityReqBO.setLogDetails(logDetailBOS);
        if (busiReqBO.getFailCount() > 0) {
            abilityReqBO.setImpResult(Integer.valueOf(0));
        } else {
            abilityReqBO.setImpResult(Integer.valueOf(1));
        }
        ArrayList<BusinessChangeFileAnnoxBO> fileUrlList = new ArrayList<BusinessChangeFileAnnoxBO>();
        BusinessChangeFileAnnoxBO annoxBO = new BusinessChangeFileAnnoxBO();
        annoxBO.setPath(reqBO.getFileUrl());
        fileUrlList.add(annoxBO);
        abilityReqBO.setFileUrl(fileUrlList);
        CnncUmcFileImpLogAbilityRspBO abilityRspBO = this.cnncUmcFileImpLogAbilityService.fileImpLogAdd(abilityReqBO);
        if (!abilityRspBO.getRespCode().equals("0000")) {
            rspBO.setRespCode(abilityRspBO.getRespCode());
            rspBO.setRespDesc("\u5bfc\u5165\u64cd\u4f5c\u6210\u529f!\u5b58\u50a8\u672c\u6b21\u5bfc\u5165\u7ed3\u679c\u8bb0\u5f55\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setImpId(abilityRspBO.getImpId());
        }
        return rspBO;
    }

    private void validImport(UccWarehouseBuyerImportAbilityReqBO reqBO) {
        if (reqBO.getWarehouseId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getFileUrl())) {
            throw new BusinessException("0001", "\u5165\u53c2[fileUrl]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getWarehouseId())) {
            throw new BusinessException("0001", "\u5165\u53c2[warehouseId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

