/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.SmartContainerCatalogBO;
import com.tydic.commodity.common.ability.bo.SmartContainerCatalogReqBO;
import com.tydic.commodity.common.ability.bo.SmartContainerCatalogRspBO;
import com.tydic.commodity.common.busi.api.SmartContainerCatalogBusiService;
import com.tydic.commodity.common.external.util.BatchImportUtils;
import com.tydic.commodity.dao.SmartContainerCatalogMapper;
import com.tydic.commodity.dao.SmartContainerImportMapper;
import com.tydic.commodity.po.SmartContainerCatalogPO;
import com.tydic.commodity.po.SmartContainerImportPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SmartContainerCatalogBusiServiceImpl
implements SmartContainerCatalogBusiService {
    @Autowired
    private SmartContainerCatalogMapper smartContainerCatalogMapper;
    @Autowired
    private SmartContainerImportMapper smartContainerImportMapper;

    @Override
    public SmartContainerCatalogRspBO qryScCatalogList(SmartContainerCatalogReqBO reqBO) {
        SmartContainerCatalogPO containerUserPO = new SmartContainerCatalogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)containerUserPO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.smartContainerCatalogMapper.getListPage(containerUserPO, page);
        SmartContainerCatalogRspBO rspBO = new SmartContainerCatalogRspBO();
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<SmartContainerCatalogBO> rows = new ArrayList<SmartContainerCatalogBO>();
            for (SmartContainerCatalogPO containerPO : list) {
                SmartContainerCatalogBO bo = new SmartContainerCatalogBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                rows.add(bo);
            }
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public SmartContainerCatalogRspBO dealUpdateSmart(SmartContainerCatalogReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5165\u53c2ID");
        }
        SmartContainerCatalogRspBO rspBO = new SmartContainerCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SmartContainerCatalogPO userPO = new SmartContainerCatalogPO();
        userPO.setId(reqBO.getId());
        userPO = (SmartContainerCatalogPO)this.smartContainerCatalogMapper.selectByCondition(userPO).get(0);
        if (1 == reqBO.getState()) {
            ArrayList<String> codes = new ArrayList<String>();
            codes.add(userPO.getCatalogCode());
            String str = this.check(codes);
            if (StringUtils.isNotBlank((CharSequence)str)) {
                throw new BusinessException("8888", "\u5f53\u524d\u5206\u7c7b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u8d27\u67dc\uff0c\u8bf7\u5148\u505c\u7528\u5176\u4ed6\u8d27\u67dc\u4e0b\u8be5\u5206\u7c7b\uff0c\u518d\u542f\u7528");
            }
        }
        userPO = new SmartContainerCatalogPO();
        userPO.setUpdateUserName(reqBO.getUsername());
        userPO.setUpdateUserId(reqBO.getUserId() + "");
        userPO.setUpdateName(reqBO.getName());
        userPO.setUpdateTime(new Date());
        userPO.setId(reqBO.getId());
        userPO.setState(reqBO.getState());
        this.smartContainerCatalogMapper.update(userPO);
        return rspBO;
    }

    @Override
    public SmartContainerCatalogRspBO dealAddScCatalog(SmartContainerCatalogReqBO reqBO) {
        String str;
        SmartContainerCatalogRspBO rspBO = new SmartContainerCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<SmartContainerCatalogPO> list = new ArrayList<SmartContainerCatalogPO>();
        ArrayList<String> codes = new ArrayList<String>();
        for (SmartContainerCatalogBO smartContainerCatalogBO : reqBO.getCatalogList()) {
            SmartContainerCatalogPO containerCatalogPO;
            Long id = Sequence.getInstance().nextId();
            if (smartContainerCatalogBO.getId() == null) {
                containerCatalogPO = new SmartContainerCatalogPO();
                BeanUtils.copyProperties((Object)smartContainerCatalogBO, (Object)containerCatalogPO);
                containerCatalogPO.setId(id);
                containerCatalogPO.setScId(reqBO.getScId());
                containerCatalogPO.setCreateName(reqBO.getName());
                containerCatalogPO.setCreateTime(new Date());
                containerCatalogPO.setCreateUserId(reqBO.getUserId() + "");
                containerCatalogPO.setCreateUserName(reqBO.getUsername());
                containerCatalogPO.setUpdateName(reqBO.getName());
                containerCatalogPO.setUpdateTime(new Date());
                containerCatalogPO.setUpdateUserId(reqBO.getUserId() + "");
                containerCatalogPO.setUpdateUserName(reqBO.getUsername());
                containerCatalogPO.setState(Integer.valueOf(1));
                codes.add(containerCatalogPO.getCatalogCode());
                list.add(containerCatalogPO);
                continue;
            }
            containerCatalogPO = new SmartContainerCatalogPO();
            containerCatalogPO.setId(smartContainerCatalogBO.getId());
            containerCatalogPO.setScId(reqBO.getScId());
            containerCatalogPO.setUpdateName(reqBO.getName());
            containerCatalogPO.setUpdateTime(new Date());
            containerCatalogPO.setUpdateUserId(reqBO.getUserId() + "");
            containerCatalogPO.setUpdateUserName(reqBO.getUsername());
            containerCatalogPO.setState(Integer.valueOf(3));
            this.smartContainerCatalogMapper.update(containerCatalogPO);
        }
        if (codes.size() > 0 && StringUtils.isNotBlank((CharSequence)(str = this.check(codes)))) {
            throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u8d27\u67dc\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
        }
        if (list.size() > 0) {
            this.smartContainerCatalogMapper.insertBatch(list);
        }
        return rspBO;
    }

    @Override
    public SmartContainerCatalogRspBO dealImportScCatalog(SmartContainerCatalogReqBO reqBO) {
        List<Map<String, Object>> importDataMap;
        SmartContainerCatalogRspBO rspBO = new SmartContainerCatalogRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u952eID");
        title.add("\u7269\u8d44\u5206\u7c7b\u7f16\u7801");
        title.add("\u7269\u8d44\u5206\u7c7b\u540d\u79f0");
        title.add("\u505c\u7528/\u542f\u7528");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<SmartContainerCatalogBO> batchImportUtils = new BatchImportUtils<SmartContainerCatalogBO>(title, data, SmartContainerCatalogBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 0, 1, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Object> insertImp = new ArrayList<Object>();
        ArrayList<SmartContainerCatalogPO> insertCatalog = new ArrayList<SmartContainerCatalogPO>();
        List list = JSONArray.parseArray((String)JSON.toJSONString(importDataMap), SmartContainerCatalogBO.class);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (SmartContainerCatalogBO bo : list) {
            if (bo.getId() == null || "\u505c\u7528".equals(bo.getStateStr())) continue;
            ids.add(bo.getId());
        }
        if (ids.size() > 0) {
            String str;
            SmartContainerCatalogPO check = new SmartContainerCatalogPO();
            check.setIds(ids);
            check.setState(Integer.valueOf(0));
            List have = this.smartContainerCatalogMapper.selectByCondition(check);
            ArrayList codes = new ArrayList();
            for (SmartContainerCatalogPO catalogPO : have) {
                codes.add(catalogPO.getCatalogCode());
            }
            if (codes.size() > 0 && StringUtils.isNotBlank((CharSequence)(str = this.check(codes)))) {
                throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u8d27\u67dc\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
            }
        }
        Long tempId = Sequence.getInstance().nextId();
        rspBO.setTempId(tempId);
        ArrayList<String> codes = new ArrayList<String>();
        for (SmartContainerCatalogBO bo : list) {
            if (bo.getId() != null) {
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setScId(reqBO.getScId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(1));
                importPO.setTempId(tempId);
                insertImp.add(importPO);
                SmartContainerCatalogPO catalogPO = new SmartContainerCatalogPO();
                catalogPO.setId(bo.getId());
                if (StringUtils.isNotBlank((CharSequence)bo.getStateStr())) {
                    if ("\u505c\u7528".equals(bo.getStateStr())) {
                        catalogPO.setState(Integer.valueOf(0));
                    } else {
                        catalogPO.setState(Integer.valueOf(1));
                    }
                } else {
                    catalogPO.setState(Integer.valueOf(1));
                }
                catalogPO.setUpdateTime(new Date());
                catalogPO.setUpdateName(reqBO.getName());
                catalogPO.setUpdateUserId(reqBO.getUserId() + "");
                catalogPO.setUpdateUserName(reqBO.getUsername());
                this.smartContainerCatalogMapper.update(catalogPO);
                continue;
            }
            codes.add(bo.getCatalogCode());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(codes)) {
            if (insertImp.size() > 0) {
                this.smartContainerImportMapper.insertBatch(insertImp);
            }
            return rspBO;
        }
        SmartContainerCatalogPO check = new SmartContainerCatalogPO();
        check.setCatalogCodes(codes);
        List catalogBOS = this.smartContainerCatalogMapper.getCatalog(check);
        if (CollectionUtils.isEmpty((Collection)catalogBOS)) {
            for (SmartContainerCatalogBO bo : list) {
                if (bo.getId() != null) continue;
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setScId(reqBO.getScId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(0));
                importPO.setFailCentent("\u672a\u67e5\u8be2\u5230\u8be5\u5206\u7c7b");
                importPO.setTempId(tempId);
                insertImp.add(importPO);
            }
        } else {
            String str = this.check(codes);
            if (StringUtils.isNotBlank((CharSequence)str)) {
                throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u8d27\u67dc\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
            }
            Map<String, SmartContainerCatalogPO> map = catalogBOS.stream().collect(Collectors.toMap(SmartContainerCatalogPO::getCatalogCode, i -> i));
            for (SmartContainerCatalogBO bo : list) {
                if (bo.getId() != null) continue;
                SmartContainerCatalogPO catalogPO = map.get(bo.getCatalogCode());
                SmartContainerImportPO importPO = new SmartContainerImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setScId(reqBO.getScId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setTempId(tempId);
                if (catalogPO == null) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728");
                    insertImp.add(importPO);
                    continue;
                }
                if (!catalogPO.getCatalogName().equals(bo.getCatalogFullName())) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u548c\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e0d\u5339\u914d");
                    insertImp.add(importPO);
                    continue;
                }
                importPO.setState(Integer.valueOf(1));
                insertImp.add(importPO);
                catalogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                catalogPO.setScId(reqBO.getScId());
                catalogPO.setCreateName(reqBO.getName());
                catalogPO.setCreateTime(new Date());
                catalogPO.setCreateUserId(reqBO.getUserId() + "");
                catalogPO.setCreateUserName(reqBO.getUsername());
                catalogPO.setUpdateName(reqBO.getName());
                catalogPO.setUpdateTime(new Date());
                catalogPO.setUpdateUserId(reqBO.getUserId() + "");
                catalogPO.setUpdateUserName(reqBO.getUsername());
                if ("\u505c\u7528".equals(bo.getStateStr())) {
                    catalogPO.setState(Integer.valueOf(0));
                } else {
                    catalogPO.setState(Integer.valueOf(1));
                }
                insertCatalog.add(catalogPO);
            }
        }
        if (insertImp.size() > 0) {
            this.smartContainerImportMapper.insertBatch(insertImp);
        }
        if (insertCatalog.size() > 0) {
            this.smartContainerCatalogMapper.insertBatch(insertCatalog);
        }
        return rspBO;
    }

    private String check(List<String> codes) {
        SmartContainerCatalogPO check = new SmartContainerCatalogPO();
        check.setCatalogCodes(codes);
        check.setState(Integer.valueOf(1));
        List have = this.smartContainerCatalogMapper.selectByCondition(check);
        if (!CollectionUtils.isEmpty((Collection)have)) {
            StringBuilder code = new StringBuilder();
            for (SmartContainerCatalogPO catalogPO : have) {
                code.append(catalogPO.getCatalogCode()).append(",");
            }
            code.replace(code.lastIndexOf(","), code.lastIndexOf(",") + 1, "");
            return code.toString();
        }
        return null;
    }

    public static void main(String[] args) {
        StringBuilder code = new StringBuilder("123,");
        code.replace(code.lastIndexOf(","), code.lastIndexOf(",") + 1, "");
        System.out.print(code.toString());
    }
}

