/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.bo.BrandESBO;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccMallBrandUpdateAbilityRspBo;
import com.tydic.commodity.common.busi.api.UccMallBrandUpdateBusiService;
import com.tydic.commodity.dao.UccBrandExtMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccMallBrandRelPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallBrandUpdateBusiServiceImpl
implements UccMallBrandUpdateBusiService {
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @Override
    public UccMallBrandUpdateAbilityRspBo updateBrandInfo(UccMallBrandUpdateAbilityReqBo reqBo) {
        Map<List<Long>, Map<Object, Object>> dealCreateRel;
        UccMallBrandUpdateAbilityRspBo rspBo = new UccMallBrandUpdateAbilityRspBo();
        ArrayList<BrandESBO> brandList = new ArrayList<BrandESBO>();
        Map<Integer, List<UccMallBrandUpdateAbilityBo>> collect = reqBo.getBrandInfo().stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getType));
        List<Long> dealCancelRel = this.dealCancelRel(collect.get(UccConstants.BrandRelOperType.CANCEL));
        if (!CollectionUtils.isEmpty(dealCancelRel)) {
            BrandESBO brandEsBo = new BrandESBO();
            brandEsBo.setOriginBrandIdList(dealCancelRel);
            HashMap<String, String> updateMap = new HashMap<String, String>(2);
            updateMap.put("brand_id", "ctx._source.origin_brand_id");
            updateMap.put("brand_name", "ctx._source.origin_brand_name");
            brandEsBo.setBrandMap(updateMap);
            brandList.add(brandEsBo);
        }
        if (!CollectionUtils.isEmpty(dealCreateRel = this.dealCreateRel(collect.get(UccConstants.BrandRelOperType.CREATE), reqBo))) {
            dealCreateRel.forEach((idList, brandMap) -> {
                BrandESBO brandEsBo = new BrandESBO();
                brandEsBo.setBrandIdList(idList);
                brandEsBo.setBrandMap(brandMap);
                brandList.add(brandEsBo);
            });
        }
        rspBo.setBrandList(brandList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> dealCancelRel(List<UccMallBrandUpdateAbilityBo> uccMallBrandUpdateAbilityBos) {
        Map<Long, List<UccMallBrandUpdateAbilityBo>> collect;
        ArrayList<Long> brandIdList = new ArrayList<Long>();
        ArrayList skuIdList = new ArrayList();
        if (!CollectionUtils.isEmpty(uccMallBrandUpdateAbilityBos) && !CollectionUtils.isEmpty(collect = uccMallBrandUpdateAbilityBos.stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getMallBrandId)))) {
            collect.forEach((mallBrandId, updateBrandList) -> {
                List idList;
                if (!CollectionUtils.isEmpty((Collection)updateBrandList) && !CollectionUtils.isEmpty((Collection)(idList = this.uccBrandExtMapper.getBrandIdList(mallBrandId, updateBrandList.stream().map(UccMallBrandUpdateAbilityBo::getBrandName).collect(Collectors.toList()))))) {
                    this.uccBrandExtMapper.cancelBrandRel(mallBrandId, ((UccMallBrandUpdateAbilityBo)updateBrandList.get(0)).getUpdateOperId(), idList);
                    this.uccMallBrandRelMapper.deleteRelByMallBrandIdAndBrandIds(mallBrandId, idList);
                    brandIdList.addAll(idList);
                }
            });
        }
        return brandIdList;
    }

    private Map<List<Long>, Map<Object, Object>> dealCreateRel(List<UccMallBrandUpdateAbilityBo> uccMallBrandUpdateAbilityBos, UccMallBrandUpdateAbilityReqBo reqBo) {
        HashMap<List<Long>, Map<Object, Object>> brandMap = new HashMap<List<Long>, Map<Object, Object>>(1);
        if (!CollectionUtils.isEmpty(uccMallBrandUpdateAbilityBos)) {
            Map<String, List<UccMallBrandUpdateAbilityBo>> collect = uccMallBrandUpdateAbilityBos.stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getMallBrandName));
            collect.forEach((mallBrandName, updateBrandList) -> {
                List idList;
                Long mallBrandId;
                if (!CollectionUtils.isEmpty((Collection)updateBrandList) && null != (mallBrandId = ((UccMallBrandUpdateAbilityBo)updateBrandList.get(0)).getMallBrandId()) && !CollectionUtils.isEmpty((Collection)(idList = this.uccBrandExtMapper.getBrandIdList(null, updateBrandList.stream().map(UccMallBrandUpdateAbilityBo::getBrandName).collect(Collectors.toList()))))) {
                    this.uccBrandExtMapper.updateBrandRel(mallBrandId, idList);
                    ArrayList uccMallBrandRelPoList = new ArrayList();
                    Date now = new Date();
                    idList.forEach(id -> {
                        UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
                        uccMallBrandRelPo.setMallBrandId(mallBrandId);
                        uccMallBrandRelPo.setMallBrandName(mallBrandName);
                        uccMallBrandRelPo.setBrandId(id);
                        uccMallBrandRelPo.setCreateOperId(reqBo.getUsername());
                        uccMallBrandRelPo.setCreateOperName(reqBo.getName());
                        uccMallBrandRelPo.setCreateTime(now);
                        uccMallBrandRelPoList.add(uccMallBrandRelPo);
                    });
                    this.uccMallBrandRelMapper.insertBatch(uccMallBrandRelPoList);
                    HashMap<String, String> mallBrandMap = new HashMap<String, String>(2);
                    mallBrandMap.put("brand_id", mallBrandId + "L");
                    mallBrandMap.put("brand_name", "'" + mallBrandName + "'");
                    brandMap.put(idList, mallBrandMap);
                }
            });
        }
        return brandMap;
    }
}

