/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccWarehouseCatalogBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseCatalogReqBO;
import com.tydic.commodity.common.ability.bo.UccWarehouseCatalogRspBO;
import com.tydic.commodity.common.busi.api.UccWarehouseCatalogBusiService;
import com.tydic.commodity.common.external.util.BatchImportUtils;
import com.tydic.commodity.dao.UccWarehouseCatalogMapper;
import com.tydic.commodity.dao.UccWarehouseImportMapper;
import com.tydic.commodity.po.UccWarehouseCatalogPO;
import com.tydic.commodity.po.UccWarehouseImportPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccWarehouseCatalogBusiServiceImpl
implements UccWarehouseCatalogBusiService {
    @Autowired
    private UccWarehouseCatalogMapper uccWarehouseCatalogMapper;
    @Autowired
    private UccWarehouseImportMapper uccWarehouseImportMapper;

    @Override
    public UccWarehouseCatalogRspBO qryWarehouseCatalogList(UccWarehouseCatalogReqBO reqBO) {
        UccWarehouseCatalogPO containerUserPO = new UccWarehouseCatalogPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)containerUserPO);
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.uccWarehouseCatalogMapper.getListPage(containerUserPO, page);
        UccWarehouseCatalogRspBO rspBO = new UccWarehouseCatalogRspBO();
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<UccWarehouseCatalogBO> rows = new ArrayList<UccWarehouseCatalogBO>();
            for (UccWarehouseCatalogPO containerPO : list) {
                UccWarehouseCatalogBO bo = new UccWarehouseCatalogBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u542f\u7528" : "\u505c\u7528");
                rows.add(bo);
            }
            rspBO.setRows(rows);
            rspBO.setRecordsTotal(page.getTotalCount());
            rspBO.setTotal(page.getTotalPages());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccWarehouseCatalogRspBO dealUpdateWarehouse(UccWarehouseCatalogReqBO reqBO) {
        if (reqBO.getId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5165\u53c2ID");
        }
        UccWarehouseCatalogRspBO rspBO = new UccWarehouseCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        UccWarehouseCatalogPO userPO = new UccWarehouseCatalogPO();
        userPO.setId(reqBO.getId());
        userPO = (UccWarehouseCatalogPO)this.uccWarehouseCatalogMapper.selectByCondition(userPO).get(0);
        if (1 == reqBO.getState()) {
            ArrayList<String> codes = new ArrayList<String>();
            codes.add(userPO.getCatalogCode());
            String str = this.check(codes);
            if (StringUtils.isNotBlank((CharSequence)str)) {
                throw new BusinessException("8888", "\u5f53\u524d\u5206\u7c7b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u4f01\u914d\u4ed3\uff0c\u8bf7\u5148\u505c\u7528\u5176\u4ed6\u4f01\u914d\u4ed3\u4e0b\u8be5\u5206\u7c7b\uff0c\u518d\u542f\u7528");
            }
        }
        userPO = new UccWarehouseCatalogPO();
        userPO.setUpdateUserName(reqBO.getUsername());
        userPO.setUpdateUserId(reqBO.getUserId() + "");
        userPO.setUpdateName(reqBO.getName());
        userPO.setUpdateTime(new Date());
        userPO.setId(reqBO.getId());
        userPO.setState(reqBO.getState());
        this.uccWarehouseCatalogMapper.update(userPO);
        return rspBO;
    }

    @Override
    public UccWarehouseCatalogRspBO dealAddWarehouseCatalog(UccWarehouseCatalogReqBO reqBO) {
        String str;
        UccWarehouseCatalogRspBO rspBO = new UccWarehouseCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        ArrayList<UccWarehouseCatalogPO> list = new ArrayList<UccWarehouseCatalogPO>();
        ArrayList<String> codes = new ArrayList<String>();
        for (UccWarehouseCatalogBO uccWarehouseCatalogBO : reqBO.getCatalogList()) {
            UccWarehouseCatalogPO containerCatalogPO;
            Long id = Sequence.getInstance().nextId();
            if (uccWarehouseCatalogBO.getId() == null) {
                containerCatalogPO = new UccWarehouseCatalogPO();
                BeanUtils.copyProperties((Object)uccWarehouseCatalogBO, (Object)containerCatalogPO);
                containerCatalogPO.setId(id);
                containerCatalogPO.setWarehouseId(reqBO.getWarehouseId());
                containerCatalogPO.setCreateName(reqBO.getName());
                containerCatalogPO.setCreateTime(new Date());
                containerCatalogPO.setCreateUserId(reqBO.getUserId() + "");
                containerCatalogPO.setCreateUserName(reqBO.getUsername());
                containerCatalogPO.setUpdateName(reqBO.getName());
                containerCatalogPO.setUpdateTime(new Date());
                containerCatalogPO.setUpdateUserId(reqBO.getUserId() + "");
                containerCatalogPO.setUpdateUserName(reqBO.getUsername());
                containerCatalogPO.setState(Integer.valueOf(1));
                codes.add(containerCatalogPO.getCatalogCode());
                list.add(containerCatalogPO);
                continue;
            }
            containerCatalogPO = new UccWarehouseCatalogPO();
            containerCatalogPO.setId(uccWarehouseCatalogBO.getId());
            containerCatalogPO.setWarehouseId(reqBO.getWarehouseId());
            containerCatalogPO.setUpdateName(reqBO.getName());
            containerCatalogPO.setUpdateTime(new Date());
            containerCatalogPO.setUpdateUserId(reqBO.getUserId() + "");
            containerCatalogPO.setUpdateUserName(reqBO.getUsername());
            containerCatalogPO.setState(Integer.valueOf(3));
            this.uccWarehouseCatalogMapper.update(containerCatalogPO);
        }
        if (codes.size() > 0 && StringUtils.isNotBlank((CharSequence)(str = this.check(codes)))) {
            throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u4f01\u914d\u4ed3\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
        }
        if (list.size() > 0) {
            this.uccWarehouseCatalogMapper.insertBatch(list);
        }
        return rspBO;
    }

    @Override
    public UccWarehouseCatalogRspBO dealImportWarehouseCatalog(UccWarehouseCatalogReqBO reqBO) {
        List<Map<String, Object>> importDataMap;
        UccWarehouseCatalogRspBO rspBO = new UccWarehouseCatalogRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4e3b\u952eID");
        title.add("\u7269\u8d44\u5206\u7c7b\u7f16\u7801");
        title.add("\u7269\u8d44\u5206\u7c7b\u540d\u79f0");
        title.add("\u505c\u7528/\u542f\u7528");
        ArrayList<List<String>> data = new ArrayList<List<String>>();
        try {
            BatchImportUtils<UccWarehouseCatalogBO> batchImportUtils = new BatchImportUtils<UccWarehouseCatalogBO>(title, data, UccWarehouseCatalogBO.class);
            batchImportUtils.batchImport(reqBO.getUrl(), 0, 1, -1);
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            e.printStackTrace();
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty(importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        ArrayList<Object> insertImp = new ArrayList<Object>();
        ArrayList<UccWarehouseCatalogPO> insertCatalog = new ArrayList<UccWarehouseCatalogPO>();
        List list = JSONArray.parseArray((String)JSON.toJSONString(importDataMap), UccWarehouseCatalogBO.class);
        ArrayList<Long> ids = new ArrayList<Long>();
        for (UccWarehouseCatalogBO bo : list) {
            if (bo.getId() == null || "\u505c\u7528".equals(bo.getStateStr())) continue;
            ids.add(bo.getId());
        }
        if (ids.size() > 0) {
            String str;
            UccWarehouseCatalogPO check = new UccWarehouseCatalogPO();
            check.setIds(ids);
            check.setState(Integer.valueOf(0));
            List have = this.uccWarehouseCatalogMapper.selectByCondition(check);
            ArrayList codes = new ArrayList();
            for (UccWarehouseCatalogPO catalogPO : have) {
                codes.add(catalogPO.getCatalogCode());
            }
            if (codes.size() > 0 && StringUtils.isNotBlank((CharSequence)(str = this.check(codes)))) {
                throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u4f01\u914d\u4ed3\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
            }
        }
        Long tempId = Sequence.getInstance().nextId();
        rspBO.setTempId(tempId);
        ArrayList<String> codes = new ArrayList<String>();
        for (UccWarehouseCatalogBO bo : list) {
            if (bo.getId() != null) {
                UccWarehouseImportPO importPO = new UccWarehouseImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setWarehouseId(reqBO.getWarehouseId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(1));
                importPO.setTempId(tempId);
                insertImp.add(importPO);
                UccWarehouseCatalogPO catalogPO = new UccWarehouseCatalogPO();
                catalogPO.setId(bo.getId());
                if (StringUtils.isNotBlank((CharSequence)bo.getStateStr())) {
                    if ("\u505c\u7528".equals(bo.getStateStr())) {
                        catalogPO.setState(Integer.valueOf(0));
                    } else {
                        catalogPO.setState(Integer.valueOf(1));
                    }
                } else {
                    catalogPO.setState(Integer.valueOf(1));
                }
                catalogPO.setUpdateTime(new Date());
                catalogPO.setUpdateName(reqBO.getName());
                catalogPO.setUpdateUserId(reqBO.getUserId() + "");
                catalogPO.setUpdateUserName(reqBO.getUsername());
                this.uccWarehouseCatalogMapper.update(catalogPO);
                continue;
            }
            codes.add(bo.getCatalogCode());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty(codes)) {
            if (insertImp.size() > 0) {
                this.uccWarehouseImportMapper.insertBatch(insertImp);
            }
            return rspBO;
        }
        UccWarehouseCatalogPO check = new UccWarehouseCatalogPO();
        check.setCatalogCodes(codes);
        List catalogBOS = this.uccWarehouseCatalogMapper.getCatalog(check);
        if (CollectionUtils.isEmpty((Collection)catalogBOS)) {
            for (UccWarehouseCatalogBO bo : list) {
                if (bo.getId() != null) continue;
                UccWarehouseImportPO importPO = new UccWarehouseImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setWarehouseId(reqBO.getWarehouseId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setState(Integer.valueOf(0));
                importPO.setFailCentent("\u672a\u67e5\u8be2\u5230\u8be5\u5206\u7c7b");
                importPO.setTempId(tempId);
                insertImp.add(importPO);
            }
        } else {
            String str = this.check(codes);
            if (StringUtils.isNotBlank((CharSequence)str)) {
                throw new BusinessException("8888", "\u4ee5\u4e0b\u7f16\u7801\u5b58\u5728\u542f\u7528\u72b6\u6001\u4f01\u914d\u4ed3\uff0c\u8bf7\u5148\u505c\u7528\u6216\u8005\u5220\u9664\u5bfc\u5165\u6587\u4ef6\u4e2d\u6570\u636e\uff0c\u7f16\u7801\u4e3a\uff1a" + str);
            }
            Map<String, UccWarehouseCatalogPO> map = catalogBOS.stream().collect(Collectors.toMap(UccWarehouseCatalogPO::getCatalogCode, i -> i));
            for (UccWarehouseCatalogBO bo : list) {
                if (bo.getId() != null) continue;
                UccWarehouseCatalogPO catalogPO = map.get(bo.getCatalogCode());
                UccWarehouseImportPO importPO = new UccWarehouseImportPO();
                importPO.setImportType(Integer.valueOf(2));
                importPO.setWarehouseId(reqBO.getWarehouseId());
                importPO.setCreateUserId(reqBO.getUserId() + "");
                importPO.setCreateName(reqBO.getCreateName());
                importPO.setCreateUserName(reqBO.getUsername());
                importPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                importPO.setCatalogFullName(bo.getCatalogFullName());
                importPO.setCatalogCode(bo.getCatalogCode());
                importPO.setCreateTime(new Date());
                importPO.setTempId(tempId);
                if (catalogPO == null) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u8be5\u5206\u7c7b\u4e0d\u5b58\u5728");
                    insertImp.add(importPO);
                    continue;
                }
                if (!catalogPO.getCatalogName().equals(bo.getCatalogFullName())) {
                    importPO.setState(Integer.valueOf(0));
                    importPO.setFailCentent("\u7269\u8d44\u5206\u7c7b\u7f16\u7801\u548c\u7269\u8d44\u5206\u7c7b\u540d\u79f0\u4e0d\u5339\u914d");
                    insertImp.add(importPO);
                    continue;
                }
                importPO.setState(Integer.valueOf(1));
                insertImp.add(importPO);
                catalogPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                catalogPO.setWarehouseId(reqBO.getWarehouseId());
                catalogPO.setCreateName(reqBO.getName());
                catalogPO.setCreateTime(new Date());
                catalogPO.setCreateUserId(reqBO.getUserId() + "");
                catalogPO.setCreateUserName(reqBO.getUsername());
                catalogPO.setUpdateName(reqBO.getName());
                catalogPO.setUpdateTime(new Date());
                catalogPO.setUpdateUserId(reqBO.getUserId() + "");
                catalogPO.setUpdateUserName(reqBO.getUsername());
                if ("\u505c\u7528".equals(bo.getStateStr())) {
                    catalogPO.setState(Integer.valueOf(0));
                } else {
                    catalogPO.setState(Integer.valueOf(1));
                }
                insertCatalog.add(catalogPO);
            }
        }
        if (insertImp.size() > 0) {
            this.uccWarehouseImportMapper.insertBatch(insertImp);
        }
        if (insertCatalog.size() > 0) {
            this.uccWarehouseCatalogMapper.insertBatch(insertCatalog);
        }
        return rspBO;
    }

    private String check(List<String> codes) {
        UccWarehouseCatalogPO check = new UccWarehouseCatalogPO();
        check.setCatalogCodes(codes);
        check.setState(Integer.valueOf(1));
        List have = this.uccWarehouseCatalogMapper.selectByCondition(check);
        if (!CollectionUtils.isEmpty((Collection)have)) {
            StringBuilder code = new StringBuilder();
            for (UccWarehouseCatalogPO catalogPO : have) {
                code.append(catalogPO.getCatalogCode()).append(",");
            }
            code.replace(code.lastIndexOf(","), code.lastIndexOf(",") + 1, "");
            return code.toString();
        }
        return null;
    }

    @Override
    public UccWarehouseCatalogRspBO getImportLog(UccWarehouseCatalogReqBO reqBO) {
        UccWarehouseImportPO uccWarehouseImportPO = new UccWarehouseImportPO();
        uccWarehouseImportPO.setWarehouseId(reqBO.getId());
        uccWarehouseImportPO.setState(reqBO.getState());
        uccWarehouseImportPO.setImportType(reqBO.getImportType());
        uccWarehouseImportPO.setTempId(reqBO.getTempId());
        Page page = new Page();
        page.setPageNo(reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setLimit(reqBO.getPageSize());
        page.setOffset(reqBO.getPageSize() * (reqBO.getPageNo() - 1));
        List list = this.uccWarehouseImportMapper.getListPage(uccWarehouseImportPO, page);
        UccWarehouseCatalogRspBO rspBO = new UccWarehouseCatalogRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setSuccessCount(Integer.valueOf(0));
        rspBO.setFailCount(Integer.valueOf(0));
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setTotal(0);
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setRecordsTotal(0);
            rspBO.setRows(new ArrayList());
        } else {
            int i = 1;
            ArrayList<UccWarehouseCatalogBO> rows = new ArrayList<UccWarehouseCatalogBO>();
            for (UccWarehouseImportPO containerPO : list) {
                UccWarehouseCatalogBO bo = new UccWarehouseCatalogBO();
                BeanUtils.copyProperties((Object)containerPO, (Object)bo);
                bo.setOrder(Integer.valueOf(reqBO.getPageSize() * (reqBO.getPageNo() - 1) + i));
                ++i;
                bo.setStateStr(bo.getState() == 1 ? "\u6210\u529f" : "\u5931\u8d25");
                rows.add(bo);
            }
            rspBO.setRows(rows);
            List temp = this.uccWarehouseImportMapper.getTemp(uccWarehouseImportPO);
            for (UccWarehouseImportPO po : temp) {
                if (po.getState() == 1) {
                    rspBO.setSuccessCount(po.getImportType());
                } else {
                    rspBO.setFailCount(po.getImportType());
                }
                rspBO.setCreateTime(po.getCreateTime());
            }
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        }
        return rspBO;
    }

    public static void main(String[] args) {
        StringBuilder code = new StringBuilder("123,");
        code.replace(code.lastIndexOf(","), code.lastIndexOf(",") + 1, "");
        System.out.print(code.toString());
    }
}

