/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.base.utils.CheckUtil;
import com.tydic.commodity.common.ability.api.UccSkuhasBeenapprovalListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccLadderPriceBO;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryBO;
import com.tydic.commodity.common.ability.bo.UccSkuhasBeenapprovalListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuhasBeenapprovalListQryAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.SkuDataGovernMapper;
import com.tydic.commodity.dao.SkuDataGovernSamePriceMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.UccSkuExtMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirLogMapper;
import com.tydic.commodity.po.DicDictionaryPo;
import com.tydic.commodity.po.SkuDataGovernPO;
import com.tydic.commodity.po.SkuDataGovernSamePricePO;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccMallBrandRelPO;
import com.tydic.commodity.po.UccSkuExtPo;
import com.tydic.commodity.po.UccSkuManagementPO;
import com.tydic.commodity.po.UccSkuShelvesPo;
import com.tydic.commodity.po.UccSkuhasBeenapprovalPO;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.smcsdk.api.SmcsdkQryStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkQryStockNumRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuhasBeenapprovalListQryAbilityService"})
public class UccSkuhasBeenapprovalListQryAbilityServiceImpl
implements UccSkuhasBeenapprovalListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuhasBeenapprovalListQryAbilityServiceImpl.class);
    @Autowired
    private UccBrandDealMapper uccBrandDealMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SmcsdkQryStockNumService smcsdkQryStockNumService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuPutCirLogMapper uccSkuPutCirLogMapper;
    private SkuDataGovernMapper skuDataGovernMapper;
    private SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper;
    @Autowired
    private UccSkuExtMapper uccSkuExtMapper;

    @PostMapping(value={"gethasBeenapprovalListQry"})
    public UccSkuhasBeenapprovalListQryAbilityRspBO gethasBeenapprovalListQry(@RequestBody UccSkuhasBeenapprovalListQryAbilityReqBO reqBO) {
        List skuIds;
        UccSkuhasBeenapprovalListQryAbilityRspBO rspBO = new UccSkuhasBeenapprovalListQryAbilityRspBO();
        ArrayList<Long> brands = new ArrayList<Long>();
        if (reqBO.getBrandId() != null) {
            brands.add(reqBO.getBrandId());
            UccMallBrandRelPO brandRelPO = new UccMallBrandRelPO();
            brandRelPO.setMallBrandId(reqBO.getBrandId());
            List relPOList = this.uccMallBrandRelMapper.getList(brandRelPO);
            if (!CollectionUtils.isEmpty((Collection)relPOList)) {
                List brandList = relPOList.stream().map(UccMallBrandRelPO::getBrandId).collect(Collectors.toList());
                brands.addAll(brandList);
            }
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccSkuhasBeenapprovalPO uccSkuhasBeenapprovalPO = new UccSkuhasBeenapprovalPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)uccSkuhasBeenapprovalPO);
        if (!CollectionUtils.isEmpty((Collection)reqBO.getObjTypes())) {
            uccSkuhasBeenapprovalPO.setObjType(null);
        }
        if (reqBO.getSalePriceStar() != null) {
            uccSkuhasBeenapprovalPO.setSalePriceStar(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePriceStar())));
        }
        if (reqBO.getSalePriceEnd() != null) {
            uccSkuhasBeenapprovalPO.setSalePriceEnd(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getSalePriceEnd())));
        }
        if (reqBO.getMarketPriceBegin() != null) {
            uccSkuhasBeenapprovalPO.setMarketPriceBegin(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPriceBegin())));
        }
        if (reqBO.getMarketPriceEnd() != null) {
            uccSkuhasBeenapprovalPO.setMarketPriceEnd(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBO.getMarketPriceEnd())));
        }
        if (null != uccSkuhasBeenapprovalPO.getExtSpuId() && uccSkuhasBeenapprovalPO.getExtSpuId().contains(",")) {
            Object[] extSpuIds = uccSkuhasBeenapprovalPO.getExtSpuId().split(",");
            uccSkuhasBeenapprovalPO.setExtSpuIds((List)Lists.newArrayList((Object[])extSpuIds));
            uccSkuhasBeenapprovalPO.setExtSpuId(null);
        }
        if (null != uccSkuhasBeenapprovalPO.getExtSkuId() && uccSkuhasBeenapprovalPO.getExtSkuId().contains(",")) {
            Object[] extSkuIds = uccSkuhasBeenapprovalPO.getExtSkuId().split(",");
            uccSkuhasBeenapprovalPO.setExtSkuIds((List)Lists.newArrayList((Object[])extSkuIds));
            uccSkuhasBeenapprovalPO.setExtSkuId(null);
        }
        if (null != uccSkuhasBeenapprovalPO.getCommodityCode() && uccSkuhasBeenapprovalPO.getCommodityCode().contains(",")) {
            Object[] commodityCodes = uccSkuhasBeenapprovalPO.getCommodityCode().split(",");
            uccSkuhasBeenapprovalPO.setCommodityCodes((List)Lists.newArrayList((Object[])commodityCodes));
            uccSkuhasBeenapprovalPO.setCommodityCode(null);
        }
        if (null != uccSkuhasBeenapprovalPO.getSkuCode() && uccSkuhasBeenapprovalPO.getSkuCode().contains(",")) {
            Object[] skuCodes = uccSkuhasBeenapprovalPO.getSkuCode().split(",");
            uccSkuhasBeenapprovalPO.setSkuCodes((List)Lists.newArrayList((Object[])skuCodes));
            uccSkuhasBeenapprovalPO.setSkuCode(null);
        }
        log.info("--------\u54c1\u724cID\uff1a" + brands);
        if (Objects.equals(reqBO.getIsSupermarketStaff(), "") || Objects.equals(reqBO.getIsSupermarketStaff(), null)) {
            uccSkuhasBeenapprovalPO.setIsSupermarketStaff(Integer.valueOf(0));
        } else {
            uccSkuhasBeenapprovalPO.setIsSupermarketStaff(reqBO.getIsSupermarketStaff());
        }
        List uccskuManagementPOList = this.uccSkuMapper.queryHasBeenApprovalSku(uccSkuhasBeenapprovalPO, brands, page);
        rspBO.setTotal(page.getTotalPages());
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        if (!CollectionUtils.isEmpty((Collection)uccskuManagementPOList)) {
            List uccEMdmCatalogPOList;
            Set brandList = uccskuManagementPOList.stream().map(UccSkuManagementPO::getBrandId).collect(Collectors.toSet());
            Map<Long, List<UccMallBrandRelPO>> goupBrand = null;
            if (!CollectionUtils.isEmpty(brandList)) {
                List getRelByBrandList = this.uccMallBrandRelMapper.getRelByBrandList(new ArrayList(brandList));
                goupBrand = getRelByBrandList.stream().collect(Collectors.groupingBy(UccMallBrandRelPO::getBrandId));
            }
            ArrayList<UccSkuManagementListQryBO> rows = new ArrayList<UccSkuManagementListQryBO>();
            List skus = uccskuManagementPOList.stream().map(UccSkuManagementPO::getSkuId).collect(Collectors.toList());
            List catalogs = uccskuManagementPOList.stream().map(UccSkuManagementPO::getL4mgCategoryId).collect(Collectors.toList());
            Map<Object, Object> catalogMap = new HashMap();
            if (!CollectionUtils.isEmpty(catalogs) && !CollectionUtils.isEmpty((Collection)(uccEMdmCatalogPOList = this.uccEMdmCatalogMapper.queryByCatIds(catalogs)))) {
                catalogMap = uccEMdmCatalogPOList.stream().collect(Collectors.toMap(a -> a.getCatalogId(), a -> a, (first, second) -> first));
            }
            ArrayList uccSkuStockBOS = new ArrayList();
            Map getStockMap = new HashMap();
            try {
                SmcsdkQryStockNumReqBO smcsdkQryStockNumReqBO = new SmcsdkQryStockNumReqBO();
                smcsdkQryStockNumReqBO.setSkuIds((List)Lists.newArrayList(skus));
                SmcsdkQryStockNumRspBO smcsdkQryStockNumRspBO = this.smcsdkQryStockNumService.qryStockNum(smcsdkQryStockNumReqBO);
                log.info("\u7b80\u7248\u5e93\u5b58\uff1a" + JSONObject.toJSONString((Object)smcsdkQryStockNumRspBO));
                if (!"0000".equals(smcsdkQryStockNumRspBO.getRespCode())) {
                    log.error("\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                    throw new BusinessException(RspConstantEnums.SMCSDKOPERATESTOCK_QRY_FAIL.code(), "\u8c03\u7528\u7b80\u7248\u5e93\u5b58\u67e5\u8be2\u5931\u8d25" + smcsdkQryStockNumRspBO.getRespDesc());
                }
                getStockMap = smcsdkQryStockNumRspBO.getSkuStockNumMap();
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            DicDictionaryPo dicDictionaryPo = null;
            for (UccSkuManagementPO each : uccskuManagementPOList) {
                SkuDataGovernPO dataGovernPo = new SkuDataGovernPO();
                dataGovernPo.setSkuId(each.getSkuId());
                SkuDataGovernPO modelBy = this.skuDataGovernMapper.getModelBy(dataGovernPo);
                each.setIfGovern(Integer.valueOf(modelBy == null ? 0 : 1));
                if (each.getStandardPrice() != null && each.getUpRatio() != null && each.getAgreementPrice() != null) {
                    if (MoneyUtils.haoToYuan((Long)each.getAgreementPrice()).compareTo(each.getStandardPrice().multiply(BigDecimal.ONE.add(each.getUpRatio()))) > 0) {
                        each.setSurpassStandardPriceFlag("1");
                    } else {
                        each.setSurpassStandardPriceFlag("0");
                    }
                } else {
                    each.setSurpassStandardPriceFlag("0");
                }
                SkuDataGovernSamePricePO pricePo = new SkuDataGovernSamePricePO();
                pricePo.setType(Integer.valueOf(1));
                pricePo.setSkuId(each.getSkuId());
                List list = this.skuDataGovernSamePriceMapper.getList(pricePo);
                list.stream().map(SkuDataGovernSamePricePO::getPrice).filter(Objects::nonNull).min(BigDecimal::compareTo).ifPresent(arg_0 -> ((UccSkuManagementPO)each).setLowestComPrice(arg_0));
                UccSkuManagementListQryBO bo = new UccSkuManagementListQryBO();
                BeanUtils.copyProperties((Object)each, (Object)bo);
                if (CheckUtil.isNotBlank((Object)each.getDiscountLimitValue())) {
                    bo.setDiscountLimitValue(each.getDiscountLimitValue());
                }
                if (CheckUtil.isNotBlank((Object)each.getHide())) {
                    bo.setHide(each.getHide());
                }
                if (CheckUtil.isNotBlank((Object)bo.getBelongModule())) {
                    bo.setBelongModuleStr(bo.getBelongModule() == 1 ? "\u5185\u4ea7\u4e13\u533a" : "\u4e61\u6751\u632f\u5174");
                }
                bo.setCommodityTypeName(each.getCommodityTypeNmae());
                bo.setCatalogId(each.getL4mgCategoryId());
                if (CheckUtil.isNotBlank((Object)bo.getBrandVerify())) {
                    bo.setBrandVerifyDesc(bo.getBrandVerify() == 1 ? "\u662f" : "\u5426");
                }
                if (CheckUtil.isNotBlank((Object)bo.getIfGovern())) {
                    bo.setIfGovernDesc(bo.getIfGovern() == 1 ? "\u662f" : "\u5426");
                }
                if (catalogMap.containsKey(each.getL4mgCategoryId())) {
                    bo.setL4mgCategoryName(((UccEMdmCatalogPO)catalogMap.get(each.getL4mgCategoryId())).getCatalogName());
                    bo.setCatalogName(((UccEMdmCatalogPO)catalogMap.get(each.getL4mgCategoryId())).getCatalogName());
                    bo.setCatalogCode(((UccEMdmCatalogPO)catalogMap.get(each.getL4mgCategoryId())).getCatalogCode());
                }
                if (getStockMap != null && !getStockMap.isEmpty() && getStockMap.containsKey(each.getSkuId())) {
                    bo.setTotalNum(MoneyUtils.haoToYuan((Long)((Long)getStockMap.get(each.getSkuId()))));
                }
                if (each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getApprovalStatus().toString(), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                    bo.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getCommodityStatus() != null && each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityStatus().toString(), CommodityEnum.COMMODITY_STATUS.toString())) != null) {
                    bo.setCommodityStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(each.getApprovalStatus()), SkuEnum.SKU_APPROVAL_STATUS.toString())) != null) {
                    bo.setApprovalStatusDesc(dicDictionaryPo.getTitle());
                }
                if (each.getTradeMode() != null) {
                    Map<String, String> tradeMode = this.uccDictionaryAtomService.queryBypCodeBackMap("TRADE_MODE");
                    bo.setTradeModeStr(tradeMode.get(each.getTradeMode().toString()));
                }
                if (each.getSkuStatus() != null && each.getApprovalStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getSkuStatus().toString(), SkuEnum.SKU_STATUS.toString())) != null) {
                    bo.setSkuStatusDesc(dicDictionaryPo.getTitle());
                }
                if (goupBrand != null && !goupBrand.isEmpty() && goupBrand.containsKey(each.getBrandId())) {
                    each.setBrandId(goupBrand.get(each.getBrandId()).get(0).getMallBrandId());
                    each.setBrandName(goupBrand.get(each.getBrandId()).get(0).getMallBrandName());
                }
                if (each.getAgreementPrice() != null) {
                    bo.setAgreementPrice(MoneyUtils.haoToYuan((Long)each.getAgreementPrice()));
                }
                if (each.getSalePrice() != null) {
                    bo.setSalePrice(MoneyUtils.haoToYuan((Long)each.getSalePrice()));
                }
                if (each.getMarketPrice() != null) {
                    bo.setMarketPrice(MoneyUtils.haoToYuan((Long)each.getMarketPrice()));
                }
                if (each.getSwitchOn() == 1 && !CollectionUtils.isEmpty((Collection)each.getLadderPrice())) {
                    ArrayList<UccLadderPriceBO> ladderPrice = new ArrayList<UccLadderPriceBO>();
                    for (UccLadderPricePO price : each.getLadderPrice()) {
                        UccLadderPriceBO uccLadderPriceBO = new UccLadderPriceBO();
                        BeanUtils.copyProperties((Object)price, (Object)uccLadderPriceBO);
                        if (price.getStart() != null) {
                            if (price.getStart() != 0L) {
                                uccLadderPriceBO.setStart(MoneyUtils.haoToYuan((Long)price.getStart()));
                            } else {
                                uccLadderPriceBO.setStart(new BigDecimal("0"));
                            }
                        }
                        if (price.getStop() != null) {
                            uccLadderPriceBO.setStop(MoneyUtils.haoToYuan((Long)price.getStop()));
                        }
                        if (price.getPrice() != null) {
                            uccLadderPriceBO.setPrice(MoneyUtils.haoToYuan((Long)price.getPrice()));
                        }
                        ladderPrice.add(uccLadderPriceBO);
                    }
                    bo.setLadderPriceInfo(ladderPrice);
                } else {
                    bo.setLadderPriceInfo(null);
                }
                rows.add(bo);
            }
            rspBO.setRows(rows);
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows()) && !CollectionUtils.isEmpty(skuIds = rspBO.getRows().stream().map(UccSkuManagementListQryBO::getSkuId).collect(Collectors.toList()))) {
            List uccSkuShelvesPos = this.uccSkuPutCirLogMapper.getSkuShelves(skuIds);
            Map<Long, List<UccSkuShelvesPo>> skuShelvesMap = uccSkuShelvesPos.stream().collect(Collectors.groupingBy(UccSkuShelvesPo::getSkuId));
            List uccSkuExtPos = this.uccSkuExtMapper.selectByskuIds(skuIds);
            Map<Long, List<UccSkuExtPo>> uccSkuExtMap = uccSkuExtPos.stream().collect(Collectors.groupingBy(UccSkuExtPo::getSkuId));
            for (UccSkuManagementListQryBO bo : rspBO.getRows()) {
                if (!CollectionUtils.isEmpty((Collection)skuShelvesMap.get(bo.getSkuId()))) {
                    bo.setUpCount(skuShelvesMap.get(bo.getSkuId()).get(0).getUpCount());
                } else {
                    bo.setUpCount(Integer.valueOf(0));
                }
                if (CollectionUtils.isEmpty((Collection)uccSkuExtMap.get(bo.getSkuId()))) continue;
                bo.setOnTheShelfRemarks(uccSkuExtMap.get(bo.getSkuId()).get(0).getValue());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Autowired
    public void setSkuDataGovernMapper(SkuDataGovernMapper skuDataGovernMapper) {
        this.skuDataGovernMapper = skuDataGovernMapper;
    }

    @Autowired
    public void setSkuDataGovernSamePriceMapper(SkuDataGovernSamePriceMapper skuDataGovernSamePriceMapper) {
        this.skuDataGovernSamePriceMapper = skuDataGovernSamePriceMapper;
    }
}

