/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccAddCollectAbilityServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccAddCollectAbilityServiceRspBo;
import com.tydic.commodity.common.busi.api.UccAddCollectBusiService;
import com.tydic.commodity.dao.UccCollectMapper;
import com.tydic.commodity.po.UccCollectPO;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.stereotype.Service;

@Service
public class UccAddCollectBusiServiceImpl
implements UccAddCollectBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAddCollectBusiServiceImpl.class);
    @Autowired
    private UccCollectMapper uccCollectMapper;

    @Override
    public UccAddCollectAbilityServiceRspBo addCollect(UccAddCollectAbilityServiceReqBo reqBo) {
        this.val(reqBo);
        UccCollectPO modelBy = new UccCollectPO();
        modelBy.setSkuId(reqBo.getSkuId());
        modelBy = this.uccCollectMapper.getModelBy(modelBy);
        List<Integer> typeList = Arrays.asList(1, 2);
        if (modelBy == null) {
            if (typeList.contains(reqBo.getType())) {
                UccCollectPO insertPO = new UccCollectPO();
                insertPO.setSkuId(reqBo.getSkuId());
                if (reqBo.getType() == 1) {
                    insertPO.setLookNum(Integer.valueOf(0));
                    insertPO.setCollectNum(Integer.valueOf(1));
                } else {
                    insertPO.setLookNum(Integer.valueOf(1));
                    insertPO.setCollectNum(Integer.valueOf(0));
                }
                try {
                    this.uccCollectMapper.insert(insertPO);
                }
                catch (DuplicateKeyException E) {
                    this.uccCollectMapper.updateCollect(reqBo.getSkuId(), reqBo.getType().intValue());
                }
            }
        } else {
            this.uccCollectMapper.updateCollect(reqBo.getSkuId(), reqBo.getType().intValue());
        }
        UccAddCollectAbilityServiceRspBo rspBO = new UccAddCollectAbilityServiceRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void val(UccAddCollectAbilityServiceReqBo reqBO) {
        if (null == reqBO) {
            throw new BusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSkuId() == null) {
            throw new BusinessException("0001", "\u5165\u53c2[skuId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getType() == null || reqBO.getType() != 1 && reqBO.getType() != 2 && reqBO.getType() != 3) {
            throw new BusinessException("0001", "\u5165\u53c2[type]\u4e0d\u7b26\u5408\u89c4\u8303\uff01");
        }
    }
}

