/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.bo.UccWarehouseBusiEmpBO;
import com.tydic.commodity.common.busi.api.UccEnterpriseWarehouseAddBusiService;
import com.tydic.commodity.common.busi.bo.UccEnterpriseWarehouseAddBusiReqBO;
import com.tydic.commodity.common.busi.bo.UccEnterpriseWarehouseAddBusiRspBO;
import com.tydic.commodity.dao.UccEnterpriseWarehouseMapper;
import com.tydic.commodity.dao.UccWarehouseBusiEmpMapper;
import com.tydic.commodity.po.UccEnterpriseWarehousePO;
import com.tydic.commodity.po.UccWarehouseBusiEmpPO;
import com.tydic.umc.general.ability.api.UmcDycMemberWarehouseEmpUpdateAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycMemberWarehouseEmpUpdateAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcDycMemberWarehouseEmpUpdateAbilityRspBO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccEnterpriseWarehouseAddBusiServiceImpl
implements UccEnterpriseWarehouseAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccEnterpriseWarehouseAddBusiServiceImpl.class);
    @Autowired
    private UccEnterpriseWarehouseMapper uccEnterpriseWarehouseMapper;
    @Autowired
    private UccWarehouseBusiEmpMapper uccWarehouseBusiEmpMapper;
    @Autowired
    private UmcDycMemberWarehouseEmpUpdateAbilityService umcDycMemberWarehouseEmpUpdateAbilityService;

    @Override
    public UccEnterpriseWarehouseAddBusiRspBO addEnterpriseWarehouse(UccEnterpriseWarehouseAddBusiReqBO reqBO) {
        UccEnterpriseWarehousePO uccEnterpriseWarehousePO = new UccEnterpriseWarehousePO();
        uccEnterpriseWarehousePO.setWarehouseCode(reqBO.getWarehouseCode());
        int i = this.uccEnterpriseWarehouseMapper.getCheckBy(uccEnterpriseWarehousePO);
        if (i > 0) {
            throw new BusinessException(RspConstantEnums.WAREHOUSE_ADD_FAIL.code(), "\u4f01\u914d\u4ed3\u7f16\u7801\u5df2\u5b58\u5728\uff01");
        }
        ArrayList<String> areaList = new ArrayList<String>();
        if (!StringUtils.isEmpty((Object)reqBO.getProvince())) {
            areaList.add(reqBO.getProvince());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCity())) {
            areaList.add(reqBO.getCity());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getCounty())) {
            areaList.add(reqBO.getCounty());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getTown())) {
            areaList.add(reqBO.getTown());
        }
        String area = String.join((CharSequence)"/", areaList);
        UccEnterpriseWarehousePO enterpriseWarehousePO = (UccEnterpriseWarehousePO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), UccEnterpriseWarehousePO.class);
        enterpriseWarehousePO.setArea(area);
        enterpriseWarehousePO.setWarehouseId(Long.valueOf(Sequence.getInstance().nextId()));
        enterpriseWarehousePO.setStatus(UccConstants.WarehouseState.VALID);
        Date nowDate = new Date();
        enterpriseWarehousePO.setCreateTime(nowDate);
        enterpriseWarehousePO.setCreateUserName(reqBO.getName());
        enterpriseWarehousePO.setCreateUserId(reqBO.getUserId());
        enterpriseWarehousePO.setCreateUserAccount(reqBO.getUsername());
        enterpriseWarehousePO.setUpdateTime(nowDate);
        enterpriseWarehousePO.setUpdateUserName(reqBO.getName());
        enterpriseWarehousePO.setUpdateUserId(reqBO.getUserId());
        enterpriseWarehousePO.setUpdateUserAccount(reqBO.getUsername());
        enterpriseWarehousePO.setSupplierId(reqBO.getSupplierId());
        this.uccEnterpriseWarehouseMapper.insert(enterpriseWarehousePO);
        ArrayList<Long> enableUserList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(reqBO.getWarehouseBusiEmpBOList())) {
            ArrayList<UccWarehouseBusiEmpPO> uccWarehouseBusiEmpPOS = new ArrayList<UccWarehouseBusiEmpPO>(reqBO.getWarehouseBusiEmpBOList().size());
            for (UccWarehouseBusiEmpBO busiEmpBO : reqBO.getWarehouseBusiEmpBOList()) {
                UccWarehouseBusiEmpPO uccWarehouseBusiEmpPO = (UccWarehouseBusiEmpPO)JSON.parseObject((String)JSON.toJSONString((Object)busiEmpBO), UccWarehouseBusiEmpPO.class);
                uccWarehouseBusiEmpPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                uccWarehouseBusiEmpPO.setWarehouseId(enterpriseWarehousePO.getWarehouseId());
                uccWarehouseBusiEmpPO.setCreateTime(nowDate);
                uccWarehouseBusiEmpPO.setCreateUserName(reqBO.getName());
                uccWarehouseBusiEmpPO.setCreateUserId(reqBO.getUserId());
                uccWarehouseBusiEmpPO.setCreateUserAccount(reqBO.getUsername());
                uccWarehouseBusiEmpPO.setUpdateTime(nowDate);
                uccWarehouseBusiEmpPO.setUpdateUserName(reqBO.getName());
                uccWarehouseBusiEmpPO.setUpdateUserId(reqBO.getUserId());
                uccWarehouseBusiEmpPO.setUpdateUserAccount(reqBO.getUsername());
                uccWarehouseBusiEmpPOS.add(uccWarehouseBusiEmpPO);
                if (!UccConstants.WarehouseBusiEmpStatus.VALID.equals(uccWarehouseBusiEmpPO.getStopStatus())) continue;
                enableUserList.add(uccWarehouseBusiEmpPO.getUserId());
            }
            this.uccWarehouseBusiEmpMapper.insertBatch(uccWarehouseBusiEmpPOS);
        }
        if (!CollectionUtils.isEmpty(enableUserList)) {
            UmcDycMemberWarehouseEmpUpdateAbilityReqBO umcDycMemberWarehouseEmpUpdateAbilityReqBO = new UmcDycMemberWarehouseEmpUpdateAbilityReqBO();
            umcDycMemberWarehouseEmpUpdateAbilityReqBO.setEnableUserList(enableUserList);
            log.debug("\u4f01\u914d\u4ed3\u6743\u9650\u540c\u6b65\u4f1a\u5458\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcDycMemberWarehouseEmpUpdateAbilityReqBO));
            UmcDycMemberWarehouseEmpUpdateAbilityRspBO umcDycMemberWarehouseEmpUpdateAbilityRspBO = this.umcDycMemberWarehouseEmpUpdateAbilityService.updateMemberWarehouseEmp(umcDycMemberWarehouseEmpUpdateAbilityReqBO);
            log.debug("\u4f01\u914d\u4ed3\u6743\u9650\u540c\u6b65\u4f1a\u5458\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)umcDycMemberWarehouseEmpUpdateAbilityRspBO));
            if (!"0000".equals(umcDycMemberWarehouseEmpUpdateAbilityRspBO.getRespCode())) {
                throw new BusinessException(RspConstantEnums.WAREHOUSE_UPDATE_FAIL.code(), "\u540c\u6b65\u4f1a\u5458\u4f01\u914d\u4ed3\u6743\u9650\u5931\u8d25\uff01");
            }
        }
        UccEnterpriseWarehouseAddBusiRspBO rspBO = new UccEnterpriseWarehouseAddBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

