/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.RspUccBo;
import com.tydic.commodity.base.bo.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.SyncSceneCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.api.SyncSceneStandardCommodityToEsAtomService;
import com.tydic.commodity.busibase.atom.bo.SyncSceneStandardCommodityToEsReqBO;
import com.tydic.commodity.common.ability.api.UccAutoHideCatalogStandardSkuAbilityService;
import com.tydic.commodity.common.ability.bo.UccAutoHideCatalogStandardSkuAbilityReqBO;
import com.tydic.commodity.common.busi.api.UccAutoHideCatalogStandardSkuBusiService;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiReqBo;
import com.tydic.commodity.common.busi.bo.UccAutoHideCatalogStandardSkuBusiRspBo;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccAutoHideCatalogStandardSkuAbilityService"})
public class UccAutoHideCatalogStandardSkuAbilityServiceImpl
implements UccAutoHideCatalogStandardSkuAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccAutoHideCatalogStandardSkuAbilityServiceImpl.class);
    @Autowired
    private UccAutoHideCatalogStandardSkuBusiService uccAutoHideCatalogStandardSkuBusiService;
    @Autowired
    private SyncSceneCommodityToEsAtomService syncSceneCommodityToEsAtomService;
    @Autowired
    private SyncSceneStandardCommodityToEsAtomService syncSceneStandardCommodityToEsAtomService;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Value(value="${MDM_STANDARD_SKU_NUM_HIDE_SIZE:100}")
    private Integer MDM_STANDARD_SKU_NUM_HIDE_SIZE;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();
    private static final ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
    private static final ExecutorService fixedThreadPool = new ThreadPoolExecutor((int)CPU, CPU * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);

    @PostMapping(value={"autoHideCatalogStandardSku"})
    public RspUccBo autoHideCatalogStandardSku(@RequestBody UccAutoHideCatalogStandardSkuAbilityReqBO reqBO) {
        this.hideSku();
        this.displaySku();
        RspUccBo rspUccBo = new RspUccBo();
        rspUccBo.setRespCode("0000");
        rspUccBo.setRespDesc("\u6210\u529f");
        return rspUccBo;
    }

    private void hideSku() {
        log.debug("\u8fdb\u5165\u4e86\u9690\u85cf\u903b\u8f91-----------");
        Integer count = this.uccEMdmCatalogMapper.getListByStandardTaskCount(UccConstants.Hide.no);
        if (count > 0) {
            int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
            int i = 1;
            while (i <= cycle) {
                int finalI = i++;
                fixedThreadPool.submit(() -> {
                    Page page = new Page(finalI, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue());
                    List byStandardTaskCountPage = this.uccEMdmCatalogMapper.getListByStandardTaskCountPage(UccConstants.Hide.no, page);
                    UccAutoHideCatalogStandardSkuBusiReqBo uccAutoHideCatalogStandardSkuBusiReqBo = new UccAutoHideCatalogStandardSkuBusiReqBo();
                    uccAutoHideCatalogStandardSkuBusiReqBo.setUccSkuPoList(byStandardTaskCountPage);
                    uccAutoHideCatalogStandardSkuBusiReqBo.setHide(UccConstants.Hide.yes);
                    UccAutoHideCatalogStandardSkuBusiRspBo rspBo = this.uccAutoHideCatalogStandardSkuBusiService.dealSkuChangeTask(uccAutoHideCatalogStandardSkuBusiReqBo);
                    if (!"0000".equals(rspBo.getRespCode())) {
                        throw new BusinessException("8888", rspBo.getRespDesc());
                    }
                    List<Long> standardIds = rspBo.getStandardIds();
                    Map<Long, List<UccSkuPo>> mapSku = byStandardTaskCountPage.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                    for (Long supplierShopId : mapSku.keySet()) {
                        List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                        syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        try {
                            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                        }
                        catch (Exception e) {
                            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                        }
                    }
                    if (!CollectionUtils.isEmpty(standardIds)) {
                        SyncSceneStandardCommodityToEsReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                        syncSceneStandardCommodityToEsReqBO.setStandardIdLList(standardIds);
                        syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                        this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
                    }
                });
            }
        }
    }

    private void displaySku() {
        log.debug("\u8fdb\u5165\u4e86\u6062\u590d\u4e0a\u67b6\u903b\u8f91-----------");
        Integer count = this.uccEMdmCatalogMapper.getListByStandardTaskCount(UccConstants.Hide.yes);
        if (count > 0) {
            int cycle = count % this.MDM_STANDARD_SKU_NUM_HIDE_SIZE == 0 ? count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE : count / this.MDM_STANDARD_SKU_NUM_HIDE_SIZE + 1;
            int i = 1;
            while (i <= cycle) {
                int finalI = i++;
                fixedThreadPool.submit(() -> {
                    Page page = new Page(finalI, this.MDM_STANDARD_SKU_NUM_HIDE_SIZE.intValue());
                    List byStandardTaskCountPage = this.uccEMdmCatalogMapper.getListByStandardTaskCountPage(UccConstants.Hide.yes, page);
                    UccAutoHideCatalogStandardSkuBusiReqBo uccAutoHideCatalogStandardSkuBusiReqBo = new UccAutoHideCatalogStandardSkuBusiReqBo();
                    uccAutoHideCatalogStandardSkuBusiReqBo.setUccSkuPoList(byStandardTaskCountPage);
                    uccAutoHideCatalogStandardSkuBusiReqBo.setHide(UccConstants.Hide.no);
                    UccAutoHideCatalogStandardSkuBusiRspBo rspBo = this.uccAutoHideCatalogStandardSkuBusiService.dealSkuChangeTask(uccAutoHideCatalogStandardSkuBusiReqBo);
                    if (!"0000".equals(rspBo.getRespCode())) {
                        throw new BusinessException("8888", rspBo.getRespDesc());
                    }
                    List<Long> standardIds = rspBo.getStandardIds();
                    Map<Long, List<UccSkuPo>> mapSku = byStandardTaskCountPage.stream().collect(Collectors.groupingBy(UccSkuPo::getSupplierShopId));
                    for (Long supplierShopId : mapSku.keySet()) {
                        List skus = mapSku.get(supplierShopId).stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList(skus));
                        syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL);
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        try {
                            this.syncSceneCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneCommodityToEsReqBO);
                        }
                        catch (Exception e) {
                            log.error("\u540c\u6b65ES MQ\u53d1\u9001\u4fe1\u606f\u5931\u8d25");
                        }
                    }
                    if (!CollectionUtils.isEmpty(standardIds)) {
                        SyncSceneStandardCommodityToEsReqBO syncSceneStandardCommodityToEsReqBO = new SyncSceneStandardCommodityToEsReqBO();
                        syncSceneStandardCommodityToEsReqBO.setStandardIdLList(standardIds);
                        syncSceneStandardCommodityToEsReqBO.setSyncType(UccConstants.StandardSyncEsType.add);
                        this.syncSceneStandardCommodityToEsAtomService.syncSceneCommodityToEs(syncSceneStandardCommodityToEsReqBO);
                    }
                });
            }
        }
    }
}

