/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.common.ability.api.UccCheckBatchGroundingStandardComInfoAbilityService;
import com.tydic.commodity.common.ability.bo.UccCheckBatchGroundingStandardComInfoAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccCheckBatchGroundingStandardComInfoAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccCheckStandardComInfoBo;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCheckBatchGroundingStandardComInfoAbilityService"})
public class UccCheckBatchGroundingStandardComInfoAbilityServiceImpl
implements UccCheckBatchGroundingStandardComInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCheckBatchGroundingStandardComInfoAbilityServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    @PostMapping(value={"checkBatchGroundingStandardComInfo"})
    public UccCheckBatchGroundingStandardComInfoAbilityRspBO checkBatchGroundingStandardComInfo(@RequestBody UccCheckBatchGroundingStandardComInfoAbilityReqBO reqBO) {
        UccCheckBatchGroundingStandardComInfoAbilityServiceImpl.checkParam(reqBO);
        HashMap map = new HashMap(reqBO.getUccStandardComInfoBos().size());
        for (UccCheckStandardComInfoBo uccStandardComInfoBo : reqBO.getUccStandardComInfoBos()) {
            map.put(uccStandardComInfoBo.getSkuIds().get(0), uccStandardComInfoBo.getStandardComId());
        }
        List uccEMdmCatalogPos = this.uccEMdmCatalogMapper.qryUccEMdmCatalogBySkuIds(new ArrayList(map.keySet()));
        if (CollectionUtil.isEmpty((Collection)uccEMdmCatalogPos)) {
            throw new BusinessException("8888", "\u672a\u67e5\u8be2\u5230\u7269\u6599\u5206\u7c7b\u4fe1\u606f");
        }
        HashMap<Long, UccEMdmCatalogPO> uccEMdmCatalogMap = new HashMap<Long, UccEMdmCatalogPO>(reqBO.getUccStandardComInfoBos().size());
        for (UccEMdmCatalogPO uccEMdmCatalogPo : uccEMdmCatalogPos) {
            Long standardComId = (Long)map.get(uccEMdmCatalogPo.getSkuId());
            if (standardComId == null) continue;
            uccEMdmCatalogMap.put(standardComId, uccEMdmCatalogPo);
        }
        log.debug("map\u96c6\u5408{}", uccEMdmCatalogMap);
        UccCheckBatchGroundingStandardComInfoAbilityRspBO rspBO = new UccCheckBatchGroundingStandardComInfoAbilityRspBO();
        ArrayList<UccCheckStandardComInfoBo> passList = new ArrayList<UccCheckStandardComInfoBo>();
        ArrayList<UccCheckStandardComInfoBo> noPassList = new ArrayList<UccCheckStandardComInfoBo>();
        for (UccCheckStandardComInfoBo each : reqBO.getUccStandardComInfoBos()) {
            UccCheckStandardComInfoBo uccCheckStandardComInfoBo = new UccCheckStandardComInfoBo();
            uccCheckStandardComInfoBo.setStandardComId(each.getStandardComId());
            uccCheckStandardComInfoBo.setSkuIds(each.getSkuIds());
            UccEMdmCatalogPO uccEMdmCatalogPO = (UccEMdmCatalogPO)uccEMdmCatalogMap.get(each.getStandardComId());
            log.debug("\u83b7\u53d6\u5230\u7684uccEMdmCatalogPO{}", (Object)uccEMdmCatalogPO);
            if (uccEMdmCatalogPO != null) {
                if (UccConstants.StandardFlag.YES.equals(uccEMdmCatalogPO.getStandardFlag())) {
                    int count = this.uccSkuMapper.qryListStandardComSkuCount(each.getSkuIds(), each.getStandardComId());
                    int size = (int)each.getSkuIds().stream().distinct().count() + count;
                    if (uccEMdmCatalogPO.getStandardSkuNum() == null || size < uccEMdmCatalogPO.getStandardSkuNum()) {
                        uccCheckStandardComInfoBo.setRemark("\u8be5\u6807\u51c6\u5546\u54c1\u4e0d\u6ee1\u8db3\u7533\u8bf7\u4e0a\u67b6\u6700\u4f4e\u5355\u54c1\u6570\u91cf\uff01");
                        noPassList.add(uccCheckStandardComInfoBo);
                        continue;
                    }
                    passList.add(uccCheckStandardComInfoBo);
                    continue;
                }
                passList.add(uccCheckStandardComInfoBo);
                continue;
            }
            noPassList.add(each);
        }
        rspBO.setNoPassList(noPassList);
        rspBO.setPassList(passList);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static void checkParam(UccCheckBatchGroundingStandardComInfoAbilityReqBO reqBO) {
        if (CollectionUtil.isEmpty((Collection)reqBO.getUccStandardComInfoBos())) {
            throw new BusinessException("8888", "\u5165\u53c2\u3010\u6807\u54c1\u4fe1\u606f\u96c6\u5408\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (UccCheckStandardComInfoBo uccStandardComInfoBo : reqBO.getUccStandardComInfoBos()) {
            if (uccStandardComInfoBo.getStandardComId() == null) {
                throw new BusinessException("8888", "\u5165\u53c2\u3010\u6807\u54c1Id\u3011\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!CollectionUtil.isEmpty((Collection)uccStandardComInfoBo.getSkuIds())) continue;
            throw new BusinessException("8888", "\u5165\u53c2\u3010skuId\u96c6\u5408\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

