/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.busibase.atom.api.UccDataGovernPushSkuStateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomBO;
import com.tydic.commodity.busibase.atom.bo.UccDataGovernPushSkuStateAtomReqBO;
import com.tydic.commodity.common.ability.api.UccDataGovernSkuStateAllPushAbilityService;
import com.tydic.commodity.common.ability.bo.UccDataGovernSkuStateAllPushAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccDataGovernSkuStateAllPushAbilityRspBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.UccSkuPo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccDataGovernSkuStateAllPushAbilityService"})
public class UccDataGovernSkuStateAllPushAbilityServiceImpl
implements UccDataGovernSkuStateAllPushAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccDataGovernSkuStateAllPushAbilityServiceImpl.class);
    @Autowired
    private UccDataGovernPushSkuStateAtomService uccDataGovernPushSkuStateAtomService;
    @Value(value="#{'${status_list_str:17,2,3,16}'.split(',')}")
    private String status_list_str;
    @Value(value="${PUSH_SKU_STATE_ALL_PAGE_SIZE:100}")
    private String PUSH_SKU_STATE_ALL_PAGE_SIZE;
    @Value(value="${BATCH_SYNC_MA_POOL_SIZE:10}")
    private String BATCH_SYNC_MA_POOL_SIZE;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private static final Integer CPU = Runtime.getRuntime().availableProcessors();

    @PostMapping(value={"skuStateAllPush"})
    public UccDataGovernSkuStateAllPushAbilityRspBO skuStateAllPush(@RequestBody UccDataGovernSkuStateAllPushAbilityReqBO reqBo) {
        List<Integer> statusList = UccDataGovernSkuStateAllPushAbilityServiceImpl.stringToIntegerList(this.status_list_str);
        Integer pageSize = Integer.parseInt(this.PUSH_SKU_STATE_ALL_PAGE_SIZE);
        Integer count = this.uccSkuMapper.getCountByStatus(statusList);
        if (count > pageSize) {
            this.multiThreadMethod(count, pageSize, statusList);
        } else {
            Page page = new Page(1, pageSize.intValue());
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuStatusList(statusList);
            List uccSkuPos = this.uccSkuMapper.getSkuStateListPage(uccSkuPo, page);
            if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                this.dealPush(uccSkuPos, Thread.currentThread().getName());
            }
        }
        UccDataGovernSkuStateAllPushAbilityRspBO rspBO = new UccDataGovernSkuStateAllPushAbilityRspBO();
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void multiThreadMethod(Integer count, Integer pageSize, List<Integer> statusList) {
        log.info("---------------------\u7ebf\u7a0b\u5904\u7406\u5f00\u59cb--------------");
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor((int)CPU, Integer.parseInt(this.BATCH_SYNC_MA_POOL_SIZE), 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        int cycle = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        int pageNo = 1;
        while (pageNo <= cycle) {
            int finalPageNo = pageNo++;
            fixedThreadPool.submit(() -> {
                try {
                    log.info("\u7ebf\u7a0b {} \u5f00\u59cb\u6267\u884c", (Object)Thread.currentThread().getName());
                    Page page = new Page(finalPageNo, pageSize.intValue());
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuStatusList(statusList);
                    List uccSkuPos = this.uccSkuMapper.getSkuStateListPage(uccSkuPo, page);
                    if (!CollectionUtils.isEmpty((Collection)uccSkuPos)) {
                        this.dealPush(uccSkuPos, Thread.currentThread().getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u7ebf\u7a0b {} \u6267\u884c\u5f02\u5e38:{]", (Object)Thread.currentThread().getName(), (Object)e.getMessage());
                }
            });
        }
        fixedThreadPool.shutdown();
    }

    private void dealPush(List<UccSkuPo> poList, String threadName) {
        try {
            List pushList = poList.stream().map(e -> {
                UccDataGovernPushSkuStateAtomBO atomBO = new UccDataGovernPushSkuStateAtomBO();
                atomBO.setSkuId(e.getSkuId());
                Date date = e.getUpdateTime() != null ? e.getUpdateTime() : e.getCreateTime();
                atomBO.setChangeTime(DateUtils.dateToStrLong((Date)date));
                atomBO.setSkuStatus(e.getSkuStatus());
                return atomBO;
            }).collect(Collectors.toList());
            UccDataGovernPushSkuStateAtomReqBO stateAtomReqBO = new UccDataGovernPushSkuStateAtomReqBO();
            stateAtomReqBO.setPushSkuList(pushList);
            log.info("\u63a8\u9001\u6570\u636e\u5165\u53c2 -{}-,{}", (Object)threadName, (Object)JSON.toJSONString((Object)stateAtomReqBO));
            this.uccDataGovernPushSkuStateAtomService.dealDataGovernPushSkuStateBatch(stateAtomReqBO);
        }
        catch (Exception e2) {
            log.error("\u63a8\u9001\u72b6\u6001\u4fe1\u606f\u5931\u8d25 {}", (Object)e2.getMessage());
        }
    }

    public static List<Integer> stringToIntegerList(String str) {
        String[] parts = str.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String part : parts) {
            int number = Integer.parseInt(part.trim());
            list.add(number);
        }
        return list;
    }
}

